// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.aily.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.aily.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class DataAssetImportKnowledgeSetting {
    /**
     * 知识切片配置
     * <p> 示例值：
     */
    @SerializedName("chunk_setting")
    private DataAssetKnowledgeChunkSetting chunkSetting;
    /**
     * 知识导入-文件
     * <p> 示例值：
     */
    @SerializedName("file")
    private DataAssetImportKnowledgeFile file;
    /**
     * 知识导入-飞书云文档
     * <p> 示例值：
     */
    @SerializedName("lark_doc")
    private DataAssetImportKnowledgeLarkDoc larkDoc;
    /**
     * 知识导入-飞书知识空间
     * <p> 示例值：
     */
    @SerializedName("lark_wiki_space")
    private DataAssetImportKnowledgeWiki larkWikiSpace;
    /**
     * 知识导入-飞书服务台
     * <p> 示例值：
     */
    @SerializedName("lark_helpdesk")
    private DataAssetImportKnowledgeHelpdesk larkHelpdesk;

    // builder 开始
    public DataAssetImportKnowledgeSetting() {
    }

    public DataAssetImportKnowledgeSetting(Builder builder) {
        /**
         * 知识切片配置
         * <p> 示例值：
         */
        this.chunkSetting = builder.chunkSetting;
        /**
         * 知识导入-文件
         * <p> 示例值：
         */
        this.file = builder.file;
        /**
         * 知识导入-飞书云文档
         * <p> 示例值：
         */
        this.larkDoc = builder.larkDoc;
        /**
         * 知识导入-飞书知识空间
         * <p> 示例值：
         */
        this.larkWikiSpace = builder.larkWikiSpace;
        /**
         * 知识导入-飞书服务台
         * <p> 示例值：
         */
        this.larkHelpdesk = builder.larkHelpdesk;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public DataAssetKnowledgeChunkSetting getChunkSetting() {
        return this.chunkSetting;
    }

    public void setChunkSetting(DataAssetKnowledgeChunkSetting chunkSetting) {
        this.chunkSetting = chunkSetting;
    }

    public DataAssetImportKnowledgeFile getFile() {
        return this.file;
    }

    public void setFile(DataAssetImportKnowledgeFile file) {
        this.file = file;
    }

    public DataAssetImportKnowledgeLarkDoc getLarkDoc() {
        return this.larkDoc;
    }

    public void setLarkDoc(DataAssetImportKnowledgeLarkDoc larkDoc) {
        this.larkDoc = larkDoc;
    }

    public DataAssetImportKnowledgeWiki getLarkWikiSpace() {
        return this.larkWikiSpace;
    }

    public void setLarkWikiSpace(DataAssetImportKnowledgeWiki larkWikiSpace) {
        this.larkWikiSpace = larkWikiSpace;
    }

    public DataAssetImportKnowledgeHelpdesk getLarkHelpdesk() {
        return this.larkHelpdesk;
    }

    public void setLarkHelpdesk(DataAssetImportKnowledgeHelpdesk larkHelpdesk) {
        this.larkHelpdesk = larkHelpdesk;
    }

    public static class Builder {
        /**
         * 知识切片配置
         * <p> 示例值：
         */
        private DataAssetKnowledgeChunkSetting chunkSetting;
        /**
         * 知识导入-文件
         * <p> 示例值：
         */
        private DataAssetImportKnowledgeFile file;
        /**
         * 知识导入-飞书云文档
         * <p> 示例值：
         */
        private DataAssetImportKnowledgeLarkDoc larkDoc;
        /**
         * 知识导入-飞书知识空间
         * <p> 示例值：
         */
        private DataAssetImportKnowledgeWiki larkWikiSpace;
        /**
         * 知识导入-飞书服务台
         * <p> 示例值：
         */
        private DataAssetImportKnowledgeHelpdesk larkHelpdesk;

        /**
         * 知识切片配置
         * <p> 示例值：
         *
         * @param chunkSetting
         * @return
         */
        public Builder chunkSetting(DataAssetKnowledgeChunkSetting chunkSetting) {
            this.chunkSetting = chunkSetting;
            return this;
        }


        /**
         * 知识导入-文件
         * <p> 示例值：
         *
         * @param file
         * @return
         */
        public Builder file(DataAssetImportKnowledgeFile file) {
            this.file = file;
            return this;
        }


        /**
         * 知识导入-飞书云文档
         * <p> 示例值：
         *
         * @param larkDoc
         * @return
         */
        public Builder larkDoc(DataAssetImportKnowledgeLarkDoc larkDoc) {
            this.larkDoc = larkDoc;
            return this;
        }


        /**
         * 知识导入-飞书知识空间
         * <p> 示例值：
         *
         * @param larkWikiSpace
         * @return
         */
        public Builder larkWikiSpace(DataAssetImportKnowledgeWiki larkWikiSpace) {
            this.larkWikiSpace = larkWikiSpace;
            return this;
        }


        /**
         * 知识导入-飞书服务台
         * <p> 示例值：
         *
         * @param larkHelpdesk
         * @return
         */
        public Builder larkHelpdesk(DataAssetImportKnowledgeHelpdesk larkHelpdesk) {
            this.larkHelpdesk = larkHelpdesk;
            return this;
        }


        public DataAssetImportKnowledgeSetting build() {
            return new DataAssetImportKnowledgeSetting(this);
        }
    }
}
