// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class App {
    /**
     * aPaaS 产品应用的名称
     * <p> 示例值：
     */
    @SerializedName("name")
    private I18n[] name;
    /**
     * aPaaS 产品应用的命名空间
     * <p> 示例值：package_35f605__c
     */
    @SerializedName("namespace")
    private String namespace;
    /**
     * aPaaS 产品应用的创建时间
     * <p> 示例值：1736480945563
     */
    @SerializedName("created_at")
    private Integer createdAt;
    /**
     * aPaaS 产品应用的所有者
     * <p> 示例值：1818624575806604
     */
    @SerializedName("owner")
    private Integer owner;
    /**
     * aPaaS 产品应用的状态
     * <p> 示例值：enabled
     */
    @SerializedName("status")
    private String status;
    /**
     * aPaaS 产品应用的成员管理信息
     * <p> 示例值：
     */
    @SerializedName("app_roles_info")
    private AppRolesInfo appRolesInfo;

    // builder 开始
    public App() {
    }

    public App(Builder builder) {
        /**
         *   aPaaS 产品应用的名称
         * <p> 示例值：
         */
        this.name = builder.name;
        /**
         * aPaaS 产品应用的命名空间
         * <p> 示例值：package_35f605__c
         */
        this.namespace = builder.namespace;
        /**
         * aPaaS 产品应用的创建时间
         * <p> 示例值：1736480945563
         */
        this.createdAt = builder.createdAt;
        /**
         * aPaaS 产品应用的所有者
         * <p> 示例值：1818624575806604
         */
        this.owner = builder.owner;
        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         */
        this.status = builder.status;
        /**
         * aPaaS 产品应用的成员管理信息
         * <p> 示例值：
         */
        this.appRolesInfo = builder.appRolesInfo;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public I18n[] getName() {
        return this.name;
    }

    public void setName(I18n[] name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getOwner() {
        return this.owner;
    }

    public void setOwner(Integer owner) {
        this.owner = owner;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AppRolesInfo getAppRolesInfo() {
        return this.appRolesInfo;
    }

    public void setAppRolesInfo(AppRolesInfo appRolesInfo) {
        this.appRolesInfo = appRolesInfo;
    }

    public static class Builder {
        /**
         * aPaaS 产品应用的名称
         * <p> 示例值：
         */
        private I18n[] name;
        /**
         * aPaaS 产品应用的命名空间
         * <p> 示例值：package_35f605__c
         */
        private String namespace;
        /**
         * aPaaS 产品应用的创建时间
         * <p> 示例值：1736480945563
         */
        private Integer createdAt;
        /**
         * aPaaS 产品应用的所有者
         * <p> 示例值：1818624575806604
         */
        private Integer owner;
        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         */
        private String status;
        /**
         * aPaaS 产品应用的成员管理信息
         * <p> 示例值：
         */
        private AppRolesInfo appRolesInfo;

        /**
         * aPaaS 产品应用的名称
         * <p> 示例值：
         *
         * @param name
         * @return
         */
        public Builder name(I18n[] name) {
            this.name = name;
            return this;
        }


        /**
         * aPaaS 产品应用的命名空间
         * <p> 示例值：package_35f605__c
         *
         * @param namespace
         * @return
         */
        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }


        /**
         * aPaaS 产品应用的创建时间
         * <p> 示例值：1736480945563
         *
         * @param createdAt
         * @return
         */
        public Builder createdAt(Integer createdAt) {
            this.createdAt = createdAt;
            return this;
        }


        /**
         * aPaaS 产品应用的所有者
         * <p> 示例值：1818624575806604
         *
         * @param owner
         * @return
         */
        public Builder owner(Integer owner) {
            this.owner = owner;
            return this;
        }


        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         *
         * @param status
         * @return
         */
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         *
         * @param status {@link com.lark.oapi.service.apaas.v1.enums.AppAppDisplayStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.apaas.v1.enums.AppAppDisplayStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * aPaaS 产品应用的成员管理信息
         * <p> 示例值：
         *
         * @param appRolesInfo
         * @return
         */
        public Builder appRolesInfo(AppRolesInfo appRolesInfo) {
            this.appRolesInfo = appRolesInfo;
            return this;
        }


        public App build() {
            return new App(this);
        }
    }
}
