// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ShiftAttendanceTimeConfig {
    /**
     * 应出勤时长
     * <p> 示例值：1
     */
    @SerializedName("attendance_time")
    private Double attendanceTime;
    /**
     * 上半天应出勤时长
     * <p> 示例值：1
     */
    @SerializedName("on_attendance_time")
    private Double onAttendanceTime;
    /**
     * 下半天应出勤时长
     * <p> 示例值：1
     */
    @SerializedName("off_attendance_time")
    private Double offAttendanceTime;

    // builder 开始
    public ShiftAttendanceTimeConfig() {
    }

    public ShiftAttendanceTimeConfig(Builder builder) {
        /**
         * 应出勤时长
         * <p> 示例值：1
         */
        this.attendanceTime = builder.attendanceTime;
        /**
         * 上半天应出勤时长
         * <p> 示例值：1
         */
        this.onAttendanceTime = builder.onAttendanceTime;
        /**
         * 下半天应出勤时长
         * <p> 示例值：1
         */
        this.offAttendanceTime = builder.offAttendanceTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Double getAttendanceTime() {
        return this.attendanceTime;
    }

    public void setAttendanceTime(Double attendanceTime) {
        this.attendanceTime = attendanceTime;
    }

    public Double getOnAttendanceTime() {
        return this.onAttendanceTime;
    }

    public void setOnAttendanceTime(Double onAttendanceTime) {
        this.onAttendanceTime = onAttendanceTime;
    }

    public Double getOffAttendanceTime() {
        return this.offAttendanceTime;
    }

    public void setOffAttendanceTime(Double offAttendanceTime) {
        this.offAttendanceTime = offAttendanceTime;
    }

    public static class Builder {
        /**
         * 应出勤时长
         * <p> 示例值：1
         */
        private Double attendanceTime;
        /**
         * 上半天应出勤时长
         * <p> 示例值：1
         */
        private Double onAttendanceTime;
        /**
         * 下半天应出勤时长
         * <p> 示例值：1
         */
        private Double offAttendanceTime;

        /**
         * 应出勤时长
         * <p> 示例值：1
         *
         * @param attendanceTime
         * @return
         */
        public Builder attendanceTime(Double attendanceTime) {
            this.attendanceTime = attendanceTime;
            return this;
        }


        /**
         * 上半天应出勤时长
         * <p> 示例值：1
         *
         * @param onAttendanceTime
         * @return
         */
        public Builder onAttendanceTime(Double onAttendanceTime) {
            this.onAttendanceTime = onAttendanceTime;
            return this;
        }


        /**
         * 下半天应出勤时长
         * <p> 示例值：1
         *
         * @param offAttendanceTime
         * @return
         */
        public Builder offAttendanceTime(Double offAttendanceTime) {
            this.offAttendanceTime = offAttendanceTime;
            return this;
        }


        public ShiftAttendanceTimeConfig build() {
            return new ShiftAttendanceTimeConfig(this);
        }
    }
}
