// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class SegmentValue {
    /**
     * 分段开始时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
     * <p> 示例值：7220356259681386540
     */
    @SerializedName("start_time")
    private String startTime;
    /**
     * 分段结束时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
     * <p> 示例值：7220356259681386540
     */
    @SerializedName("end_time")
    private String endTime;
    /**
     * 引用类型算薪项分段展示值
     * <p> 示例值：
     */
    @SerializedName("reference_values")
    private I18nContent[] referenceValues;
    /**
     * 算薪项分段原始值
     * <p> 示例值：10000
     */
    @SerializedName("original_value")
    private String originalValue;

    // builder 开始
    public SegmentValue() {
    }

    public SegmentValue(Builder builder) {
        /**
         * 分段开始时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         */
        this.startTime = builder.startTime;
        /**
         * 分段结束时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         */
        this.endTime = builder.endTime;
        /**
         * 引用类型算薪项分段展示值
         * <p> 示例值：
         */
        this.referenceValues = builder.referenceValues;
        /**
         * 算薪项分段原始值
         * <p> 示例值：10000
         */
        this.originalValue = builder.originalValue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public I18nContent[] getReferenceValues() {
        return this.referenceValues;
    }

    public void setReferenceValues(I18nContent[] referenceValues) {
        this.referenceValues = referenceValues;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public static class Builder {
        /**
         * 分段开始时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         */
        private String startTime;
        /**
         * 分段结束时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         */
        private String endTime;
        /**
         * 引用类型算薪项分段展示值
         * <p> 示例值：
         */
        private I18nContent[] referenceValues;
        /**
         * 算薪项分段原始值
         * <p> 示例值：10000
         */
        private String originalValue;

        /**
         * 分段开始时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 分段结束时间-毫秒级时间戳，[start_time, end_time] 是一个左闭右闭区间。
         * <p> 示例值：7220356259681386540
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 引用类型算薪项分段展示值
         * <p> 示例值：
         *
         * @param referenceValues
         * @return
         */
        public Builder referenceValues(I18nContent[] referenceValues) {
            this.referenceValues = referenceValues;
            return this;
        }


        /**
         * 算薪项分段原始值
         * <p> 示例值：10000
         *
         * @param originalValue
         * @return
         */
        public Builder originalValue(String originalValue) {
            this.originalValue = originalValue;
            return this;
        }


        public SegmentValue build() {
            return new SegmentValue(this);
        }
    }
}
