/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.cache.ICache;
import com.lark.oapi.core.cache.LocalCache;
import com.lark.oapi.core.enums.AppType;
import com.lark.oapi.core.enums.BaseUrlEnum;
import com.lark.oapi.core.httpclient.IHttpTransport;
import com.lark.oapi.core.httpclient.OkHttpTransport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.token.AppTicketManager;
import com.lark.oapi.core.token.GlobalAppTicketManager;
import com.lark.oapi.core.token.GlobalTokenManager;
import com.lark.oapi.core.token.TokenManager;
import com.lark.oapi.core.utils.OKHttps;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.service.acs.AcsService;
import com.lark.oapi.service.admin.AdminService;
import com.lark.oapi.service.aily.AilyService;
import com.lark.oapi.service.apaas.ApaasService;
import com.lark.oapi.service.application.ApplicationService;
import com.lark.oapi.service.approval.ApprovalService;
import com.lark.oapi.service.attendance.AttendanceService;
import com.lark.oapi.service.auth.AuthService;
import com.lark.oapi.service.authen.AuthenService;
import com.lark.oapi.service.baike.BaikeService;
import com.lark.oapi.service.bitable.BitableService;
import com.lark.oapi.service.block.BlockService;
import com.lark.oapi.service.board.BoardService;
import com.lark.oapi.service.calendar.CalendarService;
import com.lark.oapi.service.cardkit.CardkitService;
import com.lark.oapi.service.compensation.CompensationService;
import com.lark.oapi.service.contact.ContactService;
import com.lark.oapi.service.corehr.CorehrService;
import com.lark.oapi.service.docs.DocsService;
import com.lark.oapi.service.document_ai.DocumentAiService;
import com.lark.oapi.service.docx.DocxService;
import com.lark.oapi.service.drive.DriveService;
import com.lark.oapi.service.ehr.EhrService;
import com.lark.oapi.service.event.EventService;
import com.lark.oapi.service.ext.ExtService;
import com.lark.oapi.service.helpdesk.HelpdeskService;
import com.lark.oapi.service.hire.HireService;
import com.lark.oapi.service.human_authentication.HumanAuthenticationService;
import com.lark.oapi.service.im.ImService;
import com.lark.oapi.service.lingo.LingoService;
import com.lark.oapi.service.mail.MailService;
import com.lark.oapi.service.mdm.MdmService;
import com.lark.oapi.service.meeting_room.MeetingRoomService;
import com.lark.oapi.service.minutes.MinutesService;
import com.lark.oapi.service.moments.MomentsService;
import com.lark.oapi.service.okr.OkrService;
import com.lark.oapi.service.optical_char_recognition.OpticalCharRecognitionService;
import com.lark.oapi.service.passport.PassportService;
import com.lark.oapi.service.payroll.PayrollService;
import com.lark.oapi.service.performance.PerformanceService;
import com.lark.oapi.service.personal_settings.PersonalSettingsService;
import com.lark.oapi.service.report.ReportService;
import com.lark.oapi.service.search.SearchService;
import com.lark.oapi.service.security_and_compliance.SecurityAndComplianceService;
import com.lark.oapi.service.sheets.SheetsService;
import com.lark.oapi.service.speech_to_text.SpeechToTextService;
import com.lark.oapi.service.task.TaskService;
import com.lark.oapi.service.tenant.TenantService;
import com.lark.oapi.service.translation.TranslationService;
import com.lark.oapi.service.vc.VcService;
import com.lark.oapi.service.verification.VerificationService;
import com.lark.oapi.service.wiki.WikiService;
import com.lark.oapi.service.workplace.WorkplaceService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;

public class Client {
    private Config config;
    private TenantService tenant;
    private WikiService wiki;
    private WorkplaceService workplace;
    private LingoService lingo;
    private PayrollService payroll;
    private CardkitService cardkit;
    private MdmService mdm;
    private ApplicationService application;
    private CalendarService calendar;
    private OkrService okr;
    private SearchService search;
    private BoardService board;
    private MomentsService moments;
    private MeetingRoomService meetingRoom;
    private PassportService passport;
    private DocxService docx;
    private HumanAuthenticationService humanAuthentication;
    private BlockService block;
    private HireService hire;
    private SheetsService sheets;
    private VcService vc;
    private AcsService acs;
    private AdminService admin;
    private DocsService docs;
    private DocumentAiService documentAi;
    private MinutesService minutes;
    private OpticalCharRecognitionService opticalCharRecognition;
    private PersonalSettingsService personalSettings;
    private SpeechToTextService speechToText;
    private AttendanceService attendance;
    private CompensationService compensation;
    private AuthService auth;
    private AuthenService authen;
    private ContactService contact;
    private DriveService drive;
    private EhrService ehr;
    private ImService im;
    private AilyService aily;
    private ApaasService apaas;
    private SecurityAndComplianceService securityAndCompliance;
    private TaskService task;
    private TranslationService translation;
    private MailService mail;
    private ReportService report;
    private BitableService bitable;
    private CorehrService corehr;
    private EventService event;
    private HelpdeskService helpdesk;
    private PerformanceService performance;
    private VerificationService verification;
    private ApprovalService approval;
    private BaikeService baike;
    private ExtService extService;

    public static Builder newBuilder(String appId, String appSecret) {
        return new Builder(appId, appSecret);
    }

    public ExtService ext() {
        return this.extService;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public TenantService tenant() {
        return this.tenant;
    }

    public WikiService wiki() {
        return this.wiki;
    }

    public WorkplaceService workplace() {
        return this.workplace;
    }

    public LingoService lingo() {
        return this.lingo;
    }

    public PayrollService payroll() {
        return this.payroll;
    }

    public CardkitService cardkit() {
        return this.cardkit;
    }

    public MdmService mdm() {
        return this.mdm;
    }

    public ApplicationService application() {
        return this.application;
    }

    public CalendarService calendar() {
        return this.calendar;
    }

    public OkrService okr() {
        return this.okr;
    }

    public SearchService search() {
        return this.search;
    }

    public BoardService board() {
        return this.board;
    }

    public MomentsService moments() {
        return this.moments;
    }

    public MeetingRoomService meetingRoom() {
        return this.meetingRoom;
    }

    public PassportService passport() {
        return this.passport;
    }

    public DocxService docx() {
        return this.docx;
    }

    public HumanAuthenticationService humanAuthentication() {
        return this.humanAuthentication;
    }

    public BlockService block() {
        return this.block;
    }

    public HireService hire() {
        return this.hire;
    }

    public SheetsService sheets() {
        return this.sheets;
    }

    public VcService vc() {
        return this.vc;
    }

    public AcsService acs() {
        return this.acs;
    }

    public AdminService admin() {
        return this.admin;
    }

    public DocsService docs() {
        return this.docs;
    }

    public DocumentAiService documentAi() {
        return this.documentAi;
    }

    public MinutesService minutes() {
        return this.minutes;
    }

    public OpticalCharRecognitionService opticalCharRecognition() {
        return this.opticalCharRecognition;
    }

    public PersonalSettingsService personalSettings() {
        return this.personalSettings;
    }

    public SpeechToTextService speechToText() {
        return this.speechToText;
    }

    public AttendanceService attendance() {
        return this.attendance;
    }

    public CompensationService compensation() {
        return this.compensation;
    }

    public AuthService auth() {
        return this.auth;
    }

    public AuthenService authen() {
        return this.authen;
    }

    public ContactService contact() {
        return this.contact;
    }

    public DriveService drive() {
        return this.drive;
    }

    public EhrService ehr() {
        return this.ehr;
    }

    public ImService im() {
        return this.im;
    }

    public AilyService aily() {
        return this.aily;
    }

    public ApaasService apaas() {
        return this.apaas;
    }

    public SecurityAndComplianceService securityAndCompliance() {
        return this.securityAndCompliance;
    }

    public TaskService task() {
        return this.task;
    }

    public TranslationService translation() {
        return this.translation;
    }

    public MailService mail() {
        return this.mail;
    }

    public ReportService report() {
        return this.report;
    }

    public BitableService bitable() {
        return this.bitable;
    }

    public CorehrService corehr() {
        return this.corehr;
    }

    public EventService event() {
        return this.event;
    }

    public HelpdeskService helpdesk() {
        return this.helpdesk;
    }

    public PerformanceService performance() {
        return this.performance;
    }

    public VerificationService verification() {
        return this.verification;
    }

    public ApprovalService approval() {
        return this.approval;
    }

    public BaikeService baike() {
        return this.baike;
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse post(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "POST", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse get(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "GET", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse delete(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "DELETE", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse put(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PUT", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse patch(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "PATCH", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType, RequestOptions requestOptions) throws Exception {
        return Transport.send(this.config, requestOptions, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public RawResponse options(String httpPath, Object body, AccessTokenType accessTokenType) throws Exception {
        return Transport.send(this.config, null, "OPTIONS", httpPath, Sets.newHashSet(accessTokenType), body);
    }

    public static final class Builder {
        private Config config = new Config();

        public Builder(String appId, String appSecret) {
            this.config.setAppId(appId);
            this.config.setAppSecret(appSecret);
            this.config.setBaseUrl(BaseUrlEnum.FeiShu.getUrl());
            this.config.setAppType(AppType.SELF_BUILT);
            this.config.setDisableTokenCache(false);
        }

        public Builder helpDeskCredential(String helpDeskId, String helpDeskToken) {
            this.config.setHelpDeskToken(helpDeskToken);
            this.config.setHelpDeskID(helpDeskId);
            if (Strings.isNotEmpty(helpDeskId) && Strings.isNotEmpty(helpDeskToken)) {
                this.config.setHelpDeskAuthToken(Base64.getEncoder().encodeToString(String.format("%s:%s", helpDeskId, helpDeskToken).getBytes(StandardCharsets.UTF_8)));
            }
            return this;
        }

        public Builder appType(AppType appType) {
            this.config.setAppType(appType);
            return this;
        }

        public Builder marketplaceApp() {
            this.config.setAppType(AppType.MARKETPLACE);
            return this;
        }

        public Builder disableTokenCache() {
            this.config.setDisableTokenCache(true);
            return this;
        }

        public Builder logReqAtDebug(boolean logReqRespInfoAtDebugLevel) {
            this.config.setLogReqAtDebug(logReqRespInfoAtDebugLevel);
            return this;
        }

        public Builder openBaseUrl(String baseUrl) {
            this.config.setBaseUrl(baseUrl);
            return this;
        }

        public Builder openBaseUrl(BaseUrlEnum baseUrl) {
            this.config.setBaseUrl(baseUrl.getUrl());
            return this;
        }

        public Builder tokenCache(ICache cache) {
            this.config.setCache(cache);
            return this;
        }

        public Builder requestTimeout(long timeout, TimeUnit timeUnit) {
            this.config.setRequestTimeOut(timeout);
            this.config.setTimeOutTimeUnit(timeUnit);
            return this;
        }

        public Builder httpTransport(IHttpTransport httpTransport) {
            this.config.setHttpTransport(httpTransport);
            return this;
        }

        private void initCache(Config config) {
            if (config.getCache() != null) {
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(config.getCache()));
                GlobalTokenManager.setTokenManager(new TokenManager(config.getCache()));
            } else {
                LocalCache cache = LocalCache.getInstance();
                GlobalAppTicketManager.setAppTicketManager(new AppTicketManager(cache));
                GlobalTokenManager.setTokenManager(new TokenManager(cache));
            }
        }

        private void initHttpTransport(Config config) {
            if (config.getHttpTransport() == null) {
                if (config.getRequestTimeOut() > 0L) {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.create(config.getRequestTimeOut(), config.getTimeOutTimeUnit())));
                } else {
                    config.setHttpTransport(new OkHttpTransport(OKHttps.defaultClient));
                }
            }
        }

        public Client build() {
            Client client = new Client();
            client.setConfig(this.config);
            this.initCache(this.config);
            this.initHttpTransport(this.config);
            client.extService = new ExtService(this.config);
            client.tenant = new TenantService(this.config);
            client.wiki = new WikiService(this.config);
            client.workplace = new WorkplaceService(this.config);
            client.lingo = new LingoService(this.config);
            client.payroll = new PayrollService(this.config);
            client.cardkit = new CardkitService(this.config);
            client.mdm = new MdmService(this.config);
            client.application = new ApplicationService(this.config);
            client.calendar = new CalendarService(this.config);
            client.okr = new OkrService(this.config);
            client.search = new SearchService(this.config);
            client.board = new BoardService(this.config);
            client.moments = new MomentsService(this.config);
            client.meetingRoom = new MeetingRoomService(this.config);
            client.passport = new PassportService(this.config);
            client.docx = new DocxService(this.config);
            client.humanAuthentication = new HumanAuthenticationService(this.config);
            client.block = new BlockService(this.config);
            client.hire = new HireService(this.config);
            client.sheets = new SheetsService(this.config);
            client.vc = new VcService(this.config);
            client.acs = new AcsService(this.config);
            client.admin = new AdminService(this.config);
            client.docs = new DocsService(this.config);
            client.documentAi = new DocumentAiService(this.config);
            client.minutes = new MinutesService(this.config);
            client.opticalCharRecognition = new OpticalCharRecognitionService(this.config);
            client.personalSettings = new PersonalSettingsService(this.config);
            client.speechToText = new SpeechToTextService(this.config);
            client.attendance = new AttendanceService(this.config);
            client.compensation = new CompensationService(this.config);
            client.auth = new AuthService(this.config);
            client.authen = new AuthenService(this.config);
            client.contact = new ContactService(this.config);
            client.drive = new DriveService(this.config);
            client.ehr = new EhrService(this.config);
            client.im = new ImService(this.config);
            client.aily = new AilyService(this.config);
            client.apaas = new ApaasService(this.config);
            client.securityAndCompliance = new SecurityAndComplianceService(this.config);
            client.task = new TaskService(this.config);
            client.translation = new TranslationService(this.config);
            client.mail = new MailService(this.config);
            client.report = new ReportService(this.config);
            client.bitable = new BitableService(this.config);
            client.corehr = new CorehrService(this.config);
            client.event = new EventService(this.config);
            client.helpdesk = new HelpdeskService(this.config);
            client.performance = new PerformanceService(this.config);
            client.verification = new VerificationService(this.config);
            client.approval = new ApprovalService(this.config);
            client.baike = new BaikeService(this.config);
            return client;
        }
    }
}

