/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.document_ai.v1.resource;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.service.document_ai.v1.model.RecognizeHealthCertificateReq;
import com.lark.oapi.service.document_ai.v1.model.RecognizeHealthCertificateResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCertificate {
    private static final Logger log = LoggerFactory.getLogger(HealthCertificate.class);
    private final Config config;

    public HealthCertificate(Config config) {
        this.config = config;
    }

    public RecognizeHealthCertificateResp recognize(RecognizeHealthCertificateReq req, RequestOptions reqOptions) throws Exception {
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/health_certificate/recognize", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        RecognizeHealthCertificateResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeHealthCertificateResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/health_certificate/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }

    public RecognizeHealthCertificateResp recognize(RecognizeHealthCertificateReq req) throws Exception {
        RequestOptions reqOptions = new RequestOptions();
        reqOptions.setSupportUpload(true);
        RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/document_ai/v1/health_certificate/recognize", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
        RecognizeHealthCertificateResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RecognizeHealthCertificateResp.class);
        if (resp == null) {
            log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/document_ai/v1/health_certificate/recognize", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
        }
        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        return resp;
    }
}

