// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.approval.v4.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.approval.v4.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class InstanceSearchNode {
    /**
     * 审批实例 code
     * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
     */
    @SerializedName("code")
    private String code;
    /**
     * 审批实例外部 id
     * <p> 示例值：0004_3ED52DC1-AA6C
     */
    @SerializedName("external_id")
    private String externalId;
    /**
     * 审批实例发起人 id
     * <p> 示例值：lwiu098wj
     */
    @SerializedName("user_id")
    private String userId;
    /**
     * 审批实例开始时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("start_time")
    private String startTime;
    /**
     * 审批实例结束时间
     * <p> 示例值：1547654251506
     */
    @SerializedName("end_time")
    private String endTime;
    /**
     * 审批实例状态
     * <p> 示例值：pending
     */
    @SerializedName("status")
    private String status;
    /**
     * 审批实例名称（只有第三方审批有）
     * <p> 示例值：test
     */
    @SerializedName("title")
    private String title;
    /**
     * 审批实例扩展字段，string型json
     * <p> 示例值：{}
     */
    @SerializedName("extra")
    private String extra;
    /**
     * 审批流水号
     * <p> 示例值：201902020001
     */
    @SerializedName("serial_id")
    private String serialId;
    /**
     * 审批实例链接（只有第三方审批有）
     * <p> 示例值：
     */
    @SerializedName("link")
    private InstanceSearchLink link;

    // builder 开始
    public InstanceSearchNode() {
    }

    public InstanceSearchNode(Builder builder) {
        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         */
        this.code = builder.code;
        /**
         * 审批实例外部 id
         * <p> 示例值：0004_3ED52DC1-AA6C
         */
        this.externalId = builder.externalId;
        /**
         * 审批实例发起人 id
         * <p> 示例值：lwiu098wj
         */
        this.userId = builder.userId;
        /**
         * 审批实例开始时间
         * <p> 示例值：1547654251506
         */
        this.startTime = builder.startTime;
        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         */
        this.endTime = builder.endTime;
        /**
         * 审批实例状态
         * <p> 示例值：pending
         */
        this.status = builder.status;
        /**
         * 审批实例名称（只有第三方审批有）
         * <p> 示例值：test
         */
        this.title = builder.title;
        /**
         * 审批实例扩展字段，string型json
         * <p> 示例值：{}
         */
        this.extra = builder.extra;
        /**
         * 审批流水号
         * <p> 示例值：201902020001
         */
        this.serialId = builder.serialId;
        /**
         * 审批实例链接（只有第三方审批有）
         * <p> 示例值：
         */
        this.link = builder.link;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    public InstanceSearchLink getLink() {
        return this.link;
    }

    public void setLink(InstanceSearchLink link) {
        this.link = link;
    }

    public static class Builder {
        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         */
        private String code;
        /**
         * 审批实例外部 id
         * <p> 示例值：0004_3ED52DC1-AA6C
         */
        private String externalId;
        /**
         * 审批实例发起人 id
         * <p> 示例值：lwiu098wj
         */
        private String userId;
        /**
         * 审批实例开始时间
         * <p> 示例值：1547654251506
         */
        private String startTime;
        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         */
        private String endTime;
        /**
         * 审批实例状态
         * <p> 示例值：pending
         */
        private String status;
        /**
         * 审批实例名称（只有第三方审批有）
         * <p> 示例值：test
         */
        private String title;
        /**
         * 审批实例扩展字段，string型json
         * <p> 示例值：{}
         */
        private String extra;
        /**
         * 审批流水号
         * <p> 示例值：201902020001
         */
        private String serialId;
        /**
         * 审批实例链接（只有第三方审批有）
         * <p> 示例值：
         */
        private InstanceSearchLink link;

        /**
         * 审批实例 code
         * <p> 示例值：EB828003-9FFE-4B3F-AA50-2E199E2ED943
         *
         * @param code
         * @return
         */
        public Builder code(String code) {
            this.code = code;
            return this;
        }


        /**
         * 审批实例外部 id
         * <p> 示例值：0004_3ED52DC1-AA6C
         *
         * @param externalId
         * @return
         */
        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }


        /**
         * 审批实例发起人 id
         * <p> 示例值：lwiu098wj
         *
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 审批实例开始时间
         * <p> 示例值：1547654251506
         *
         * @param startTime
         * @return
         */
        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }


        /**
         * 审批实例结束时间
         * <p> 示例值：1547654251506
         *
         * @param endTime
         * @return
         */
        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }


        /**
         * 审批实例状态
         * <p> 示例值：pending
         *
         * @param status
         * @return
         */
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        /**
         * 审批实例状态
         * <p> 示例值：pending
         *
         * @param status {@link com.lark.oapi.service.approval.v4.enums.InstanceSearchNodeStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.approval.v4.enums.InstanceSearchNodeStatusEnum status) {
            this.status = status.getValue();
            return this;
        }


        /**
         * 审批实例名称（只有第三方审批有）
         * <p> 示例值：test
         *
         * @param title
         * @return
         */
        public Builder title(String title) {
            this.title = title;
            return this;
        }


        /**
         * 审批实例扩展字段，string型json
         * <p> 示例值：{}
         *
         * @param extra
         * @return
         */
        public Builder extra(String extra) {
            this.extra = extra;
            return this;
        }


        /**
         * 审批流水号
         * <p> 示例值：201902020001
         *
         * @param serialId
         * @return
         */
        public Builder serialId(String serialId) {
            this.serialId = serialId;
            return this;
        }


        /**
         * 审批实例链接（只有第三方审批有）
         * <p> 示例值：
         *
         * @param link
         * @return
         */
        public Builder link(InstanceSearchLink link) {
            this.link = link;
            return this;
        }


        public InstanceSearchNode build() {
            return new InstanceSearchNode(this);
        }
    }
}
