// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ApplicationDetailBasicInfo {
    /**
     * 投递 ID
     * <p> 示例值：6949805467799537964
     */
    @SerializedName("id")
    private String id;
    /**
     * 投递的职位 ID
     * <p> 示例值：6843547872837273223
     */
    @SerializedName("job_id")
    private String jobId;
    /**
     * 投递的人才 ID
     * <p> 示例值：6843547872837273223
     */
    @SerializedName("talent_id")
    private String talentId;
    /**
     * 投递处于的阶段
     * <p> 示例值：
     */
    @SerializedName("stage")
    private ApplicationStageInfo stage;
    /**
     * 投递活跃状态
     * <p> 示例值：1
     */
    @SerializedName("active_status")
    private Integer activeStatus;
    /**
     * 投递方式
     * <p> 示例值：1
     */
    @SerializedName("delivery_type")
    private Integer deliveryType;
    /**
     * 投递来源信息
     * <p> 示例值：
     */
    @SerializedName("resume_source_info")
    private ApplicationResumeSource resumeSourceInfo;
    /**
     * 官网投递来源
     * <p> 示例值：
     */
    @SerializedName("website_resume_source")
    private ApplicationWebsiteResumeSource websiteResumeSource;
    /**
     * 简历附件 ID
     * <p> 示例值：6960663240925956415
     */
    @SerializedName("talent_attachment_resume_id")
    private String talentAttachmentResumeId;
    /**
     * 投递阶段变更时间列表
     * <p> 示例值：
     */
    @SerializedName("stage_time_list")
    private ApplicationStageTime[] stageTimeList;
    /**
     * 投递入职状态
     * <p> 示例值：1
     */
    @SerializedName("onboard_status")
    private Integer onboardStatus;
    /**
     * 意向投递城市列表
     * <p> 示例值：
     */
    @SerializedName("application_preferred_city_list")
    private CodeNameObject[] applicationPreferredCityList;
    /**
     * 投递终止原因
     * <p> 示例值：
     */
    @SerializedName("termination_reason")
    private TerminationReasonInfo terminationReason;
    /**
     * 投递创建者 ID，仅当投递创建人为企业内部员工时可获取（如员工手动上传简历 / 加入职位 / 内推），其余情况返回为空（如候选人主动投递）
     * <p> 示例值：ou_ce613028fe74745421f5dc320bb9c709
     */
    @SerializedName("creator_id")
    private String creatorId;
    /**
     * 投递所有者 ID
     * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
     */
    @SerializedName("owner_id")
    private String ownerId;
    /**
     * 投递终止者 ID
     * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
     */
    @SerializedName("terminator_id")
    private String terminatorId;
    /**
     * 创建时间戳（单位：毫秒）
     * <p> 示例值：1632990774278
     */
    @SerializedName("create_time")
    private String createTime;
    /**
     * 修改时间戳（单位：毫秒）
     * <p> 示例值：1634801678103
     */
    @SerializedName("modify_time")
    private String modifyTime;

    // builder 开始
    public ApplicationDetailBasicInfo() {
    }

    public ApplicationDetailBasicInfo(Builder builder) {
        /**
         * 投递 ID
         * <p> 示例值：6949805467799537964
         */
        this.id = builder.id;
        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         */
        this.jobId = builder.jobId;
        /**
         * 投递的人才 ID
         * <p> 示例值：6843547872837273223
         */
        this.talentId = builder.talentId;
        /**
         * 投递处于的阶段
         * <p> 示例值：
         */
        this.stage = builder.stage;
        /**
         * 投递活跃状态
         * <p> 示例值：1
         */
        this.activeStatus = builder.activeStatus;
        /**
         * 投递方式
         * <p> 示例值：1
         */
        this.deliveryType = builder.deliveryType;
        /**
         * 投递来源信息
         * <p> 示例值：
         */
        this.resumeSourceInfo = builder.resumeSourceInfo;
        /**
         * 官网投递来源
         * <p> 示例值：
         */
        this.websiteResumeSource = builder.websiteResumeSource;
        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         */
        this.talentAttachmentResumeId = builder.talentAttachmentResumeId;
        /**
         * 投递阶段变更时间列表
         * <p> 示例值：
         */
        this.stageTimeList = builder.stageTimeList;
        /**
         * 投递入职状态
         * <p> 示例值：1
         */
        this.onboardStatus = builder.onboardStatus;
        /**
         * 意向投递城市列表
         * <p> 示例值：
         */
        this.applicationPreferredCityList = builder.applicationPreferredCityList;
        /**
         * 投递终止原因
         * <p> 示例值：
         */
        this.terminationReason = builder.terminationReason;
        /**
         * 投递创建者 ID，仅当投递创建人为企业内部员工时可获取（如员工手动上传简历 / 加入职位 / 内推），其余情况返回为空（如候选人主动投递）
         * <p> 示例值：ou_ce613028fe74745421f5dc320bb9c709
         */
        this.creatorId = builder.creatorId;
        /**
         * 投递所有者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         */
        this.ownerId = builder.ownerId;
        /**
         * 投递终止者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         */
        this.terminatorId = builder.terminatorId;
        /**
         * 创建时间戳（单位：毫秒）
         * <p> 示例值：1632990774278
         */
        this.createTime = builder.createTime;
        /**
         * 修改时间戳（单位：毫秒）
         * <p> 示例值：1634801678103
         */
        this.modifyTime = builder.modifyTime;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTalentId() {
        return this.talentId;
    }

    public void setTalentId(String talentId) {
        this.talentId = talentId;
    }

    public ApplicationStageInfo getStage() {
        return this.stage;
    }

    public void setStage(ApplicationStageInfo stage) {
        this.stage = stage;
    }

    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public Integer getDeliveryType() {
        return this.deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public ApplicationResumeSource getResumeSourceInfo() {
        return this.resumeSourceInfo;
    }

    public void setResumeSourceInfo(ApplicationResumeSource resumeSourceInfo) {
        this.resumeSourceInfo = resumeSourceInfo;
    }

    public ApplicationWebsiteResumeSource getWebsiteResumeSource() {
        return this.websiteResumeSource;
    }

    public void setWebsiteResumeSource(ApplicationWebsiteResumeSource websiteResumeSource) {
        this.websiteResumeSource = websiteResumeSource;
    }

    public String getTalentAttachmentResumeId() {
        return this.talentAttachmentResumeId;
    }

    public void setTalentAttachmentResumeId(String talentAttachmentResumeId) {
        this.talentAttachmentResumeId = talentAttachmentResumeId;
    }

    public ApplicationStageTime[] getStageTimeList() {
        return this.stageTimeList;
    }

    public void setStageTimeList(ApplicationStageTime[] stageTimeList) {
        this.stageTimeList = stageTimeList;
    }

    public Integer getOnboardStatus() {
        return this.onboardStatus;
    }

    public void setOnboardStatus(Integer onboardStatus) {
        this.onboardStatus = onboardStatus;
    }

    public CodeNameObject[] getApplicationPreferredCityList() {
        return this.applicationPreferredCityList;
    }

    public void setApplicationPreferredCityList(CodeNameObject[] applicationPreferredCityList) {
        this.applicationPreferredCityList = applicationPreferredCityList;
    }

    public TerminationReasonInfo getTerminationReason() {
        return this.terminationReason;
    }

    public void setTerminationReason(TerminationReasonInfo terminationReason) {
        this.terminationReason = terminationReason;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getTerminatorId() {
        return this.terminatorId;
    }

    public void setTerminatorId(String terminatorId) {
        this.terminatorId = terminatorId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }

    public static class Builder {
        /**
         * 投递 ID
         * <p> 示例值：6949805467799537964
         */
        private String id;
        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         */
        private String jobId;
        /**
         * 投递的人才 ID
         * <p> 示例值：6843547872837273223
         */
        private String talentId;
        /**
         * 投递处于的阶段
         * <p> 示例值：
         */
        private ApplicationStageInfo stage;
        /**
         * 投递活跃状态
         * <p> 示例值：1
         */
        private Integer activeStatus;
        /**
         * 投递方式
         * <p> 示例值：1
         */
        private Integer deliveryType;
        /**
         * 投递来源信息
         * <p> 示例值：
         */
        private ApplicationResumeSource resumeSourceInfo;
        /**
         * 官网投递来源
         * <p> 示例值：
         */
        private ApplicationWebsiteResumeSource websiteResumeSource;
        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         */
        private String talentAttachmentResumeId;
        /**
         * 投递阶段变更时间列表
         * <p> 示例值：
         */
        private ApplicationStageTime[] stageTimeList;
        /**
         * 投递入职状态
         * <p> 示例值：1
         */
        private Integer onboardStatus;
        /**
         * 意向投递城市列表
         * <p> 示例值：
         */
        private CodeNameObject[] applicationPreferredCityList;
        /**
         * 投递终止原因
         * <p> 示例值：
         */
        private TerminationReasonInfo terminationReason;
        /**
         * 投递创建者 ID，仅当投递创建人为企业内部员工时可获取（如员工手动上传简历 / 加入职位 / 内推），其余情况返回为空（如候选人主动投递）
         * <p> 示例值：ou_ce613028fe74745421f5dc320bb9c709
         */
        private String creatorId;
        /**
         * 投递所有者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         */
        private String ownerId;
        /**
         * 投递终止者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         */
        private String terminatorId;
        /**
         * 创建时间戳（单位：毫秒）
         * <p> 示例值：1632990774278
         */
        private String createTime;
        /**
         * 修改时间戳（单位：毫秒）
         * <p> 示例值：1634801678103
         */
        private String modifyTime;

        /**
         * 投递 ID
         * <p> 示例值：6949805467799537964
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 投递的职位 ID
         * <p> 示例值：6843547872837273223
         *
         * @param jobId
         * @return
         */
        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }


        /**
         * 投递的人才 ID
         * <p> 示例值：6843547872837273223
         *
         * @param talentId
         * @return
         */
        public Builder talentId(String talentId) {
            this.talentId = talentId;
            return this;
        }


        /**
         * 投递处于的阶段
         * <p> 示例值：
         *
         * @param stage
         * @return
         */
        public Builder stage(ApplicationStageInfo stage) {
            this.stage = stage;
            return this;
        }


        /**
         * 投递活跃状态
         * <p> 示例值：1
         *
         * @param activeStatus
         * @return
         */
        public Builder activeStatus(Integer activeStatus) {
            this.activeStatus = activeStatus;
            return this;
        }


        /**
         * 投递方式
         * <p> 示例值：1
         *
         * @param deliveryType
         * @return
         */
        public Builder deliveryType(Integer deliveryType) {
            this.deliveryType = deliveryType;
            return this;
        }


        /**
         * 投递来源信息
         * <p> 示例值：
         *
         * @param resumeSourceInfo
         * @return
         */
        public Builder resumeSourceInfo(ApplicationResumeSource resumeSourceInfo) {
            this.resumeSourceInfo = resumeSourceInfo;
            return this;
        }


        /**
         * 官网投递来源
         * <p> 示例值：
         *
         * @param websiteResumeSource
         * @return
         */
        public Builder websiteResumeSource(ApplicationWebsiteResumeSource websiteResumeSource) {
            this.websiteResumeSource = websiteResumeSource;
            return this;
        }


        /**
         * 简历附件 ID
         * <p> 示例值：6960663240925956415
         *
         * @param talentAttachmentResumeId
         * @return
         */
        public Builder talentAttachmentResumeId(String talentAttachmentResumeId) {
            this.talentAttachmentResumeId = talentAttachmentResumeId;
            return this;
        }


        /**
         * 投递阶段变更时间列表
         * <p> 示例值：
         *
         * @param stageTimeList
         * @return
         */
        public Builder stageTimeList(ApplicationStageTime[] stageTimeList) {
            this.stageTimeList = stageTimeList;
            return this;
        }


        /**
         * 投递入职状态
         * <p> 示例值：1
         *
         * @param onboardStatus
         * @return
         */
        public Builder onboardStatus(Integer onboardStatus) {
            this.onboardStatus = onboardStatus;
            return this;
        }


        /**
         * 意向投递城市列表
         * <p> 示例值：
         *
         * @param applicationPreferredCityList
         * @return
         */
        public Builder applicationPreferredCityList(CodeNameObject[] applicationPreferredCityList) {
            this.applicationPreferredCityList = applicationPreferredCityList;
            return this;
        }


        /**
         * 投递终止原因
         * <p> 示例值：
         *
         * @param terminationReason
         * @return
         */
        public Builder terminationReason(TerminationReasonInfo terminationReason) {
            this.terminationReason = terminationReason;
            return this;
        }


        /**
         * 投递创建者 ID，仅当投递创建人为企业内部员工时可获取（如员工手动上传简历 / 加入职位 / 内推），其余情况返回为空（如候选人主动投递）
         * <p> 示例值：ou_ce613028fe74745421f5dc320bb9c709
         *
         * @param creatorId
         * @return
         */
        public Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }


        /**
         * 投递所有者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         *
         * @param ownerId
         * @return
         */
        public Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }


        /**
         * 投递终止者 ID
         * <p> 示例值：ou_ce913028fe74123221f5dc320bb9c709
         *
         * @param terminatorId
         * @return
         */
        public Builder terminatorId(String terminatorId) {
            this.terminatorId = terminatorId;
            return this;
        }


        /**
         * 创建时间戳（单位：毫秒）
         * <p> 示例值：1632990774278
         *
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }


        /**
         * 修改时间戳（单位：毫秒）
         * <p> 示例值：1634801678103
         *
         * @param modifyTime
         * @return
         */
        public Builder modifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
            return this;
        }


        public ApplicationDetailBasicInfo build() {
            return new ApplicationDetailBasicInfo(this);
        }
    }
}
