// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.payroll.v1.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.payroll.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class CostAllocationPlan {
    /**
     * 唯一标识
     * <p> 示例值：6823630319749580301
     */
    @SerializedName("id")
    private String id;
    /**
     * 方案名称
     * <p> 示例值：
     */
    @SerializedName("names")
    private I18nContent[] names;
    /**
     * 适用国家
     * <p> 示例值：6823630319749580302
     */
    @SerializedName("applicable_country_region")
    private String applicableCountryRegion;
    /**
     * 成本分摊方案对应的汇总维度列表
     * <p> 示例值：
     */
    @SerializedName("dimensions")
    private Dimension[] dimensions;
    /**
     * 成本分摊方案对应的成本项列表
     * <p> 示例值：
     */
    @SerializedName("cost_items")
    private CostItem[] costItems;

    // builder 开始
    public CostAllocationPlan() {
    }

    public CostAllocationPlan(Builder builder) {
        /**
         * 唯一标识
         * <p> 示例值：6823630319749580301
         */
        this.id = builder.id;
        /**
         * 方案名称
         * <p> 示例值：
         */
        this.names = builder.names;
        /**
         * 适用国家
         * <p> 示例值：6823630319749580302
         */
        this.applicableCountryRegion = builder.applicableCountryRegion;
        /**
         * 成本分摊方案对应的汇总维度列表
         * <p> 示例值：
         */
        this.dimensions = builder.dimensions;
        /**
         * 成本分摊方案对应的成本项列表
         * <p> 示例值：
         */
        this.costItems = builder.costItems;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public I18nContent[] getNames() {
        return this.names;
    }

    public void setNames(I18nContent[] names) {
        this.names = names;
    }

    public String getApplicableCountryRegion() {
        return this.applicableCountryRegion;
    }

    public void setApplicableCountryRegion(String applicableCountryRegion) {
        this.applicableCountryRegion = applicableCountryRegion;
    }

    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimension[] dimensions) {
        this.dimensions = dimensions;
    }

    public CostItem[] getCostItems() {
        return this.costItems;
    }

    public void setCostItems(CostItem[] costItems) {
        this.costItems = costItems;
    }

    public static class Builder {
        /**
         * 唯一标识
         * <p> 示例值：6823630319749580301
         */
        private String id;
        /**
         * 方案名称
         * <p> 示例值：
         */
        private I18nContent[] names;
        /**
         * 适用国家
         * <p> 示例值：6823630319749580302
         */
        private String applicableCountryRegion;
        /**
         * 成本分摊方案对应的汇总维度列表
         * <p> 示例值：
         */
        private Dimension[] dimensions;
        /**
         * 成本分摊方案对应的成本项列表
         * <p> 示例值：
         */
        private CostItem[] costItems;

        /**
         * 唯一标识
         * <p> 示例值：6823630319749580301
         *
         * @param id
         * @return
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }


        /**
         * 方案名称
         * <p> 示例值：
         *
         * @param names
         * @return
         */
        public Builder names(I18nContent[] names) {
            this.names = names;
            return this;
        }


        /**
         * 适用国家
         * <p> 示例值：6823630319749580302
         *
         * @param applicableCountryRegion
         * @return
         */
        public Builder applicableCountryRegion(String applicableCountryRegion) {
            this.applicableCountryRegion = applicableCountryRegion;
            return this;
        }


        /**
         * 成本分摊方案对应的汇总维度列表
         * <p> 示例值：
         *
         * @param dimensions
         * @return
         */
        public Builder dimensions(Dimension[] dimensions) {
            this.dimensions = dimensions;
            return this;
        }


        /**
         * 成本分摊方案对应的成本项列表
         * <p> 示例值：
         *
         * @param costItems
         * @return
         */
        public Builder costItems(CostItem[] costItems) {
            this.costItems = costItems;
            return this;
        }


        public CostAllocationPlan build() {
            return new CostAllocationPlan(this);
        }
    }
}
