// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.performance.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.performance.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class ReviewProfile {
    /**
     * 被评估人 ID
     * <p> 示例值：
     */
    @SerializedName("user_id")
    private User userId;
    /**
     * 绩效评估周期 ID
     * <p> 示例值：7343513161666707459
     */
    @SerializedName("semester_id")
    private String semesterId;
    /**
     * 绩效评估项目 ID
     * <p> 示例值：7343513161666707459
     */
    @SerializedName("activity_id")
    private String activityId;
    /**
     * 被评估人在该周期对应的后台评估模板 ID
     * <p> 示例值：7343513161666707459
     */
    @SerializedName("review_template_id")
    private String reviewTemplateId;
    /**
     * 本周期内各环节内容
     * <p> 示例值：
     */
    @SerializedName("stages")
    private ReviewStage[] stages;

    // builder 开始
    public ReviewProfile() {
    }

    public ReviewProfile(Builder builder) {
        /**
         * 被评估人 ID
         * <p> 示例值：
         */
        this.userId = builder.userId;
        /**
         * 绩效评估周期 ID
         * <p> 示例值：7343513161666707459
         */
        this.semesterId = builder.semesterId;
        /**
         * 绩效评估项目 ID
         * <p> 示例值：7343513161666707459
         */
        this.activityId = builder.activityId;
        /**
         * 被评估人在该周期对应的后台评估模板 ID
         * <p> 示例值：7343513161666707459
         */
        this.reviewTemplateId = builder.reviewTemplateId;
        /**
         * 本周期内各环节内容
         * <p> 示例值：
         */
        this.stages = builder.stages;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public User getUserId() {
        return this.userId;
    }

    public void setUserId(User userId) {
        this.userId = userId;
    }

    public String getSemesterId() {
        return this.semesterId;
    }

    public void setSemesterId(String semesterId) {
        this.semesterId = semesterId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getReviewTemplateId() {
        return this.reviewTemplateId;
    }

    public void setReviewTemplateId(String reviewTemplateId) {
        this.reviewTemplateId = reviewTemplateId;
    }

    public ReviewStage[] getStages() {
        return this.stages;
    }

    public void setStages(ReviewStage[] stages) {
        this.stages = stages;
    }

    public static class Builder {
        /**
         * 被评估人 ID
         * <p> 示例值：
         */
        private User userId;
        /**
         * 绩效评估周期 ID
         * <p> 示例值：7343513161666707459
         */
        private String semesterId;
        /**
         * 绩效评估项目 ID
         * <p> 示例值：7343513161666707459
         */
        private String activityId;
        /**
         * 被评估人在该周期对应的后台评估模板 ID
         * <p> 示例值：7343513161666707459
         */
        private String reviewTemplateId;
        /**
         * 本周期内各环节内容
         * <p> 示例值：
         */
        private ReviewStage[] stages;

        /**
         * 被评估人 ID
         * <p> 示例值：
         *
         * @param userId
         * @return
         */
        public Builder userId(User userId) {
            this.userId = userId;
            return this;
        }


        /**
         * 绩效评估周期 ID
         * <p> 示例值：7343513161666707459
         *
         * @param semesterId
         * @return
         */
        public Builder semesterId(String semesterId) {
            this.semesterId = semesterId;
            return this;
        }


        /**
         * 绩效评估项目 ID
         * <p> 示例值：7343513161666707459
         *
         * @param activityId
         * @return
         */
        public Builder activityId(String activityId) {
            this.activityId = activityId;
            return this;
        }


        /**
         * 被评估人在该周期对应的后台评估模板 ID
         * <p> 示例值：7343513161666707459
         *
         * @param reviewTemplateId
         * @return
         */
        public Builder reviewTemplateId(String reviewTemplateId) {
            this.reviewTemplateId = reviewTemplateId;
            return this;
        }


        /**
         * 本周期内各环节内容
         * <p> 示例值：
         *
         * @param stages
         * @return
         */
        public Builder stages(ReviewStage[] stages) {
            this.stages = stages;
            return this;
        }


        public ReviewProfile build() {
            return new ReviewProfile(this);
        }
    }
}
