// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.search.v2.model;

import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.search.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;

public class KnowledgeSourceAnswerRequest {
    /**
     * query
     * <p> 示例值：hello
     */
    @SerializedName("query")
    private String query;
    /**
     * enable_image
     * <p> 示例值：false
     */
    @SerializedName("enable_image")
    private Boolean enableImage;
    /**
     * 指定答案生成的范围
     * <p> 示例值：enterprise/internet/llm
     */
    @SerializedName("knowledge_scope")
    private String knowledgeScope;
    /**
     * enterprise_knowledge_source
     * <p> 示例值：
     */
    @SerializedName("enterprise_knowledge_source")
    private EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource;
    /**
     * extra
     * <p> 示例值：
     */
    @SerializedName("extra")
    private KnowledgeSourceRequestExtra extra;

    // builder 开始
    public KnowledgeSourceAnswerRequest() {
    }

    public KnowledgeSourceAnswerRequest(Builder builder) {
        /**
         * query
         * <p> 示例值：hello
         */
        this.query = builder.query;
        /**
         * enable_image
         * <p> 示例值：false
         */
        this.enableImage = builder.enableImage;
        /**
         * 指定答案生成的范围
         * <p> 示例值：enterprise/internet/llm
         */
        this.knowledgeScope = builder.knowledgeScope;
        /**
         * enterprise_knowledge_source
         * <p> 示例值：
         */
        this.enterpriseKnowledgeSource = builder.enterpriseKnowledgeSource;
        /**
         * extra
         * <p> 示例值：
         */
        this.extra = builder.extra;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Boolean getEnableImage() {
        return this.enableImage;
    }

    public void setEnableImage(Boolean enableImage) {
        this.enableImage = enableImage;
    }

    public String getKnowledgeScope() {
        return this.knowledgeScope;
    }

    public void setKnowledgeScope(String knowledgeScope) {
        this.knowledgeScope = knowledgeScope;
    }

    public EnterpriseKnowledgeSourceParam getEnterpriseKnowledgeSource() {
        return this.enterpriseKnowledgeSource;
    }

    public void setEnterpriseKnowledgeSource(EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource) {
        this.enterpriseKnowledgeSource = enterpriseKnowledgeSource;
    }

    public KnowledgeSourceRequestExtra getExtra() {
        return this.extra;
    }

    public void setExtra(KnowledgeSourceRequestExtra extra) {
        this.extra = extra;
    }

    public static class Builder {
        /**
         * query
         * <p> 示例值：hello
         */
        private String query;
        /**
         * enable_image
         * <p> 示例值：false
         */
        private Boolean enableImage;
        /**
         * 指定答案生成的范围
         * <p> 示例值：enterprise/internet/llm
         */
        private String knowledgeScope;
        /**
         * enterprise_knowledge_source
         * <p> 示例值：
         */
        private EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource;
        /**
         * extra
         * <p> 示例值：
         */
        private KnowledgeSourceRequestExtra extra;

        /**
         * query
         * <p> 示例值：hello
         *
         * @param query
         * @return
         */
        public Builder query(String query) {
            this.query = query;
            return this;
        }


        /**
         * enable_image
         * <p> 示例值：false
         *
         * @param enableImage
         * @return
         */
        public Builder enableImage(Boolean enableImage) {
            this.enableImage = enableImage;
            return this;
        }


        /**
         * 指定答案生成的范围
         * <p> 示例值：enterprise/internet/llm
         *
         * @param knowledgeScope
         * @return
         */
        public Builder knowledgeScope(String knowledgeScope) {
            this.knowledgeScope = knowledgeScope;
            return this;
        }


        /**
         * enterprise_knowledge_source
         * <p> 示例值：
         *
         * @param enterpriseKnowledgeSource
         * @return
         */
        public Builder enterpriseKnowledgeSource(EnterpriseKnowledgeSourceParam enterpriseKnowledgeSource) {
            this.enterpriseKnowledgeSource = enterpriseKnowledgeSource;
            return this;
        }


        /**
         * extra
         * <p> 示例值：
         *
         * @param extra
         * @return
         */
        public Builder extra(KnowledgeSourceRequestExtra extra) {
            this.extra = extra;
            return this;
        }


        public KnowledgeSourceAnswerRequest build() {
            return new KnowledgeSourceAnswerRequest(this);
        }
    }
}
