// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.acs;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.acs.v1.V1;
import com.lark.oapi.service.acs.v1.model.*;
import com.lark.oapi.service.acs.v1.resource.AccessRecord;
import com.lark.oapi.service.acs.v1.resource.AccessRecordAccessPhoto;
import com.lark.oapi.service.acs.v1.resource.Device;
import com.lark.oapi.service.acs.v1.resource.RuleExternal;
import com.lark.oapi.service.acs.v1.resource.User;
import com.lark.oapi.service.acs.v1.resource.UserFace;
import com.lark.oapi.service.acs.v1.resource.Visitor;

public class AcsService {
    private final V1 v1;
    private final AccessRecord accessRecord; // 门禁记录
    private final AccessRecordAccessPhoto accessRecordAccessPhoto; // access_record.access_photo
    private final Device device; // 门禁设备
    private final RuleExternal ruleExternal; // rule_external
    private final User user; // 用户管理
    private final UserFace userFace; // user.face
    private final Visitor visitor; // visitor

    public AcsService(Config config) {
    this.v1 = new V1(config);
    this.accessRecord = new AccessRecord(config);
    this.accessRecordAccessPhoto = new AccessRecordAccessPhoto(config);
    this.device = new Device(config);
    this.ruleExternal = new RuleExternal(config);
    this.user = new User(config);
    this.userFace = new UserFace(config);
    this.visitor = new Visitor(config);
    }
    public V1 v1() {
        return v1;
    }
    public AccessRecord accessRecord() {
        return accessRecord;
    }
    public AccessRecordAccessPhoto accessRecordAccessPhoto() {
        return accessRecordAccessPhoto;
    }
    public Device device() {
        return device;
    }
    public RuleExternal ruleExternal() {
        return ruleExternal;
    }
    public User user() {
        return user;
    }
    public UserFace userFace() {
        return userFace;
    }
    public Visitor visitor() {
        return visitor;
    }
    public abstract static class P2AccessRecordCreatedV1Handler implements IEventHandler<P2AccessRecordCreatedV1> {
        @Override
        public P2AccessRecordCreatedV1 getEvent() {
            return new P2AccessRecordCreatedV1();
        }
    }
    public abstract static class P2UserUpdatedV1Handler implements IEventHandler<P2UserUpdatedV1> {
        @Override
        public P2UserUpdatedV1 getEvent() {
            return new P2UserUpdatedV1();
        }
    }
}