// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.admin.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.admin.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class UserReport2023 {
     /**
      * 用户ID
      * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
      */
    @SerializedName("user_id")
    private String userId;
     /**
      * 所在租户目前的总人数,已激活、未离职
      * <p> 示例值：171434
      */
    @SerializedName("tenant_all_cnt")
    private Integer tenantAllCnt;
     /**
      * 用户的飞书激活日期,yyyyMMdd格式(201909之前的用户可能是空)
      * <p> 示例值：20200720
      */
    @SerializedName("user_register_date")
    private String userRegisterDate;
     /**
      * 用户激活至今的天数
      * <p> 示例值：1245
      */
    @SerializedName("all_day_cnt")
    private Integer allDayCnt;
     /**
      * 用户2023年内活跃时长> 0的天数
      * <p> 示例值：365
      */
    @SerializedName("active_day_cnt")
    private Integer activeDayCnt;
     /**
      * 用户2022-2023使用总时长(格式0.01h),共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
      * <p> 示例值：
      */
    @SerializedName("duration_cnt_2")
    private AnnualReportMapFloat[] durationCnt2;
     /**
      * 2023年全年活跃时长的排名。
      * <p> 示例值：21338
      */
    @SerializedName("duration_cnt_rank")
    private String durationCntRank;
     /**
      * 用户2023年最忙碌一个月。最忙碌一个月的定义:所有自然月中,飞书在线时长最长的一个月。
      * <p> 示例值：7
      */
    @SerializedName("busy_month")
    private String busyMonth;
     /**
      * 用户2023年最忙碌一个月的活跃时长(格式0.01h)
      * <p> 示例值：5702
      */
    @SerializedName("busy_month_sum_duration")
    private Double busyMonthSumDuration;
     /**
      * 用户2023年最忙碌一个月的发消息数
      * <p> 示例值：78169
      */
    @SerializedName("busy_month_send_msg_cnt")
    private Integer busyMonthSendMsgCnt;
     /**
      * 用户2023年最忙碌一个月的参会数(指本人发起的会议+受邀参与的会议)
      * <p> 示例值：5702
      */
    @SerializedName("busy_month_meeting_cnt")
    private Integer busyMonthMeetingCnt;
     /**
      * 用户2023年最忙碌一个月的会议结束最晚的时间(格式 : 【20230507 23:59】)。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
      * <p> 示例值：2:25
      */
    @SerializedName("busy_month_last_meeting_time")
    private String busyMonthLastMeetingTime;
     /**
      * 用户2023年最忙碌一个月的创建+编辑评论文档
      * <p> 示例值：5702
      */
    @SerializedName("busy_month_create_edit_file_cnt")
    private Integer busyMonthCreateEditFileCnt;
     /**
      * 用户2022-2023发消息数，共2组键值对，表示2年各自的数据。举例:[{"year":"2022","count":"33”},{"year":"2023","count":"55"}]
      * <p> 示例值：
      */
    @SerializedName("im_send_msg_cnt_2")
    private AnnualReportMapInt[] imSendMsgCnt2;
     /**
      * 用户2023年发出消息数,在租户内的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("im_send_msg_cnt_rank")
    private String imSendMsgCntRank;
     /**
      * 用户2023年发消息最多的一天
      * <p> 示例值：20230916
      */
    @SerializedName("im_busy_date")
    private String imBusyDate;
     /**
      * 用户2023年发消息最多的一天发消息条数
      * <p> 示例值：89
      */
    @SerializedName("im_busy_date_send_msg_cnt")
    private Integer imBusyDateSendMsgCnt;
     /**
      * 用户2023年发出时间最晚的一条消息的时间,时间格式, 【20230507 23:59】。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
      * <p> 示例值：3:11
      */
    @SerializedName("im_last_send_msg_time")
    private String imLastSendMsgTime;
     /**
      * 用户2023年发过言的群数
      * <p> 示例值：21338
      */
    @SerializedName("im_talked_chat_cnt")
    private Integer imTalkedChatCnt;
     /**
      * 用户2023年私聊过的人数
      * <p> 示例值：21338
      */
    @SerializedName("im_private_chat_cnt")
    private Integer imPrivateChatCnt;
     /**
      * 用户2023年使用最多的表情1
      * <p> 示例值：thumbsup
      */
    @SerializedName("im_emoji_top1")
    private String imEmojiTop1;
     /**
      * 用户2023年使用最多的表情1次数
      * <p> 示例值：21338
      */
    @SerializedName("im_emoji_top1_cnt")
    private String imEmojiTop1Cnt;
     /**
      * 用户2023年使用最多的表情2
      * <p> 示例值：jiayi
      */
    @SerializedName("im_emoji_top2")
    private String imEmojiTop2;
     /**
      * 用户2023年使用最多的表情2次数
      * <p> 示例值：21338
      */
    @SerializedName("im_emoji_top2_cnt")
    private String imEmojiTop2Cnt;
     /**
      * 用户2023年使用最多的表情3
      * <p> 示例值：love
      */
    @SerializedName("im_emoji_top3")
    private String imEmojiTop3;
     /**
      * 用户2023年使用最多的表情3次数
      * <p> 示例值：21338
      */
    @SerializedName("im_emoji_top3_cnt")
    private String imEmojiTop3Cnt;
     /**
      * 用户2022-2023收到正向reaction次数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("im_positive_reaction_cnt_2")
    private AnnualReportMapInt[] imPositiveReactionCnt2;
     /**
      * 2023年收到表情数量排名
      * <p> 示例值：21338
      */
    @SerializedName("im_positive_reaction_cnt_rank")
    private String imPositiveReactionCntRank;
     /**
      * 用户2022-2023创建文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("ccm_create_cnt_2")
    private AnnualReportMapInt[] ccmCreateCnt2;
     /**
      * 用户2023年创建文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("ccm_create_cnt_rank")
    private String ccmCreateCntRank;
     /**
      * 用户2023年创建文档数最多的月份
      * <p> 示例值：9
      */
    @SerializedName("ccm_create_busy_month")
    private String ccmCreateBusyMonth;
     /**
      * 用户2023年创建文档数最多的月份的文档数
      * <p> 示例值：5702
      */
    @SerializedName("ccm_create_busy_month_cnt")
    private Integer ccmCreateBusyMonthCnt;
     /**
      * 用户本人创建的文档在2023年全年的浏览人数。注意:仅限制浏览时间是2023年,不限制文档的创建时间。
      * <p> 示例值：21338
      */
    @SerializedName("ccm_create_viewed_ucnt")
    private Integer ccmCreateViewedUcnt;
     /**
      * 用户本人创建的文档在2023年收到的点赞数,仅指文档底部的大拇指点赞。注意:仅限制点赞时间是2023年,不限制文档的创建时间。
      * <p> 示例值：21338
      */
    @SerializedName("ccm_create_liked_cnt")
    private Integer ccmCreateLikedCnt;
     /**
      * 用户2023年由本人创建的文档的点赞数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("ccm_create_liked_cnt_rank")
    private String ccmCreateLikedCntRank;
     /**
      * 用户2022-2023参与编辑、评论他人的文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("ccm_edit_comment_fcnt_2")
    private AnnualReportMapInt[] ccmEditCommentFcnt2;
     /**
      * 用户2023年参与编辑、评论他人的文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("ccm_edit_comment_fcnt_rank")
    private String ccmEditCommentFcntRank;
     /**
      * 用户2023年点击浏览过的他人文档数
      * <p> 示例值：21338
      */
    @SerializedName("ccm_view_other_fcnt")
    private Integer ccmViewOtherFcnt;
     /**
      * 用户2023年点击浏览过的他人文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("ccm_view_other_fcnt_rank")
    private String ccmViewOtherFcntRank;
     /**
      * 用户2022-2023本人发起的线上视频会议的数量(循环会议算多次,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("vc_sent_meeting_cnt_2")
    private AnnualReportMapInt[] vcSentMeetingCnt2;
     /**
      * 用户2023年本人发起的线上视频会议的数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("vc_sent_meeting_cnt_rank")
    private String vcSentMeetingCntRank;
     /**
      * 用户2023年本人发起会议邀请参会的人次
      * <p> 示例值：21338
      */
    @SerializedName("vc_sent_meeting_ucnt")
    private Integer vcSentMeetingUcnt;
     /**
      * 用户2022-2023本人受邀参与的会议数(循环会议算多次),共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("vc_join_meeting_cnt_2")
    private AnnualReportMapInt[] vcJoinMeetingCnt2;
     /**
      * 用户2023年本人受邀参与的会议数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("vc_join_meeting_cnt_rank")
    private String vcJoinMeetingCntRank;
     /**
      * 用户2023年本人的总参会次数(包含自己发起和被邀请)
      * <p> 示例值：21338
      */
    @SerializedName("vc_all_meeting_cnt")
    private Integer vcAllMeetingCnt;
     /**
      * 用户2023年本人的总参会次数(包含自己发起和被邀请)的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量
      * <p> 示例值：10
      */
    @SerializedName("vc_all_meeting_cnt_rank")
    private String vcAllMeetingCntRank;
     /**
      * 用户2022-2023本人总参会的时长(包含自己发起和被邀请),格式0.01h,共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
      * <p> 示例值：
      */
    @SerializedName("vc_all_meeting_duration_2")
    private AnnualReportMapFloat[] vcAllMeetingDuration2;
     /**
      * 用户2023年中最常开始日程的时间,精确到分钟,格式:【23:59】
      * <p> 示例值：12:35
      */
    @SerializedName("cal_comment_cal_time")
    private String calCommentCalTime;
     /**
      * 2023年查看同事profile的人次
      * <p> 示例值：21338
      */
    @SerializedName("people_profile_view_cnt")
    private String peopleProfileViewCnt;
     /**
      * 用户2022-2023面试了多少场,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("people_interview_num_2")
    private AnnualReportMapInt[] peopleInterviewNum2;
     /**
      * people用户2023年面试总场次的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("people_interview_num_rank")
    private String peopleInterviewNumRank;
     /**
      * 用户2022-2023本人面试之后,发出offer数量,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
    @SerializedName("people_interview_offer_num_2")
    private AnnualReportMapInt[] peopleInterviewOfferNum2;
     /**
      * 2023年由本人面试之后,发出offer数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
    @SerializedName("people_interview_offer_num_rank")
    private String peopleInterviewOfferNumRank;
     /**
      * 用户2023年发邮件数
      * <p> 示例值：4852
      */
    @SerializedName("email_send_email_count")
    private Integer emailSendEmailCount;
     /**
      * 用户2023年收邮件数
      * <p> 示例值：7045
      */
    @SerializedName("email_receive_email_count")
    private Integer emailReceiveEmailCount;
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Integer getTenantAllCnt() {
        return this.tenantAllCnt;
    }

    public void setTenantAllCnt(Integer tenantAllCnt) {
        this.tenantAllCnt = tenantAllCnt;
    }

    public String getUserRegisterDate() {
        return this.userRegisterDate;
    }

    public void setUserRegisterDate(String userRegisterDate) {
        this.userRegisterDate = userRegisterDate;
    }

    public Integer getAllDayCnt() {
        return this.allDayCnt;
    }

    public void setAllDayCnt(Integer allDayCnt) {
        this.allDayCnt = allDayCnt;
    }

    public Integer getActiveDayCnt() {
        return this.activeDayCnt;
    }

    public void setActiveDayCnt(Integer activeDayCnt) {
        this.activeDayCnt = activeDayCnt;
    }

    public AnnualReportMapFloat[] getDurationCnt2() {
        return this.durationCnt2;
    }

    public void setDurationCnt2(AnnualReportMapFloat[] durationCnt2) {
        this.durationCnt2 = durationCnt2;
    }

    public String getDurationCntRank() {
        return this.durationCntRank;
    }

    public void setDurationCntRank(String durationCntRank) {
        this.durationCntRank = durationCntRank;
    }

    public String getBusyMonth() {
        return this.busyMonth;
    }

    public void setBusyMonth(String busyMonth) {
        this.busyMonth = busyMonth;
    }

    public Double getBusyMonthSumDuration() {
        return this.busyMonthSumDuration;
    }

    public void setBusyMonthSumDuration(Double busyMonthSumDuration) {
        this.busyMonthSumDuration = busyMonthSumDuration;
    }

    public Integer getBusyMonthSendMsgCnt() {
        return this.busyMonthSendMsgCnt;
    }

    public void setBusyMonthSendMsgCnt(Integer busyMonthSendMsgCnt) {
        this.busyMonthSendMsgCnt = busyMonthSendMsgCnt;
    }

    public Integer getBusyMonthMeetingCnt() {
        return this.busyMonthMeetingCnt;
    }

    public void setBusyMonthMeetingCnt(Integer busyMonthMeetingCnt) {
        this.busyMonthMeetingCnt = busyMonthMeetingCnt;
    }

    public String getBusyMonthLastMeetingTime() {
        return this.busyMonthLastMeetingTime;
    }

    public void setBusyMonthLastMeetingTime(String busyMonthLastMeetingTime) {
        this.busyMonthLastMeetingTime = busyMonthLastMeetingTime;
    }

    public Integer getBusyMonthCreateEditFileCnt() {
        return this.busyMonthCreateEditFileCnt;
    }

    public void setBusyMonthCreateEditFileCnt(Integer busyMonthCreateEditFileCnt) {
        this.busyMonthCreateEditFileCnt = busyMonthCreateEditFileCnt;
    }

    public AnnualReportMapInt[] getImSendMsgCnt2() {
        return this.imSendMsgCnt2;
    }

    public void setImSendMsgCnt2(AnnualReportMapInt[] imSendMsgCnt2) {
        this.imSendMsgCnt2 = imSendMsgCnt2;
    }

    public String getImSendMsgCntRank() {
        return this.imSendMsgCntRank;
    }

    public void setImSendMsgCntRank(String imSendMsgCntRank) {
        this.imSendMsgCntRank = imSendMsgCntRank;
    }

    public String getImBusyDate() {
        return this.imBusyDate;
    }

    public void setImBusyDate(String imBusyDate) {
        this.imBusyDate = imBusyDate;
    }

    public Integer getImBusyDateSendMsgCnt() {
        return this.imBusyDateSendMsgCnt;
    }

    public void setImBusyDateSendMsgCnt(Integer imBusyDateSendMsgCnt) {
        this.imBusyDateSendMsgCnt = imBusyDateSendMsgCnt;
    }

    public String getImLastSendMsgTime() {
        return this.imLastSendMsgTime;
    }

    public void setImLastSendMsgTime(String imLastSendMsgTime) {
        this.imLastSendMsgTime = imLastSendMsgTime;
    }

    public Integer getImTalkedChatCnt() {
        return this.imTalkedChatCnt;
    }

    public void setImTalkedChatCnt(Integer imTalkedChatCnt) {
        this.imTalkedChatCnt = imTalkedChatCnt;
    }

    public Integer getImPrivateChatCnt() {
        return this.imPrivateChatCnt;
    }

    public void setImPrivateChatCnt(Integer imPrivateChatCnt) {
        this.imPrivateChatCnt = imPrivateChatCnt;
    }

    public String getImEmojiTop1() {
        return this.imEmojiTop1;
    }

    public void setImEmojiTop1(String imEmojiTop1) {
        this.imEmojiTop1 = imEmojiTop1;
    }

    public String getImEmojiTop1Cnt() {
        return this.imEmojiTop1Cnt;
    }

    public void setImEmojiTop1Cnt(String imEmojiTop1Cnt) {
        this.imEmojiTop1Cnt = imEmojiTop1Cnt;
    }

    public String getImEmojiTop2() {
        return this.imEmojiTop2;
    }

    public void setImEmojiTop2(String imEmojiTop2) {
        this.imEmojiTop2 = imEmojiTop2;
    }

    public String getImEmojiTop2Cnt() {
        return this.imEmojiTop2Cnt;
    }

    public void setImEmojiTop2Cnt(String imEmojiTop2Cnt) {
        this.imEmojiTop2Cnt = imEmojiTop2Cnt;
    }

    public String getImEmojiTop3() {
        return this.imEmojiTop3;
    }

    public void setImEmojiTop3(String imEmojiTop3) {
        this.imEmojiTop3 = imEmojiTop3;
    }

    public String getImEmojiTop3Cnt() {
        return this.imEmojiTop3Cnt;
    }

    public void setImEmojiTop3Cnt(String imEmojiTop3Cnt) {
        this.imEmojiTop3Cnt = imEmojiTop3Cnt;
    }

    public AnnualReportMapInt[] getImPositiveReactionCnt2() {
        return this.imPositiveReactionCnt2;
    }

    public void setImPositiveReactionCnt2(AnnualReportMapInt[] imPositiveReactionCnt2) {
        this.imPositiveReactionCnt2 = imPositiveReactionCnt2;
    }

    public String getImPositiveReactionCntRank() {
        return this.imPositiveReactionCntRank;
    }

    public void setImPositiveReactionCntRank(String imPositiveReactionCntRank) {
        this.imPositiveReactionCntRank = imPositiveReactionCntRank;
    }

    public AnnualReportMapInt[] getCcmCreateCnt2() {
        return this.ccmCreateCnt2;
    }

    public void setCcmCreateCnt2(AnnualReportMapInt[] ccmCreateCnt2) {
        this.ccmCreateCnt2 = ccmCreateCnt2;
    }

    public String getCcmCreateCntRank() {
        return this.ccmCreateCntRank;
    }

    public void setCcmCreateCntRank(String ccmCreateCntRank) {
        this.ccmCreateCntRank = ccmCreateCntRank;
    }

    public String getCcmCreateBusyMonth() {
        return this.ccmCreateBusyMonth;
    }

    public void setCcmCreateBusyMonth(String ccmCreateBusyMonth) {
        this.ccmCreateBusyMonth = ccmCreateBusyMonth;
    }

    public Integer getCcmCreateBusyMonthCnt() {
        return this.ccmCreateBusyMonthCnt;
    }

    public void setCcmCreateBusyMonthCnt(Integer ccmCreateBusyMonthCnt) {
        this.ccmCreateBusyMonthCnt = ccmCreateBusyMonthCnt;
    }

    public Integer getCcmCreateViewedUcnt() {
        return this.ccmCreateViewedUcnt;
    }

    public void setCcmCreateViewedUcnt(Integer ccmCreateViewedUcnt) {
        this.ccmCreateViewedUcnt = ccmCreateViewedUcnt;
    }

    public Integer getCcmCreateLikedCnt() {
        return this.ccmCreateLikedCnt;
    }

    public void setCcmCreateLikedCnt(Integer ccmCreateLikedCnt) {
        this.ccmCreateLikedCnt = ccmCreateLikedCnt;
    }

    public String getCcmCreateLikedCntRank() {
        return this.ccmCreateLikedCntRank;
    }

    public void setCcmCreateLikedCntRank(String ccmCreateLikedCntRank) {
        this.ccmCreateLikedCntRank = ccmCreateLikedCntRank;
    }

    public AnnualReportMapInt[] getCcmEditCommentFcnt2() {
        return this.ccmEditCommentFcnt2;
    }

    public void setCcmEditCommentFcnt2(AnnualReportMapInt[] ccmEditCommentFcnt2) {
        this.ccmEditCommentFcnt2 = ccmEditCommentFcnt2;
    }

    public String getCcmEditCommentFcntRank() {
        return this.ccmEditCommentFcntRank;
    }

    public void setCcmEditCommentFcntRank(String ccmEditCommentFcntRank) {
        this.ccmEditCommentFcntRank = ccmEditCommentFcntRank;
    }

    public Integer getCcmViewOtherFcnt() {
        return this.ccmViewOtherFcnt;
    }

    public void setCcmViewOtherFcnt(Integer ccmViewOtherFcnt) {
        this.ccmViewOtherFcnt = ccmViewOtherFcnt;
    }

    public String getCcmViewOtherFcntRank() {
        return this.ccmViewOtherFcntRank;
    }

    public void setCcmViewOtherFcntRank(String ccmViewOtherFcntRank) {
        this.ccmViewOtherFcntRank = ccmViewOtherFcntRank;
    }

    public AnnualReportMapInt[] getVcSentMeetingCnt2() {
        return this.vcSentMeetingCnt2;
    }

    public void setVcSentMeetingCnt2(AnnualReportMapInt[] vcSentMeetingCnt2) {
        this.vcSentMeetingCnt2 = vcSentMeetingCnt2;
    }

    public String getVcSentMeetingCntRank() {
        return this.vcSentMeetingCntRank;
    }

    public void setVcSentMeetingCntRank(String vcSentMeetingCntRank) {
        this.vcSentMeetingCntRank = vcSentMeetingCntRank;
    }

    public Integer getVcSentMeetingUcnt() {
        return this.vcSentMeetingUcnt;
    }

    public void setVcSentMeetingUcnt(Integer vcSentMeetingUcnt) {
        this.vcSentMeetingUcnt = vcSentMeetingUcnt;
    }

    public AnnualReportMapInt[] getVcJoinMeetingCnt2() {
        return this.vcJoinMeetingCnt2;
    }

    public void setVcJoinMeetingCnt2(AnnualReportMapInt[] vcJoinMeetingCnt2) {
        this.vcJoinMeetingCnt2 = vcJoinMeetingCnt2;
    }

    public String getVcJoinMeetingCntRank() {
        return this.vcJoinMeetingCntRank;
    }

    public void setVcJoinMeetingCntRank(String vcJoinMeetingCntRank) {
        this.vcJoinMeetingCntRank = vcJoinMeetingCntRank;
    }

    public Integer getVcAllMeetingCnt() {
        return this.vcAllMeetingCnt;
    }

    public void setVcAllMeetingCnt(Integer vcAllMeetingCnt) {
        this.vcAllMeetingCnt = vcAllMeetingCnt;
    }

    public String getVcAllMeetingCntRank() {
        return this.vcAllMeetingCntRank;
    }

    public void setVcAllMeetingCntRank(String vcAllMeetingCntRank) {
        this.vcAllMeetingCntRank = vcAllMeetingCntRank;
    }

    public AnnualReportMapFloat[] getVcAllMeetingDuration2() {
        return this.vcAllMeetingDuration2;
    }

    public void setVcAllMeetingDuration2(AnnualReportMapFloat[] vcAllMeetingDuration2) {
        this.vcAllMeetingDuration2 = vcAllMeetingDuration2;
    }

    public String getCalCommentCalTime() {
        return this.calCommentCalTime;
    }

    public void setCalCommentCalTime(String calCommentCalTime) {
        this.calCommentCalTime = calCommentCalTime;
    }

    public String getPeopleProfileViewCnt() {
        return this.peopleProfileViewCnt;
    }

    public void setPeopleProfileViewCnt(String peopleProfileViewCnt) {
        this.peopleProfileViewCnt = peopleProfileViewCnt;
    }

    public AnnualReportMapInt[] getPeopleInterviewNum2() {
        return this.peopleInterviewNum2;
    }

    public void setPeopleInterviewNum2(AnnualReportMapInt[] peopleInterviewNum2) {
        this.peopleInterviewNum2 = peopleInterviewNum2;
    }

    public String getPeopleInterviewNumRank() {
        return this.peopleInterviewNumRank;
    }

    public void setPeopleInterviewNumRank(String peopleInterviewNumRank) {
        this.peopleInterviewNumRank = peopleInterviewNumRank;
    }

    public AnnualReportMapInt[] getPeopleInterviewOfferNum2() {
        return this.peopleInterviewOfferNum2;
    }

    public void setPeopleInterviewOfferNum2(AnnualReportMapInt[] peopleInterviewOfferNum2) {
        this.peopleInterviewOfferNum2 = peopleInterviewOfferNum2;
    }

    public String getPeopleInterviewOfferNumRank() {
        return this.peopleInterviewOfferNumRank;
    }

    public void setPeopleInterviewOfferNumRank(String peopleInterviewOfferNumRank) {
        this.peopleInterviewOfferNumRank = peopleInterviewOfferNumRank;
    }

    public Integer getEmailSendEmailCount() {
        return this.emailSendEmailCount;
    }

    public void setEmailSendEmailCount(Integer emailSendEmailCount) {
        this.emailSendEmailCount = emailSendEmailCount;
    }

    public Integer getEmailReceiveEmailCount() {
        return this.emailReceiveEmailCount;
    }

    public void setEmailReceiveEmailCount(Integer emailReceiveEmailCount) {
        this.emailReceiveEmailCount = emailReceiveEmailCount;
    }


// builder 开始
  public UserReport2023(){}

  public UserReport2023(Builder builder){
         /**
          * 用户ID
          * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
          */
      this.userId = builder.userId;
         /**
          * 所在租户目前的总人数,已激活、未离职
          * <p> 示例值：171434
          */
      this.tenantAllCnt = builder.tenantAllCnt;
         /**
          * 用户的飞书激活日期,yyyyMMdd格式(201909之前的用户可能是空)
          * <p> 示例值：20200720
          */
      this.userRegisterDate = builder.userRegisterDate;
         /**
          * 用户激活至今的天数
          * <p> 示例值：1245
          */
      this.allDayCnt = builder.allDayCnt;
         /**
          * 用户2023年内活跃时长> 0的天数
          * <p> 示例值：365
          */
      this.activeDayCnt = builder.activeDayCnt;
         /**
          * 用户2022-2023使用总时长(格式0.01h),共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
          * <p> 示例值：
          */
      this.durationCnt2 = builder.durationCnt2;
         /**
          * 2023年全年活跃时长的排名。
          * <p> 示例值：21338
          */
      this.durationCntRank = builder.durationCntRank;
         /**
          * 用户2023年最忙碌一个月。最忙碌一个月的定义:所有自然月中,飞书在线时长最长的一个月。
          * <p> 示例值：7
          */
      this.busyMonth = builder.busyMonth;
         /**
          * 用户2023年最忙碌一个月的活跃时长(格式0.01h)
          * <p> 示例值：5702
          */
      this.busyMonthSumDuration = builder.busyMonthSumDuration;
         /**
          * 用户2023年最忙碌一个月的发消息数
          * <p> 示例值：78169
          */
      this.busyMonthSendMsgCnt = builder.busyMonthSendMsgCnt;
         /**
          * 用户2023年最忙碌一个月的参会数(指本人发起的会议+受邀参与的会议)
          * <p> 示例值：5702
          */
      this.busyMonthMeetingCnt = builder.busyMonthMeetingCnt;
         /**
          * 用户2023年最忙碌一个月的会议结束最晚的时间(格式 : 【20230507 23:59】)。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
          * <p> 示例值：2:25
          */
      this.busyMonthLastMeetingTime = builder.busyMonthLastMeetingTime;
         /**
          * 用户2023年最忙碌一个月的创建+编辑评论文档
          * <p> 示例值：5702
          */
      this.busyMonthCreateEditFileCnt = builder.busyMonthCreateEditFileCnt;
         /**
          * 用户2022-2023发消息数，共2组键值对，表示2年各自的数据。举例:[{"year":"2022","count":"33”},{"year":"2023","count":"55"}]
          * <p> 示例值：
          */
      this.imSendMsgCnt2 = builder.imSendMsgCnt2;
         /**
          * 用户2023年发出消息数,在租户内的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.imSendMsgCntRank = builder.imSendMsgCntRank;
         /**
          * 用户2023年发消息最多的一天
          * <p> 示例值：20230916
          */
      this.imBusyDate = builder.imBusyDate;
         /**
          * 用户2023年发消息最多的一天发消息条数
          * <p> 示例值：89
          */
      this.imBusyDateSendMsgCnt = builder.imBusyDateSendMsgCnt;
         /**
          * 用户2023年发出时间最晚的一条消息的时间,时间格式, 【20230507 23:59】。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
          * <p> 示例值：3:11
          */
      this.imLastSendMsgTime = builder.imLastSendMsgTime;
         /**
          * 用户2023年发过言的群数
          * <p> 示例值：21338
          */
      this.imTalkedChatCnt = builder.imTalkedChatCnt;
         /**
          * 用户2023年私聊过的人数
          * <p> 示例值：21338
          */
      this.imPrivateChatCnt = builder.imPrivateChatCnt;
         /**
          * 用户2023年使用最多的表情1
          * <p> 示例值：thumbsup
          */
      this.imEmojiTop1 = builder.imEmojiTop1;
         /**
          * 用户2023年使用最多的表情1次数
          * <p> 示例值：21338
          */
      this.imEmojiTop1Cnt = builder.imEmojiTop1Cnt;
         /**
          * 用户2023年使用最多的表情2
          * <p> 示例值：jiayi
          */
      this.imEmojiTop2 = builder.imEmojiTop2;
         /**
          * 用户2023年使用最多的表情2次数
          * <p> 示例值：21338
          */
      this.imEmojiTop2Cnt = builder.imEmojiTop2Cnt;
         /**
          * 用户2023年使用最多的表情3
          * <p> 示例值：love
          */
      this.imEmojiTop3 = builder.imEmojiTop3;
         /**
          * 用户2023年使用最多的表情3次数
          * <p> 示例值：21338
          */
      this.imEmojiTop3Cnt = builder.imEmojiTop3Cnt;
         /**
          * 用户2022-2023收到正向reaction次数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.imPositiveReactionCnt2 = builder.imPositiveReactionCnt2;
         /**
          * 2023年收到表情数量排名
          * <p> 示例值：21338
          */
      this.imPositiveReactionCntRank = builder.imPositiveReactionCntRank;
         /**
          * 用户2022-2023创建文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.ccmCreateCnt2 = builder.ccmCreateCnt2;
         /**
          * 用户2023年创建文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.ccmCreateCntRank = builder.ccmCreateCntRank;
         /**
          * 用户2023年创建文档数最多的月份
          * <p> 示例值：9
          */
      this.ccmCreateBusyMonth = builder.ccmCreateBusyMonth;
         /**
          * 用户2023年创建文档数最多的月份的文档数
          * <p> 示例值：5702
          */
      this.ccmCreateBusyMonthCnt = builder.ccmCreateBusyMonthCnt;
         /**
          * 用户本人创建的文档在2023年全年的浏览人数。注意:仅限制浏览时间是2023年,不限制文档的创建时间。
          * <p> 示例值：21338
          */
      this.ccmCreateViewedUcnt = builder.ccmCreateViewedUcnt;
         /**
          * 用户本人创建的文档在2023年收到的点赞数,仅指文档底部的大拇指点赞。注意:仅限制点赞时间是2023年,不限制文档的创建时间。
          * <p> 示例值：21338
          */
      this.ccmCreateLikedCnt = builder.ccmCreateLikedCnt;
         /**
          * 用户2023年由本人创建的文档的点赞数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.ccmCreateLikedCntRank = builder.ccmCreateLikedCntRank;
         /**
          * 用户2022-2023参与编辑、评论他人的文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.ccmEditCommentFcnt2 = builder.ccmEditCommentFcnt2;
         /**
          * 用户2023年参与编辑、评论他人的文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.ccmEditCommentFcntRank = builder.ccmEditCommentFcntRank;
         /**
          * 用户2023年点击浏览过的他人文档数
          * <p> 示例值：21338
          */
      this.ccmViewOtherFcnt = builder.ccmViewOtherFcnt;
         /**
          * 用户2023年点击浏览过的他人文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.ccmViewOtherFcntRank = builder.ccmViewOtherFcntRank;
         /**
          * 用户2022-2023本人发起的线上视频会议的数量(循环会议算多次,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.vcSentMeetingCnt2 = builder.vcSentMeetingCnt2;
         /**
          * 用户2023年本人发起的线上视频会议的数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.vcSentMeetingCntRank = builder.vcSentMeetingCntRank;
         /**
          * 用户2023年本人发起会议邀请参会的人次
          * <p> 示例值：21338
          */
      this.vcSentMeetingUcnt = builder.vcSentMeetingUcnt;
         /**
          * 用户2022-2023本人受邀参与的会议数(循环会议算多次),共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.vcJoinMeetingCnt2 = builder.vcJoinMeetingCnt2;
         /**
          * 用户2023年本人受邀参与的会议数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.vcJoinMeetingCntRank = builder.vcJoinMeetingCntRank;
         /**
          * 用户2023年本人的总参会次数(包含自己发起和被邀请)
          * <p> 示例值：21338
          */
      this.vcAllMeetingCnt = builder.vcAllMeetingCnt;
         /**
          * 用户2023年本人的总参会次数(包含自己发起和被邀请)的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量
          * <p> 示例值：10
          */
      this.vcAllMeetingCntRank = builder.vcAllMeetingCntRank;
         /**
          * 用户2022-2023本人总参会的时长(包含自己发起和被邀请),格式0.01h,共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
          * <p> 示例值：
          */
      this.vcAllMeetingDuration2 = builder.vcAllMeetingDuration2;
         /**
          * 用户2023年中最常开始日程的时间,精确到分钟,格式:【23:59】
          * <p> 示例值：12:35
          */
      this.calCommentCalTime = builder.calCommentCalTime;
         /**
          * 2023年查看同事profile的人次
          * <p> 示例值：21338
          */
      this.peopleProfileViewCnt = builder.peopleProfileViewCnt;
         /**
          * 用户2022-2023面试了多少场,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.peopleInterviewNum2 = builder.peopleInterviewNum2;
         /**
          * people用户2023年面试总场次的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.peopleInterviewNumRank = builder.peopleInterviewNumRank;
         /**
          * 用户2022-2023本人面试之后,发出offer数量,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
          * <p> 示例值：
          */
      this.peopleInterviewOfferNum2 = builder.peopleInterviewOfferNum2;
         /**
          * 2023年由本人面试之后,发出offer数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
          * <p> 示例值：4852
          */
      this.peopleInterviewOfferNumRank = builder.peopleInterviewOfferNumRank;
         /**
          * 用户2023年发邮件数
          * <p> 示例值：4852
          */
      this.emailSendEmailCount = builder.emailSendEmailCount;
         /**
          * 用户2023年收邮件数
          * <p> 示例值：7045
          */
      this.emailReceiveEmailCount = builder.emailReceiveEmailCount;
  }

    public static class Builder {
     /**
      * 用户ID
      * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
      */
        private String userId;
     /**
      * 所在租户目前的总人数,已激活、未离职
      * <p> 示例值：171434
      */
        private Integer tenantAllCnt;
     /**
      * 用户的飞书激活日期,yyyyMMdd格式(201909之前的用户可能是空)
      * <p> 示例值：20200720
      */
        private String userRegisterDate;
     /**
      * 用户激活至今的天数
      * <p> 示例值：1245
      */
        private Integer allDayCnt;
     /**
      * 用户2023年内活跃时长> 0的天数
      * <p> 示例值：365
      */
        private Integer activeDayCnt;
     /**
      * 用户2022-2023使用总时长(格式0.01h),共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
      * <p> 示例值：
      */
        private AnnualReportMapFloat[] durationCnt2;
     /**
      * 2023年全年活跃时长的排名。
      * <p> 示例值：21338
      */
        private String durationCntRank;
     /**
      * 用户2023年最忙碌一个月。最忙碌一个月的定义:所有自然月中,飞书在线时长最长的一个月。
      * <p> 示例值：7
      */
        private String busyMonth;
     /**
      * 用户2023年最忙碌一个月的活跃时长(格式0.01h)
      * <p> 示例值：5702
      */
        private Double busyMonthSumDuration;
     /**
      * 用户2023年最忙碌一个月的发消息数
      * <p> 示例值：78169
      */
        private Integer busyMonthSendMsgCnt;
     /**
      * 用户2023年最忙碌一个月的参会数(指本人发起的会议+受邀参与的会议)
      * <p> 示例值：5702
      */
        private Integer busyMonthMeetingCnt;
     /**
      * 用户2023年最忙碌一个月的会议结束最晚的时间(格式 : 【20230507 23:59】)。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
      * <p> 示例值：2:25
      */
        private String busyMonthLastMeetingTime;
     /**
      * 用户2023年最忙碌一个月的创建+编辑评论文档
      * <p> 示例值：5702
      */
        private Integer busyMonthCreateEditFileCnt;
     /**
      * 用户2022-2023发消息数，共2组键值对，表示2年各自的数据。举例:[{"year":"2022","count":"33”},{"year":"2023","count":"55"}]
      * <p> 示例值：
      */
        private AnnualReportMapInt[] imSendMsgCnt2;
     /**
      * 用户2023年发出消息数,在租户内的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String imSendMsgCntRank;
     /**
      * 用户2023年发消息最多的一天
      * <p> 示例值：20230916
      */
        private String imBusyDate;
     /**
      * 用户2023年发消息最多的一天发消息条数
      * <p> 示例值：89
      */
        private Integer imBusyDateSendMsgCnt;
     /**
      * 用户2023年发出时间最晚的一条消息的时间,时间格式, 【20230507 23:59】。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
      * <p> 示例值：3:11
      */
        private String imLastSendMsgTime;
     /**
      * 用户2023年发过言的群数
      * <p> 示例值：21338
      */
        private Integer imTalkedChatCnt;
     /**
      * 用户2023年私聊过的人数
      * <p> 示例值：21338
      */
        private Integer imPrivateChatCnt;
     /**
      * 用户2023年使用最多的表情1
      * <p> 示例值：thumbsup
      */
        private String imEmojiTop1;
     /**
      * 用户2023年使用最多的表情1次数
      * <p> 示例值：21338
      */
        private String imEmojiTop1Cnt;
     /**
      * 用户2023年使用最多的表情2
      * <p> 示例值：jiayi
      */
        private String imEmojiTop2;
     /**
      * 用户2023年使用最多的表情2次数
      * <p> 示例值：21338
      */
        private String imEmojiTop2Cnt;
     /**
      * 用户2023年使用最多的表情3
      * <p> 示例值：love
      */
        private String imEmojiTop3;
     /**
      * 用户2023年使用最多的表情3次数
      * <p> 示例值：21338
      */
        private String imEmojiTop3Cnt;
     /**
      * 用户2022-2023收到正向reaction次数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] imPositiveReactionCnt2;
     /**
      * 2023年收到表情数量排名
      * <p> 示例值：21338
      */
        private String imPositiveReactionCntRank;
     /**
      * 用户2022-2023创建文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] ccmCreateCnt2;
     /**
      * 用户2023年创建文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String ccmCreateCntRank;
     /**
      * 用户2023年创建文档数最多的月份
      * <p> 示例值：9
      */
        private String ccmCreateBusyMonth;
     /**
      * 用户2023年创建文档数最多的月份的文档数
      * <p> 示例值：5702
      */
        private Integer ccmCreateBusyMonthCnt;
     /**
      * 用户本人创建的文档在2023年全年的浏览人数。注意:仅限制浏览时间是2023年,不限制文档的创建时间。
      * <p> 示例值：21338
      */
        private Integer ccmCreateViewedUcnt;
     /**
      * 用户本人创建的文档在2023年收到的点赞数,仅指文档底部的大拇指点赞。注意:仅限制点赞时间是2023年,不限制文档的创建时间。
      * <p> 示例值：21338
      */
        private Integer ccmCreateLikedCnt;
     /**
      * 用户2023年由本人创建的文档的点赞数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String ccmCreateLikedCntRank;
     /**
      * 用户2022-2023参与编辑、评论他人的文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] ccmEditCommentFcnt2;
     /**
      * 用户2023年参与编辑、评论他人的文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String ccmEditCommentFcntRank;
     /**
      * 用户2023年点击浏览过的他人文档数
      * <p> 示例值：21338
      */
        private Integer ccmViewOtherFcnt;
     /**
      * 用户2023年点击浏览过的他人文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String ccmViewOtherFcntRank;
     /**
      * 用户2022-2023本人发起的线上视频会议的数量(循环会议算多次,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] vcSentMeetingCnt2;
     /**
      * 用户2023年本人发起的线上视频会议的数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String vcSentMeetingCntRank;
     /**
      * 用户2023年本人发起会议邀请参会的人次
      * <p> 示例值：21338
      */
        private Integer vcSentMeetingUcnt;
     /**
      * 用户2022-2023本人受邀参与的会议数(循环会议算多次),共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] vcJoinMeetingCnt2;
     /**
      * 用户2023年本人受邀参与的会议数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String vcJoinMeetingCntRank;
     /**
      * 用户2023年本人的总参会次数(包含自己发起和被邀请)
      * <p> 示例值：21338
      */
        private Integer vcAllMeetingCnt;
     /**
      * 用户2023年本人的总参会次数(包含自己发起和被邀请)的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量
      * <p> 示例值：10
      */
        private String vcAllMeetingCntRank;
     /**
      * 用户2022-2023本人总参会的时长(包含自己发起和被邀请),格式0.01h,共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
      * <p> 示例值：
      */
        private AnnualReportMapFloat[] vcAllMeetingDuration2;
     /**
      * 用户2023年中最常开始日程的时间,精确到分钟,格式:【23:59】
      * <p> 示例值：12:35
      */
        private String calCommentCalTime;
     /**
      * 2023年查看同事profile的人次
      * <p> 示例值：21338
      */
        private String peopleProfileViewCnt;
     /**
      * 用户2022-2023面试了多少场,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] peopleInterviewNum2;
     /**
      * people用户2023年面试总场次的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String peopleInterviewNumRank;
     /**
      * 用户2022-2023本人面试之后,发出offer数量,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
      * <p> 示例值：
      */
        private AnnualReportMapInt[] peopleInterviewOfferNum2;
     /**
      * 2023年由本人面试之后,发出offer数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
      * <p> 示例值：4852
      */
        private String peopleInterviewOfferNumRank;
     /**
      * 用户2023年发邮件数
      * <p> 示例值：4852
      */
        private Integer emailSendEmailCount;
     /**
      * 用户2023年收邮件数
      * <p> 示例值：7045
      */
        private Integer emailReceiveEmailCount;

        /**
         * 用户ID
         * <p> 示例值：ou_7dab8a3d3cdcc9da365777c7ad535d62
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
             this.userId = userId;
             return this;
        }

    

        /**
         * 所在租户目前的总人数,已激活、未离职
         * <p> 示例值：171434
         * @param tenantAllCnt
         * @return
         */
        public Builder tenantAllCnt(Integer tenantAllCnt) {
             this.tenantAllCnt = tenantAllCnt;
             return this;
        }

    

        /**
         * 用户的飞书激活日期,yyyyMMdd格式(201909之前的用户可能是空)
         * <p> 示例值：20200720
         * @param userRegisterDate
         * @return
         */
        public Builder userRegisterDate(String userRegisterDate) {
             this.userRegisterDate = userRegisterDate;
             return this;
        }

    

        /**
         * 用户激活至今的天数
         * <p> 示例值：1245
         * @param allDayCnt
         * @return
         */
        public Builder allDayCnt(Integer allDayCnt) {
             this.allDayCnt = allDayCnt;
             return this;
        }

    

        /**
         * 用户2023年内活跃时长> 0的天数
         * <p> 示例值：365
         * @param activeDayCnt
         * @return
         */
        public Builder activeDayCnt(Integer activeDayCnt) {
             this.activeDayCnt = activeDayCnt;
             return this;
        }

    

        /**
         * 用户2022-2023使用总时长(格式0.01h),共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
         * <p> 示例值：
         * @param durationCnt2
         * @return
         */
        public Builder durationCnt2(AnnualReportMapFloat[] durationCnt2) {
             this.durationCnt2 = durationCnt2;
             return this;
        }

    

        /**
         * 2023年全年活跃时长的排名。
         * <p> 示例值：21338
         * @param durationCntRank
         * @return
         */
        public Builder durationCntRank(String durationCntRank) {
             this.durationCntRank = durationCntRank;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月。最忙碌一个月的定义:所有自然月中,飞书在线时长最长的一个月。
         * <p> 示例值：7
         * @param busyMonth
         * @return
         */
        public Builder busyMonth(String busyMonth) {
             this.busyMonth = busyMonth;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月的活跃时长(格式0.01h)
         * <p> 示例值：5702
         * @param busyMonthSumDuration
         * @return
         */
        public Builder busyMonthSumDuration(Double busyMonthSumDuration) {
             this.busyMonthSumDuration = busyMonthSumDuration;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月的发消息数
         * <p> 示例值：78169
         * @param busyMonthSendMsgCnt
         * @return
         */
        public Builder busyMonthSendMsgCnt(Integer busyMonthSendMsgCnt) {
             this.busyMonthSendMsgCnt = busyMonthSendMsgCnt;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月的参会数(指本人发起的会议+受邀参与的会议)
         * <p> 示例值：5702
         * @param busyMonthMeetingCnt
         * @return
         */
        public Builder busyMonthMeetingCnt(Integer busyMonthMeetingCnt) {
             this.busyMonthMeetingCnt = busyMonthMeetingCnt;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月的会议结束最晚的时间(格式 : 【20230507 23:59】)。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
         * <p> 示例值：2:25
         * @param busyMonthLastMeetingTime
         * @return
         */
        public Builder busyMonthLastMeetingTime(String busyMonthLastMeetingTime) {
             this.busyMonthLastMeetingTime = busyMonthLastMeetingTime;
             return this;
        }

    

        /**
         * 用户2023年最忙碌一个月的创建+编辑评论文档
         * <p> 示例值：5702
         * @param busyMonthCreateEditFileCnt
         * @return
         */
        public Builder busyMonthCreateEditFileCnt(Integer busyMonthCreateEditFileCnt) {
             this.busyMonthCreateEditFileCnt = busyMonthCreateEditFileCnt;
             return this;
        }

    

        /**
         * 用户2022-2023发消息数，共2组键值对，表示2年各自的数据。举例:[{"year":"2022","count":"33”},{"year":"2023","count":"55"}]
         * <p> 示例值：
         * @param imSendMsgCnt2
         * @return
         */
        public Builder imSendMsgCnt2(AnnualReportMapInt[] imSendMsgCnt2) {
             this.imSendMsgCnt2 = imSendMsgCnt2;
             return this;
        }

    

        /**
         * 用户2023年发出消息数,在租户内的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param imSendMsgCntRank
         * @return
         */
        public Builder imSendMsgCntRank(String imSendMsgCntRank) {
             this.imSendMsgCntRank = imSendMsgCntRank;
             return this;
        }

    

        /**
         * 用户2023年发消息最多的一天
         * <p> 示例值：20230916
         * @param imBusyDate
         * @return
         */
        public Builder imBusyDate(String imBusyDate) {
             this.imBusyDate = imBusyDate;
             return this;
        }

    

        /**
         * 用户2023年发消息最多的一天发消息条数
         * <p> 示例值：89
         * @param imBusyDateSendMsgCnt
         * @return
         */
        public Builder imBusyDateSendMsgCnt(Integer imBusyDateSendMsgCnt) {
             this.imBusyDateSendMsgCnt = imBusyDateSendMsgCnt;
             return this;
        }

    

        /**
         * 用户2023年发出时间最晚的一条消息的时间,时间格式, 【20230507 23:59】。最晚时间的定义:将每天凌晨5点之前计入前一天来计算最晚时间点。
         * <p> 示例值：3:11
         * @param imLastSendMsgTime
         * @return
         */
        public Builder imLastSendMsgTime(String imLastSendMsgTime) {
             this.imLastSendMsgTime = imLastSendMsgTime;
             return this;
        }

    

        /**
         * 用户2023年发过言的群数
         * <p> 示例值：21338
         * @param imTalkedChatCnt
         * @return
         */
        public Builder imTalkedChatCnt(Integer imTalkedChatCnt) {
             this.imTalkedChatCnt = imTalkedChatCnt;
             return this;
        }

    

        /**
         * 用户2023年私聊过的人数
         * <p> 示例值：21338
         * @param imPrivateChatCnt
         * @return
         */
        public Builder imPrivateChatCnt(Integer imPrivateChatCnt) {
             this.imPrivateChatCnt = imPrivateChatCnt;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情1
         * <p> 示例值：thumbsup
         * @param imEmojiTop1
         * @return
         */
        public Builder imEmojiTop1(String imEmojiTop1) {
             this.imEmojiTop1 = imEmojiTop1;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情1次数
         * <p> 示例值：21338
         * @param imEmojiTop1Cnt
         * @return
         */
        public Builder imEmojiTop1Cnt(String imEmojiTop1Cnt) {
             this.imEmojiTop1Cnt = imEmojiTop1Cnt;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情2
         * <p> 示例值：jiayi
         * @param imEmojiTop2
         * @return
         */
        public Builder imEmojiTop2(String imEmojiTop2) {
             this.imEmojiTop2 = imEmojiTop2;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情2次数
         * <p> 示例值：21338
         * @param imEmojiTop2Cnt
         * @return
         */
        public Builder imEmojiTop2Cnt(String imEmojiTop2Cnt) {
             this.imEmojiTop2Cnt = imEmojiTop2Cnt;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情3
         * <p> 示例值：love
         * @param imEmojiTop3
         * @return
         */
        public Builder imEmojiTop3(String imEmojiTop3) {
             this.imEmojiTop3 = imEmojiTop3;
             return this;
        }

    

        /**
         * 用户2023年使用最多的表情3次数
         * <p> 示例值：21338
         * @param imEmojiTop3Cnt
         * @return
         */
        public Builder imEmojiTop3Cnt(String imEmojiTop3Cnt) {
             this.imEmojiTop3Cnt = imEmojiTop3Cnt;
             return this;
        }

    

        /**
         * 用户2022-2023收到正向reaction次数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param imPositiveReactionCnt2
         * @return
         */
        public Builder imPositiveReactionCnt2(AnnualReportMapInt[] imPositiveReactionCnt2) {
             this.imPositiveReactionCnt2 = imPositiveReactionCnt2;
             return this;
        }

    

        /**
         * 2023年收到表情数量排名
         * <p> 示例值：21338
         * @param imPositiveReactionCntRank
         * @return
         */
        public Builder imPositiveReactionCntRank(String imPositiveReactionCntRank) {
             this.imPositiveReactionCntRank = imPositiveReactionCntRank;
             return this;
        }

    

        /**
         * 用户2022-2023创建文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param ccmCreateCnt2
         * @return
         */
        public Builder ccmCreateCnt2(AnnualReportMapInt[] ccmCreateCnt2) {
             this.ccmCreateCnt2 = ccmCreateCnt2;
             return this;
        }

    

        /**
         * 用户2023年创建文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param ccmCreateCntRank
         * @return
         */
        public Builder ccmCreateCntRank(String ccmCreateCntRank) {
             this.ccmCreateCntRank = ccmCreateCntRank;
             return this;
        }

    

        /**
         * 用户2023年创建文档数最多的月份
         * <p> 示例值：9
         * @param ccmCreateBusyMonth
         * @return
         */
        public Builder ccmCreateBusyMonth(String ccmCreateBusyMonth) {
             this.ccmCreateBusyMonth = ccmCreateBusyMonth;
             return this;
        }

    

        /**
         * 用户2023年创建文档数最多的月份的文档数
         * <p> 示例值：5702
         * @param ccmCreateBusyMonthCnt
         * @return
         */
        public Builder ccmCreateBusyMonthCnt(Integer ccmCreateBusyMonthCnt) {
             this.ccmCreateBusyMonthCnt = ccmCreateBusyMonthCnt;
             return this;
        }

    

        /**
         * 用户本人创建的文档在2023年全年的浏览人数。注意:仅限制浏览时间是2023年,不限制文档的创建时间。
         * <p> 示例值：21338
         * @param ccmCreateViewedUcnt
         * @return
         */
        public Builder ccmCreateViewedUcnt(Integer ccmCreateViewedUcnt) {
             this.ccmCreateViewedUcnt = ccmCreateViewedUcnt;
             return this;
        }

    

        /**
         * 用户本人创建的文档在2023年收到的点赞数,仅指文档底部的大拇指点赞。注意:仅限制点赞时间是2023年,不限制文档的创建时间。
         * <p> 示例值：21338
         * @param ccmCreateLikedCnt
         * @return
         */
        public Builder ccmCreateLikedCnt(Integer ccmCreateLikedCnt) {
             this.ccmCreateLikedCnt = ccmCreateLikedCnt;
             return this;
        }

    

        /**
         * 用户2023年由本人创建的文档的点赞数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param ccmCreateLikedCntRank
         * @return
         */
        public Builder ccmCreateLikedCntRank(String ccmCreateLikedCntRank) {
             this.ccmCreateLikedCntRank = ccmCreateLikedCntRank;
             return this;
        }

    

        /**
         * 用户2022-2023参与编辑、评论他人的文档数,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param ccmEditCommentFcnt2
         * @return
         */
        public Builder ccmEditCommentFcnt2(AnnualReportMapInt[] ccmEditCommentFcnt2) {
             this.ccmEditCommentFcnt2 = ccmEditCommentFcnt2;
             return this;
        }

    

        /**
         * 用户2023年参与编辑、评论他人的文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param ccmEditCommentFcntRank
         * @return
         */
        public Builder ccmEditCommentFcntRank(String ccmEditCommentFcntRank) {
             this.ccmEditCommentFcntRank = ccmEditCommentFcntRank;
             return this;
        }

    

        /**
         * 用户2023年点击浏览过的他人文档数
         * <p> 示例值：21338
         * @param ccmViewOtherFcnt
         * @return
         */
        public Builder ccmViewOtherFcnt(Integer ccmViewOtherFcnt) {
             this.ccmViewOtherFcnt = ccmViewOtherFcnt;
             return this;
        }

    

        /**
         * 用户2023年点击浏览过的他人文档数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param ccmViewOtherFcntRank
         * @return
         */
        public Builder ccmViewOtherFcntRank(String ccmViewOtherFcntRank) {
             this.ccmViewOtherFcntRank = ccmViewOtherFcntRank;
             return this;
        }

    

        /**
         * 用户2022-2023本人发起的线上视频会议的数量(循环会议算多次,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param vcSentMeetingCnt2
         * @return
         */
        public Builder vcSentMeetingCnt2(AnnualReportMapInt[] vcSentMeetingCnt2) {
             this.vcSentMeetingCnt2 = vcSentMeetingCnt2;
             return this;
        }

    

        /**
         * 用户2023年本人发起的线上视频会议的数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param vcSentMeetingCntRank
         * @return
         */
        public Builder vcSentMeetingCntRank(String vcSentMeetingCntRank) {
             this.vcSentMeetingCntRank = vcSentMeetingCntRank;
             return this;
        }

    

        /**
         * 用户2023年本人发起会议邀请参会的人次
         * <p> 示例值：21338
         * @param vcSentMeetingUcnt
         * @return
         */
        public Builder vcSentMeetingUcnt(Integer vcSentMeetingUcnt) {
             this.vcSentMeetingUcnt = vcSentMeetingUcnt;
             return this;
        }

    

        /**
         * 用户2022-2023本人受邀参与的会议数(循环会议算多次),共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param vcJoinMeetingCnt2
         * @return
         */
        public Builder vcJoinMeetingCnt2(AnnualReportMapInt[] vcJoinMeetingCnt2) {
             this.vcJoinMeetingCnt2 = vcJoinMeetingCnt2;
             return this;
        }

    

        /**
         * 用户2023年本人受邀参与的会议数排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param vcJoinMeetingCntRank
         * @return
         */
        public Builder vcJoinMeetingCntRank(String vcJoinMeetingCntRank) {
             this.vcJoinMeetingCntRank = vcJoinMeetingCntRank;
             return this;
        }

    

        /**
         * 用户2023年本人的总参会次数(包含自己发起和被邀请)
         * <p> 示例值：21338
         * @param vcAllMeetingCnt
         * @return
         */
        public Builder vcAllMeetingCnt(Integer vcAllMeetingCnt) {
             this.vcAllMeetingCnt = vcAllMeetingCnt;
             return this;
        }

    

        /**
         * 用户2023年本人的总参会次数(包含自己发起和被邀请)的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量
         * <p> 示例值：10
         * @param vcAllMeetingCntRank
         * @return
         */
        public Builder vcAllMeetingCntRank(String vcAllMeetingCntRank) {
             this.vcAllMeetingCntRank = vcAllMeetingCntRank;
             return this;
        }

    

        /**
         * 用户2022-2023本人总参会的时长(包含自己发起和被邀请),格式0.01h,共2组键值对,表示2年各自的数据。举例:{"2022":"33.33","2023":"55.55"}
         * <p> 示例值：
         * @param vcAllMeetingDuration2
         * @return
         */
        public Builder vcAllMeetingDuration2(AnnualReportMapFloat[] vcAllMeetingDuration2) {
             this.vcAllMeetingDuration2 = vcAllMeetingDuration2;
             return this;
        }

    

        /**
         * 用户2023年中最常开始日程的时间,精确到分钟,格式:【23:59】
         * <p> 示例值：12:35
         * @param calCommentCalTime
         * @return
         */
        public Builder calCommentCalTime(String calCommentCalTime) {
             this.calCommentCalTime = calCommentCalTime;
             return this;
        }

    

        /**
         * 2023年查看同事profile的人次
         * <p> 示例值：21338
         * @param peopleProfileViewCnt
         * @return
         */
        public Builder peopleProfileViewCnt(String peopleProfileViewCnt) {
             this.peopleProfileViewCnt = peopleProfileViewCnt;
             return this;
        }

    

        /**
         * 用户2022-2023面试了多少场,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param peopleInterviewNum2
         * @return
         */
        public Builder peopleInterviewNum2(AnnualReportMapInt[] peopleInterviewNum2) {
             this.peopleInterviewNum2 = peopleInterviewNum2;
             return this;
        }

    

        /**
         * people用户2023年面试总场次的排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param peopleInterviewNumRank
         * @return
         */
        public Builder peopleInterviewNumRank(String peopleInterviewNumRank) {
             this.peopleInterviewNumRank = peopleInterviewNumRank;
             return this;
        }

    

        /**
         * 用户2022-2023本人面试之后,发出offer数量,共2组键值对,表示2年各自的数据。举例:{"2022":"33","2023":"55"}
         * <p> 示例值：
         * @param peopleInterviewOfferNum2
         * @return
         */
        public Builder peopleInterviewOfferNum2(AnnualReportMapInt[] peopleInterviewOfferNum2) {
             this.peopleInterviewOfferNum2 = peopleInterviewOfferNum2;
             return this;
        }

    

        /**
         * 2023年由本人面试之后,发出offer数量排名。排名的统一定义:在同一租户内,此指标大于本人的用户数量。
         * <p> 示例值：4852
         * @param peopleInterviewOfferNumRank
         * @return
         */
        public Builder peopleInterviewOfferNumRank(String peopleInterviewOfferNumRank) {
             this.peopleInterviewOfferNumRank = peopleInterviewOfferNumRank;
             return this;
        }

    

        /**
         * 用户2023年发邮件数
         * <p> 示例值：4852
         * @param emailSendEmailCount
         * @return
         */
        public Builder emailSendEmailCount(Integer emailSendEmailCount) {
             this.emailSendEmailCount = emailSendEmailCount;
             return this;
        }

    

        /**
         * 用户2023年收邮件数
         * <p> 示例值：7045
         * @param emailReceiveEmailCount
         * @return
         */
        public Builder emailReceiveEmailCount(Integer emailReceiveEmailCount) {
             this.emailReceiveEmailCount = emailReceiveEmailCount;
             return this;
        }

    
    
    public UserReport2023 build(){
        return new UserReport2023(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
