// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.aily.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.aily.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class MessageError {
     /**
      * 错误码
      * <p> 示例值：sp_ec_cr_200001
      */
    @SerializedName("code")
    private String code;
     /**
      * 错误消息
      * <p> 示例值：意图状态不合法，当前为1，实际为4
      */
    @SerializedName("message")
    private String message;
     /**
      * 错误类型
      * <p> 示例值：SYSTEM
      */
    @SerializedName("error_type")
    private String errorType;
     /**
      * 反馈码
      * <p> 示例值：2023122620474996FAC90E4B49302D7C93
      */
    @SerializedName("log_id")
    private String logId;
     /**
      * 错误标题
      * <p> 示例值：意图状态不合法
      */
    @SerializedName("title")
    private String title;
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }


// builder 开始
  public MessageError(){}

  public MessageError(Builder builder){
         /**
          * 错误码
          * <p> 示例值：sp_ec_cr_200001
          */
      this.code = builder.code;
         /**
          * 错误消息
          * <p> 示例值：意图状态不合法，当前为1，实际为4
          */
      this.message = builder.message;
         /**
          * 错误类型
          * <p> 示例值：SYSTEM
          */
      this.errorType = builder.errorType;
         /**
          * 反馈码
          * <p> 示例值：2023122620474996FAC90E4B49302D7C93
          */
      this.logId = builder.logId;
         /**
          * 错误标题
          * <p> 示例值：意图状态不合法
          */
      this.title = builder.title;
  }

    public static class Builder {
     /**
      * 错误码
      * <p> 示例值：sp_ec_cr_200001
      */
        private String code;
     /**
      * 错误消息
      * <p> 示例值：意图状态不合法，当前为1，实际为4
      */
        private String message;
     /**
      * 错误类型
      * <p> 示例值：SYSTEM
      */
        private String errorType;
     /**
      * 反馈码
      * <p> 示例值：2023122620474996FAC90E4B49302D7C93
      */
        private String logId;
     /**
      * 错误标题
      * <p> 示例值：意图状态不合法
      */
        private String title;

        /**
         * 错误码
         * <p> 示例值：sp_ec_cr_200001
         * @param code
         * @return
         */
        public Builder code(String code) {
             this.code = code;
             return this;
        }

    

        /**
         * 错误消息
         * <p> 示例值：意图状态不合法，当前为1，实际为4
         * @param message
         * @return
         */
        public Builder message(String message) {
             this.message = message;
             return this;
        }

    

        /**
         * 错误类型
         * <p> 示例值：SYSTEM
         * @param errorType
         * @return
         */
        public Builder errorType(String errorType) {
             this.errorType = errorType;
             return this;
        }
        /**
         * 错误类型
         * <p> 示例值：SYSTEM
         * @param errorType {@link com.lark.oapi.service.aily.v1.enums.MessageErrorErrorTypeEnum}
         * @return
         */
        public Builder errorType(com.lark.oapi.service.aily.v1.enums.MessageErrorErrorTypeEnum errorType) {
             this.errorType = errorType.getValue();
             return this;
        }

    

        /**
         * 反馈码
         * <p> 示例值：2023122620474996FAC90E4B49302D7C93
         * @param logId
         * @return
         */
        public Builder logId(String logId) {
             this.logId = logId;
             return this;
        }

    

        /**
         * 错误标题
         * <p> 示例值：意图状态不合法
         * @param title
         * @return
         */
        public Builder title(String title) {
             this.title = title;
             return this;
        }

    
    
    public MessageError build(){
        return new MessageError(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
