// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.aily.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.aily.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Session {
     /**
      * session 的唯一标识
      * <p> 示例值：7316801852719906836
      */
    @SerializedName("id")
    private String id;
     /**
      * session 的创建时间，毫秒时间戳
      * <p> 示例值：1703486238000
      */
    @SerializedName("created_at")
    private String createdAt;
     /**
      * session 的过期时间，毫秒时间戳
      * <p> 示例值：1703486238000
      */
    @SerializedName("effected_at")
    private String effectedAt;
     /**
      * session 类型
      * <p> 示例值：LONG-TERM
      */
    @SerializedName("type")
    private String type;
     /**
      * session 状态
      * <p> 示例值：VALID
      */
    @SerializedName("status")
    private String status;
     /**
      * 当前运行中的意图 id
      * <p> 示例值：7312657247586009109
      */
    @SerializedName("active_intent_id")
    private String activeIntentId;
     /**
      * 渠道类型
      * <p> 示例值：LARK_OPEN_API
      */
    @SerializedName("channel_type")
    private String channelType;
     /**
      * 是否开启调试模式
      * <p> 示例值：false
      */
    @SerializedName("enable_debug")
    private Boolean enableDebug;
     /**
      * 会话中的自定义 kv 对，包括创建时传入的渠道上下文
      * <p> 示例值：{}
      */
    @SerializedName("kvs")
    private String kvs;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getEffectedAt() {
        return this.effectedAt;
    }

    public void setEffectedAt(String effectedAt) {
        this.effectedAt = effectedAt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getActiveIntentId() {
        return this.activeIntentId;
    }

    public void setActiveIntentId(String activeIntentId) {
        this.activeIntentId = activeIntentId;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public void setChannelType(String channelType) {
        this.channelType = channelType;
    }

    public Boolean getEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(Boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public String getKvs() {
        return this.kvs;
    }

    public void setKvs(String kvs) {
        this.kvs = kvs;
    }


// builder 开始
  public Session(){}

  public Session(Builder builder){
         /**
          * session 的唯一标识
          * <p> 示例值：7316801852719906836
          */
      this.id = builder.id;
         /**
          * session 的创建时间，毫秒时间戳
          * <p> 示例值：1703486238000
          */
      this.createdAt = builder.createdAt;
         /**
          * session 的过期时间，毫秒时间戳
          * <p> 示例值：1703486238000
          */
      this.effectedAt = builder.effectedAt;
         /**
          * session 类型
          * <p> 示例值：LONG-TERM
          */
      this.type = builder.type;
         /**
          * session 状态
          * <p> 示例值：VALID
          */
      this.status = builder.status;
         /**
          * 当前运行中的意图 id
          * <p> 示例值：7312657247586009109
          */
      this.activeIntentId = builder.activeIntentId;
         /**
          * 渠道类型
          * <p> 示例值：LARK_OPEN_API
          */
      this.channelType = builder.channelType;
         /**
          * 是否开启调试模式
          * <p> 示例值：false
          */
      this.enableDebug = builder.enableDebug;
         /**
          * 会话中的自定义 kv 对，包括创建时传入的渠道上下文
          * <p> 示例值：{}
          */
      this.kvs = builder.kvs;
  }

    public static class Builder {
     /**
      * session 的唯一标识
      * <p> 示例值：7316801852719906836
      */
        private String id;
     /**
      * session 的创建时间，毫秒时间戳
      * <p> 示例值：1703486238000
      */
        private String createdAt;
     /**
      * session 的过期时间，毫秒时间戳
      * <p> 示例值：1703486238000
      */
        private String effectedAt;
     /**
      * session 类型
      * <p> 示例值：LONG-TERM
      */
        private String type;
     /**
      * session 状态
      * <p> 示例值：VALID
      */
        private String status;
     /**
      * 当前运行中的意图 id
      * <p> 示例值：7312657247586009109
      */
        private String activeIntentId;
     /**
      * 渠道类型
      * <p> 示例值：LARK_OPEN_API
      */
        private String channelType;
     /**
      * 是否开启调试模式
      * <p> 示例值：false
      */
        private Boolean enableDebug;
     /**
      * 会话中的自定义 kv 对，包括创建时传入的渠道上下文
      * <p> 示例值：{}
      */
        private String kvs;

        /**
         * session 的唯一标识
         * <p> 示例值：7316801852719906836
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * session 的创建时间，毫秒时间戳
         * <p> 示例值：1703486238000
         * @param createdAt
         * @return
         */
        public Builder createdAt(String createdAt) {
             this.createdAt = createdAt;
             return this;
        }

    

        /**
         * session 的过期时间，毫秒时间戳
         * <p> 示例值：1703486238000
         * @param effectedAt
         * @return
         */
        public Builder effectedAt(String effectedAt) {
             this.effectedAt = effectedAt;
             return this;
        }

    

        /**
         * session 类型
         * <p> 示例值：LONG-TERM
         * @param type
         * @return
         */
        public Builder type(String type) {
             this.type = type;
             return this;
        }
        /**
         * session 类型
         * <p> 示例值：LONG-TERM
         * @param type {@link com.lark.oapi.service.aily.v1.enums.SessionSessionTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.aily.v1.enums.SessionSessionTypeEnum type) {
             this.type = type.getValue();
             return this;
        }

    

        /**
         * session 状态
         * <p> 示例值：VALID
         * @param status
         * @return
         */
        public Builder status(String status) {
             this.status = status;
             return this;
        }
        /**
         * session 状态
         * <p> 示例值：VALID
         * @param status {@link com.lark.oapi.service.aily.v1.enums.SessionSessionStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.aily.v1.enums.SessionSessionStatusEnum status) {
             this.status = status.getValue();
             return this;
        }

    

        /**
         * 当前运行中的意图 id
         * <p> 示例值：7312657247586009109
         * @param activeIntentId
         * @return
         */
        public Builder activeIntentId(String activeIntentId) {
             this.activeIntentId = activeIntentId;
             return this;
        }

    

        /**
         * 渠道类型
         * <p> 示例值：LARK_OPEN_API
         * @param channelType
         * @return
         */
        public Builder channelType(String channelType) {
             this.channelType = channelType;
             return this;
        }
        /**
         * 渠道类型
         * <p> 示例值：LARK_OPEN_API
         * @param channelType {@link com.lark.oapi.service.aily.v1.enums.SessionChannelTypeEnum}
         * @return
         */
        public Builder channelType(com.lark.oapi.service.aily.v1.enums.SessionChannelTypeEnum channelType) {
             this.channelType = channelType.getValue();
             return this;
        }

    

        /**
         * 是否开启调试模式
         * <p> 示例值：false
         * @param enableDebug
         * @return
         */
        public Builder enableDebug(Boolean enableDebug) {
             this.enableDebug = enableDebug;
             return this;
        }

    

        /**
         * 会话中的自定义 kv 对，包括创建时传入的渠道上下文
         * <p> 示例值：{}
         * @param kvs
         * @return
         */
        public Builder kvs(String kvs) {
             this.kvs = kvs;
             return this;
        }

    
    
    public Session build(){
        return new Session(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
