// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class App {
     /**
      *   aPaaS 产品应用的名称
      * <p> 示例值：
      */
    @SerializedName("name")
    private I18n[] name;
     /**
      * aPaaS 产品应用的命名空间
      * <p> 示例值：package_35f605__c
      */
    @SerializedName("namespace")
    private String namespace;
     /**
      * aPaaS 产品应用的创建时间
      * <p> 示例值：1736480945563
      */
    @SerializedName("created_at")
    private Integer createdAt;
     /**
      * aPaaS 产品应用的创建者
      * <p> 示例值：1818624575806604
      */
    @SerializedName("creator")
    private Integer creator;
     /**
      * aPaaS 产品应用的所有者
      * <p> 示例值：1818624575806604
      */
    @SerializedName("owner")
    private Integer owner;
     /**
      * aPaaS 产品应用的状态
      * <p> 示例值：enabled
      */
    @SerializedName("status")
    private String status;
     /**
      * aPaaS 产品应用的成员管理信息
      * <p> 示例值：
      */
    @SerializedName("app_roles_info")
    private AppRolesInfo appRolesInfo;
     /**
      * aPaaS 产品应用的图标
      * <p> 示例值：https://ae.feishu.cn/img/namespaces/_global/download/namespace_8aed421832fa4586968596f70e6eaebd_p.jpg
      */
    @SerializedName("icon")
    private String icon;
     /**
      * aPaaS 产品应用的描述
      * <p> 示例值：
      */
    @SerializedName("description")
    private I18n[] description;
     /**
      * aPaaS 产品应用的类型
      * <p> 示例值：custom
      */
    @SerializedName("type")
    private String type;
     /**
      * aPaaS 产品应用的启用状态
      * <p> 示例值：enabled
      */
    @SerializedName("enable_status")
    private String enableStatus;
     /**
      * aPaaS 产品应用的发布状态
      * <p> 示例值：released
      */
    @SerializedName("release_status")
    private String releaseStatus;
     /**
      * aPaaS 产品应用的服务状态
      * <p> 示例值：available
      */
    @SerializedName("service_status")
    private String serviceStatus;
     /**
      * aPaaS 产品应用的停服原因
      * <p> 示例值：entitlement_expire
      */
    @SerializedName("service_unavailable_reason")
    private String serviceUnavailableReason;
     /**
      * aPaaS 产品应用的版本
      * <p> 示例值：paid
      */
    @SerializedName("feature_set")
    private String featureSet;
     /**
      * aPaaS 产品应用的计费方式
      * <p> 示例值：per_user_per_app
      */
    @SerializedName("charge_mode")
    private String chargeMode;
     /**
      * aPaaS 产品应用的服务商信息
      * <p> 示例值：
      */
    @SerializedName("isv_tenant")
    private ClientIsvTenant isvTenant;
    public I18n[] getName() {
        return this.name;
    }

    public void setName(I18n[] name) {
        this.name = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Integer getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Integer createdAt) {
        this.createdAt = createdAt;
    }

    public Integer getCreator() {
        return this.creator;
    }

    public void setCreator(Integer creator) {
        this.creator = creator;
    }

    public Integer getOwner() {
        return this.owner;
    }

    public void setOwner(Integer owner) {
        this.owner = owner;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AppRolesInfo getAppRolesInfo() {
        return this.appRolesInfo;
    }

    public void setAppRolesInfo(AppRolesInfo appRolesInfo) {
        this.appRolesInfo = appRolesInfo;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public I18n[] getDescription() {
        return this.description;
    }

    public void setDescription(I18n[] description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEnableStatus() {
        return this.enableStatus;
    }

    public void setEnableStatus(String enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public void setReleaseStatus(String releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public String getServiceStatus() {
        return this.serviceStatus;
    }

    public void setServiceStatus(String serviceStatus) {
        this.serviceStatus = serviceStatus;
    }

    public String getServiceUnavailableReason() {
        return this.serviceUnavailableReason;
    }

    public void setServiceUnavailableReason(String serviceUnavailableReason) {
        this.serviceUnavailableReason = serviceUnavailableReason;
    }

    public String getFeatureSet() {
        return this.featureSet;
    }

    public void setFeatureSet(String featureSet) {
        this.featureSet = featureSet;
    }

    public String getChargeMode() {
        return this.chargeMode;
    }

    public void setChargeMode(String chargeMode) {
        this.chargeMode = chargeMode;
    }

    public ClientIsvTenant getIsvTenant() {
        return this.isvTenant;
    }

    public void setIsvTenant(ClientIsvTenant isvTenant) {
        this.isvTenant = isvTenant;
    }


// builder 开始
  public App(){}

  public App(Builder builder){
         /**
          *   aPaaS 产品应用的名称
          * <p> 示例值：
          */
      this.name = builder.name;
         /**
          * aPaaS 产品应用的命名空间
          * <p> 示例值：package_35f605__c
          */
      this.namespace = builder.namespace;
         /**
          * aPaaS 产品应用的创建时间
          * <p> 示例值：1736480945563
          */
      this.createdAt = builder.createdAt;
         /**
          * aPaaS 产品应用的创建者
          * <p> 示例值：1818624575806604
          */
      this.creator = builder.creator;
         /**
          * aPaaS 产品应用的所有者
          * <p> 示例值：1818624575806604
          */
      this.owner = builder.owner;
         /**
          * aPaaS 产品应用的状态
          * <p> 示例值：enabled
          */
      this.status = builder.status;
         /**
          * aPaaS 产品应用的成员管理信息
          * <p> 示例值：
          */
      this.appRolesInfo = builder.appRolesInfo;
         /**
          * aPaaS 产品应用的图标
          * <p> 示例值：https://ae.feishu.cn/img/namespaces/_global/download/namespace_8aed421832fa4586968596f70e6eaebd_p.jpg
          */
      this.icon = builder.icon;
         /**
          * aPaaS 产品应用的描述
          * <p> 示例值：
          */
      this.description = builder.description;
         /**
          * aPaaS 产品应用的类型
          * <p> 示例值：custom
          */
      this.type = builder.type;
         /**
          * aPaaS 产品应用的启用状态
          * <p> 示例值：enabled
          */
      this.enableStatus = builder.enableStatus;
         /**
          * aPaaS 产品应用的发布状态
          * <p> 示例值：released
          */
      this.releaseStatus = builder.releaseStatus;
         /**
          * aPaaS 产品应用的服务状态
          * <p> 示例值：available
          */
      this.serviceStatus = builder.serviceStatus;
         /**
          * aPaaS 产品应用的停服原因
          * <p> 示例值：entitlement_expire
          */
      this.serviceUnavailableReason = builder.serviceUnavailableReason;
         /**
          * aPaaS 产品应用的版本
          * <p> 示例值：paid
          */
      this.featureSet = builder.featureSet;
         /**
          * aPaaS 产品应用的计费方式
          * <p> 示例值：per_user_per_app
          */
      this.chargeMode = builder.chargeMode;
         /**
          * aPaaS 产品应用的服务商信息
          * <p> 示例值：
          */
      this.isvTenant = builder.isvTenant;
  }

    public static class Builder {
     /**
      *   aPaaS 产品应用的名称
      * <p> 示例值：
      */
        private I18n[] name;
     /**
      * aPaaS 产品应用的命名空间
      * <p> 示例值：package_35f605__c
      */
        private String namespace;
     /**
      * aPaaS 产品应用的创建时间
      * <p> 示例值：1736480945563
      */
        private Integer createdAt;
     /**
      * aPaaS 产品应用的创建者
      * <p> 示例值：1818624575806604
      */
        private Integer creator;
     /**
      * aPaaS 产品应用的所有者
      * <p> 示例值：1818624575806604
      */
        private Integer owner;
     /**
      * aPaaS 产品应用的状态
      * <p> 示例值：enabled
      */
        private String status;
     /**
      * aPaaS 产品应用的成员管理信息
      * <p> 示例值：
      */
        private AppRolesInfo appRolesInfo;
     /**
      * aPaaS 产品应用的图标
      * <p> 示例值：https://ae.feishu.cn/img/namespaces/_global/download/namespace_8aed421832fa4586968596f70e6eaebd_p.jpg
      */
        private String icon;
     /**
      * aPaaS 产品应用的描述
      * <p> 示例值：
      */
        private I18n[] description;
     /**
      * aPaaS 产品应用的类型
      * <p> 示例值：custom
      */
        private String type;
     /**
      * aPaaS 产品应用的启用状态
      * <p> 示例值：enabled
      */
        private String enableStatus;
     /**
      * aPaaS 产品应用的发布状态
      * <p> 示例值：released
      */
        private String releaseStatus;
     /**
      * aPaaS 产品应用的服务状态
      * <p> 示例值：available
      */
        private String serviceStatus;
     /**
      * aPaaS 产品应用的停服原因
      * <p> 示例值：entitlement_expire
      */
        private String serviceUnavailableReason;
     /**
      * aPaaS 产品应用的版本
      * <p> 示例值：paid
      */
        private String featureSet;
     /**
      * aPaaS 产品应用的计费方式
      * <p> 示例值：per_user_per_app
      */
        private String chargeMode;
     /**
      * aPaaS 产品应用的服务商信息
      * <p> 示例值：
      */
        private ClientIsvTenant isvTenant;

        /**
         *   aPaaS 产品应用的名称
         * <p> 示例值：
         * @param name
         * @return
         */
        public Builder name(I18n[] name) {
             this.name = name;
             return this;
        }

    

        /**
         * aPaaS 产品应用的命名空间
         * <p> 示例值：package_35f605__c
         * @param namespace
         * @return
         */
        public Builder namespace(String namespace) {
             this.namespace = namespace;
             return this;
        }

    

        /**
         * aPaaS 产品应用的创建时间
         * <p> 示例值：1736480945563
         * @param createdAt
         * @return
         */
        public Builder createdAt(Integer createdAt) {
             this.createdAt = createdAt;
             return this;
        }

    

        /**
         * aPaaS 产品应用的创建者
         * <p> 示例值：1818624575806604
         * @param creator
         * @return
         */
        public Builder creator(Integer creator) {
             this.creator = creator;
             return this;
        }

    

        /**
         * aPaaS 产品应用的所有者
         * <p> 示例值：1818624575806604
         * @param owner
         * @return
         */
        public Builder owner(Integer owner) {
             this.owner = owner;
             return this;
        }

    

        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         * @param status
         * @return
         */
        public Builder status(String status) {
             this.status = status;
             return this;
        }
        /**
         * aPaaS 产品应用的状态
         * <p> 示例值：enabled
         * @param status {@link com.lark.oapi.service.apaas.v1.enums.AppAppDisplayStatusEnum}
         * @return
         */
        public Builder status(com.lark.oapi.service.apaas.v1.enums.AppAppDisplayStatusEnum status) {
             this.status = status.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的成员管理信息
         * <p> 示例值：
         * @param appRolesInfo
         * @return
         */
        public Builder appRolesInfo(AppRolesInfo appRolesInfo) {
             this.appRolesInfo = appRolesInfo;
             return this;
        }

    

        /**
         * aPaaS 产品应用的图标
         * <p> 示例值：https://ae.feishu.cn/img/namespaces/_global/download/namespace_8aed421832fa4586968596f70e6eaebd_p.jpg
         * @param icon
         * @return
         */
        public Builder icon(String icon) {
             this.icon = icon;
             return this;
        }

    

        /**
         * aPaaS 产品应用的描述
         * <p> 示例值：
         * @param description
         * @return
         */
        public Builder description(I18n[] description) {
             this.description = description;
             return this;
        }

    

        /**
         * aPaaS 产品应用的类型
         * <p> 示例值：custom
         * @param type
         * @return
         */
        public Builder type(String type) {
             this.type = type;
             return this;
        }
        /**
         * aPaaS 产品应用的类型
         * <p> 示例值：custom
         * @param type {@link com.lark.oapi.service.apaas.v1.enums.AppTypeEnum}
         * @return
         */
        public Builder type(com.lark.oapi.service.apaas.v1.enums.AppTypeEnum type) {
             this.type = type.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的启用状态
         * <p> 示例值：enabled
         * @param enableStatus
         * @return
         */
        public Builder enableStatus(String enableStatus) {
             this.enableStatus = enableStatus;
             return this;
        }
        /**
         * aPaaS 产品应用的启用状态
         * <p> 示例值：enabled
         * @param enableStatus {@link com.lark.oapi.service.apaas.v1.enums.AppEnableStatusEnum}
         * @return
         */
        public Builder enableStatus(com.lark.oapi.service.apaas.v1.enums.AppEnableStatusEnum enableStatus) {
             this.enableStatus = enableStatus.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的发布状态
         * <p> 示例值：released
         * @param releaseStatus
         * @return
         */
        public Builder releaseStatus(String releaseStatus) {
             this.releaseStatus = releaseStatus;
             return this;
        }
        /**
         * aPaaS 产品应用的发布状态
         * <p> 示例值：released
         * @param releaseStatus {@link com.lark.oapi.service.apaas.v1.enums.AppReleaseStatusEnum}
         * @return
         */
        public Builder releaseStatus(com.lark.oapi.service.apaas.v1.enums.AppReleaseStatusEnum releaseStatus) {
             this.releaseStatus = releaseStatus.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的服务状态
         * <p> 示例值：available
         * @param serviceStatus
         * @return
         */
        public Builder serviceStatus(String serviceStatus) {
             this.serviceStatus = serviceStatus;
             return this;
        }
        /**
         * aPaaS 产品应用的服务状态
         * <p> 示例值：available
         * @param serviceStatus {@link com.lark.oapi.service.apaas.v1.enums.AppServiceStatusEnum}
         * @return
         */
        public Builder serviceStatus(com.lark.oapi.service.apaas.v1.enums.AppServiceStatusEnum serviceStatus) {
             this.serviceStatus = serviceStatus.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的停服原因
         * <p> 示例值：entitlement_expire
         * @param serviceUnavailableReason
         * @return
         */
        public Builder serviceUnavailableReason(String serviceUnavailableReason) {
             this.serviceUnavailableReason = serviceUnavailableReason;
             return this;
        }
        /**
         * aPaaS 产品应用的停服原因
         * <p> 示例值：entitlement_expire
         * @param serviceUnavailableReason {@link com.lark.oapi.service.apaas.v1.enums.AppServiceUnavailableReasonEnum}
         * @return
         */
        public Builder serviceUnavailableReason(com.lark.oapi.service.apaas.v1.enums.AppServiceUnavailableReasonEnum serviceUnavailableReason) {
             this.serviceUnavailableReason = serviceUnavailableReason.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的版本
         * <p> 示例值：paid
         * @param featureSet
         * @return
         */
        public Builder featureSet(String featureSet) {
             this.featureSet = featureSet;
             return this;
        }
        /**
         * aPaaS 产品应用的版本
         * <p> 示例值：paid
         * @param featureSet {@link com.lark.oapi.service.apaas.v1.enums.AppFeatureSetEnum}
         * @return
         */
        public Builder featureSet(com.lark.oapi.service.apaas.v1.enums.AppFeatureSetEnum featureSet) {
             this.featureSet = featureSet.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的计费方式
         * <p> 示例值：per_user_per_app
         * @param chargeMode
         * @return
         */
        public Builder chargeMode(String chargeMode) {
             this.chargeMode = chargeMode;
             return this;
        }
        /**
         * aPaaS 产品应用的计费方式
         * <p> 示例值：per_user_per_app
         * @param chargeMode {@link com.lark.oapi.service.apaas.v1.enums.AppChargeModeEnum}
         * @return
         */
        public Builder chargeMode(com.lark.oapi.service.apaas.v1.enums.AppChargeModeEnum chargeMode) {
             this.chargeMode = chargeMode.getValue();
             return this;
        }

    

        /**
         * aPaaS 产品应用的服务商信息
         * <p> 示例值：
         * @param isvTenant
         * @return
         */
        public Builder isvTenant(ClientIsvTenant isvTenant) {
             this.isvTenant = isvTenant;
             return this;
        }

    
    
    public App build(){
        return new App(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
