// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import java.util.Map;
import com.lark.oapi.core.response.BaseResponse;
public class AuditLogEsField {
     /**
      * 审计日志ID
      * <p> 示例值：7376574450886557740
      */
    @SerializedName("log_id")
    private String logId;
     /**
      * 操作时间
      * <p> 示例值：1723634726874
      */
    @SerializedName("op_time")
    private String opTime;
     /**
      * 日志类型:10000-全部类型;10001-企业管理; 10002-登录日志;10003-应用管理
      * <p> 示例值：10000
      */
    @SerializedName("log_type")
    private String logType;
     /**
      * 操作人
      * <p> 示例值：
      */
    @SerializedName("operator")
    private LookupWithAvatar operator;
     /**
      * 是否为外部用户,true代表是外部用户
      * <p> 示例值：
      */
    @SerializedName("outsider")
    private Boolean outsider;
     /**
      * 登录类型:11001-飞书登录;11003-账号密码登录
      * <p> 示例值：11001
      */
    @SerializedName("login_type")
    private String loginType;
     /**
      * 飞书租户ID
      * <p> 示例值：123
      */
    @SerializedName("lark_tenant_id")
    private String larkTenantId;
     /**
      * apaas租户ID
      * <p> 示例值：23333
      */
    @SerializedName("apaas_tenant_id")
    private String apaasTenantId;
     /**
      * 用户地理信息
      * <p> 示例值：America/Chicago
      */
    @SerializedName("user_geo")
    private String userGeo;
     /**
      * 客户端IP
      * <p> 示例值：192.168.1.1
      */
    @SerializedName("client_ip")
    private String clientIp;
     /**
      * IP位置
      * <p> 示例值：中国北京
      */
    @SerializedName("ip_loc")
    private String ipLoc;
     /**
      * IP提供商
      * <p> 示例值：ISP_com
      */
    @SerializedName("ip_provider")
    private String ipProvider;
     /**
      * 引用页面
      * <p> 示例值：https://example.com/referer
      */
    @SerializedName("referer")
    private String referer;
     /**
      * 源页面
      * <p> 示例值：https://example.com/origin
      */
    @SerializedName("origin")
    private String origin;
     /**
      * 路由路径
      * <p> 示例值：/api/xxx
      */
    @SerializedName("api_path")
    private String apiPath;
     /**
      * 网关路径
      * <p> 示例值：/api/xxx
      */
    @SerializedName("full_path")
    private String fullPath;
     /**
      * 用户代理
      * <p> 示例值：Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148
      */
    @SerializedName("user_agent")
    private String userAgent;
     /**
      * 设备ID
      * <p> 示例值：device_1234
      */
    @SerializedName("device_id")
    private String deviceId;
     /**
      * web端设备ID
      * <p> 示例值：webDevice_1234
      */
    @SerializedName("web_device_id")
    private String webDeviceId;
     /**
      * 终端类型:13002-PC类型;13003-Web类型
      * <p> 示例值：2
      */
    @SerializedName("terminal_type")
    private String terminalType;
     /**
      * 系统类型:14002-window;14001-未知
      * <p> 示例值：14002
      */
    @SerializedName("os_type")
    private String osType;
     /**
      * 系统版本
      * <p> 示例值：14.6
      */
    @SerializedName("os_version")
    private String osVersion;
     /**
      * 功能模块
      * <p> 示例值：17001
      */
    @SerializedName("module")
    private String module;
     /**
      * 数据对象
      * <p> 示例值：object_api_aaa
      */
    @SerializedName("data_object")
    private String dataObject;
     /**
      * 审计域:15001-企业管理后台;15002-应用管理后 台;15003-应用开发平台
      * <p> 示例值：15001
      */
    @SerializedName("audit_scope")
    private String auditScope;
     /**
      * 租户ID
      * <p> 示例值：23335
      */
    @SerializedName("tenant_id")
    private String tenantId;
     /**
      * 应用唯一标识
      * <p> 示例值：package_aacc
      */
    @SerializedName("namespace")
    private String namespace;
     /**
      * 环境类型:16001-沙箱环境;16003-线上环境
      * <p> 示例值：16003
      */
    @SerializedName("env_type")
    private String envType;
     /**
      * 事件类型
      * <p> 示例值：19001
      */
    @SerializedName("op_type")
    private String opType;
     /**
      * 操作详情内容
      * <p> 示例值：
      */
    @SerializedName("op_detail")
    private Map<String, String> opDetail;
     /**
      * 操作源:20001-前端;20004-openapi
      * <p> 示例值：20001
      */
    @SerializedName("op_source")
    private String opSource;
     /**
      * 操作状态:18001-成功;18002-失败
      * <p> 示例值：18001
      */
    @SerializedName("status")
    private String status;
     /**
      * 失败原因
      * <p> 示例值：
      */
    @SerializedName("failed_reason_i18n")
    private Map<String, String> failedReasonI18n;
     /**
      * 数据变化(旧值和新值)
      * <p> 示例值：
      */
    @SerializedName("data_changes")
    private String[] dataChanges;
     /**
      * 应用名称
      * <p> 示例值：
      */
    @SerializedName("app_name")
    private Map<String, String> appName;
     /**
      * 应用版本号
      * <p> 示例值：v1.2.3
      */
    @SerializedName("keyword_field_app_version")
    private String keywordFieldAppVersion;
     /**
      * 审计日志事件子模块
      * <p> 示例值：223
      */
    @SerializedName("keyword_field_functional_sub_module")
    private String keywordFieldFunctionalSubModule;
    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public String getOpTime() {
        return this.opTime;
    }

    public void setOpTime(String opTime) {
        this.opTime = opTime;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public LookupWithAvatar getOperator() {
        return this.operator;
    }

    public void setOperator(LookupWithAvatar operator) {
        this.operator = operator;
    }

    public Boolean getOutsider() {
        return this.outsider;
    }

    public void setOutsider(Boolean outsider) {
        this.outsider = outsider;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public String getLarkTenantId() {
        return this.larkTenantId;
    }

    public void setLarkTenantId(String larkTenantId) {
        this.larkTenantId = larkTenantId;
    }

    public String getApaasTenantId() {
        return this.apaasTenantId;
    }

    public void setApaasTenantId(String apaasTenantId) {
        this.apaasTenantId = apaasTenantId;
    }

    public String getUserGeo() {
        return this.userGeo;
    }

    public void setUserGeo(String userGeo) {
        this.userGeo = userGeo;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getIpLoc() {
        return this.ipLoc;
    }

    public void setIpLoc(String ipLoc) {
        this.ipLoc = ipLoc;
    }

    public String getIpProvider() {
        return this.ipProvider;
    }

    public void setIpProvider(String ipProvider) {
        this.ipProvider = ipProvider;
    }

    public String getReferer() {
        return this.referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public void setApiPath(String apiPath) {
        this.apiPath = apiPath;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getWebDeviceId() {
        return this.webDeviceId;
    }

    public void setWebDeviceId(String webDeviceId) {
        this.webDeviceId = webDeviceId;
    }

    public String getTerminalType() {
        return this.terminalType;
    }

    public void setTerminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getDataObject() {
        return this.dataObject;
    }

    public void setDataObject(String dataObject) {
        this.dataObject = dataObject;
    }

    public String getAuditScope() {
        return this.auditScope;
    }

    public void setAuditScope(String auditScope) {
        this.auditScope = auditScope;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEnvType() {
        return this.envType;
    }

    public void setEnvType(String envType) {
        this.envType = envType;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public Map<String, String> getOpDetail() {
        return this.opDetail;
    }

    public void setOpDetail(Map<String, String> opDetail) {
        this.opDetail = opDetail;
    }

    public String getOpSource() {
        return this.opSource;
    }

    public void setOpSource(String opSource) {
        this.opSource = opSource;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Map<String, String> getFailedReasonI18n() {
        return this.failedReasonI18n;
    }

    public void setFailedReasonI18n(Map<String, String> failedReasonI18n) {
        this.failedReasonI18n = failedReasonI18n;
    }

    public String[] getDataChanges() {
        return this.dataChanges;
    }

    public void setDataChanges(String[] dataChanges) {
        this.dataChanges = dataChanges;
    }

    public Map<String, String> getAppName() {
        return this.appName;
    }

    public void setAppName(Map<String, String> appName) {
        this.appName = appName;
    }

    public String getKeywordFieldAppVersion() {
        return this.keywordFieldAppVersion;
    }

    public void setKeywordFieldAppVersion(String keywordFieldAppVersion) {
        this.keywordFieldAppVersion = keywordFieldAppVersion;
    }

    public String getKeywordFieldFunctionalSubModule() {
        return this.keywordFieldFunctionalSubModule;
    }

    public void setKeywordFieldFunctionalSubModule(String keywordFieldFunctionalSubModule) {
        this.keywordFieldFunctionalSubModule = keywordFieldFunctionalSubModule;
    }


// builder 开始
  public AuditLogEsField(){}

  public AuditLogEsField(Builder builder){
         /**
          * 审计日志ID
          * <p> 示例值：7376574450886557740
          */
      this.logId = builder.logId;
         /**
          * 操作时间
          * <p> 示例值：1723634726874
          */
      this.opTime = builder.opTime;
         /**
          * 日志类型:10000-全部类型;10001-企业管理; 10002-登录日志;10003-应用管理
          * <p> 示例值：10000
          */
      this.logType = builder.logType;
         /**
          * 操作人
          * <p> 示例值：
          */
      this.operator = builder.operator;
         /**
          * 是否为外部用户,true代表是外部用户
          * <p> 示例值：
          */
      this.outsider = builder.outsider;
         /**
          * 登录类型:11001-飞书登录;11003-账号密码登录
          * <p> 示例值：11001
          */
      this.loginType = builder.loginType;
         /**
          * 飞书租户ID
          * <p> 示例值：123
          */
      this.larkTenantId = builder.larkTenantId;
         /**
          * apaas租户ID
          * <p> 示例值：23333
          */
      this.apaasTenantId = builder.apaasTenantId;
         /**
          * 用户地理信息
          * <p> 示例值：America/Chicago
          */
      this.userGeo = builder.userGeo;
         /**
          * 客户端IP
          * <p> 示例值：192.168.1.1
          */
      this.clientIp = builder.clientIp;
         /**
          * IP位置
          * <p> 示例值：中国北京
          */
      this.ipLoc = builder.ipLoc;
         /**
          * IP提供商
          * <p> 示例值：ISP_com
          */
      this.ipProvider = builder.ipProvider;
         /**
          * 引用页面
          * <p> 示例值：https://example.com/referer
          */
      this.referer = builder.referer;
         /**
          * 源页面
          * <p> 示例值：https://example.com/origin
          */
      this.origin = builder.origin;
         /**
          * 路由路径
          * <p> 示例值：/api/xxx
          */
      this.apiPath = builder.apiPath;
         /**
          * 网关路径
          * <p> 示例值：/api/xxx
          */
      this.fullPath = builder.fullPath;
         /**
          * 用户代理
          * <p> 示例值：Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148
          */
      this.userAgent = builder.userAgent;
         /**
          * 设备ID
          * <p> 示例值：device_1234
          */
      this.deviceId = builder.deviceId;
         /**
          * web端设备ID
          * <p> 示例值：webDevice_1234
          */
      this.webDeviceId = builder.webDeviceId;
         /**
          * 终端类型:13002-PC类型;13003-Web类型
          * <p> 示例值：2
          */
      this.terminalType = builder.terminalType;
         /**
          * 系统类型:14002-window;14001-未知
          * <p> 示例值：14002
          */
      this.osType = builder.osType;
         /**
          * 系统版本
          * <p> 示例值：14.6
          */
      this.osVersion = builder.osVersion;
         /**
          * 功能模块
          * <p> 示例值：17001
          */
      this.module = builder.module;
         /**
          * 数据对象
          * <p> 示例值：object_api_aaa
          */
      this.dataObject = builder.dataObject;
         /**
          * 审计域:15001-企业管理后台;15002-应用管理后 台;15003-应用开发平台
          * <p> 示例值：15001
          */
      this.auditScope = builder.auditScope;
         /**
          * 租户ID
          * <p> 示例值：23335
          */
      this.tenantId = builder.tenantId;
         /**
          * 应用唯一标识
          * <p> 示例值：package_aacc
          */
      this.namespace = builder.namespace;
         /**
          * 环境类型:16001-沙箱环境;16003-线上环境
          * <p> 示例值：16003
          */
      this.envType = builder.envType;
         /**
          * 事件类型
          * <p> 示例值：19001
          */
      this.opType = builder.opType;
         /**
          * 操作详情内容
          * <p> 示例值：
          */
      this.opDetail = builder.opDetail;
         /**
          * 操作源:20001-前端;20004-openapi
          * <p> 示例值：20001
          */
      this.opSource = builder.opSource;
         /**
          * 操作状态:18001-成功;18002-失败
          * <p> 示例值：18001
          */
      this.status = builder.status;
         /**
          * 失败原因
          * <p> 示例值：
          */
      this.failedReasonI18n = builder.failedReasonI18n;
         /**
          * 数据变化(旧值和新值)
          * <p> 示例值：
          */
      this.dataChanges = builder.dataChanges;
         /**
          * 应用名称
          * <p> 示例值：
          */
      this.appName = builder.appName;
         /**
          * 应用版本号
          * <p> 示例值：v1.2.3
          */
      this.keywordFieldAppVersion = builder.keywordFieldAppVersion;
         /**
          * 审计日志事件子模块
          * <p> 示例值：223
          */
      this.keywordFieldFunctionalSubModule = builder.keywordFieldFunctionalSubModule;
  }

    public static class Builder {
     /**
      * 审计日志ID
      * <p> 示例值：7376574450886557740
      */
        private String logId;
     /**
      * 操作时间
      * <p> 示例值：1723634726874
      */
        private String opTime;
     /**
      * 日志类型:10000-全部类型;10001-企业管理; 10002-登录日志;10003-应用管理
      * <p> 示例值：10000
      */
        private String logType;
     /**
      * 操作人
      * <p> 示例值：
      */
        private LookupWithAvatar operator;
     /**
      * 是否为外部用户,true代表是外部用户
      * <p> 示例值：
      */
        private Boolean outsider;
     /**
      * 登录类型:11001-飞书登录;11003-账号密码登录
      * <p> 示例值：11001
      */
        private String loginType;
     /**
      * 飞书租户ID
      * <p> 示例值：123
      */
        private String larkTenantId;
     /**
      * apaas租户ID
      * <p> 示例值：23333
      */
        private String apaasTenantId;
     /**
      * 用户地理信息
      * <p> 示例值：America/Chicago
      */
        private String userGeo;
     /**
      * 客户端IP
      * <p> 示例值：192.168.1.1
      */
        private String clientIp;
     /**
      * IP位置
      * <p> 示例值：中国北京
      */
        private String ipLoc;
     /**
      * IP提供商
      * <p> 示例值：ISP_com
      */
        private String ipProvider;
     /**
      * 引用页面
      * <p> 示例值：https://example.com/referer
      */
        private String referer;
     /**
      * 源页面
      * <p> 示例值：https://example.com/origin
      */
        private String origin;
     /**
      * 路由路径
      * <p> 示例值：/api/xxx
      */
        private String apiPath;
     /**
      * 网关路径
      * <p> 示例值：/api/xxx
      */
        private String fullPath;
     /**
      * 用户代理
      * <p> 示例值：Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148
      */
        private String userAgent;
     /**
      * 设备ID
      * <p> 示例值：device_1234
      */
        private String deviceId;
     /**
      * web端设备ID
      * <p> 示例值：webDevice_1234
      */
        private String webDeviceId;
     /**
      * 终端类型:13002-PC类型;13003-Web类型
      * <p> 示例值：2
      */
        private String terminalType;
     /**
      * 系统类型:14002-window;14001-未知
      * <p> 示例值：14002
      */
        private String osType;
     /**
      * 系统版本
      * <p> 示例值：14.6
      */
        private String osVersion;
     /**
      * 功能模块
      * <p> 示例值：17001
      */
        private String module;
     /**
      * 数据对象
      * <p> 示例值：object_api_aaa
      */
        private String dataObject;
     /**
      * 审计域:15001-企业管理后台;15002-应用管理后 台;15003-应用开发平台
      * <p> 示例值：15001
      */
        private String auditScope;
     /**
      * 租户ID
      * <p> 示例值：23335
      */
        private String tenantId;
     /**
      * 应用唯一标识
      * <p> 示例值：package_aacc
      */
        private String namespace;
     /**
      * 环境类型:16001-沙箱环境;16003-线上环境
      * <p> 示例值：16003
      */
        private String envType;
     /**
      * 事件类型
      * <p> 示例值：19001
      */
        private String opType;
     /**
      * 操作详情内容
      * <p> 示例值：
      */
        private Map<String, String> opDetail;
     /**
      * 操作源:20001-前端;20004-openapi
      * <p> 示例值：20001
      */
        private String opSource;
     /**
      * 操作状态:18001-成功;18002-失败
      * <p> 示例值：18001
      */
        private String status;
     /**
      * 失败原因
      * <p> 示例值：
      */
        private Map<String, String> failedReasonI18n;
     /**
      * 数据变化(旧值和新值)
      * <p> 示例值：
      */
        private String[] dataChanges;
     /**
      * 应用名称
      * <p> 示例值：
      */
        private Map<String, String> appName;
     /**
      * 应用版本号
      * <p> 示例值：v1.2.3
      */
        private String keywordFieldAppVersion;
     /**
      * 审计日志事件子模块
      * <p> 示例值：223
      */
        private String keywordFieldFunctionalSubModule;

        /**
         * 审计日志ID
         * <p> 示例值：7376574450886557740
         * @param logId
         * @return
         */
        public Builder logId(String logId) {
             this.logId = logId;
             return this;
        }

    

        /**
         * 操作时间
         * <p> 示例值：1723634726874
         * @param opTime
         * @return
         */
        public Builder opTime(String opTime) {
             this.opTime = opTime;
             return this;
        }

    

        /**
         * 日志类型:10000-全部类型;10001-企业管理; 10002-登录日志;10003-应用管理
         * <p> 示例值：10000
         * @param logType
         * @return
         */
        public Builder logType(String logType) {
             this.logType = logType;
             return this;
        }

    

        /**
         * 操作人
         * <p> 示例值：
         * @param operator
         * @return
         */
        public Builder operator(LookupWithAvatar operator) {
             this.operator = operator;
             return this;
        }

    

        /**
         * 是否为外部用户,true代表是外部用户
         * <p> 示例值：
         * @param outsider
         * @return
         */
        public Builder outsider(Boolean outsider) {
             this.outsider = outsider;
             return this;
        }

    

        /**
         * 登录类型:11001-飞书登录;11003-账号密码登录
         * <p> 示例值：11001
         * @param loginType
         * @return
         */
        public Builder loginType(String loginType) {
             this.loginType = loginType;
             return this;
        }

    

        /**
         * 飞书租户ID
         * <p> 示例值：123
         * @param larkTenantId
         * @return
         */
        public Builder larkTenantId(String larkTenantId) {
             this.larkTenantId = larkTenantId;
             return this;
        }

    

        /**
         * apaas租户ID
         * <p> 示例值：23333
         * @param apaasTenantId
         * @return
         */
        public Builder apaasTenantId(String apaasTenantId) {
             this.apaasTenantId = apaasTenantId;
             return this;
        }

    

        /**
         * 用户地理信息
         * <p> 示例值：America/Chicago
         * @param userGeo
         * @return
         */
        public Builder userGeo(String userGeo) {
             this.userGeo = userGeo;
             return this;
        }

    

        /**
         * 客户端IP
         * <p> 示例值：192.168.1.1
         * @param clientIp
         * @return
         */
        public Builder clientIp(String clientIp) {
             this.clientIp = clientIp;
             return this;
        }

    

        /**
         * IP位置
         * <p> 示例值：中国北京
         * @param ipLoc
         * @return
         */
        public Builder ipLoc(String ipLoc) {
             this.ipLoc = ipLoc;
             return this;
        }

    

        /**
         * IP提供商
         * <p> 示例值：ISP_com
         * @param ipProvider
         * @return
         */
        public Builder ipProvider(String ipProvider) {
             this.ipProvider = ipProvider;
             return this;
        }

    

        /**
         * 引用页面
         * <p> 示例值：https://example.com/referer
         * @param referer
         * @return
         */
        public Builder referer(String referer) {
             this.referer = referer;
             return this;
        }

    

        /**
         * 源页面
         * <p> 示例值：https://example.com/origin
         * @param origin
         * @return
         */
        public Builder origin(String origin) {
             this.origin = origin;
             return this;
        }

    

        /**
         * 路由路径
         * <p> 示例值：/api/xxx
         * @param apiPath
         * @return
         */
        public Builder apiPath(String apiPath) {
             this.apiPath = apiPath;
             return this;
        }

    

        /**
         * 网关路径
         * <p> 示例值：/api/xxx
         * @param fullPath
         * @return
         */
        public Builder fullPath(String fullPath) {
             this.fullPath = fullPath;
             return this;
        }

    

        /**
         * 用户代理
         * <p> 示例值：Mozilla/5.0 (iPhone; CPU iPhone OS 14_6 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Mobile/15E148
         * @param userAgent
         * @return
         */
        public Builder userAgent(String userAgent) {
             this.userAgent = userAgent;
             return this;
        }

    

        /**
         * 设备ID
         * <p> 示例值：device_1234
         * @param deviceId
         * @return
         */
        public Builder deviceId(String deviceId) {
             this.deviceId = deviceId;
             return this;
        }

    

        /**
         * web端设备ID
         * <p> 示例值：webDevice_1234
         * @param webDeviceId
         * @return
         */
        public Builder webDeviceId(String webDeviceId) {
             this.webDeviceId = webDeviceId;
             return this;
        }

    

        /**
         * 终端类型:13002-PC类型;13003-Web类型
         * <p> 示例值：2
         * @param terminalType
         * @return
         */
        public Builder terminalType(String terminalType) {
             this.terminalType = terminalType;
             return this;
        }

    

        /**
         * 系统类型:14002-window;14001-未知
         * <p> 示例值：14002
         * @param osType
         * @return
         */
        public Builder osType(String osType) {
             this.osType = osType;
             return this;
        }

    

        /**
         * 系统版本
         * <p> 示例值：14.6
         * @param osVersion
         * @return
         */
        public Builder osVersion(String osVersion) {
             this.osVersion = osVersion;
             return this;
        }

    

        /**
         * 功能模块
         * <p> 示例值：17001
         * @param module
         * @return
         */
        public Builder module(String module) {
             this.module = module;
             return this;
        }

    

        /**
         * 数据对象
         * <p> 示例值：object_api_aaa
         * @param dataObject
         * @return
         */
        public Builder dataObject(String dataObject) {
             this.dataObject = dataObject;
             return this;
        }

    

        /**
         * 审计域:15001-企业管理后台;15002-应用管理后 台;15003-应用开发平台
         * <p> 示例值：15001
         * @param auditScope
         * @return
         */
        public Builder auditScope(String auditScope) {
             this.auditScope = auditScope;
             return this;
        }

    

        /**
         * 租户ID
         * <p> 示例值：23335
         * @param tenantId
         * @return
         */
        public Builder tenantId(String tenantId) {
             this.tenantId = tenantId;
             return this;
        }

    

        /**
         * 应用唯一标识
         * <p> 示例值：package_aacc
         * @param namespace
         * @return
         */
        public Builder namespace(String namespace) {
             this.namespace = namespace;
             return this;
        }

    

        /**
         * 环境类型:16001-沙箱环境;16003-线上环境
         * <p> 示例值：16003
         * @param envType
         * @return
         */
        public Builder envType(String envType) {
             this.envType = envType;
             return this;
        }

    

        /**
         * 事件类型
         * <p> 示例值：19001
         * @param opType
         * @return
         */
        public Builder opType(String opType) {
             this.opType = opType;
             return this;
        }

    

        /**
         * 操作详情内容
         * <p> 示例值：
         * @param opDetail
         * @return
         */
        public Builder opDetail(Map<String, String> opDetail) {
             this.opDetail = opDetail;
             return this;
        }

    

        /**
         * 操作源:20001-前端;20004-openapi
         * <p> 示例值：20001
         * @param opSource
         * @return
         */
        public Builder opSource(String opSource) {
             this.opSource = opSource;
             return this;
        }

    

        /**
         * 操作状态:18001-成功;18002-失败
         * <p> 示例值：18001
         * @param status
         * @return
         */
        public Builder status(String status) {
             this.status = status;
             return this;
        }

    

        /**
         * 失败原因
         * <p> 示例值：
         * @param failedReasonI18n
         * @return
         */
        public Builder failedReasonI18n(Map<String, String> failedReasonI18n) {
             this.failedReasonI18n = failedReasonI18n;
             return this;
        }

    

        /**
         * 数据变化(旧值和新值)
         * <p> 示例值：
         * @param dataChanges
         * @return
         */
        public Builder dataChanges(String[] dataChanges) {
             this.dataChanges = dataChanges;
             return this;
        }

    

        /**
         * 应用名称
         * <p> 示例值：
         * @param appName
         * @return
         */
        public Builder appName(Map<String, String> appName) {
             this.appName = appName;
             return this;
        }

    

        /**
         * 应用版本号
         * <p> 示例值：v1.2.3
         * @param keywordFieldAppVersion
         * @return
         */
        public Builder keywordFieldAppVersion(String keywordFieldAppVersion) {
             this.keywordFieldAppVersion = keywordFieldAppVersion;
             return this;
        }

    

        /**
         * 审计日志事件子模块
         * <p> 示例值：223
         * @param keywordFieldFunctionalSubModule
         * @return
         */
        public Builder keywordFieldFunctionalSubModule(String keywordFieldFunctionalSubModule) {
             this.keywordFieldFunctionalSubModule = keywordFieldFunctionalSubModule;
             return this;
        }

    
    
    public AuditLogEsField build(){
        return new AuditLogEsField(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
