// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Event {
     /**
      * 事件ID
      * <p> 示例值：invoke_workflow_event-12345678
      */
    @SerializedName("id")
    private String id;
     /**
      * 事件类型
      * <p> 示例值：invoke_function_event
      */
    @SerializedName("type")
    private String type;
     /**
      * 事件开始时间
      * <p> 示例值：1741249747824
      */
    @SerializedName("start_timestamp")
    private Integer startTimestamp;
     /**
      * 可选，事件的结束时间
      * <p> 示例值：1741249747824
      */
    @SerializedName("end_timestamp")
    private Integer endTimestamp;
     /**
      * 事件是否已结束
      * <p> 示例值：true
      */
    @SerializedName("is_finished")
    private Boolean isFinished;
     /**
      * trace id
      * <p> 示例值：edf45bdf-9f3f-4aad-b260-9287ab09e0de
      */
    @SerializedName("trace_id")
    private String traceId;
     /**
      * 事件详情，json 格式
      * <p> 示例值：{"foo":"bar"}
      */
    @SerializedName("detail")
    private String detail;
     /**
      * 附加属性，json 格式，包括应用相关属性（如 tenant_id, namespace）等
      * <p> 示例值：{"tenant_id": "123"}
      */
    @SerializedName("attributes")
    private String attributes;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Integer startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Integer getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setEndTimestamp(Integer endTimestamp) {
        this.endTimestamp = endTimestamp;
    }

    public Boolean getIsFinished() {
        return this.isFinished;
    }

    public void setIsFinished(Boolean isFinished) {
        this.isFinished = isFinished;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setAttributes(String attributes) {
        this.attributes = attributes;
    }


// builder 开始
  public Event(){}

  public Event(Builder builder){
         /**
          * 事件ID
          * <p> 示例值：invoke_workflow_event-12345678
          */
      this.id = builder.id;
         /**
          * 事件类型
          * <p> 示例值：invoke_function_event
          */
      this.type = builder.type;
         /**
          * 事件开始时间
          * <p> 示例值：1741249747824
          */
      this.startTimestamp = builder.startTimestamp;
         /**
          * 可选，事件的结束时间
          * <p> 示例值：1741249747824
          */
      this.endTimestamp = builder.endTimestamp;
         /**
          * 事件是否已结束
          * <p> 示例值：true
          */
      this.isFinished = builder.isFinished;
         /**
          * trace id
          * <p> 示例值：edf45bdf-9f3f-4aad-b260-9287ab09e0de
          */
      this.traceId = builder.traceId;
         /**
          * 事件详情，json 格式
          * <p> 示例值：{"foo":"bar"}
          */
      this.detail = builder.detail;
         /**
          * 附加属性，json 格式，包括应用相关属性（如 tenant_id, namespace）等
          * <p> 示例值：{"tenant_id": "123"}
          */
      this.attributes = builder.attributes;
  }

    public static class Builder {
     /**
      * 事件ID
      * <p> 示例值：invoke_workflow_event-12345678
      */
        private String id;
     /**
      * 事件类型
      * <p> 示例值：invoke_function_event
      */
        private String type;
     /**
      * 事件开始时间
      * <p> 示例值：1741249747824
      */
        private Integer startTimestamp;
     /**
      * 可选，事件的结束时间
      * <p> 示例值：1741249747824
      */
        private Integer endTimestamp;
     /**
      * 事件是否已结束
      * <p> 示例值：true
      */
        private Boolean isFinished;
     /**
      * trace id
      * <p> 示例值：edf45bdf-9f3f-4aad-b260-9287ab09e0de
      */
        private String traceId;
     /**
      * 事件详情，json 格式
      * <p> 示例值：{"foo":"bar"}
      */
        private String detail;
     /**
      * 附加属性，json 格式，包括应用相关属性（如 tenant_id, namespace）等
      * <p> 示例值：{"tenant_id": "123"}
      */
        private String attributes;

        /**
         * 事件ID
         * <p> 示例值：invoke_workflow_event-12345678
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 事件类型
         * <p> 示例值：invoke_function_event
         * @param type
         * @return
         */
        public Builder type(String type) {
             this.type = type;
             return this;
        }

    

        /**
         * 事件开始时间
         * <p> 示例值：1741249747824
         * @param startTimestamp
         * @return
         */
        public Builder startTimestamp(Integer startTimestamp) {
             this.startTimestamp = startTimestamp;
             return this;
        }

    

        /**
         * 可选，事件的结束时间
         * <p> 示例值：1741249747824
         * @param endTimestamp
         * @return
         */
        public Builder endTimestamp(Integer endTimestamp) {
             this.endTimestamp = endTimestamp;
             return this;
        }

    

        /**
         * 事件是否已结束
         * <p> 示例值：true
         * @param isFinished
         * @return
         */
        public Builder isFinished(Boolean isFinished) {
             this.isFinished = isFinished;
             return this;
        }

    

        /**
         * trace id
         * <p> 示例值：edf45bdf-9f3f-4aad-b260-9287ab09e0de
         * @param traceId
         * @return
         */
        public Builder traceId(String traceId) {
             this.traceId = traceId;
             return this;
        }

    

        /**
         * 事件详情，json 格式
         * <p> 示例值：{"foo":"bar"}
         * @param detail
         * @return
         */
        public Builder detail(String detail) {
             this.detail = detail;
             return this;
        }

    

        /**
         * 附加属性，json 格式，包括应用相关属性（如 tenant_id, namespace）等
         * <p> 示例值：{"tenant_id": "123"}
         * @param attributes
         * @return
         */
        public Builder attributes(String attributes) {
             this.attributes = attributes;
             return this;
        }

    
    
    public Event build(){
        return new Event(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
