// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.apaas.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.apaas.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class PatchApplicationObjectRecordReq {
     /**
      * 应用命名空间
      * <p> 示例值：package_test__c
      */
    @Path
    @SerializedName("namespace")
    private String namespace;
     /**
      * 对象唯一标识
      * <p> 示例值：user
      */
    @Path
    @SerializedName("object_api_name")
    private String objectApiName;
     /**
      * 记录ID
      * <p> 示例值：1764024447556775
      */
    @Path
    @SerializedName("id")
    private String id;
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getObjectApiName() {
        return this.objectApiName;
    }

    public void setObjectApiName(String objectApiName) {
        this.objectApiName = objectApiName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Body
    private PatchApplicationObjectRecordReqBody body;

    public PatchApplicationObjectRecordReqBody getPatchApplicationObjectRecordReqBody() {
        return this.body;
    }

    public void setPatchApplicationObjectRecordReqBody(PatchApplicationObjectRecordReqBody body) {
        this.body = body;
    }

// builder 开始
  public PatchApplicationObjectRecordReq(){}

  public PatchApplicationObjectRecordReq(Builder builder){
     /**
      * 应用命名空间
      * <p> 示例值：package_test__c
      */
       this.namespace = builder.namespace;
     /**
      * 对象唯一标识
      * <p> 示例值：user
      */
       this.objectApiName = builder.objectApiName;
     /**
      * 记录ID
      * <p> 示例值：1764024447556775
      */
       this.id = builder.id;
        this.body = builder.body;
  }

    public static class Builder {
    
        private String namespace; // 应用命名空间
        private String objectApiName; // 对象唯一标识
        private String id; // 记录ID
        /**
         * 应用命名空间
         * <p> 示例值：package_test__c
         * @param namespace
         * @return
         */
          public Builder namespace(String namespace) {
               this.namespace = namespace;
               return this;
          }

    
        /**
         * 对象唯一标识
         * <p> 示例值：user
         * @param objectApiName
         * @return
         */
          public Builder objectApiName(String objectApiName) {
               this.objectApiName = objectApiName;
               return this;
          }

    
        /**
         * 记录ID
         * <p> 示例值：1764024447556775
         * @param id
         * @return
         */
          public Builder id(String id) {
               this.id = id;
               return this;
          }

    
        private PatchApplicationObjectRecordReqBody body;
    
        public PatchApplicationObjectRecordReqBody getPatchApplicationObjectRecordReqBody() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder patchApplicationObjectRecordReqBody(PatchApplicationObjectRecordReqBody body) {
             this.body = body;
             return this;
        }
    public PatchApplicationObjectRecordReq build(){
        return new PatchApplicationObjectRecordReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
