// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.attendance.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.attendance.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class AntiCheatPunch {
     /**
      * 拦截疑似作弊打卡，默认关闭；关闭时，其余防作弊开关都会关闭
      * <p> 示例值：true
      */
    @SerializedName("intercept_suspected_cheat_punch")
    private Boolean interceptSuspectedCheatPunch;
     /**
      * 是否校验疑似作弊软件打卡，默认关闭
      * <p> 示例值：true
      */
    @SerializedName("check_cheat_software_punch")
    private Boolean checkCheatSoftwarePunch;
     /**
      * 是否校验疑似他人代打卡，默认关闭
      * <p> 示例值：true
      */
    @SerializedName("check_buddy_punch")
    private Boolean checkBuddyPunch;
     /**
      * 是否校验疑似模拟 WI-FI 打卡，默认关闭
      * <p> 示例值：true
      */
    @SerializedName("check_simulate_wifi_punch")
    private Boolean checkSimulateWifiPunch;
     /**
      * 是否校验更换设备打卡，默认关闭
      * <p> 示例值：true
      */
    @SerializedName("check_change_device_punch")
    private Boolean checkChangeDevicePunch;
     /**
      * 同一考勤人员最多可绑定打卡设备数量上限，开启校验更换设备打卡时必填
      * <p> 示例值：2
      */
    @SerializedName("allow_change_device_num")
    private Integer allowChangeDeviceNum;
     /**
      * 疑似作弊打卡时的处理方式
      * <p> 示例值：1
      */
    @SerializedName("suspected_cheat_handle_method")
    private Integer suspectedCheatHandleMethod;
    public Boolean getInterceptSuspectedCheatPunch() {
        return this.interceptSuspectedCheatPunch;
    }

    public void setInterceptSuspectedCheatPunch(Boolean interceptSuspectedCheatPunch) {
        this.interceptSuspectedCheatPunch = interceptSuspectedCheatPunch;
    }

    public Boolean getCheckCheatSoftwarePunch() {
        return this.checkCheatSoftwarePunch;
    }

    public void setCheckCheatSoftwarePunch(Boolean checkCheatSoftwarePunch) {
        this.checkCheatSoftwarePunch = checkCheatSoftwarePunch;
    }

    public Boolean getCheckBuddyPunch() {
        return this.checkBuddyPunch;
    }

    public void setCheckBuddyPunch(Boolean checkBuddyPunch) {
        this.checkBuddyPunch = checkBuddyPunch;
    }

    public Boolean getCheckSimulateWifiPunch() {
        return this.checkSimulateWifiPunch;
    }

    public void setCheckSimulateWifiPunch(Boolean checkSimulateWifiPunch) {
        this.checkSimulateWifiPunch = checkSimulateWifiPunch;
    }

    public Boolean getCheckChangeDevicePunch() {
        return this.checkChangeDevicePunch;
    }

    public void setCheckChangeDevicePunch(Boolean checkChangeDevicePunch) {
        this.checkChangeDevicePunch = checkChangeDevicePunch;
    }

    public Integer getAllowChangeDeviceNum() {
        return this.allowChangeDeviceNum;
    }

    public void setAllowChangeDeviceNum(Integer allowChangeDeviceNum) {
        this.allowChangeDeviceNum = allowChangeDeviceNum;
    }

    public Integer getSuspectedCheatHandleMethod() {
        return this.suspectedCheatHandleMethod;
    }

    public void setSuspectedCheatHandleMethod(Integer suspectedCheatHandleMethod) {
        this.suspectedCheatHandleMethod = suspectedCheatHandleMethod;
    }


// builder 开始
  public AntiCheatPunch(){}

  public AntiCheatPunch(Builder builder){
         /**
          * 拦截疑似作弊打卡，默认关闭；关闭时，其余防作弊开关都会关闭
          * <p> 示例值：true
          */
      this.interceptSuspectedCheatPunch = builder.interceptSuspectedCheatPunch;
         /**
          * 是否校验疑似作弊软件打卡，默认关闭
          * <p> 示例值：true
          */
      this.checkCheatSoftwarePunch = builder.checkCheatSoftwarePunch;
         /**
          * 是否校验疑似他人代打卡，默认关闭
          * <p> 示例值：true
          */
      this.checkBuddyPunch = builder.checkBuddyPunch;
         /**
          * 是否校验疑似模拟 WI-FI 打卡，默认关闭
          * <p> 示例值：true
          */
      this.checkSimulateWifiPunch = builder.checkSimulateWifiPunch;
         /**
          * 是否校验更换设备打卡，默认关闭
          * <p> 示例值：true
          */
      this.checkChangeDevicePunch = builder.checkChangeDevicePunch;
         /**
          * 同一考勤人员最多可绑定打卡设备数量上限，开启校验更换设备打卡时必填
          * <p> 示例值：2
          */
      this.allowChangeDeviceNum = builder.allowChangeDeviceNum;
         /**
          * 疑似作弊打卡时的处理方式
          * <p> 示例值：1
          */
      this.suspectedCheatHandleMethod = builder.suspectedCheatHandleMethod;
  }

    public static class Builder {
     /**
      * 拦截疑似作弊打卡，默认关闭；关闭时，其余防作弊开关都会关闭
      * <p> 示例值：true
      */
        private Boolean interceptSuspectedCheatPunch;
     /**
      * 是否校验疑似作弊软件打卡，默认关闭
      * <p> 示例值：true
      */
        private Boolean checkCheatSoftwarePunch;
     /**
      * 是否校验疑似他人代打卡，默认关闭
      * <p> 示例值：true
      */
        private Boolean checkBuddyPunch;
     /**
      * 是否校验疑似模拟 WI-FI 打卡，默认关闭
      * <p> 示例值：true
      */
        private Boolean checkSimulateWifiPunch;
     /**
      * 是否校验更换设备打卡，默认关闭
      * <p> 示例值：true
      */
        private Boolean checkChangeDevicePunch;
     /**
      * 同一考勤人员最多可绑定打卡设备数量上限，开启校验更换设备打卡时必填
      * <p> 示例值：2
      */
        private Integer allowChangeDeviceNum;
     /**
      * 疑似作弊打卡时的处理方式
      * <p> 示例值：1
      */
        private Integer suspectedCheatHandleMethod;

        /**
         * 拦截疑似作弊打卡，默认关闭；关闭时，其余防作弊开关都会关闭
         * <p> 示例值：true
         * @param interceptSuspectedCheatPunch
         * @return
         */
        public Builder interceptSuspectedCheatPunch(Boolean interceptSuspectedCheatPunch) {
             this.interceptSuspectedCheatPunch = interceptSuspectedCheatPunch;
             return this;
        }

    

        /**
         * 是否校验疑似作弊软件打卡，默认关闭
         * <p> 示例值：true
         * @param checkCheatSoftwarePunch
         * @return
         */
        public Builder checkCheatSoftwarePunch(Boolean checkCheatSoftwarePunch) {
             this.checkCheatSoftwarePunch = checkCheatSoftwarePunch;
             return this;
        }

    

        /**
         * 是否校验疑似他人代打卡，默认关闭
         * <p> 示例值：true
         * @param checkBuddyPunch
         * @return
         */
        public Builder checkBuddyPunch(Boolean checkBuddyPunch) {
             this.checkBuddyPunch = checkBuddyPunch;
             return this;
        }

    

        /**
         * 是否校验疑似模拟 WI-FI 打卡，默认关闭
         * <p> 示例值：true
         * @param checkSimulateWifiPunch
         * @return
         */
        public Builder checkSimulateWifiPunch(Boolean checkSimulateWifiPunch) {
             this.checkSimulateWifiPunch = checkSimulateWifiPunch;
             return this;
        }

    

        /**
         * 是否校验更换设备打卡，默认关闭
         * <p> 示例值：true
         * @param checkChangeDevicePunch
         * @return
         */
        public Builder checkChangeDevicePunch(Boolean checkChangeDevicePunch) {
             this.checkChangeDevicePunch = checkChangeDevicePunch;
             return this;
        }

    

        /**
         * 同一考勤人员最多可绑定打卡设备数量上限，开启校验更换设备打卡时必填
         * <p> 示例值：2
         * @param allowChangeDeviceNum
         * @return
         */
        public Builder allowChangeDeviceNum(Integer allowChangeDeviceNum) {
             this.allowChangeDeviceNum = allowChangeDeviceNum;
             return this;
        }

    

        /**
         * 疑似作弊打卡时的处理方式
         * <p> 示例值：1
         * @param suspectedCheatHandleMethod
         * @return
         */
        public Builder suspectedCheatHandleMethod(Integer suspectedCheatHandleMethod) {
             this.suspectedCheatHandleMethod = suspectedCheatHandleMethod;
             return this;
        }
        /**
         * 疑似作弊打卡时的处理方式
         * <p> 示例值：1
         * @param suspectedCheatHandleMethod {@link com.lark.oapi.service.attendance.v1.enums.AntiCheatPunchSuspectedCheatHandleMethodEnum}
         * @return
         */
        public Builder suspectedCheatHandleMethod(com.lark.oapi.service.attendance.v1.enums.AntiCheatPunchSuspectedCheatHandleMethodEnum suspectedCheatHandleMethod) {
             this.suspectedCheatHandleMethod = suspectedCheatHandleMethod.getValue();
             return this;
        }

    
    
    public AntiCheatPunch build(){
        return new AntiCheatPunch(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
