// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.baike.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.baike.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class StatisticalReport {
     /**
      * 请求时间区间
      * <p> 示例值：请求时间区间
      */
    @SerializedName("date_interval")
    private Integer dateInterval;
     /**
      * 词汇量相关数据
      * <p> 示例值：
      */
    @SerializedName("word_info")
    private WordInfo wordInfo;
     /**
      * 纠错相关数据
      * <p> 示例值：
      */
    @SerializedName("correct_info")
    private CorrectInfo correctInfo;
     /**
      * 天维度的时间戳，用于确认数据最近一次更新时间
      * <p> 示例值：“20221101”
      */
    @SerializedName("update_date")
    private String updateDate;
    public Integer getDateInterval() {
        return this.dateInterval;
    }

    public void setDateInterval(Integer dateInterval) {
        this.dateInterval = dateInterval;
    }

    public WordInfo getWordInfo() {
        return this.wordInfo;
    }

    public void setWordInfo(WordInfo wordInfo) {
        this.wordInfo = wordInfo;
    }

    public CorrectInfo getCorrectInfo() {
        return this.correctInfo;
    }

    public void setCorrectInfo(CorrectInfo correctInfo) {
        this.correctInfo = correctInfo;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }


// builder 开始
  public StatisticalReport(){}

  public StatisticalReport(Builder builder){
         /**
          * 请求时间区间
          * <p> 示例值：请求时间区间
          */
      this.dateInterval = builder.dateInterval;
         /**
          * 词汇量相关数据
          * <p> 示例值：
          */
      this.wordInfo = builder.wordInfo;
         /**
          * 纠错相关数据
          * <p> 示例值：
          */
      this.correctInfo = builder.correctInfo;
         /**
          * 天维度的时间戳，用于确认数据最近一次更新时间
          * <p> 示例值：“20221101”
          */
      this.updateDate = builder.updateDate;
  }

    public static class Builder {
     /**
      * 请求时间区间
      * <p> 示例值：请求时间区间
      */
        private Integer dateInterval;
     /**
      * 词汇量相关数据
      * <p> 示例值：
      */
        private WordInfo wordInfo;
     /**
      * 纠错相关数据
      * <p> 示例值：
      */
        private CorrectInfo correctInfo;
     /**
      * 天维度的时间戳，用于确认数据最近一次更新时间
      * <p> 示例值：“20221101”
      */
        private String updateDate;

        /**
         * 请求时间区间
         * <p> 示例值：请求时间区间
         * @param dateInterval
         * @return
         */
        public Builder dateInterval(Integer dateInterval) {
             this.dateInterval = dateInterval;
             return this;
        }
        /**
         * 请求时间区间
         * <p> 示例值：请求时间区间
         * @param dateInterval {@link com.lark.oapi.service.baike.v1.enums.StatisticalReportDateIntervalEnum}
         * @return
         */
        public Builder dateInterval(com.lark.oapi.service.baike.v1.enums.StatisticalReportDateIntervalEnum dateInterval) {
             this.dateInterval = dateInterval.getValue();
             return this;
        }

    

        /**
         * 词汇量相关数据
         * <p> 示例值：
         * @param wordInfo
         * @return
         */
        public Builder wordInfo(WordInfo wordInfo) {
             this.wordInfo = wordInfo;
             return this;
        }

    

        /**
         * 纠错相关数据
         * <p> 示例值：
         * @param correctInfo
         * @return
         */
        public Builder correctInfo(CorrectInfo correctInfo) {
             this.correctInfo = correctInfo;
             return this;
        }

    

        /**
         * 天维度的时间戳，用于确认数据最近一次更新时间
         * <p> 示例值：“20221101”
         * @param updateDate
         * @return
         */
        public Builder updateDate(String updateDate) {
             this.updateDate = updateDate;
             return this;
        }

    
    
    public StatisticalReport build(){
        return new StatisticalReport(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
