// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.bitable.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class CreateAppReq {
     /**
      * 是否使用自定义配置创建方式，默认不使用
      * <p> 示例值：false
      */
    @Query
    @SerializedName("customized_config")
    private Boolean customizedConfig;
     /**
      * 源app，当使用自定义配置创建方式时有效
      * <p> 示例值：Xm5EbPVCInfoqRs0HKBbyIBjc1g
      */
    @Query
    @SerializedName("source_app_token")
    private String sourceAppToken;
     /**
      * 定制化权限配置类型列表，1为协作者列表，2为高级权限，类型是string
      * <p> 示例值：
      */
    @Query
    @SerializedName("copy_types")
    private String[] copyTypes;
     /**
      * 只有旧逻辑场景才会用到，为new时会在旧逻辑场景切换到新场景，方便旧逻辑的业务方进行切换
      * <p> 示例值：new
      */
    @Query
    @SerializedName("api_type")
    private String apiType;
    public Boolean getCustomizedConfig() {
        return this.customizedConfig;
    }

    public void setCustomizedConfig(Boolean customizedConfig) {
        this.customizedConfig = customizedConfig;
    }

    public String getSourceAppToken() {
        return this.sourceAppToken;
    }

    public void setSourceAppToken(String sourceAppToken) {
        this.sourceAppToken = sourceAppToken;
    }

    public String[] getCopyTypes() {
        return this.copyTypes;
    }

    public void setCopyTypes(String[] copyTypes) {
        this.copyTypes = copyTypes;
    }

    public String getApiType() {
        return this.apiType;
    }

    public void setApiType(String apiType) {
        this.apiType = apiType;
    }

    @Body
    private ReqApp body;

    public ReqApp getReqApp() {
        return this.body;
    }

    public void setReqApp(ReqApp body) {
        this.body = body;
    }

// builder 开始
  public CreateAppReq(){}

  public CreateAppReq(Builder builder){
         /**
          * 是否使用自定义配置创建方式，默认不使用
          * <p> 示例值：false
          */
       this.customizedConfig = builder.customizedConfig;
         /**
          * 源app，当使用自定义配置创建方式时有效
          * <p> 示例值：Xm5EbPVCInfoqRs0HKBbyIBjc1g
          */
       this.sourceAppToken = builder.sourceAppToken;
         /**
          * 定制化权限配置类型列表，1为协作者列表，2为高级权限，类型是string
          * <p> 示例值：
          */
       this.copyTypes = builder.copyTypes;
         /**
          * 只有旧逻辑场景才会用到，为new时会在旧逻辑场景切换到新场景，方便旧逻辑的业务方进行切换
          * <p> 示例值：new
          */
       this.apiType = builder.apiType;
        this.body = builder.body;
  }

    public static class Builder {
        private Boolean customizedConfig; // 是否使用自定义配置创建方式，默认不使用
        private String sourceAppToken; // 源app，当使用自定义配置创建方式时有效
        private String[] copyTypes; // 定制化权限配置类型列表，1为协作者列表，2为高级权限，类型是string
        private String apiType; // 只有旧逻辑场景才会用到，为new时会在旧逻辑场景切换到新场景，方便旧逻辑的业务方进行切换
    
        /**
         * 是否使用自定义配置创建方式，默认不使用
         * <p> 示例值：false
         * @param customizedConfig
         * @return
         */
           public Builder customizedConfig(Boolean customizedConfig) {
                this.customizedConfig = customizedConfig;
                return this;
           }

    
        /**
         * 源app，当使用自定义配置创建方式时有效
         * <p> 示例值：Xm5EbPVCInfoqRs0HKBbyIBjc1g
         * @param sourceAppToken
         * @return
         */
           public Builder sourceAppToken(String sourceAppToken) {
                this.sourceAppToken = sourceAppToken;
                return this;
           }

    
        /**
         * 定制化权限配置类型列表，1为协作者列表，2为高级权限，类型是string
         * <p> 示例值：
         * @param copyTypes
         * @return
         */
           public Builder copyTypes(String[] copyTypes) {
                this.copyTypes = copyTypes;
                return this;
           }

    
        /**
         * 只有旧逻辑场景才会用到，为new时会在旧逻辑场景切换到新场景，方便旧逻辑的业务方进行切换
         * <p> 示例值：new
         * @param apiType
         * @return
         */
           public Builder apiType(String apiType) {
                this.apiType = apiType;
                return this;
           }

    
        private ReqApp body;
    
        public ReqApp getReqApp() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder reqApp(ReqApp body) {
             this.body = body;
             return this;
        }
    public CreateAppReq build(){
        return new CreateAppReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
