// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.bitable.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListAppTableRecordReq {
     /**
      * 视图的唯一标识符，获取指定视图下的记录[view_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe);;注意：;当 filter 参数 或 sort 参数不为空时，请求视为对数据表中的全部数据做条件过滤，指定的view_id 会被忽略。
      * <p> 示例值：vewqhz51lk
      */
    @Query
    @SerializedName("view_id")
    private String viewId;
     /**
      * 筛选参数，用于指定本次查询的筛选条件;;注意：;;1.不支持对“人员”以及“关联字段”的属性进行过滤筛选，如人员的 OpenID。;;2.指定筛选条件时，参数长度不超过2000个字符。;;;详细请参考[筛选条件支持的公式](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/filter)
      * <p> 示例值：AND(CurrentValue.[身高]>180, CurrentValue.[体重]>150)
      */
    @Query
    @SerializedName("filter")
    private String filter;
     /**
      * 排序参数，用于指定本次查询返回结果的顺序;;注意：;;1.不支持对带“公式”和“关联字段”的表的使用。;;2.指定排序条件时，参数长度不超过1000字符。;;3.当存在多个排序条件时，数据将根据条件顺序逐层排序
      * <p> 示例值：["字段1 DESC","字段2 ASC"]
      */
    @Query
    @SerializedName("sort")
    private String sort;
     /**
      * 字段名称，用于指定本次查询返回记录中包含的字段
      * <p> 示例值：["字段1","字段2"]
      */
    @Query
    @SerializedName("field_names")
    private String fieldNames;
     /**
      * 控制多行文本字段数据的返回格式，true 表示以数组形式返回。;;注意：;;1.多行文本中如果有超链接部分，则会返回链接的 URL。;;2.目前可以返回多行文本中 URL 类型为多维表格链接、飞书 doc、飞书 sheet的URL类型以及@人员的数据结构。
      * <p> 示例值：true
      */
    @Query
    @SerializedName("text_field_as_array")
    private Boolean textFieldAsArray;
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 默认值为false，返回当前字段的默认类型和结果；当该参数的值为true时，公式 和 查找引用 类型的字段，将会以 被引用字段 的格式返回
      * <p> 示例值：true
      */
    @Query
    @SerializedName("display_formula_ref")
    private Boolean displayFormulaRef;
     /**
      * 控制是否返回自动计算的字段，例如 `created_by`/`created_time`/`last_modified_by`/`last_modified_time`，true 表示返回
      * <p> 示例值：true
      */
    @Query
    @SerializedName("automatic_fields")
    private Boolean automaticFields;
     /**
      * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
      * <p> 示例值：recn0hoyXL
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
     /**
      * 分页大小
      * <p> 示例值：10
      */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(String fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Boolean getTextFieldAsArray() {
        return this.textFieldAsArray;
    }

    public void setTextFieldAsArray(Boolean textFieldAsArray) {
        this.textFieldAsArray = textFieldAsArray;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public Boolean getDisplayFormulaRef() {
        return this.displayFormulaRef;
    }

    public void setDisplayFormulaRef(Boolean displayFormulaRef) {
        this.displayFormulaRef = displayFormulaRef;
    }

    public Boolean getAutomaticFields() {
        return this.automaticFields;
    }

    public void setAutomaticFields(Boolean automaticFields) {
        this.automaticFields = automaticFields;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

     /**
      * 多维表格的唯一标识符 [app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
      * <p> 示例值：bascnCMII2ORej2RItqpZZUNMIe
      */
    @Path
    @SerializedName("app_token")
    private String appToken;
     /**
      * 多维表格数据表的唯一标识符 [table_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#735fe883)
      * <p> 示例值：tblxI2tWaxP5dG7p
      */
    @Path
    @SerializedName("table_id")
    private String tableId;
    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }


// builder 开始
  public ListAppTableRecordReq(){}

  public ListAppTableRecordReq(Builder builder){
         /**
          * 视图的唯一标识符，获取指定视图下的记录[view_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe);;注意：;当 filter 参数 或 sort 参数不为空时，请求视为对数据表中的全部数据做条件过滤，指定的view_id 会被忽略。
          * <p> 示例值：vewqhz51lk
          */
       this.viewId = builder.viewId;
         /**
          * 筛选参数，用于指定本次查询的筛选条件;;注意：;;1.不支持对“人员”以及“关联字段”的属性进行过滤筛选，如人员的 OpenID。;;2.指定筛选条件时，参数长度不超过2000个字符。;;;详细请参考[筛选条件支持的公式](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/filter)
          * <p> 示例值：AND(CurrentValue.[身高]>180, CurrentValue.[体重]>150)
          */
       this.filter = builder.filter;
         /**
          * 排序参数，用于指定本次查询返回结果的顺序;;注意：;;1.不支持对带“公式”和“关联字段”的表的使用。;;2.指定排序条件时，参数长度不超过1000字符。;;3.当存在多个排序条件时，数据将根据条件顺序逐层排序
          * <p> 示例值：["字段1 DESC","字段2 ASC"]
          */
       this.sort = builder.sort;
         /**
          * 字段名称，用于指定本次查询返回记录中包含的字段
          * <p> 示例值：["字段1","字段2"]
          */
       this.fieldNames = builder.fieldNames;
         /**
          * 控制多行文本字段数据的返回格式，true 表示以数组形式返回。;;注意：;;1.多行文本中如果有超链接部分，则会返回链接的 URL。;;2.目前可以返回多行文本中 URL 类型为多维表格链接、飞书 doc、飞书 sheet的URL类型以及@人员的数据结构。
          * <p> 示例值：true
          */
       this.textFieldAsArray = builder.textFieldAsArray;
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
         /**
          * 默认值为false，返回当前字段的默认类型和结果；当该参数的值为true时，公式 和 查找引用 类型的字段，将会以 被引用字段 的格式返回
          * <p> 示例值：true
          */
       this.displayFormulaRef = builder.displayFormulaRef;
         /**
          * 控制是否返回自动计算的字段，例如 `created_by`/`created_time`/`last_modified_by`/`last_modified_time`，true 表示返回
          * <p> 示例值：true
          */
       this.automaticFields = builder.automaticFields;
         /**
          * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
          * <p> 示例值：recn0hoyXL
          */
       this.pageToken = builder.pageToken;
         /**
          * 分页大小
          * <p> 示例值：10
          */
       this.pageSize = builder.pageSize;
     /**
      * 多维表格的唯一标识符 [app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
      * <p> 示例值：bascnCMII2ORej2RItqpZZUNMIe
      */
       this.appToken = builder.appToken;
     /**
      * 多维表格数据表的唯一标识符 [table_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#735fe883)
      * <p> 示例值：tblxI2tWaxP5dG7p
      */
       this.tableId = builder.tableId;
  }

    public static class Builder {
        private String viewId; // 视图的唯一标识符，获取指定视图下的记录[view_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe);;注意：;当 filter 参数 或 sort 参数不为空时，请求视为对数据表中的全部数据做条件过滤，指定的view_id 会被忽略。
        private String filter; // 筛选参数，用于指定本次查询的筛选条件;;注意：;;1.不支持对“人员”以及“关联字段”的属性进行过滤筛选，如人员的 OpenID。;;2.指定筛选条件时，参数长度不超过2000个字符。;;;详细请参考[筛选条件支持的公式](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/filter)
        private String sort; // 排序参数，用于指定本次查询返回结果的顺序;;注意：;;1.不支持对带“公式”和“关联字段”的表的使用。;;2.指定排序条件时，参数长度不超过1000字符。;;3.当存在多个排序条件时，数据将根据条件顺序逐层排序
        private String fieldNames; // 字段名称，用于指定本次查询返回记录中包含的字段
        private Boolean textFieldAsArray; // 控制多行文本字段数据的返回格式，true 表示以数组形式返回。;;注意：;;1.多行文本中如果有超链接部分，则会返回链接的 URL。;;2.目前可以返回多行文本中 URL 类型为多维表格链接、飞书 doc、飞书 sheet的URL类型以及@人员的数据结构。
        private String userIdType; // 此次调用中使用的用户ID的类型
        private Boolean displayFormulaRef; // 默认值为false，返回当前字段的默认类型和结果；当该参数的值为true时，公式 和 查找引用 类型的字段，将会以 被引用字段 的格式返回
        private Boolean automaticFields; // 控制是否返回自动计算的字段，例如 `created_by`/`created_time`/`last_modified_by`/`last_modified_time`，true 表示返回
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
        private Integer pageSize; // 分页大小
    
        /**
         * 视图的唯一标识符，获取指定视图下的记录[view_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe);;注意：;当 filter 参数 或 sort 参数不为空时，请求视为对数据表中的全部数据做条件过滤，指定的view_id 会被忽略。
         * <p> 示例值：vewqhz51lk
         * @param viewId
         * @return
         */
           public Builder viewId(String viewId) {
                this.viewId = viewId;
                return this;
           }

    
        /**
         * 筛选参数，用于指定本次查询的筛选条件;;注意：;;1.不支持对“人员”以及“关联字段”的属性进行过滤筛选，如人员的 OpenID。;;2.指定筛选条件时，参数长度不超过2000个字符。;;;详细请参考[筛选条件支持的公式](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/filter)
         * <p> 示例值：AND(CurrentValue.[身高]>180, CurrentValue.[体重]>150)
         * @param filter
         * @return
         */
           public Builder filter(String filter) {
                this.filter = filter;
                return this;
           }

    
        /**
         * 排序参数，用于指定本次查询返回结果的顺序;;注意：;;1.不支持对带“公式”和“关联字段”的表的使用。;;2.指定排序条件时，参数长度不超过1000字符。;;3.当存在多个排序条件时，数据将根据条件顺序逐层排序
         * <p> 示例值：["字段1 DESC","字段2 ASC"]
         * @param sort
         * @return
         */
           public Builder sort(String sort) {
                this.sort = sort;
                return this;
           }

    
        /**
         * 字段名称，用于指定本次查询返回记录中包含的字段
         * <p> 示例值：["字段1","字段2"]
         * @param fieldNames
         * @return
         */
           public Builder fieldNames(String fieldNames) {
                this.fieldNames = fieldNames;
                return this;
           }

    
        /**
         * 控制多行文本字段数据的返回格式，true 表示以数组形式返回。;;注意：;;1.多行文本中如果有超链接部分，则会返回链接的 URL。;;2.目前可以返回多行文本中 URL 类型为多维表格链接、飞书 doc、飞书 sheet的URL类型以及@人员的数据结构。
         * <p> 示例值：true
         * @param textFieldAsArray
         * @return
         */
           public Builder textFieldAsArray(Boolean textFieldAsArray) {
                this.textFieldAsArray = textFieldAsArray;
                return this;
           }

    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.bitable.v1.enums.ListAppTableRecordUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.bitable.v1.enums.ListAppTableRecordUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        /**
         * 默认值为false，返回当前字段的默认类型和结果；当该参数的值为true时，公式 和 查找引用 类型的字段，将会以 被引用字段 的格式返回
         * <p> 示例值：true
         * @param displayFormulaRef
         * @return
         */
           public Builder displayFormulaRef(Boolean displayFormulaRef) {
                this.displayFormulaRef = displayFormulaRef;
                return this;
           }

    
        /**
         * 控制是否返回自动计算的字段，例如 `created_by`/`created_time`/`last_modified_by`/`last_modified_time`，true 表示返回
         * <p> 示例值：true
         * @param automaticFields
         * @return
         */
           public Builder automaticFields(Boolean automaticFields) {
                this.automaticFields = automaticFields;
                return this;
           }

    
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
         * <p> 示例值：recn0hoyXL
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
        /**
         * 分页大小
         * <p> 示例值：10
         * @param pageSize
         * @return
         */
           public Builder pageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        private String appToken; // 多维表格的唯一标识符 [app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
        private String tableId; // 多维表格数据表的唯一标识符 [table_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#735fe883)
        /**
         * 多维表格的唯一标识符 [app_token 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#8121eebe)
         * <p> 示例值：bascnCMII2ORej2RItqpZZUNMIe
         * @param appToken
         * @return
         */
          public Builder appToken(String appToken) {
               this.appToken = appToken;
               return this;
          }

    
        /**
         * 多维表格数据表的唯一标识符 [table_id 参数说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/bitable/notification#735fe883)
         * <p> 示例值：tblxI2tWaxP5dG7p
         * @param tableId
         * @return
         */
          public Builder tableId(String tableId) {
               this.tableId = tableId;
               return this;
          }

    
    public ListAppTableRecordReq build(){
        return new ListAppTableRecordReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
