// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.bitable.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class SearchAppTableRecordReq {
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：open_id
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
      * <p> 示例值：
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
     /**
      * 分页大小
      * <p> 示例值：
      */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

     /**
      * 表格token
      * <p> 示例值：NQRxbRkBMa6OnZsjtERcxhNWnNh
      */
    @Path
    @SerializedName("app_token")
    private String appToken;
     /**
      * 表ID
      * <p> 示例值：tbl0xe5g8PP3U3cS
      */
    @Path
    @SerializedName("table_id")
    private String tableId;
    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    @Body
    private SearchAppTableRecordReqBody body;

    public SearchAppTableRecordReqBody getSearchAppTableRecordReqBody() {
        return this.body;
    }

    public void setSearchAppTableRecordReqBody(SearchAppTableRecordReqBody body) {
        this.body = body;
    }

// builder 开始
  public SearchAppTableRecordReq(){}

  public SearchAppTableRecordReq(Builder builder){
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：open_id
          */
       this.userIdType = builder.userIdType;
         /**
          * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
          * <p> 示例值：
          */
       this.pageToken = builder.pageToken;
         /**
          * 分页大小
          * <p> 示例值：
          */
       this.pageSize = builder.pageSize;
     /**
      * 表格token
      * <p> 示例值：NQRxbRkBMa6OnZsjtERcxhNWnNh
      */
       this.appToken = builder.appToken;
     /**
      * 表ID
      * <p> 示例值：tbl0xe5g8PP3U3cS
      */
       this.tableId = builder.tableId;
        this.body = builder.body;
  }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
        private Integer pageSize; // 分页大小
    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         * @param userIdType {@link com.lark.oapi.service.bitable.v1.enums.SearchAppTableRecordUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.bitable.v1.enums.SearchAppTableRecordUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
         * <p> 示例值：
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
        /**
         * 分页大小
         * <p> 示例值：
         * @param pageSize
         * @return
         */
           public Builder pageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        private String appToken; // 表格token
        private String tableId; // 表ID
        /**
         * 表格token
         * <p> 示例值：NQRxbRkBMa6OnZsjtERcxhNWnNh
         * @param appToken
         * @return
         */
          public Builder appToken(String appToken) {
               this.appToken = appToken;
               return this;
          }

    
        /**
         * 表ID
         * <p> 示例值：tbl0xe5g8PP3U3cS
         * @param tableId
         * @return
         */
          public Builder tableId(String tableId) {
               this.tableId = tableId;
               return this;
          }

    
        private SearchAppTableRecordReqBody body;
    
        public SearchAppTableRecordReqBody getSearchAppTableRecordReqBody() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder searchAppTableRecordReqBody(SearchAppTableRecordReqBody body) {
             this.body = body;
             return this;
        }
    public SearchAppTableRecordReq build(){
        return new SearchAppTableRecordReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
