// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.bitable.v1.resource;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.nio.charset.StandardCharsets;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.request.RequestOptions;
import java.io.ByteArrayOutputStream;
import com.lark.oapi.service.bitable.v1.model.*;
import java.io.*;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.ArrayList;

public class AppTable {
    private static final Logger log = LoggerFactory.getLogger(AppTable.class);
    private final Config config;

    public AppTable(Config config) {
        this.config = config;
    }

    
    /**
     * 新增多个数据表，新增多个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_create</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchCreateAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchCreateAppTableSample.java</a> ;
     */
    public BatchCreateAppTableResp batchCreate(BatchCreateAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        BatchCreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchCreateAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * 新增多个数据表，新增多个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_create</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchCreateAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchCreateAppTableSample.java</a> ;
     */
    public BatchCreateAppTableResp batchCreate(BatchCreateAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        BatchCreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchCreateAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/batch_create"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
    /**
     * 删除多个数据表，删除多个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_delete</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchDeleteAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchDeleteAppTableSample.java</a> ;
     */
    public BatchDeleteAppTableResp batchDelete(BatchDeleteAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        BatchDeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * 删除多个数据表，删除多个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/batch_delete</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchDeleteAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/BatchDeleteAppTableSample.java</a> ;
     */
    public BatchDeleteAppTableResp batchDelete(BatchDeleteAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        BatchDeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, BatchDeleteAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/batch_delete"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
    /**
     * 新增数据表，新增一个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/create</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/CreateAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/CreateAppTableSample.java</a> ;
     */
    public CreateAppTableResp create(CreateAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        CreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * 新增数据表，新增一个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/create">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/create</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/CreateAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/CreateAppTableSample.java</a> ;
     */
    public CreateAppTableResp create(CreateAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "POST"
                , "/open-apis/bitable/v1/apps/:app_token/tables"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        CreateAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
    /**
     * 删除数据表，删除一个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/delete</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/DeleteAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/DeleteAppTableSample.java</a> ;
     */
    public DeleteAppTableResp delete(DeleteAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
                , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        DeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * 删除数据表，删除一个数据表
     * <p> 该接口支持调用频率上限为 10 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/delete">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/delete</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/DeleteAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/DeleteAppTableSample.java</a> ;
     */
    public DeleteAppTableResp delete(DeleteAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "DELETE"
                , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        DeleteAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
    /**
     * 列出数据表，根据  app_token，获取多维表格下的所有数据表
     * <p> 该接口支持调用频率上限为 20 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/list</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/ListAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/ListAppTableSample.java</a> ;
     */
    public ListAppTableResp list(ListAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
                , "/open-apis/bitable/v1/apps/:app_token/tables"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        ListAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * 列出数据表，根据  app_token，获取多维表格下的所有数据表
     * <p> 该接口支持调用频率上限为 20 QPS ;
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/list">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/list</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/ListAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/ListAppTableSample.java</a> ;
     */
    public ListAppTableResp list(ListAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "GET"
                , "/open-apis/bitable/v1/apps/:app_token/tables"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        ListAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
    /**
     * ，
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/patch">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/patch</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/PatchAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/PatchAppTableSample.java</a> ;
     */
    public PatchAppTableResp patch(PatchAppTableReq req, RequestOptions reqOptions) throws Exception {
        // 请求参数选项
        if (reqOptions == null) {
            reqOptions = new RequestOptions();
        }

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
                , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        PatchAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

       resp.setRawResponse(httpResponse);
       resp.setRequest(req);
       
       return resp;
    }

    /**
     * ，
     * <p> 官网API文档链接:<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/patch">https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/bitable-v1/app-table/patch</a> ;
     * <p> 使用Demo链接: <a href="https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/PatchAppTableSample.java">https://github.com/larksuite/oapi-sdk-java/tree/v2_main/sample/src/main/java/com/lark/oapi/sample/apiall/bitablev1/PatchAppTableSample.java</a> ;
     */
    public PatchAppTableResp patch(PatchAppTableReq req) throws Exception {
        // 请求参数选项
        RequestOptions reqOptions = new RequestOptions();

        // 发起请求
        RawResponse httpResponse = Transport.send(config, reqOptions, "PATCH"
                , "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                , Sets.newHashSet(AccessTokenType.User, AccessTokenType.Tenant)
                , req);
        
        // 反序列化
        PatchAppTableResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PatchAppTableResp.class);
        if (resp == null) {
            log.error(String.format(
                    "%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/bitable/v1/apps/:app_token/tables/:table_id"
                    , Jsons.DEFAULT.toJson(req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()),
                    httpResponse.getStatusCode(), new String(httpResponse.getBody(),
                    StandardCharsets.UTF_8)));
            throw new IllegalArgumentException("The result returned by the server is illegal");
       }

        resp.setRawResponse(httpResponse);
        resp.setRequest(req);
        
        return resp;
    }
}
