// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.compensation.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.compensation.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class RecurringPaymentForCreate {
     /**
      * 外部幂等id，由上游业务决定
      * <p> 示例值：7402510801304718380_7309316347007764012_7402523725868058156_1726070400000_10000
      */
    @SerializedName("unique_id")
    private String uniqueId;
     /**
      * 员工id，具体类型由入参中的 user_id_type 指定
      * <p> 示例值：7337149697626801708
      */
    @SerializedName("user_id")
    private String userId;
     /**
      * 薪酬项id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/item/list?appId=cli_a3077e2bb03c100d 进行查询）
      * <p> 示例值：7411039006180312620
      */
    @SerializedName("item_id")
    private String itemId;
     /**
      * 每次发放金额
      * <p> 示例值：20.00
      */
    @SerializedName("each_amount")
    private String eachAmount;
     /**
      * 发放开始时间
      * <p> 示例值：2024-08-01
      */
    @SerializedName("start_date")
    private String startDate;
     /**
      * 发放结束时间
      * <p> 示例值：2025-08-01
      */
    @SerializedName("end_date")
    private String endDate;
     /**
      * 币种id
      * <p> 示例值：6863329932261459464
      */
    @SerializedName("currency_id")
    private String currencyId;
     /**
      * 发放方式
      * <p> 示例值：with_salary
      */
    @SerializedName("issuance_type")
    private String issuanceType;
     /**
      * 发放频率
      * <p> 示例值：year
      */
    @SerializedName("issuance_period")
    private String issuancePeriod;
     /**
      * 备注
      * <p> 示例值：这是个备注
      */
    @SerializedName("remark")
    private String remark;
     /**
      * 发放国家id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-country_region/search进行查询）
      * <p> 示例值：6862995745046267400
      */
    @SerializedName("issuance_country_region_id")
    private String issuanceCountryRegionId;
    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getEachAmount() {
        return this.eachAmount;
    }

    public void setEachAmount(String eachAmount) {
        this.eachAmount = eachAmount;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public String getIssuanceType() {
        return this.issuanceType;
    }

    public void setIssuanceType(String issuanceType) {
        this.issuanceType = issuanceType;
    }

    public String getIssuancePeriod() {
        return this.issuancePeriod;
    }

    public void setIssuancePeriod(String issuancePeriod) {
        this.issuancePeriod = issuancePeriod;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getIssuanceCountryRegionId() {
        return this.issuanceCountryRegionId;
    }

    public void setIssuanceCountryRegionId(String issuanceCountryRegionId) {
        this.issuanceCountryRegionId = issuanceCountryRegionId;
    }


// builder 开始
  public RecurringPaymentForCreate(){}

  public RecurringPaymentForCreate(Builder builder){
         /**
          * 外部幂等id，由上游业务决定
          * <p> 示例值：7402510801304718380_7309316347007764012_7402523725868058156_1726070400000_10000
          */
      this.uniqueId = builder.uniqueId;
         /**
          * 员工id，具体类型由入参中的 user_id_type 指定
          * <p> 示例值：7337149697626801708
          */
      this.userId = builder.userId;
         /**
          * 薪酬项id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/item/list?appId=cli_a3077e2bb03c100d 进行查询）
          * <p> 示例值：7411039006180312620
          */
      this.itemId = builder.itemId;
         /**
          * 每次发放金额
          * <p> 示例值：20.00
          */
      this.eachAmount = builder.eachAmount;
         /**
          * 发放开始时间
          * <p> 示例值：2024-08-01
          */
      this.startDate = builder.startDate;
         /**
          * 发放结束时间
          * <p> 示例值：2025-08-01
          */
      this.endDate = builder.endDate;
         /**
          * 币种id
          * <p> 示例值：6863329932261459464
          */
      this.currencyId = builder.currencyId;
         /**
          * 发放方式
          * <p> 示例值：with_salary
          */
      this.issuanceType = builder.issuanceType;
         /**
          * 发放频率
          * <p> 示例值：year
          */
      this.issuancePeriod = builder.issuancePeriod;
         /**
          * 备注
          * <p> 示例值：这是个备注
          */
      this.remark = builder.remark;
         /**
          * 发放国家id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-country_region/search进行查询）
          * <p> 示例值：6862995745046267400
          */
      this.issuanceCountryRegionId = builder.issuanceCountryRegionId;
  }

    public static class Builder {
     /**
      * 外部幂等id，由上游业务决定
      * <p> 示例值：7402510801304718380_7309316347007764012_7402523725868058156_1726070400000_10000
      */
        private String uniqueId;
     /**
      * 员工id，具体类型由入参中的 user_id_type 指定
      * <p> 示例值：7337149697626801708
      */
        private String userId;
     /**
      * 薪酬项id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/item/list?appId=cli_a3077e2bb03c100d 进行查询）
      * <p> 示例值：7411039006180312620
      */
        private String itemId;
     /**
      * 每次发放金额
      * <p> 示例值：20.00
      */
        private String eachAmount;
     /**
      * 发放开始时间
      * <p> 示例值：2024-08-01
      */
        private String startDate;
     /**
      * 发放结束时间
      * <p> 示例值：2025-08-01
      */
        private String endDate;
     /**
      * 币种id
      * <p> 示例值：6863329932261459464
      */
        private String currencyId;
     /**
      * 发放方式
      * <p> 示例值：with_salary
      */
        private String issuanceType;
     /**
      * 发放频率
      * <p> 示例值：year
      */
        private String issuancePeriod;
     /**
      * 备注
      * <p> 示例值：这是个备注
      */
        private String remark;
     /**
      * 发放国家id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-country_region/search进行查询）
      * <p> 示例值：6862995745046267400
      */
        private String issuanceCountryRegionId;

        /**
         * 外部幂等id，由上游业务决定
         * <p> 示例值：7402510801304718380_7309316347007764012_7402523725868058156_1726070400000_10000
         * @param uniqueId
         * @return
         */
        public Builder uniqueId(String uniqueId) {
             this.uniqueId = uniqueId;
             return this;
        }

    

        /**
         * 员工id，具体类型由入参中的 user_id_type 指定
         * <p> 示例值：7337149697626801708
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
             this.userId = userId;
             return this;
        }

    

        /**
         * 薪酬项id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/item/list?appId=cli_a3077e2bb03c100d 进行查询）
         * <p> 示例值：7411039006180312620
         * @param itemId
         * @return
         */
        public Builder itemId(String itemId) {
             this.itemId = itemId;
             return this;
        }

    

        /**
         * 每次发放金额
         * <p> 示例值：20.00
         * @param eachAmount
         * @return
         */
        public Builder eachAmount(String eachAmount) {
             this.eachAmount = eachAmount;
             return this;
        }

    

        /**
         * 发放开始时间
         * <p> 示例值：2024-08-01
         * @param startDate
         * @return
         */
        public Builder startDate(String startDate) {
             this.startDate = startDate;
             return this;
        }

    

        /**
         * 发放结束时间
         * <p> 示例值：2025-08-01
         * @param endDate
         * @return
         */
        public Builder endDate(String endDate) {
             this.endDate = endDate;
             return this;
        }

    

        /**
         * 币种id
         * <p> 示例值：6863329932261459464
         * @param currencyId
         * @return
         */
        public Builder currencyId(String currencyId) {
             this.currencyId = currencyId;
             return this;
        }

    

        /**
         * 发放方式
         * <p> 示例值：with_salary
         * @param issuanceType
         * @return
         */
        public Builder issuanceType(String issuanceType) {
             this.issuanceType = issuanceType;
             return this;
        }
        /**
         * 发放方式
         * <p> 示例值：with_salary
         * @param issuanceType {@link com.lark.oapi.service.compensation.v1.enums.RecurringPaymentForCreateIssuanceTypeEnum}
         * @return
         */
        public Builder issuanceType(com.lark.oapi.service.compensation.v1.enums.RecurringPaymentForCreateIssuanceTypeEnum issuanceType) {
             this.issuanceType = issuanceType.getValue();
             return this;
        }

    

        /**
         * 发放频率
         * <p> 示例值：year
         * @param issuancePeriod
         * @return
         */
        public Builder issuancePeriod(String issuancePeriod) {
             this.issuancePeriod = issuancePeriod;
             return this;
        }
        /**
         * 发放频率
         * <p> 示例值：year
         * @param issuancePeriod {@link com.lark.oapi.service.compensation.v1.enums.RecurringPaymentForCreateIssuancePeriodEnum}
         * @return
         */
        public Builder issuancePeriod(com.lark.oapi.service.compensation.v1.enums.RecurringPaymentForCreateIssuancePeriodEnum issuancePeriod) {
             this.issuancePeriod = issuancePeriod.getValue();
             return this;
        }

    

        /**
         * 备注
         * <p> 示例值：这是个备注
         * @param remark
         * @return
         */
        public Builder remark(String remark) {
             this.remark = remark;
             return this;
        }

    

        /**
         * 发放国家id（可通过 https://open.larkoffice.com/document/uAjLw4CM/ukTMukTMukTM/corehr-v2/basic_info-country_region/search进行查询）
         * <p> 示例值：6862995745046267400
         * @param issuanceCountryRegionId
         * @return
         */
        public Builder issuanceCountryRegionId(String issuanceCountryRegionId) {
             this.issuanceCountryRegionId = issuanceCountryRegionId;
             return this;
        }

    
    
    public RecurringPaymentForCreate build(){
        return new RecurringPaymentForCreate(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
