// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.contact;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.contact.v3.V3;
import com.lark.oapi.service.contact.v3.model.*;
import com.lark.oapi.service.contact.v3.resource.CustomAttr;
import com.lark.oapi.service.contact.v3.resource.CustomAttrEvent;
import com.lark.oapi.service.contact.v3.resource.Department;
import com.lark.oapi.service.contact.v3.resource.EmployeeTypeEnum;
import com.lark.oapi.service.contact.v3.resource.FunctionalRole;
import com.lark.oapi.service.contact.v3.resource.FunctionalRoleMember;
import com.lark.oapi.service.contact.v3.resource.Group;
import com.lark.oapi.service.contact.v3.resource.GroupMember;
import com.lark.oapi.service.contact.v3.resource.JobFamily;
import com.lark.oapi.service.contact.v3.resource.JobLevel;
import com.lark.oapi.service.contact.v3.resource.JobTitle;
import com.lark.oapi.service.contact.v3.resource.Scope;
import com.lark.oapi.service.contact.v3.resource.Unit;
import com.lark.oapi.service.contact.v3.resource.User;
import com.lark.oapi.service.contact.v3.resource.WorkCity;

public class ContactService {
    private final V3 v3;
    private final CustomAttr customAttr; // 自定义用户字段
    private final CustomAttrEvent customAttrEvent; // 事件
    private final Department department; // 部门
    private final EmployeeTypeEnum employeeTypeEnum; // 人员类型
    private final FunctionalRole functionalRole; // functional_role
    private final FunctionalRoleMember functionalRoleMember; // functional_role.member
    private final Group group; // 用户组
    private final GroupMember groupMember; // 用户组成员
    private final JobFamily jobFamily; // job_family
    private final JobLevel jobLevel; // job_level
    private final JobTitle jobTitle; // job_title
    private final Scope scope; // 通讯录权限范围
    private final Unit unit; // 单位
    private final User user; // 用户
    private final WorkCity workCity; // work_city

    public ContactService(Config config) {
    this.v3 = new V3(config);
    this.customAttr = new CustomAttr(config);
    this.customAttrEvent = new CustomAttrEvent(config);
    this.department = new Department(config);
    this.employeeTypeEnum = new EmployeeTypeEnum(config);
    this.functionalRole = new FunctionalRole(config);
    this.functionalRoleMember = new FunctionalRoleMember(config);
    this.group = new Group(config);
    this.groupMember = new GroupMember(config);
    this.jobFamily = new JobFamily(config);
    this.jobLevel = new JobLevel(config);
    this.jobTitle = new JobTitle(config);
    this.scope = new Scope(config);
    this.unit = new Unit(config);
    this.user = new User(config);
    this.workCity = new WorkCity(config);
    }
    public V3 v3() {
        return v3;
    }
    public CustomAttr customAttr() {
        return customAttr;
    }
    public CustomAttrEvent customAttrEvent() {
        return customAttrEvent;
    }
    public Department department() {
        return department;
    }
    public EmployeeTypeEnum employeeTypeEnum() {
        return employeeTypeEnum;
    }
    public FunctionalRole functionalRole() {
        return functionalRole;
    }
    public FunctionalRoleMember functionalRoleMember() {
        return functionalRoleMember;
    }
    public Group group() {
        return group;
    }
    public GroupMember groupMember() {
        return groupMember;
    }
    public JobFamily jobFamily() {
        return jobFamily;
    }
    public JobLevel jobLevel() {
        return jobLevel;
    }
    public JobTitle jobTitle() {
        return jobTitle;
    }
    public Scope scope() {
        return scope;
    }
    public Unit unit() {
        return unit;
    }
    public User user() {
        return user;
    }
    public WorkCity workCity() {
        return workCity;
    }
    public abstract static class P2CustomAttrEventUpdatedV3Handler implements IEventHandler<P2CustomAttrEventUpdatedV3> {
        @Override
        public P2CustomAttrEventUpdatedV3 getEvent() {
            return new P2CustomAttrEventUpdatedV3();
        }
    }
    public abstract static class P2DepartmentCreatedV3Handler implements IEventHandler<P2DepartmentCreatedV3> {
        @Override
        public P2DepartmentCreatedV3 getEvent() {
            return new P2DepartmentCreatedV3();
        }
    }
    public abstract static class P2DepartmentDeletedV3Handler implements IEventHandler<P2DepartmentDeletedV3> {
        @Override
        public P2DepartmentDeletedV3 getEvent() {
            return new P2DepartmentDeletedV3();
        }
    }
    public abstract static class P2DepartmentUpdatedV3Handler implements IEventHandler<P2DepartmentUpdatedV3> {
        @Override
        public P2DepartmentUpdatedV3 getEvent() {
            return new P2DepartmentUpdatedV3();
        }
    }
    public abstract static class P2EmployeeTypeEnumActivedV3Handler implements IEventHandler<P2EmployeeTypeEnumActivedV3> {
        @Override
        public P2EmployeeTypeEnumActivedV3 getEvent() {
            return new P2EmployeeTypeEnumActivedV3();
        }
    }
    public abstract static class P2EmployeeTypeEnumCreatedV3Handler implements IEventHandler<P2EmployeeTypeEnumCreatedV3> {
        @Override
        public P2EmployeeTypeEnumCreatedV3 getEvent() {
            return new P2EmployeeTypeEnumCreatedV3();
        }
    }
    public abstract static class P2EmployeeTypeEnumDeactivatedV3Handler implements IEventHandler<P2EmployeeTypeEnumDeactivatedV3> {
        @Override
        public P2EmployeeTypeEnumDeactivatedV3 getEvent() {
            return new P2EmployeeTypeEnumDeactivatedV3();
        }
    }
    public abstract static class P2EmployeeTypeEnumDeletedV3Handler implements IEventHandler<P2EmployeeTypeEnumDeletedV3> {
        @Override
        public P2EmployeeTypeEnumDeletedV3 getEvent() {
            return new P2EmployeeTypeEnumDeletedV3();
        }
    }
    public abstract static class P2EmployeeTypeEnumUpdatedV3Handler implements IEventHandler<P2EmployeeTypeEnumUpdatedV3> {
        @Override
        public P2EmployeeTypeEnumUpdatedV3 getEvent() {
            return new P2EmployeeTypeEnumUpdatedV3();
        }
    }
    public abstract static class P2ScopeUpdatedV3Handler implements IEventHandler<P2ScopeUpdatedV3> {
        @Override
        public P2ScopeUpdatedV3 getEvent() {
            return new P2ScopeUpdatedV3();
        }
    }
    public abstract static class P2UserCreatedV3Handler implements IEventHandler<P2UserCreatedV3> {
        @Override
        public P2UserCreatedV3 getEvent() {
            return new P2UserCreatedV3();
        }
    }
    public abstract static class P2UserDeletedV3Handler implements IEventHandler<P2UserDeletedV3> {
        @Override
        public P2UserDeletedV3 getEvent() {
            return new P2UserDeletedV3();
        }
    }
    public abstract static class P2UserUpdatedV3Handler implements IEventHandler<P2UserUpdatedV3> {
        @Override
        public P2UserUpdatedV3 getEvent() {
            return new P2UserUpdatedV3();
        }
    }
    public abstract static class P1UserChangedV3Handler implements IEventHandler<P1UserChangedV3> {
        @Override
        public P1UserChangedV3 getEvent() {
            return new P1UserChangedV3();
        }
    }

    public abstract static class P1UserStatusChangedV3Handler implements IEventHandler<P1UserStatusChangedV3> {
        @Override
        public P1UserStatusChangedV3 getEvent() {
            return new P1UserStatusChangedV3();
        }
    }

    public abstract static class P1DepartmentChangedV3Handler implements IEventHandler<P1DepartmentChangedV3> {
        @Override
        public P1DepartmentChangedV3 getEvent() {
            return new P1DepartmentChangedV3();
        }
    }

    public abstract static class P1ContactScopeChangedV3Handler implements IEventHandler<P1ContactScopeChangedV3> {
        @Override
        public P1ContactScopeChangedV3 getEvent() {
            return new P1ContactScopeChangedV3();
        }
    }
}