// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.contact.v3.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.contact.v3.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListDepartmentReq {
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 此次调用中使用的部门ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;
     /**
      * 父部门的ID，填上获取部门下所有子部门
      * <p> 示例值：od-80884c92e43e
      */
    @Query
    @SerializedName("parent_department_id")
    private String parentDepartmentId;
     /**
      * 是否递归获取子部门
      * <p> 示例值：false
      */
    @Query
    @SerializedName("fetch_child")
    private Boolean fetchChild;
     /**
      * 分页大小
      * <p> 示例值：10
      */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
     /**
      * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
      * <p> 示例值：5bc498db4617
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

    public String getParentDepartmentId() {
        return this.parentDepartmentId;
    }

    public void setParentDepartmentId(String parentDepartmentId) {
        this.parentDepartmentId = parentDepartmentId;
    }

    public Boolean getFetchChild() {
        return this.fetchChild;
    }

    public void setFetchChild(Boolean fetchChild) {
        this.fetchChild = fetchChild;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }


// builder 开始
  public ListDepartmentReq(){}

  public ListDepartmentReq(Builder builder){
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
         /**
          * 此次调用中使用的部门ID的类型
          * <p> 示例值：
          */
       this.departmentIdType = builder.departmentIdType;
         /**
          * 父部门的ID，填上获取部门下所有子部门
          * <p> 示例值：od-80884c92e43e
          */
       this.parentDepartmentId = builder.parentDepartmentId;
         /**
          * 是否递归获取子部门
          * <p> 示例值：false
          */
       this.fetchChild = builder.fetchChild;
         /**
          * 分页大小
          * <p> 示例值：10
          */
       this.pageSize = builder.pageSize;
         /**
          * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
          * <p> 示例值：5bc498db4617
          */
       this.pageToken = builder.pageToken;
  }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String departmentIdType; // 此次调用中使用的部门ID的类型
        private String parentDepartmentId; // 父部门的ID，填上获取部门下所有子部门
        private Boolean fetchChild; // 是否递归获取子部门
        private Integer pageSize; // 分页大小
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.contact.v3.enums.ListDepartmentUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.contact.v3.enums.ListDepartmentUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        /**
         * 此次调用中使用的部门ID的类型
         * <p> 示例值：
         * @param departmentIdType
         * @return
         */
           public Builder departmentIdType(String departmentIdType) {
                this.departmentIdType = departmentIdType;
                return this;
           }

        /**
         * 此次调用中使用的部门ID的类型
         * <p> 示例值：
         * @param departmentIdType {@link com.lark.oapi.service.contact.v3.enums.ListDepartmentDepartmentIdTypeEnum}
         * @return
         */
          public Builder departmentIdType(com.lark.oapi.service.contact.v3.enums.ListDepartmentDepartmentIdTypeEnum departmentIdType) {
               this.departmentIdType = departmentIdType.getValue();
               return this;
          }

    
        /**
         * 父部门的ID，填上获取部门下所有子部门
         * <p> 示例值：od-80884c92e43e
         * @param parentDepartmentId
         * @return
         */
           public Builder parentDepartmentId(String parentDepartmentId) {
                this.parentDepartmentId = parentDepartmentId;
                return this;
           }

    
        /**
         * 是否递归获取子部门
         * <p> 示例值：false
         * @param fetchChild
         * @return
         */
           public Builder fetchChild(Boolean fetchChild) {
                this.fetchChild = fetchChild;
                return this;
           }

    
        /**
         * 分页大小
         * <p> 示例值：10
         * @param pageSize
         * @return
         */
           public Builder pageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该page_token 获取查询结果
         * <p> 示例值：5bc498db4617
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
    public ListDepartmentReq build(){
        return new ListDepartmentReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
