// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListSubregionReq {
     /**
      * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
      * <p> 示例值：1231231987
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
     /**
      * 每页获取记录数量，最大100
      * <p> 示例值：100
      */
    @Query
    @SerializedName("page_size")
    private String pageSize;
     /**
      * 省份/行政区id，填写后只查询该省份/行政区下的城市/区域
      * <p> 示例值：100
      */
    @Query
    @SerializedName("subdivision_id")
    private String subdivisionId;
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public String getSubdivisionId() {
        return this.subdivisionId;
    }

    public void setSubdivisionId(String subdivisionId) {
        this.subdivisionId = subdivisionId;
    }


// builder 开始
  public ListSubregionReq(){}

  public ListSubregionReq(Builder builder){
         /**
          * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
          * <p> 示例值：1231231987
          */
       this.pageToken = builder.pageToken;
         /**
          * 每页获取记录数量，最大100
          * <p> 示例值：100
          */
       this.pageSize = builder.pageSize;
         /**
          * 省份/行政区id，填写后只查询该省份/行政区下的城市/区域
          * <p> 示例值：100
          */
       this.subdivisionId = builder.subdivisionId;
  }

    public static class Builder {
        private String pageToken; // 页码标识，获取第一页传空，每次查询会返回下一页的page_token
        private String pageSize; // 每页获取记录数量，最大100
        private String subdivisionId; // 省份/行政区id，填写后只查询该省份/行政区下的城市/区域
    
        /**
         * 页码标识，获取第一页传空，每次查询会返回下一页的page_token
         * <p> 示例值：1231231987
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
        /**
         * 每页获取记录数量，最大100
         * <p> 示例值：100
         * @param pageSize
         * @return
         */
           public Builder pageSize(String pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        /**
         * 省份/行政区id，填写后只查询该省份/行政区下的城市/区域
         * <p> 示例值：100
         * @param subdivisionId
         * @return
         */
           public Builder subdivisionId(String subdivisionId) {
                this.subdivisionId = subdivisionId;
                return this;
           }

    
    public ListSubregionReq build(){
        return new ListSubregionReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
