// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Person {
     /**
      * 个人手机号
      * <p> 示例值：11111111111
      */
    @SerializedName("phone_number")
    private String phoneNumber;
     /**
      * 法定姓名
      * <p> 示例值：张三
      */
    @SerializedName("legal_name")
    private String legalName;
     /**
      * 常用名
      * <p> 示例值：张四
      */
    @SerializedName("preferred_name")
    private String preferredName;
     /**
      * Person ID
      * <p> 示例值：646465654545
      */
    @SerializedName("id")
    private String id;
     /**
      * 姓名
      * <p> 示例值：
      */
    @SerializedName("name_list")
    private PersonName[] nameList;
     /**
      * 性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("gender")
    private Enum gender;
     /**
      * 出生日期
      * <p> 示例值：2020-01-01
      */
    @SerializedName("date_of_birth")
    private String dateOfBirth;
     /**
      * 国籍id
      * <p> 示例值：123456789
      */
    @SerializedName("nationality_id")
    private String nationalityId;
     /**
      * 国籍 ID，可通过【查询国籍信息】接口查询
      * <p> 示例值：7075702732803278380
      */
    @SerializedName("nationality_id_v2")
    private String nationalityIdV2;
     /**
      * 民族 / 种族，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)民族（race）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("race")
    private Enum race;
     /**
      * 婚姻状况，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)婚姻状况（marital_status）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("marital_status")
    private Enum maritalStatus;
     /**
      * 电话列表，只有当满足下面所有条件时，电话在个人信息页才可见:;- 电话号码不为空;- is_primary = "true" ;- phone_usage = "home"
      * <p> 示例值：
      */
    @SerializedName("phone_list")
    private Phone[] phoneList;
     /**
      * 地址列表
      * <p> 示例值：
      */
    @SerializedName("address_list")
    private Address[] addressList;
     /**
      * 邮箱列表
      * <p> 示例值：
      */
    @SerializedName("email_list")
    private Email[] emailList;
     /**
      * 工作履历列表
      * <p> 示例值：
      */
    @SerializedName("work_experience_list")
    private WorkExperience[] workExperienceList;
     /**
      * 教育经历列表
      * <p> 示例值：
      */
    @SerializedName("education_list")
    private Education[] educationList;
     /**
      * 银行账号
      * <p> 示例值：
      */
    @SerializedName("bank_account_list")
    private BankAccount[] bankAccountList;
     /**
      * 证件号码
      * <p> 示例值：
      */
    @SerializedName("national_id_list")
    private NationalId[] nationalIdList;
     /**
      * 亲属列表
      * <p> 示例值：
      */
    @SerializedName("dependent_list")
    private Dependent[] dependentList;
     /**
      * 紧急联系人列表
      * <p> 示例值：
      */
    @SerializedName("emergency_contact_list")
    private EmergencyContact[] emergencyContactList;
     /**
      * 参加工作日期
      * <p> 示例值：2020-10-01
      */
    @SerializedName("date_entered_workforce")
    private String dateEnteredWorkforce;
     /**
      * 头像资源的 ID
      * <p> 示例值：dfysuc8x76dsfsw
      */
    @SerializedName("profile_image_id")
    private String profileImageId;
     /**
      * 自定义字段
      * <p> 示例值：
      */
    @SerializedName("custom_fields")
    private ObjectFieldData[] customFields;
     /**
      * 邮箱
      * <p> 示例值：test@163.com
      */
    @SerializedName("email_address")
    private String emailAddress;
     /**
      * 纳税身份信息
      * <p> 示例值：["1", "2"]
      */
    @SerializedName("resident_tax_id_list")
    private String[] residentTaxIdList;
     /**
      * 年龄
      * <p> 示例值：25
      */
    @SerializedName("age")
    private Integer age;
     /**
      * 最高学历教育
      * <p> 示例值：
      */
    @SerializedName("highest_level_of_education")
    private Education highestLevelOfEducation;
     /**
      * 最高学位教育经历
      * <p> 示例值：
      */
    @SerializedName("highest_degree_of_education")
    private Education highestDegreeOfEducation;
     /**
      * 个人资料
      * <p> 示例值：
      */
    @SerializedName("personal_profile")
    private PersonalProfile[] personalProfile;
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public String getPreferredName() {
        return this.preferredName;
    }

    public void setPreferredName(String preferredName) {
        this.preferredName = preferredName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PersonName[] getNameList() {
        return this.nameList;
    }

    public void setNameList(PersonName[] nameList) {
        this.nameList = nameList;
    }

    public Enum getGender() {
        return this.gender;
    }

    public void setGender(Enum gender) {
        this.gender = gender;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getNationalityId() {
        return this.nationalityId;
    }

    public void setNationalityId(String nationalityId) {
        this.nationalityId = nationalityId;
    }

    public String getNationalityIdV2() {
        return this.nationalityIdV2;
    }

    public void setNationalityIdV2(String nationalityIdV2) {
        this.nationalityIdV2 = nationalityIdV2;
    }

    public Enum getRace() {
        return this.race;
    }

    public void setRace(Enum race) {
        this.race = race;
    }

    public Enum getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(Enum maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public Phone[] getPhoneList() {
        return this.phoneList;
    }

    public void setPhoneList(Phone[] phoneList) {
        this.phoneList = phoneList;
    }

    public Address[] getAddressList() {
        return this.addressList;
    }

    public void setAddressList(Address[] addressList) {
        this.addressList = addressList;
    }

    public Email[] getEmailList() {
        return this.emailList;
    }

    public void setEmailList(Email[] emailList) {
        this.emailList = emailList;
    }

    public WorkExperience[] getWorkExperienceList() {
        return this.workExperienceList;
    }

    public void setWorkExperienceList(WorkExperience[] workExperienceList) {
        this.workExperienceList = workExperienceList;
    }

    public Education[] getEducationList() {
        return this.educationList;
    }

    public void setEducationList(Education[] educationList) {
        this.educationList = educationList;
    }

    public BankAccount[] getBankAccountList() {
        return this.bankAccountList;
    }

    public void setBankAccountList(BankAccount[] bankAccountList) {
        this.bankAccountList = bankAccountList;
    }

    public NationalId[] getNationalIdList() {
        return this.nationalIdList;
    }

    public void setNationalIdList(NationalId[] nationalIdList) {
        this.nationalIdList = nationalIdList;
    }

    public Dependent[] getDependentList() {
        return this.dependentList;
    }

    public void setDependentList(Dependent[] dependentList) {
        this.dependentList = dependentList;
    }

    public EmergencyContact[] getEmergencyContactList() {
        return this.emergencyContactList;
    }

    public void setEmergencyContactList(EmergencyContact[] emergencyContactList) {
        this.emergencyContactList = emergencyContactList;
    }

    public String getDateEnteredWorkforce() {
        return this.dateEnteredWorkforce;
    }

    public void setDateEnteredWorkforce(String dateEnteredWorkforce) {
        this.dateEnteredWorkforce = dateEnteredWorkforce;
    }

    public String getProfileImageId() {
        return this.profileImageId;
    }

    public void setProfileImageId(String profileImageId) {
        this.profileImageId = profileImageId;
    }

    public ObjectFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ObjectFieldData[] customFields) {
        this.customFields = customFields;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String[] getResidentTaxIdList() {
        return this.residentTaxIdList;
    }

    public void setResidentTaxIdList(String[] residentTaxIdList) {
        this.residentTaxIdList = residentTaxIdList;
    }

    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public Education getHighestLevelOfEducation() {
        return this.highestLevelOfEducation;
    }

    public void setHighestLevelOfEducation(Education highestLevelOfEducation) {
        this.highestLevelOfEducation = highestLevelOfEducation;
    }

    public Education getHighestDegreeOfEducation() {
        return this.highestDegreeOfEducation;
    }

    public void setHighestDegreeOfEducation(Education highestDegreeOfEducation) {
        this.highestDegreeOfEducation = highestDegreeOfEducation;
    }

    public PersonalProfile[] getPersonalProfile() {
        return this.personalProfile;
    }

    public void setPersonalProfile(PersonalProfile[] personalProfile) {
        this.personalProfile = personalProfile;
    }


// builder 开始
  public Person(){}

  public Person(Builder builder){
         /**
          * 个人手机号
          * <p> 示例值：11111111111
          */
      this.phoneNumber = builder.phoneNumber;
         /**
          * 法定姓名
          * <p> 示例值：张三
          */
      this.legalName = builder.legalName;
         /**
          * 常用名
          * <p> 示例值：张四
          */
      this.preferredName = builder.preferredName;
         /**
          * Person ID
          * <p> 示例值：646465654545
          */
      this.id = builder.id;
         /**
          * 姓名
          * <p> 示例值：
          */
      this.nameList = builder.nameList;
         /**
          * 性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
          * <p> 示例值：
          */
      this.gender = builder.gender;
         /**
          * 出生日期
          * <p> 示例值：2020-01-01
          */
      this.dateOfBirth = builder.dateOfBirth;
         /**
          * 国籍id
          * <p> 示例值：123456789
          */
      this.nationalityId = builder.nationalityId;
         /**
          * 国籍 ID，可通过【查询国籍信息】接口查询
          * <p> 示例值：7075702732803278380
          */
      this.nationalityIdV2 = builder.nationalityIdV2;
         /**
          * 民族 / 种族，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)民族（race）枚举定义部分获得
          * <p> 示例值：
          */
      this.race = builder.race;
         /**
          * 婚姻状况，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)婚姻状况（marital_status）枚举定义部分获得
          * <p> 示例值：
          */
      this.maritalStatus = builder.maritalStatus;
         /**
          * 电话列表，只有当满足下面所有条件时，电话在个人信息页才可见:;- 电话号码不为空;- is_primary = "true" ;- phone_usage = "home"
          * <p> 示例值：
          */
      this.phoneList = builder.phoneList;
         /**
          * 地址列表
          * <p> 示例值：
          */
      this.addressList = builder.addressList;
         /**
          * 邮箱列表
          * <p> 示例值：
          */
      this.emailList = builder.emailList;
         /**
          * 工作履历列表
          * <p> 示例值：
          */
      this.workExperienceList = builder.workExperienceList;
         /**
          * 教育经历列表
          * <p> 示例值：
          */
      this.educationList = builder.educationList;
         /**
          * 银行账号
          * <p> 示例值：
          */
      this.bankAccountList = builder.bankAccountList;
         /**
          * 证件号码
          * <p> 示例值：
          */
      this.nationalIdList = builder.nationalIdList;
         /**
          * 亲属列表
          * <p> 示例值：
          */
      this.dependentList = builder.dependentList;
         /**
          * 紧急联系人列表
          * <p> 示例值：
          */
      this.emergencyContactList = builder.emergencyContactList;
         /**
          * 参加工作日期
          * <p> 示例值：2020-10-01
          */
      this.dateEnteredWorkforce = builder.dateEnteredWorkforce;
         /**
          * 头像资源的 ID
          * <p> 示例值：dfysuc8x76dsfsw
          */
      this.profileImageId = builder.profileImageId;
         /**
          * 自定义字段
          * <p> 示例值：
          */
      this.customFields = builder.customFields;
         /**
          * 邮箱
          * <p> 示例值：test@163.com
          */
      this.emailAddress = builder.emailAddress;
         /**
          * 纳税身份信息
          * <p> 示例值：["1", "2"]
          */
      this.residentTaxIdList = builder.residentTaxIdList;
         /**
          * 年龄
          * <p> 示例值：25
          */
      this.age = builder.age;
         /**
          * 最高学历教育
          * <p> 示例值：
          */
      this.highestLevelOfEducation = builder.highestLevelOfEducation;
         /**
          * 最高学位教育经历
          * <p> 示例值：
          */
      this.highestDegreeOfEducation = builder.highestDegreeOfEducation;
         /**
          * 个人资料
          * <p> 示例值：
          */
      this.personalProfile = builder.personalProfile;
  }

    public static class Builder {
     /**
      * 个人手机号
      * <p> 示例值：11111111111
      */
        private String phoneNumber;
     /**
      * 法定姓名
      * <p> 示例值：张三
      */
        private String legalName;
     /**
      * 常用名
      * <p> 示例值：张四
      */
        private String preferredName;
     /**
      * Person ID
      * <p> 示例值：646465654545
      */
        private String id;
     /**
      * 姓名
      * <p> 示例值：
      */
        private PersonName[] nameList;
     /**
      * 性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum gender;
     /**
      * 出生日期
      * <p> 示例值：2020-01-01
      */
        private String dateOfBirth;
     /**
      * 国籍id
      * <p> 示例值：123456789
      */
        private String nationalityId;
     /**
      * 国籍 ID，可通过【查询国籍信息】接口查询
      * <p> 示例值：7075702732803278380
      */
        private String nationalityIdV2;
     /**
      * 民族 / 种族，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)民族（race）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum race;
     /**
      * 婚姻状况，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)婚姻状况（marital_status）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum maritalStatus;
     /**
      * 电话列表，只有当满足下面所有条件时，电话在个人信息页才可见:;- 电话号码不为空;- is_primary = "true" ;- phone_usage = "home"
      * <p> 示例值：
      */
        private Phone[] phoneList;
     /**
      * 地址列表
      * <p> 示例值：
      */
        private Address[] addressList;
     /**
      * 邮箱列表
      * <p> 示例值：
      */
        private Email[] emailList;
     /**
      * 工作履历列表
      * <p> 示例值：
      */
        private WorkExperience[] workExperienceList;
     /**
      * 教育经历列表
      * <p> 示例值：
      */
        private Education[] educationList;
     /**
      * 银行账号
      * <p> 示例值：
      */
        private BankAccount[] bankAccountList;
     /**
      * 证件号码
      * <p> 示例值：
      */
        private NationalId[] nationalIdList;
     /**
      * 亲属列表
      * <p> 示例值：
      */
        private Dependent[] dependentList;
     /**
      * 紧急联系人列表
      * <p> 示例值：
      */
        private EmergencyContact[] emergencyContactList;
     /**
      * 参加工作日期
      * <p> 示例值：2020-10-01
      */
        private String dateEnteredWorkforce;
     /**
      * 头像资源的 ID
      * <p> 示例值：dfysuc8x76dsfsw
      */
        private String profileImageId;
     /**
      * 自定义字段
      * <p> 示例值：
      */
        private ObjectFieldData[] customFields;
     /**
      * 邮箱
      * <p> 示例值：test@163.com
      */
        private String emailAddress;
     /**
      * 纳税身份信息
      * <p> 示例值：["1", "2"]
      */
        private String[] residentTaxIdList;
     /**
      * 年龄
      * <p> 示例值：25
      */
        private Integer age;
     /**
      * 最高学历教育
      * <p> 示例值：
      */
        private Education highestLevelOfEducation;
     /**
      * 最高学位教育经历
      * <p> 示例值：
      */
        private Education highestDegreeOfEducation;
     /**
      * 个人资料
      * <p> 示例值：
      */
        private PersonalProfile[] personalProfile;

        /**
         * 个人手机号
         * <p> 示例值：11111111111
         * @param phoneNumber
         * @return
         */
        public Builder phoneNumber(String phoneNumber) {
             this.phoneNumber = phoneNumber;
             return this;
        }

    

        /**
         * 法定姓名
         * <p> 示例值：张三
         * @param legalName
         * @return
         */
        public Builder legalName(String legalName) {
             this.legalName = legalName;
             return this;
        }

    

        /**
         * 常用名
         * <p> 示例值：张四
         * @param preferredName
         * @return
         */
        public Builder preferredName(String preferredName) {
             this.preferredName = preferredName;
             return this;
        }

    

        /**
         * Person ID
         * <p> 示例值：646465654545
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 姓名
         * <p> 示例值：
         * @param nameList
         * @return
         */
        public Builder nameList(PersonName[] nameList) {
             this.nameList = nameList;
             return this;
        }

    

        /**
         * 性别，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)性别（gender）枚举定义部分获得
         * <p> 示例值：
         * @param gender
         * @return
         */
        public Builder gender(Enum gender) {
             this.gender = gender;
             return this;
        }

    

        /**
         * 出生日期
         * <p> 示例值：2020-01-01
         * @param dateOfBirth
         * @return
         */
        public Builder dateOfBirth(String dateOfBirth) {
             this.dateOfBirth = dateOfBirth;
             return this;
        }

    

        /**
         * 国籍id
         * <p> 示例值：123456789
         * @param nationalityId
         * @return
         */
        public Builder nationalityId(String nationalityId) {
             this.nationalityId = nationalityId;
             return this;
        }

    

        /**
         * 国籍 ID，可通过【查询国籍信息】接口查询
         * <p> 示例值：7075702732803278380
         * @param nationalityIdV2
         * @return
         */
        public Builder nationalityIdV2(String nationalityIdV2) {
             this.nationalityIdV2 = nationalityIdV2;
             return this;
        }

    

        /**
         * 民族 / 种族，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)民族（race）枚举定义部分获得
         * <p> 示例值：
         * @param race
         * @return
         */
        public Builder race(Enum race) {
             this.race = race;
             return this;
        }

    

        /**
         * 婚姻状况，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)婚姻状况（marital_status）枚举定义部分获得
         * <p> 示例值：
         * @param maritalStatus
         * @return
         */
        public Builder maritalStatus(Enum maritalStatus) {
             this.maritalStatus = maritalStatus;
             return this;
        }

    

        /**
         * 电话列表，只有当满足下面所有条件时，电话在个人信息页才可见:;- 电话号码不为空;- is_primary = "true" ;- phone_usage = "home"
         * <p> 示例值：
         * @param phoneList
         * @return
         */
        public Builder phoneList(Phone[] phoneList) {
             this.phoneList = phoneList;
             return this;
        }

    

        /**
         * 地址列表
         * <p> 示例值：
         * @param addressList
         * @return
         */
        public Builder addressList(Address[] addressList) {
             this.addressList = addressList;
             return this;
        }

    

        /**
         * 邮箱列表
         * <p> 示例值：
         * @param emailList
         * @return
         */
        public Builder emailList(Email[] emailList) {
             this.emailList = emailList;
             return this;
        }

    

        /**
         * 工作履历列表
         * <p> 示例值：
         * @param workExperienceList
         * @return
         */
        public Builder workExperienceList(WorkExperience[] workExperienceList) {
             this.workExperienceList = workExperienceList;
             return this;
        }

    

        /**
         * 教育经历列表
         * <p> 示例值：
         * @param educationList
         * @return
         */
        public Builder educationList(Education[] educationList) {
             this.educationList = educationList;
             return this;
        }

    

        /**
         * 银行账号
         * <p> 示例值：
         * @param bankAccountList
         * @return
         */
        public Builder bankAccountList(BankAccount[] bankAccountList) {
             this.bankAccountList = bankAccountList;
             return this;
        }

    

        /**
         * 证件号码
         * <p> 示例值：
         * @param nationalIdList
         * @return
         */
        public Builder nationalIdList(NationalId[] nationalIdList) {
             this.nationalIdList = nationalIdList;
             return this;
        }

    

        /**
         * 亲属列表
         * <p> 示例值：
         * @param dependentList
         * @return
         */
        public Builder dependentList(Dependent[] dependentList) {
             this.dependentList = dependentList;
             return this;
        }

    

        /**
         * 紧急联系人列表
         * <p> 示例值：
         * @param emergencyContactList
         * @return
         */
        public Builder emergencyContactList(EmergencyContact[] emergencyContactList) {
             this.emergencyContactList = emergencyContactList;
             return this;
        }

    

        /**
         * 参加工作日期
         * <p> 示例值：2020-10-01
         * @param dateEnteredWorkforce
         * @return
         */
        public Builder dateEnteredWorkforce(String dateEnteredWorkforce) {
             this.dateEnteredWorkforce = dateEnteredWorkforce;
             return this;
        }

    

        /**
         * 头像资源的 ID
         * <p> 示例值：dfysuc8x76dsfsw
         * @param profileImageId
         * @return
         */
        public Builder profileImageId(String profileImageId) {
             this.profileImageId = profileImageId;
             return this;
        }

    

        /**
         * 自定义字段
         * <p> 示例值：
         * @param customFields
         * @return
         */
        public Builder customFields(ObjectFieldData[] customFields) {
             this.customFields = customFields;
             return this;
        }

    

        /**
         * 邮箱
         * <p> 示例值：test@163.com
         * @param emailAddress
         * @return
         */
        public Builder emailAddress(String emailAddress) {
             this.emailAddress = emailAddress;
             return this;
        }

    

        /**
         * 纳税身份信息
         * <p> 示例值：["1", "2"]
         * @param residentTaxIdList
         * @return
         */
        public Builder residentTaxIdList(String[] residentTaxIdList) {
             this.residentTaxIdList = residentTaxIdList;
             return this;
        }

    

        /**
         * 年龄
         * <p> 示例值：25
         * @param age
         * @return
         */
        public Builder age(Integer age) {
             this.age = age;
             return this;
        }

    

        /**
         * 最高学历教育
         * <p> 示例值：
         * @param highestLevelOfEducation
         * @return
         */
        public Builder highestLevelOfEducation(Education highestLevelOfEducation) {
             this.highestLevelOfEducation = highestLevelOfEducation;
             return this;
        }

    

        /**
         * 最高学位教育经历
         * <p> 示例值：
         * @param highestDegreeOfEducation
         * @return
         */
        public Builder highestDegreeOfEducation(Education highestDegreeOfEducation) {
             this.highestDegreeOfEducation = highestDegreeOfEducation;
             return this;
        }

    

        /**
         * 个人资料
         * <p> 示例值：
         * @param personalProfile
         * @return
         */
        public Builder personalProfile(PersonalProfile[] personalProfile) {
             this.personalProfile = personalProfile;
             return this;
        }

    
    
    public Person build(){
        return new Person(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
