// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class PersonInfoChn {
     /**
      * 个人附加信息 ID
      * <p> 示例值：6950635856373745165
      */
    @SerializedName("id")
    private String id;
     /**
      * 籍贯 ID;- 枚举值可通过「查询单条省份/行政区信息」接口获取
      * <p> 示例值：6863326263973512712
      */
    @SerializedName("native_region")
    private String nativeRegion;
     /**
      * 政治面貌，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)政治面貌（political_affiliation）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("political_affiliation_list")
    private Enum[] politicalAffiliationList;
     /**
      * 户口类型，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)户口类型（hukou_type）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("hukou_type")
    private Enum hukouType;
     /**
      * 户口所在地
      * <p> 示例值：山东省平阴县
      */
    @SerializedName("hukou_location")
    private String hukouLocation;
     /**
      * Person ID
      * <p> 示例值：6919733647952053768
      */
    @SerializedName("person_id")
    private String personId;
     /**
      * 自定义字段
      * <p> 示例值：
      */
    @SerializedName("custom_fields")
    private ObjectFieldData[] customFields;
     /**
      * 工龄
      * <p> 示例值：2
      */
    @SerializedName("working_years")
    private Integer workingYears;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNativeRegion() {
        return this.nativeRegion;
    }

    public void setNativeRegion(String nativeRegion) {
        this.nativeRegion = nativeRegion;
    }

    public Enum[] getPoliticalAffiliationList() {
        return this.politicalAffiliationList;
    }

    public void setPoliticalAffiliationList(Enum[] politicalAffiliationList) {
        this.politicalAffiliationList = politicalAffiliationList;
    }

    public Enum getHukouType() {
        return this.hukouType;
    }

    public void setHukouType(Enum hukouType) {
        this.hukouType = hukouType;
    }

    public String getHukouLocation() {
        return this.hukouLocation;
    }

    public void setHukouLocation(String hukouLocation) {
        this.hukouLocation = hukouLocation;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public ObjectFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(ObjectFieldData[] customFields) {
        this.customFields = customFields;
    }

    public Integer getWorkingYears() {
        return this.workingYears;
    }

    public void setWorkingYears(Integer workingYears) {
        this.workingYears = workingYears;
    }


// builder 开始
  public PersonInfoChn(){}

  public PersonInfoChn(Builder builder){
         /**
          * 个人附加信息 ID
          * <p> 示例值：6950635856373745165
          */
      this.id = builder.id;
         /**
          * 籍贯 ID;- 枚举值可通过「查询单条省份/行政区信息」接口获取
          * <p> 示例值：6863326263973512712
          */
      this.nativeRegion = builder.nativeRegion;
         /**
          * 政治面貌，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)政治面貌（political_affiliation）枚举定义部分获得
          * <p> 示例值：
          */
      this.politicalAffiliationList = builder.politicalAffiliationList;
         /**
          * 户口类型，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)户口类型（hukou_type）枚举定义部分获得
          * <p> 示例值：
          */
      this.hukouType = builder.hukouType;
         /**
          * 户口所在地
          * <p> 示例值：山东省平阴县
          */
      this.hukouLocation = builder.hukouLocation;
         /**
          * Person ID
          * <p> 示例值：6919733647952053768
          */
      this.personId = builder.personId;
         /**
          * 自定义字段
          * <p> 示例值：
          */
      this.customFields = builder.customFields;
         /**
          * 工龄
          * <p> 示例值：2
          */
      this.workingYears = builder.workingYears;
  }

    public static class Builder {
     /**
      * 个人附加信息 ID
      * <p> 示例值：6950635856373745165
      */
        private String id;
     /**
      * 籍贯 ID;- 枚举值可通过「查询单条省份/行政区信息」接口获取
      * <p> 示例值：6863326263973512712
      */
        private String nativeRegion;
     /**
      * 政治面貌，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)政治面貌（political_affiliation）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum[] politicalAffiliationList;
     /**
      * 户口类型，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)户口类型（hukou_type）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum hukouType;
     /**
      * 户口所在地
      * <p> 示例值：山东省平阴县
      */
        private String hukouLocation;
     /**
      * Person ID
      * <p> 示例值：6919733647952053768
      */
        private String personId;
     /**
      * 自定义字段
      * <p> 示例值：
      */
        private ObjectFieldData[] customFields;
     /**
      * 工龄
      * <p> 示例值：2
      */
        private Integer workingYears;

        /**
         * 个人附加信息 ID
         * <p> 示例值：6950635856373745165
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 籍贯 ID;- 枚举值可通过「查询单条省份/行政区信息」接口获取
         * <p> 示例值：6863326263973512712
         * @param nativeRegion
         * @return
         */
        public Builder nativeRegion(String nativeRegion) {
             this.nativeRegion = nativeRegion;
             return this;
        }

    

        /**
         * 政治面貌，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)政治面貌（political_affiliation）枚举定义部分获得
         * <p> 示例值：
         * @param politicalAffiliationList
         * @return
         */
        public Builder politicalAffiliationList(Enum[] politicalAffiliationList) {
             this.politicalAffiliationList = politicalAffiliationList;
             return this;
        }

    

        /**
         * 户口类型，枚举值可通过文档[【飞书人事枚举常量】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/feishu-people-enum-constant)户口类型（hukou_type）枚举定义部分获得
         * <p> 示例值：
         * @param hukouType
         * @return
         */
        public Builder hukouType(Enum hukouType) {
             this.hukouType = hukouType;
             return this;
        }

    

        /**
         * 户口所在地
         * <p> 示例值：山东省平阴县
         * @param hukouLocation
         * @return
         */
        public Builder hukouLocation(String hukouLocation) {
             this.hukouLocation = hukouLocation;
             return this;
        }

    

        /**
         * Person ID
         * <p> 示例值：6919733647952053768
         * @param personId
         * @return
         */
        public Builder personId(String personId) {
             this.personId = personId;
             return this;
        }

    

        /**
         * 自定义字段
         * <p> 示例值：
         * @param customFields
         * @return
         */
        public Builder customFields(ObjectFieldData[] customFields) {
             this.customFields = customFields;
             return this;
        }

    

        /**
         * 工龄
         * <p> 示例值：2
         * @param workingYears
         * @return
         */
        public Builder workingYears(Integer workingYears) {
             this.workingYears = workingYears;
             return this;
        }

    
    
    public PersonInfoChn build(){
        return new PersonInfoChn(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
