// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Department {
     /**
      * 部门 ID
      * <p> 示例值：4719456877659520852
      */
    @SerializedName("id")
    private String id;
     /**
      * 部门记录版本 ID
      * <p> 示例值：6890452208593372611
      */
    @SerializedName("version_id")
    private String versionId;
     /**
      * 部门名称
      * <p> 示例值：
      */
    @SerializedName("department_name")
    private I18n[] departmentName;
     /**
      * 部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("sub_type")
    private Enum subType;
     /**
      * 上级部门 ID
      * <p> 示例值：4719456877659520111
      */
    @SerializedName("parent_department_id")
    private String parentDepartmentId;
     /**
      * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
      * <p> 示例值：6893013238632416777
      */
    @SerializedName("manager")
    private String manager;
     /**
      * 树形排序，代表同层级的部门排序序号
      * <p> 示例值：001000
      */
    @SerializedName("tree_order")
    private String treeOrder;
     /**
      * 列表排序，代表所有部门的混排序号
      * <p> 示例值：001000-001000
      */
    @SerializedName("list_order")
    private String listOrder;
     /**
      * 编码
      * <p> 示例值：D00000456
      */
    @SerializedName("code")
    private String code;
     /**
      * 是否根部门
      * <p> 示例值：false
      */
    @SerializedName("is_root")
    private Boolean isRoot;
     /**
      * 是否保密
      * <p> 示例值：false
      */
    @SerializedName("is_confidential")
    private Boolean isConfidential;
     /**
      * 生效日期
      * <p> 示例值：2020-05-01
      */
    @SerializedName("effective_date")
    private String effectiveDate;
     /**
      * 失效日期
      * <p> 示例值：2020-05-02
      */
    @SerializedName("expiration_date")
    private String expirationDate;
     /**
      * 是否启用
      * <p> 示例值：true
      */
    @SerializedName("active")
    private Boolean active;
     /**
      * 描述
      * <p> 示例值：
      */
    @SerializedName("description")
    private I18n[] description;
     /**
      * 自定义字段
      * <p> 示例值：
      */
    @SerializedName("custom_fields")
    private CustomFieldData[] customFields;
     /**
      * 是否使用职务
      * <p> 示例值：
      */
    @SerializedName("staffing_model")
    private Enum staffingModel;
     /**
      * 成本中心id
      * <p> 示例值：7142384817131652652
      */
    @SerializedName("cost_center_id")
    private String costCenterId;
     /**
      * 创建时间
      * <p> 示例值：2020-05-01 00:00:00
      */
    @SerializedName("created_time")
    private String createdTime;
     /**
      * 更新时间
      * <p> 示例值：2020-05-02 00:00:00
      */
    @SerializedName("updated_time")
    private String updatedTime;
     /**
      * 创建人
      * <p> 示例值：6893013238632416777
      */
    @SerializedName("created_by")
    private String createdBy;
     /**
      * 更新人
      * <p> 示例值：6893013238632416777
      */
    @SerializedName("updated_by")
    private String updatedBy;
     /**
      * 记录创建时间
      * <p> 示例值：2020-05-01 00:00:00
      */
    @SerializedName("record_created_time")
    private String recordCreatedTime;
     /**
      * 记录更新时间
      * <p> 示例值：2020-05-02 00:00:00
      */
    @SerializedName("record_updated_time")
    private String recordUpdatedTime;
     /**
      * 记录创建人
      * <p> 示例值：6893013238632416777
      */
    @SerializedName("record_created_by")
    private String recordCreatedBy;
     /**
      * 记录更新人
      * <p> 示例值：6893013238632416777
      */
    @SerializedName("record_updated_by")
    private String recordUpdatedBy;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public I18n[] getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(I18n[] departmentName) {
        this.departmentName = departmentName;
    }

    public Enum getSubType() {
        return this.subType;
    }

    public void setSubType(Enum subType) {
        this.subType = subType;
    }

    public String getParentDepartmentId() {
        return this.parentDepartmentId;
    }

    public void setParentDepartmentId(String parentDepartmentId) {
        this.parentDepartmentId = parentDepartmentId;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getTreeOrder() {
        return this.treeOrder;
    }

    public void setTreeOrder(String treeOrder) {
        this.treeOrder = treeOrder;
    }

    public String getListOrder() {
        return this.listOrder;
    }

    public void setListOrder(String listOrder) {
        this.listOrder = listOrder;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getIsRoot() {
        return this.isRoot;
    }

    public void setIsRoot(Boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Boolean getIsConfidential() {
        return this.isConfidential;
    }

    public void setIsConfidential(Boolean isConfidential) {
        this.isConfidential = isConfidential;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public I18n[] getDescription() {
        return this.description;
    }

    public void setDescription(I18n[] description) {
        this.description = description;
    }

    public CustomFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomFieldData[] customFields) {
        this.customFields = customFields;
    }

    public Enum getStaffingModel() {
        return this.staffingModel;
    }

    public void setStaffingModel(Enum staffingModel) {
        this.staffingModel = staffingModel;
    }

    public String getCostCenterId() {
        return this.costCenterId;
    }

    public void setCostCenterId(String costCenterId) {
        this.costCenterId = costCenterId;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(String updatedTime) {
        this.updatedTime = updatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public String getRecordCreatedTime() {
        return this.recordCreatedTime;
    }

    public void setRecordCreatedTime(String recordCreatedTime) {
        this.recordCreatedTime = recordCreatedTime;
    }

    public String getRecordUpdatedTime() {
        return this.recordUpdatedTime;
    }

    public void setRecordUpdatedTime(String recordUpdatedTime) {
        this.recordUpdatedTime = recordUpdatedTime;
    }

    public String getRecordCreatedBy() {
        return this.recordCreatedBy;
    }

    public void setRecordCreatedBy(String recordCreatedBy) {
        this.recordCreatedBy = recordCreatedBy;
    }

    public String getRecordUpdatedBy() {
        return this.recordUpdatedBy;
    }

    public void setRecordUpdatedBy(String recordUpdatedBy) {
        this.recordUpdatedBy = recordUpdatedBy;
    }


// builder 开始
  public Department(){}

  public Department(Builder builder){
         /**
          * 部门 ID
          * <p> 示例值：4719456877659520852
          */
      this.id = builder.id;
         /**
          * 部门记录版本 ID
          * <p> 示例值：6890452208593372611
          */
      this.versionId = builder.versionId;
         /**
          * 部门名称
          * <p> 示例值：
          */
      this.departmentName = builder.departmentName;
         /**
          * 部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
          * <p> 示例值：
          */
      this.subType = builder.subType;
         /**
          * 上级部门 ID
          * <p> 示例值：4719456877659520111
          */
      this.parentDepartmentId = builder.parentDepartmentId;
         /**
          * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
          * <p> 示例值：6893013238632416777
          */
      this.manager = builder.manager;
         /**
          * 树形排序，代表同层级的部门排序序号
          * <p> 示例值：001000
          */
      this.treeOrder = builder.treeOrder;
         /**
          * 列表排序，代表所有部门的混排序号
          * <p> 示例值：001000-001000
          */
      this.listOrder = builder.listOrder;
         /**
          * 编码
          * <p> 示例值：D00000456
          */
      this.code = builder.code;
         /**
          * 是否根部门
          * <p> 示例值：false
          */
      this.isRoot = builder.isRoot;
         /**
          * 是否保密
          * <p> 示例值：false
          */
      this.isConfidential = builder.isConfidential;
         /**
          * 生效日期
          * <p> 示例值：2020-05-01
          */
      this.effectiveDate = builder.effectiveDate;
         /**
          * 失效日期
          * <p> 示例值：2020-05-02
          */
      this.expirationDate = builder.expirationDate;
         /**
          * 是否启用
          * <p> 示例值：true
          */
      this.active = builder.active;
         /**
          * 描述
          * <p> 示例值：
          */
      this.description = builder.description;
         /**
          * 自定义字段
          * <p> 示例值：
          */
      this.customFields = builder.customFields;
         /**
          * 是否使用职务
          * <p> 示例值：
          */
      this.staffingModel = builder.staffingModel;
         /**
          * 成本中心id
          * <p> 示例值：7142384817131652652
          */
      this.costCenterId = builder.costCenterId;
         /**
          * 创建时间
          * <p> 示例值：2020-05-01 00:00:00
          */
      this.createdTime = builder.createdTime;
         /**
          * 更新时间
          * <p> 示例值：2020-05-02 00:00:00
          */
      this.updatedTime = builder.updatedTime;
         /**
          * 创建人
          * <p> 示例值：6893013238632416777
          */
      this.createdBy = builder.createdBy;
         /**
          * 更新人
          * <p> 示例值：6893013238632416777
          */
      this.updatedBy = builder.updatedBy;
         /**
          * 记录创建时间
          * <p> 示例值：2020-05-01 00:00:00
          */
      this.recordCreatedTime = builder.recordCreatedTime;
         /**
          * 记录更新时间
          * <p> 示例值：2020-05-02 00:00:00
          */
      this.recordUpdatedTime = builder.recordUpdatedTime;
         /**
          * 记录创建人
          * <p> 示例值：6893013238632416777
          */
      this.recordCreatedBy = builder.recordCreatedBy;
         /**
          * 记录更新人
          * <p> 示例值：6893013238632416777
          */
      this.recordUpdatedBy = builder.recordUpdatedBy;
  }

    public static class Builder {
     /**
      * 部门 ID
      * <p> 示例值：4719456877659520852
      */
        private String id;
     /**
      * 部门记录版本 ID
      * <p> 示例值：6890452208593372611
      */
        private String versionId;
     /**
      * 部门名称
      * <p> 示例值：
      */
        private I18n[] departmentName;
     /**
      * 部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum subType;
     /**
      * 上级部门 ID
      * <p> 示例值：4719456877659520111
      */
        private String parentDepartmentId;
     /**
      * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
      * <p> 示例值：6893013238632416777
      */
        private String manager;
     /**
      * 树形排序，代表同层级的部门排序序号
      * <p> 示例值：001000
      */
        private String treeOrder;
     /**
      * 列表排序，代表所有部门的混排序号
      * <p> 示例值：001000-001000
      */
        private String listOrder;
     /**
      * 编码
      * <p> 示例值：D00000456
      */
        private String code;
     /**
      * 是否根部门
      * <p> 示例值：false
      */
        private Boolean isRoot;
     /**
      * 是否保密
      * <p> 示例值：false
      */
        private Boolean isConfidential;
     /**
      * 生效日期
      * <p> 示例值：2020-05-01
      */
        private String effectiveDate;
     /**
      * 失效日期
      * <p> 示例值：2020-05-02
      */
        private String expirationDate;
     /**
      * 是否启用
      * <p> 示例值：true
      */
        private Boolean active;
     /**
      * 描述
      * <p> 示例值：
      */
        private I18n[] description;
     /**
      * 自定义字段
      * <p> 示例值：
      */
        private CustomFieldData[] customFields;
     /**
      * 是否使用职务
      * <p> 示例值：
      */
        private Enum staffingModel;
     /**
      * 成本中心id
      * <p> 示例值：7142384817131652652
      */
        private String costCenterId;
     /**
      * 创建时间
      * <p> 示例值：2020-05-01 00:00:00
      */
        private String createdTime;
     /**
      * 更新时间
      * <p> 示例值：2020-05-02 00:00:00
      */
        private String updatedTime;
     /**
      * 创建人
      * <p> 示例值：6893013238632416777
      */
        private String createdBy;
     /**
      * 更新人
      * <p> 示例值：6893013238632416777
      */
        private String updatedBy;
     /**
      * 记录创建时间
      * <p> 示例值：2020-05-01 00:00:00
      */
        private String recordCreatedTime;
     /**
      * 记录更新时间
      * <p> 示例值：2020-05-02 00:00:00
      */
        private String recordUpdatedTime;
     /**
      * 记录创建人
      * <p> 示例值：6893013238632416777
      */
        private String recordCreatedBy;
     /**
      * 记录更新人
      * <p> 示例值：6893013238632416777
      */
        private String recordUpdatedBy;

        /**
         * 部门 ID
         * <p> 示例值：4719456877659520852
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 部门记录版本 ID
         * <p> 示例值：6890452208593372611
         * @param versionId
         * @return
         */
        public Builder versionId(String versionId) {
             this.versionId = versionId;
             return this;
        }

    

        /**
         * 部门名称
         * <p> 示例值：
         * @param departmentName
         * @return
         */
        public Builder departmentName(I18n[] departmentName) {
             this.departmentName = departmentName;
             return this;
        }

    

        /**
         * 部门类型，枚举值可通过文档【飞书人事枚举常量】部门子类型（department_sub_type）枚举定义部分获得
         * <p> 示例值：
         * @param subType
         * @return
         */
        public Builder subType(Enum subType) {
             this.subType = subType;
             return this;
        }

    

        /**
         * 上级部门 ID
         * <p> 示例值：4719456877659520111
         * @param parentDepartmentId
         * @return
         */
        public Builder parentDepartmentId(String parentDepartmentId) {
             this.parentDepartmentId = parentDepartmentId;
             return this;
        }

    

        /**
         * 部门负责人雇佣 ID，枚举值及详细信息可通过【查询员工信息】接口查询获得
         * <p> 示例值：6893013238632416777
         * @param manager
         * @return
         */
        public Builder manager(String manager) {
             this.manager = manager;
             return this;
        }

    

        /**
         * 树形排序，代表同层级的部门排序序号
         * <p> 示例值：001000
         * @param treeOrder
         * @return
         */
        public Builder treeOrder(String treeOrder) {
             this.treeOrder = treeOrder;
             return this;
        }

    

        /**
         * 列表排序，代表所有部门的混排序号
         * <p> 示例值：001000-001000
         * @param listOrder
         * @return
         */
        public Builder listOrder(String listOrder) {
             this.listOrder = listOrder;
             return this;
        }

    

        /**
         * 编码
         * <p> 示例值：D00000456
         * @param code
         * @return
         */
        public Builder code(String code) {
             this.code = code;
             return this;
        }

    

        /**
         * 是否根部门
         * <p> 示例值：false
         * @param isRoot
         * @return
         */
        public Builder isRoot(Boolean isRoot) {
             this.isRoot = isRoot;
             return this;
        }

    

        /**
         * 是否保密
         * <p> 示例值：false
         * @param isConfidential
         * @return
         */
        public Builder isConfidential(Boolean isConfidential) {
             this.isConfidential = isConfidential;
             return this;
        }

    

        /**
         * 生效日期
         * <p> 示例值：2020-05-01
         * @param effectiveDate
         * @return
         */
        public Builder effectiveDate(String effectiveDate) {
             this.effectiveDate = effectiveDate;
             return this;
        }

    

        /**
         * 失效日期
         * <p> 示例值：2020-05-02
         * @param expirationDate
         * @return
         */
        public Builder expirationDate(String expirationDate) {
             this.expirationDate = expirationDate;
             return this;
        }

    

        /**
         * 是否启用
         * <p> 示例值：true
         * @param active
         * @return
         */
        public Builder active(Boolean active) {
             this.active = active;
             return this;
        }

    

        /**
         * 描述
         * <p> 示例值：
         * @param description
         * @return
         */
        public Builder description(I18n[] description) {
             this.description = description;
             return this;
        }

    

        /**
         * 自定义字段
         * <p> 示例值：
         * @param customFields
         * @return
         */
        public Builder customFields(CustomFieldData[] customFields) {
             this.customFields = customFields;
             return this;
        }

    

        /**
         * 是否使用职务
         * <p> 示例值：
         * @param staffingModel
         * @return
         */
        public Builder staffingModel(Enum staffingModel) {
             this.staffingModel = staffingModel;
             return this;
        }

    

        /**
         * 成本中心id
         * <p> 示例值：7142384817131652652
         * @param costCenterId
         * @return
         */
        public Builder costCenterId(String costCenterId) {
             this.costCenterId = costCenterId;
             return this;
        }

    

        /**
         * 创建时间
         * <p> 示例值：2020-05-01 00:00:00
         * @param createdTime
         * @return
         */
        public Builder createdTime(String createdTime) {
             this.createdTime = createdTime;
             return this;
        }

    

        /**
         * 更新时间
         * <p> 示例值：2020-05-02 00:00:00
         * @param updatedTime
         * @return
         */
        public Builder updatedTime(String updatedTime) {
             this.updatedTime = updatedTime;
             return this;
        }

    

        /**
         * 创建人
         * <p> 示例值：6893013238632416777
         * @param createdBy
         * @return
         */
        public Builder createdBy(String createdBy) {
             this.createdBy = createdBy;
             return this;
        }

    

        /**
         * 更新人
         * <p> 示例值：6893013238632416777
         * @param updatedBy
         * @return
         */
        public Builder updatedBy(String updatedBy) {
             this.updatedBy = updatedBy;
             return this;
        }

    

        /**
         * 记录创建时间
         * <p> 示例值：2020-05-01 00:00:00
         * @param recordCreatedTime
         * @return
         */
        public Builder recordCreatedTime(String recordCreatedTime) {
             this.recordCreatedTime = recordCreatedTime;
             return this;
        }

    

        /**
         * 记录更新时间
         * <p> 示例值：2020-05-02 00:00:00
         * @param recordUpdatedTime
         * @return
         */
        public Builder recordUpdatedTime(String recordUpdatedTime) {
             this.recordUpdatedTime = recordUpdatedTime;
             return this;
        }

    

        /**
         * 记录创建人
         * <p> 示例值：6893013238632416777
         * @param recordCreatedBy
         * @return
         */
        public Builder recordCreatedBy(String recordCreatedBy) {
             this.recordCreatedBy = recordCreatedBy;
             return this;
        }

    

        /**
         * 记录更新人
         * <p> 示例值：6893013238632416777
         * @param recordUpdatedBy
         * @return
         */
        public Builder recordUpdatedBy(String recordUpdatedBy) {
             this.recordUpdatedBy = recordUpdatedBy;
             return this;
        }

    
    
    public Department build(){
        return new Department(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
