// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Employee {
     /**
      * 雇佣 ID;- 类型与 user_id_type 一致;- 请使用 employment_id_v2
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("employment_id")
    private String employmentId;
     /**
      * 雇佣 ID;- 类型与 user_id_type 一致，转换失败时返回空值
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("employment_id_v2")
    private String employmentIdV2;
     /**
      * 招聘投递 ID ，详细信息可以通过【获取投递信息】接口查询获得
      * <p> 示例值：6838119494196871234
      */
    @SerializedName("ats_application_id")
    private String atsApplicationId;
     /**
      * 待入职 ID
      * <p> 示例值：7023239238976141133
      */
    @SerializedName("prehire_id")
    private String prehireId;
     /**
      * 工号
      * <p> 示例值：1000000
      */
    @SerializedName("employee_number")
    private String employeeNumber;
     /**
      * 人员类型 ID，详细信息可通过【查询单个人员类型】接口获得
      * <p> 示例值：6971090097697521314
      */
    @SerializedName("employee_type_id")
    private String employeeTypeId;
     /**
      * 人员子类型 ID
      * <p> 示例值：6971090097697521317
      */
    @SerializedName("employee_subtype_id")
    private String employeeSubtypeId;
     /**
      * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致;- 请使用 department_id_v2
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("department_id")
    private String departmentId;
     /**
      * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致，转换失败时返回空值
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("department_id_v2")
    private String departmentIdV2;
     /**
      * 职级 ID，详细信息可通过【查询单个职务级别】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("job_level_id")
    private String jobLevelId;
     /**
      * 职级
      * <p> 示例值：
      */
    @SerializedName("job_level")
    private EmployeeJobLevel jobLevel;
     /**
      * 通道 ID
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("pathway_id")
    private String pathwayId;
     /**
      * 通道
      * <p> 示例值：
      */
    @SerializedName("pathway")
    private EmployeePathway pathway;
     /**
      * 职等 ID
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("job_grade_id")
    private String jobGradeId;
     /**
      * 工作地点 ID，详细信息可通过【查询单个地点】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("work_location_id")
    private String workLocationId;
     /**
      * 序列 ID，详细信息可通过【查询单个职务序列】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("job_family_id")
    private String jobFamilyId;
     /**
      * 序列
      * <p> 示例值：
      */
    @SerializedName("job_family")
    private EmployeeJobFamily jobFamily;
     /**
      * 岗位 ID，详细信息可通过【查询单个岗位】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("position_id")
    private String positionId;
     /**
      * 岗位
      * <p> 示例值：
      */
    @SerializedName("position")
    private Position position;
     /**
      * 职务 ID，详细信息可通过【查询单个职务】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("job_id")
    private String jobId;
     /**
      * 职务
      * <p> 示例值：
      */
    @SerializedName("job")
    private Job job;
     /**
      * 所属公司 ID，详细信息可通过【查询单个公司】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("company_id")
    private String companyId;
     /**
      * 工时制度 ID，详细信息可通过【查询单个工时制度】接口获得
      * <p> 示例值：6893014062142064135
      */
    @SerializedName("working_hours_type_id")
    private String workingHoursTypeId;
     /**
      * 司龄
      * <p> 示例值：0.01
      */
    @SerializedName("tenure")
    private String tenure;
     /**
      * 资历起算日期
      * <p> 示例值：2021-03-16
      */
    @SerializedName("seniority_date")
    private String seniorityDate;
     /**
      * 当前雇佣记录的入职日期
      * <p> 示例值：2021-03-16
      */
    @SerializedName("effective_date")
    private String effectiveDate;
     /**
      * 是否是主雇佣信息
      * <p> 示例值：true
      */
    @SerializedName("primary_employment")
    private Boolean primaryEmployment;
     /**
      * 试用期时长（月）
      * <p> 示例值：16
      */
    @SerializedName("probation_period")
    private Integer probationPeriod;
     /**
      * 是否在试用期中
      * <p> 示例值：true
      */
    @SerializedName("on_probation")
    private Boolean onProbation;
     /**
      * 试用期结束日期（实际结束日期）
      * <p> 示例值：2022-08-01
      */
    @SerializedName("probation_end_date")
    private String probationEndDate;
     /**
      * 直接上级的雇佣 ID;- 类型与 user_id_type 一致;- 请使用 direct_manager_id_v2
      * <p> 示例值：7027024823985411287
      */
    @SerializedName("direct_manager_id")
    private String directManagerId;
     /**
      * 虚线上级的雇佣 ID; - 类型与 user_id_type 一致; - 请使用 dotted_line_manager_id_v2
      * <p> 示例值：7027024823985411782
      */
    @SerializedName("dotted_line_manager_id")
    private String dottedLineManagerId;
     /**
      * 直接上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
      * <p> 示例值：7027024823985411287
      */
    @SerializedName("direct_manager_id_v2")
    private String directManagerIdV2;
     /**
      * 虚线上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
      * <p> 示例值：7027024823985411782
      */
    @SerializedName("dotted_line_manager_id_v2")
    private String dottedLineManagerIdV2;
     /**
      * 雇佣类型，枚举值可通过文档【飞书人事枚举常量】雇佣类型（employment_type）枚举定义获得
      * <p> 示例值：
      */
    @SerializedName("employment_type")
    private Enum employmentType;
     /**
      * 雇佣状态，枚举值可通过文档【飞书人事枚举常量】雇员状态（employment_status）枚举定义获得
      * <p> 示例值：
      */
    @SerializedName("employment_status")
    private Enum employmentStatus;
     /**
      * 离职日期，即员工的最后一个工作日，最后一个工作日时员工的雇佣状态仍为“在职”，次日凌晨将更改为“离职”
      * <p> 示例值：2022-08-16
      */
    @SerializedName("expiration_date")
    private String expirationDate;
     /**
      * 离职原因，枚举值可通过文档【飞书人事枚举常量】离职原因（reason_for_offboarding）枚举定义部分获得
      * <p> 示例值：
      */
    @SerializedName("reason_for_offboarding")
    private Enum reasonForOffboarding;
     /**
      * 邮箱地址
      * <p> 示例值：test@163.com
      */
    @SerializedName("email_address")
    private String emailAddress;
     /**
      * 对应老People user_name字段，仅支持字节租户
      * <p> 示例值：test
      */
    @SerializedName("user_name")
    private String userName;
     /**
      * 工作邮箱列表，只有当邮箱满足下面所有条件时，才在个人信息页面可见
      * <p> 示例值：
      */
    @SerializedName("work_email_list")
    private WorkEmail[] workEmailList;
     /**
      * 成本中心列表
      * <p> 示例值：
      */
    @SerializedName("cost_center_list")
    private JobDataCostCenter[] costCenterList;
     /**
      * 是否离职重聘
      * <p> 示例值：
      */
    @SerializedName("rehire")
    private Enum rehire;
     /**
      * 历史雇佣信息 ID，可以通过【查询单个雇佣信息】查询详细信息
      * <p> 示例值：7164286667866966659
      */
    @SerializedName("rehire_employment_id")
    private String rehireEmploymentId;
     /**
      * 基本个人信息
      * <p> 示例值：
      */
    @SerializedName("person_info")
    private PersonInfo personInfo;
     /**
      * 自定义字段
      * <p> 示例值：
      */
    @SerializedName("custom_fields")
    private CustomFieldData[] customFields;
     /**
      * 竞业状态，枚举值包括:1.竞业中；2.未竞业
      * <p> 示例值：
      */
    @SerializedName("noncompete_status")
    private Enum noncompeteStatus;
     /**
      * 是否历史离职人员
      * <p> 示例值：true
      */
    @SerializedName("past_offboarding")
    private Boolean pastOffboarding;
     /**
      * 转正式日期
      * <p> 示例值：2020-01-01
      */
    @SerializedName("regular_employee_start_date")
    private String regularEmployeeStartDate;
     /**
      * 外部系统 ID , 可存储租户系统中的员工 ID
      * <p> 示例值：10000000
      */
    @SerializedName("external_id")
    private String externalId;
     /**
      * 入职次数
      * <p> 示例值：16
      */
    @SerializedName("times_employed")
    private Integer timesEmployed;
     /**
      * 招聘来源，枚举值 api_name 可通过【获取自定义字段详情】接口查询
      * <p> 示例值：
      */
    @SerializedName("recruitment_type")
    private Enum recruitmentType;
     /**
      * 员工头像
      * <p> 示例值：https://internal-api-lark-file.feishu-boe.cn/static-resource/v1/v2_a550d36b-28ef-48ad-9e50-58004beb386j~?image_size=noop&cut_type=&quality=&format=png&sticker_format=.webp
      */
    @SerializedName("avatar_url")
    private String avatarUrl;
     /**
      * 主合同 ID
      * <p> 示例值：7164286667866966659
      */
    @SerializedName("primary_contract_id")
    private String primaryContractId;
     /**
      * 主合同开始日期
      * <p> 示例值：2020-01-01
      */
    @SerializedName("contract_start_date")
    private String contractStartDate;
     /**
      * 主合同到期日期
      * <p> 示例值：2020-01-01
      */
    @SerializedName("contract_end_date")
    private String contractEndDate;
     /**
      * 主合同预计到期日期
      * <p> 示例值：2020-01-01
      */
    @SerializedName("contract_expected_end_date")
    private String contractExpectedEndDate;
     /**
      * 所属薪资组 ID
      * <p> 示例值：7164286667866966659
      */
    @SerializedName("pay_group_id")
    private String payGroupId;
     /**
      * 所属外派薪资组 ID
      * <p> 示例值：7164286667866966659
      */
    @SerializedName("assignment_pay_group_id")
    private String assignmentPayGroupId;
     /**
      * 是否外派
      * <p> 示例值：true
      */
    @SerializedName("international_assignment")
    private Boolean internationalAssignment;
     /**
      * 工作日历 ID
      * <p> 示例值：7164286667866966659
      */
    @SerializedName("work_calendar_id")
    private String workCalendarId;
     /**
      * 部门基本信息
      * <p> 示例值：
      */
    @SerializedName("department")
    private BasicDepartment department;
     /**
      * 直接上级基本信息
      * <p> 示例值：
      */
    @SerializedName("direct_manager")
    private BasicEmployee directManager;
     /**
      * 虚线上级基本信息
      * <p> 示例值：
      */
    @SerializedName("dotted_line_manager")
    private BasicEmployee dottedLineManager;
     /**
      * 时区
      * <p> 示例值：Asia/Shanghai
      */
    @SerializedName("time_zone")
    private String timeZone;
     /**
      * 当前生效的外派记录
      * <p> 示例值：
      */
    @SerializedName("primary_international_assignment")
    private InternationalAssignment primaryInternationalAssignment;
     /**
      * 任职公司
      * <p> 示例值：7174374910734141112
      */
    @SerializedName("service_company")
    private String serviceCompany;
     /**
      * 薪资类型
      * <p> 示例值：
      */
    @SerializedName("compensation_type")
    private Enum compensationType;
     /**
      * 排班类型
      * <p> 示例值：
      */
    @SerializedName("work_shift")
    private Enum workShift;
     /**
      * 所属人才池
      * <p> 示例值：
      */
    @SerializedName("talent_pool_id_list")
    private String[] talentPoolIdList;
     /**
      * 自定义组织
      * <p> 示例值：{"custom_org_02":[{"id":"1","rate":"99"}]}
      */
    @SerializedName("custom_org")
    private String customOrg;
     /**
      * 司龄调整信息
      * <p> 示例值：
      */
    @SerializedName("seniority_adjust_information_list")
    private SeniorityAdjustInformation[] seniorityAdjustInformationList;
     /**
      * 员工直属 BP 信息，当员工所在部门、属地无 BP 时，会上钻找到最近的 BP
      * <p> 示例值：
      */
    @SerializedName("employment_direct_bps")
    private EmploymentBp employmentDirectBps;
     /**
      * 员工全部 BP 信息
      * <p> 示例值：
      */
    @SerializedName("employment_all_bps")
    private EmploymentBp employmentAllBps;
     /**
      * 当前所属合同类型;- 可通过[获取字段详情](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)查询;  - object_api_name：contract;  - custom_api_name：contract_type
      * <p> 示例值：
      */
    @SerializedName("contract_type")
    private Enum contractType;
     /**
      * 当前所属薪资方案 ID;- 可结合[批量查询薪资方案](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/plan/list)接口使用
      * <p> 示例值：123456789
      */
    @SerializedName("archive_cpst_plan_id")
    private String archiveCpstPlanId;
     /**
      * 当前所在考勤组 ID;- 可通过[按 ID 查询考勤组](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/attendance-v1/group/get)获取详情
      * <p> 示例值：123456789
      */
    @SerializedName("attendance_group_id")
    private String attendanceGroupId;
    public String getEmploymentId() {
        return this.employmentId;
    }

    public void setEmploymentId(String employmentId) {
        this.employmentId = employmentId;
    }

    public String getEmploymentIdV2() {
        return this.employmentIdV2;
    }

    public void setEmploymentIdV2(String employmentIdV2) {
        this.employmentIdV2 = employmentIdV2;
    }

    public String getAtsApplicationId() {
        return this.atsApplicationId;
    }

    public void setAtsApplicationId(String atsApplicationId) {
        this.atsApplicationId = atsApplicationId;
    }

    public String getPrehireId() {
        return this.prehireId;
    }

    public void setPrehireId(String prehireId) {
        this.prehireId = prehireId;
    }

    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public String getEmployeeTypeId() {
        return this.employeeTypeId;
    }

    public void setEmployeeTypeId(String employeeTypeId) {
        this.employeeTypeId = employeeTypeId;
    }

    public String getEmployeeSubtypeId() {
        return this.employeeSubtypeId;
    }

    public void setEmployeeSubtypeId(String employeeSubtypeId) {
        this.employeeSubtypeId = employeeSubtypeId;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentIdV2() {
        return this.departmentIdV2;
    }

    public void setDepartmentIdV2(String departmentIdV2) {
        this.departmentIdV2 = departmentIdV2;
    }

    public String getJobLevelId() {
        return this.jobLevelId;
    }

    public void setJobLevelId(String jobLevelId) {
        this.jobLevelId = jobLevelId;
    }

    public EmployeeJobLevel getJobLevel() {
        return this.jobLevel;
    }

    public void setJobLevel(EmployeeJobLevel jobLevel) {
        this.jobLevel = jobLevel;
    }

    public String getPathwayId() {
        return this.pathwayId;
    }

    public void setPathwayId(String pathwayId) {
        this.pathwayId = pathwayId;
    }

    public EmployeePathway getPathway() {
        return this.pathway;
    }

    public void setPathway(EmployeePathway pathway) {
        this.pathway = pathway;
    }

    public String getJobGradeId() {
        return this.jobGradeId;
    }

    public void setJobGradeId(String jobGradeId) {
        this.jobGradeId = jobGradeId;
    }

    public String getWorkLocationId() {
        return this.workLocationId;
    }

    public void setWorkLocationId(String workLocationId) {
        this.workLocationId = workLocationId;
    }

    public String getJobFamilyId() {
        return this.jobFamilyId;
    }

    public void setJobFamilyId(String jobFamilyId) {
        this.jobFamilyId = jobFamilyId;
    }

    public EmployeeJobFamily getJobFamily() {
        return this.jobFamily;
    }

    public void setJobFamily(EmployeeJobFamily jobFamily) {
        this.jobFamily = jobFamily;
    }

    public String getPositionId() {
        return this.positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getWorkingHoursTypeId() {
        return this.workingHoursTypeId;
    }

    public void setWorkingHoursTypeId(String workingHoursTypeId) {
        this.workingHoursTypeId = workingHoursTypeId;
    }

    public String getTenure() {
        return this.tenure;
    }

    public void setTenure(String tenure) {
        this.tenure = tenure;
    }

    public String getSeniorityDate() {
        return this.seniorityDate;
    }

    public void setSeniorityDate(String seniorityDate) {
        this.seniorityDate = seniorityDate;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Boolean getPrimaryEmployment() {
        return this.primaryEmployment;
    }

    public void setPrimaryEmployment(Boolean primaryEmployment) {
        this.primaryEmployment = primaryEmployment;
    }

    public Integer getProbationPeriod() {
        return this.probationPeriod;
    }

    public void setProbationPeriod(Integer probationPeriod) {
        this.probationPeriod = probationPeriod;
    }

    public Boolean getOnProbation() {
        return this.onProbation;
    }

    public void setOnProbation(Boolean onProbation) {
        this.onProbation = onProbation;
    }

    public String getProbationEndDate() {
        return this.probationEndDate;
    }

    public void setProbationEndDate(String probationEndDate) {
        this.probationEndDate = probationEndDate;
    }

    public String getDirectManagerId() {
        return this.directManagerId;
    }

    public void setDirectManagerId(String directManagerId) {
        this.directManagerId = directManagerId;
    }

    public String getDottedLineManagerId() {
        return this.dottedLineManagerId;
    }

    public void setDottedLineManagerId(String dottedLineManagerId) {
        this.dottedLineManagerId = dottedLineManagerId;
    }

    public String getDirectManagerIdV2() {
        return this.directManagerIdV2;
    }

    public void setDirectManagerIdV2(String directManagerIdV2) {
        this.directManagerIdV2 = directManagerIdV2;
    }

    public String getDottedLineManagerIdV2() {
        return this.dottedLineManagerIdV2;
    }

    public void setDottedLineManagerIdV2(String dottedLineManagerIdV2) {
        this.dottedLineManagerIdV2 = dottedLineManagerIdV2;
    }

    public Enum getEmploymentType() {
        return this.employmentType;
    }

    public void setEmploymentType(Enum employmentType) {
        this.employmentType = employmentType;
    }

    public Enum getEmploymentStatus() {
        return this.employmentStatus;
    }

    public void setEmploymentStatus(Enum employmentStatus) {
        this.employmentStatus = employmentStatus;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Enum getReasonForOffboarding() {
        return this.reasonForOffboarding;
    }

    public void setReasonForOffboarding(Enum reasonForOffboarding) {
        this.reasonForOffboarding = reasonForOffboarding;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public WorkEmail[] getWorkEmailList() {
        return this.workEmailList;
    }

    public void setWorkEmailList(WorkEmail[] workEmailList) {
        this.workEmailList = workEmailList;
    }

    public JobDataCostCenter[] getCostCenterList() {
        return this.costCenterList;
    }

    public void setCostCenterList(JobDataCostCenter[] costCenterList) {
        this.costCenterList = costCenterList;
    }

    public Enum getRehire() {
        return this.rehire;
    }

    public void setRehire(Enum rehire) {
        this.rehire = rehire;
    }

    public String getRehireEmploymentId() {
        return this.rehireEmploymentId;
    }

    public void setRehireEmploymentId(String rehireEmploymentId) {
        this.rehireEmploymentId = rehireEmploymentId;
    }

    public PersonInfo getPersonInfo() {
        return this.personInfo;
    }

    public void setPersonInfo(PersonInfo personInfo) {
        this.personInfo = personInfo;
    }

    public CustomFieldData[] getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(CustomFieldData[] customFields) {
        this.customFields = customFields;
    }

    public Enum getNoncompeteStatus() {
        return this.noncompeteStatus;
    }

    public void setNoncompeteStatus(Enum noncompeteStatus) {
        this.noncompeteStatus = noncompeteStatus;
    }

    public Boolean getPastOffboarding() {
        return this.pastOffboarding;
    }

    public void setPastOffboarding(Boolean pastOffboarding) {
        this.pastOffboarding = pastOffboarding;
    }

    public String getRegularEmployeeStartDate() {
        return this.regularEmployeeStartDate;
    }

    public void setRegularEmployeeStartDate(String regularEmployeeStartDate) {
        this.regularEmployeeStartDate = regularEmployeeStartDate;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Integer getTimesEmployed() {
        return this.timesEmployed;
    }

    public void setTimesEmployed(Integer timesEmployed) {
        this.timesEmployed = timesEmployed;
    }

    public Enum getRecruitmentType() {
        return this.recruitmentType;
    }

    public void setRecruitmentType(Enum recruitmentType) {
        this.recruitmentType = recruitmentType;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getPrimaryContractId() {
        return this.primaryContractId;
    }

    public void setPrimaryContractId(String primaryContractId) {
        this.primaryContractId = primaryContractId;
    }

    public String getContractStartDate() {
        return this.contractStartDate;
    }

    public void setContractStartDate(String contractStartDate) {
        this.contractStartDate = contractStartDate;
    }

    public String getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(String contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public String getContractExpectedEndDate() {
        return this.contractExpectedEndDate;
    }

    public void setContractExpectedEndDate(String contractExpectedEndDate) {
        this.contractExpectedEndDate = contractExpectedEndDate;
    }

    public String getPayGroupId() {
        return this.payGroupId;
    }

    public void setPayGroupId(String payGroupId) {
        this.payGroupId = payGroupId;
    }

    public String getAssignmentPayGroupId() {
        return this.assignmentPayGroupId;
    }

    public void setAssignmentPayGroupId(String assignmentPayGroupId) {
        this.assignmentPayGroupId = assignmentPayGroupId;
    }

    public Boolean getInternationalAssignment() {
        return this.internationalAssignment;
    }

    public void setInternationalAssignment(Boolean internationalAssignment) {
        this.internationalAssignment = internationalAssignment;
    }

    public String getWorkCalendarId() {
        return this.workCalendarId;
    }

    public void setWorkCalendarId(String workCalendarId) {
        this.workCalendarId = workCalendarId;
    }

    public BasicDepartment getDepartment() {
        return this.department;
    }

    public void setDepartment(BasicDepartment department) {
        this.department = department;
    }

    public BasicEmployee getDirectManager() {
        return this.directManager;
    }

    public void setDirectManager(BasicEmployee directManager) {
        this.directManager = directManager;
    }

    public BasicEmployee getDottedLineManager() {
        return this.dottedLineManager;
    }

    public void setDottedLineManager(BasicEmployee dottedLineManager) {
        this.dottedLineManager = dottedLineManager;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public InternationalAssignment getPrimaryInternationalAssignment() {
        return this.primaryInternationalAssignment;
    }

    public void setPrimaryInternationalAssignment(InternationalAssignment primaryInternationalAssignment) {
        this.primaryInternationalAssignment = primaryInternationalAssignment;
    }

    public String getServiceCompany() {
        return this.serviceCompany;
    }

    public void setServiceCompany(String serviceCompany) {
        this.serviceCompany = serviceCompany;
    }

    public Enum getCompensationType() {
        return this.compensationType;
    }

    public void setCompensationType(Enum compensationType) {
        this.compensationType = compensationType;
    }

    public Enum getWorkShift() {
        return this.workShift;
    }

    public void setWorkShift(Enum workShift) {
        this.workShift = workShift;
    }

    public String[] getTalentPoolIdList() {
        return this.talentPoolIdList;
    }

    public void setTalentPoolIdList(String[] talentPoolIdList) {
        this.talentPoolIdList = talentPoolIdList;
    }

    public String getCustomOrg() {
        return this.customOrg;
    }

    public void setCustomOrg(String customOrg) {
        this.customOrg = customOrg;
    }

    public SeniorityAdjustInformation[] getSeniorityAdjustInformationList() {
        return this.seniorityAdjustInformationList;
    }

    public void setSeniorityAdjustInformationList(SeniorityAdjustInformation[] seniorityAdjustInformationList) {
        this.seniorityAdjustInformationList = seniorityAdjustInformationList;
    }

    public EmploymentBp getEmploymentDirectBps() {
        return this.employmentDirectBps;
    }

    public void setEmploymentDirectBps(EmploymentBp employmentDirectBps) {
        this.employmentDirectBps = employmentDirectBps;
    }

    public EmploymentBp getEmploymentAllBps() {
        return this.employmentAllBps;
    }

    public void setEmploymentAllBps(EmploymentBp employmentAllBps) {
        this.employmentAllBps = employmentAllBps;
    }

    public Enum getContractType() {
        return this.contractType;
    }

    public void setContractType(Enum contractType) {
        this.contractType = contractType;
    }

    public String getArchiveCpstPlanId() {
        return this.archiveCpstPlanId;
    }

    public void setArchiveCpstPlanId(String archiveCpstPlanId) {
        this.archiveCpstPlanId = archiveCpstPlanId;
    }

    public String getAttendanceGroupId() {
        return this.attendanceGroupId;
    }

    public void setAttendanceGroupId(String attendanceGroupId) {
        this.attendanceGroupId = attendanceGroupId;
    }


// builder 开始
  public Employee(){}

  public Employee(Builder builder){
         /**
          * 雇佣 ID;- 类型与 user_id_type 一致;- 请使用 employment_id_v2
          * <p> 示例值：6893014062142064135
          */
      this.employmentId = builder.employmentId;
         /**
          * 雇佣 ID;- 类型与 user_id_type 一致，转换失败时返回空值
          * <p> 示例值：6893014062142064135
          */
      this.employmentIdV2 = builder.employmentIdV2;
         /**
          * 招聘投递 ID ，详细信息可以通过【获取投递信息】接口查询获得
          * <p> 示例值：6838119494196871234
          */
      this.atsApplicationId = builder.atsApplicationId;
         /**
          * 待入职 ID
          * <p> 示例值：7023239238976141133
          */
      this.prehireId = builder.prehireId;
         /**
          * 工号
          * <p> 示例值：1000000
          */
      this.employeeNumber = builder.employeeNumber;
         /**
          * 人员类型 ID，详细信息可通过【查询单个人员类型】接口获得
          * <p> 示例值：6971090097697521314
          */
      this.employeeTypeId = builder.employeeTypeId;
         /**
          * 人员子类型 ID
          * <p> 示例值：6971090097697521317
          */
      this.employeeSubtypeId = builder.employeeSubtypeId;
         /**
          * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致;- 请使用 department_id_v2
          * <p> 示例值：6893014062142064135
          */
      this.departmentId = builder.departmentId;
         /**
          * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致，转换失败时返回空值
          * <p> 示例值：6893014062142064135
          */
      this.departmentIdV2 = builder.departmentIdV2;
         /**
          * 职级 ID，详细信息可通过【查询单个职务级别】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.jobLevelId = builder.jobLevelId;
         /**
          * 职级
          * <p> 示例值：
          */
      this.jobLevel = builder.jobLevel;
         /**
          * 通道 ID
          * <p> 示例值：6893014062142064135
          */
      this.pathwayId = builder.pathwayId;
         /**
          * 通道
          * <p> 示例值：
          */
      this.pathway = builder.pathway;
         /**
          * 职等 ID
          * <p> 示例值：6893014062142064135
          */
      this.jobGradeId = builder.jobGradeId;
         /**
          * 工作地点 ID，详细信息可通过【查询单个地点】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.workLocationId = builder.workLocationId;
         /**
          * 序列 ID，详细信息可通过【查询单个职务序列】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.jobFamilyId = builder.jobFamilyId;
         /**
          * 序列
          * <p> 示例值：
          */
      this.jobFamily = builder.jobFamily;
         /**
          * 岗位 ID，详细信息可通过【查询单个岗位】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.positionId = builder.positionId;
         /**
          * 岗位
          * <p> 示例值：
          */
      this.position = builder.position;
         /**
          * 职务 ID，详细信息可通过【查询单个职务】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.jobId = builder.jobId;
         /**
          * 职务
          * <p> 示例值：
          */
      this.job = builder.job;
         /**
          * 所属公司 ID，详细信息可通过【查询单个公司】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.companyId = builder.companyId;
         /**
          * 工时制度 ID，详细信息可通过【查询单个工时制度】接口获得
          * <p> 示例值：6893014062142064135
          */
      this.workingHoursTypeId = builder.workingHoursTypeId;
         /**
          * 司龄
          * <p> 示例值：0.01
          */
      this.tenure = builder.tenure;
         /**
          * 资历起算日期
          * <p> 示例值：2021-03-16
          */
      this.seniorityDate = builder.seniorityDate;
         /**
          * 当前雇佣记录的入职日期
          * <p> 示例值：2021-03-16
          */
      this.effectiveDate = builder.effectiveDate;
         /**
          * 是否是主雇佣信息
          * <p> 示例值：true
          */
      this.primaryEmployment = builder.primaryEmployment;
         /**
          * 试用期时长（月）
          * <p> 示例值：16
          */
      this.probationPeriod = builder.probationPeriod;
         /**
          * 是否在试用期中
          * <p> 示例值：true
          */
      this.onProbation = builder.onProbation;
         /**
          * 试用期结束日期（实际结束日期）
          * <p> 示例值：2022-08-01
          */
      this.probationEndDate = builder.probationEndDate;
         /**
          * 直接上级的雇佣 ID;- 类型与 user_id_type 一致;- 请使用 direct_manager_id_v2
          * <p> 示例值：7027024823985411287
          */
      this.directManagerId = builder.directManagerId;
         /**
          * 虚线上级的雇佣 ID; - 类型与 user_id_type 一致; - 请使用 dotted_line_manager_id_v2
          * <p> 示例值：7027024823985411782
          */
      this.dottedLineManagerId = builder.dottedLineManagerId;
         /**
          * 直接上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
          * <p> 示例值：7027024823985411287
          */
      this.directManagerIdV2 = builder.directManagerIdV2;
         /**
          * 虚线上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
          * <p> 示例值：7027024823985411782
          */
      this.dottedLineManagerIdV2 = builder.dottedLineManagerIdV2;
         /**
          * 雇佣类型，枚举值可通过文档【飞书人事枚举常量】雇佣类型（employment_type）枚举定义获得
          * <p> 示例值：
          */
      this.employmentType = builder.employmentType;
         /**
          * 雇佣状态，枚举值可通过文档【飞书人事枚举常量】雇员状态（employment_status）枚举定义获得
          * <p> 示例值：
          */
      this.employmentStatus = builder.employmentStatus;
         /**
          * 离职日期，即员工的最后一个工作日，最后一个工作日时员工的雇佣状态仍为“在职”，次日凌晨将更改为“离职”
          * <p> 示例值：2022-08-16
          */
      this.expirationDate = builder.expirationDate;
         /**
          * 离职原因，枚举值可通过文档【飞书人事枚举常量】离职原因（reason_for_offboarding）枚举定义部分获得
          * <p> 示例值：
          */
      this.reasonForOffboarding = builder.reasonForOffboarding;
         /**
          * 邮箱地址
          * <p> 示例值：test@163.com
          */
      this.emailAddress = builder.emailAddress;
         /**
          * 对应老People user_name字段，仅支持字节租户
          * <p> 示例值：test
          */
      this.userName = builder.userName;
         /**
          * 工作邮箱列表，只有当邮箱满足下面所有条件时，才在个人信息页面可见
          * <p> 示例值：
          */
      this.workEmailList = builder.workEmailList;
         /**
          * 成本中心列表
          * <p> 示例值：
          */
      this.costCenterList = builder.costCenterList;
         /**
          * 是否离职重聘
          * <p> 示例值：
          */
      this.rehire = builder.rehire;
         /**
          * 历史雇佣信息 ID，可以通过【查询单个雇佣信息】查询详细信息
          * <p> 示例值：7164286667866966659
          */
      this.rehireEmploymentId = builder.rehireEmploymentId;
         /**
          * 基本个人信息
          * <p> 示例值：
          */
      this.personInfo = builder.personInfo;
         /**
          * 自定义字段
          * <p> 示例值：
          */
      this.customFields = builder.customFields;
         /**
          * 竞业状态，枚举值包括:1.竞业中；2.未竞业
          * <p> 示例值：
          */
      this.noncompeteStatus = builder.noncompeteStatus;
         /**
          * 是否历史离职人员
          * <p> 示例值：true
          */
      this.pastOffboarding = builder.pastOffboarding;
         /**
          * 转正式日期
          * <p> 示例值：2020-01-01
          */
      this.regularEmployeeStartDate = builder.regularEmployeeStartDate;
         /**
          * 外部系统 ID , 可存储租户系统中的员工 ID
          * <p> 示例值：10000000
          */
      this.externalId = builder.externalId;
         /**
          * 入职次数
          * <p> 示例值：16
          */
      this.timesEmployed = builder.timesEmployed;
         /**
          * 招聘来源，枚举值 api_name 可通过【获取自定义字段详情】接口查询
          * <p> 示例值：
          */
      this.recruitmentType = builder.recruitmentType;
         /**
          * 员工头像
          * <p> 示例值：https://internal-api-lark-file.feishu-boe.cn/static-resource/v1/v2_a550d36b-28ef-48ad-9e50-58004beb386j~?image_size=noop&cut_type=&quality=&format=png&sticker_format=.webp
          */
      this.avatarUrl = builder.avatarUrl;
         /**
          * 主合同 ID
          * <p> 示例值：7164286667866966659
          */
      this.primaryContractId = builder.primaryContractId;
         /**
          * 主合同开始日期
          * <p> 示例值：2020-01-01
          */
      this.contractStartDate = builder.contractStartDate;
         /**
          * 主合同到期日期
          * <p> 示例值：2020-01-01
          */
      this.contractEndDate = builder.contractEndDate;
         /**
          * 主合同预计到期日期
          * <p> 示例值：2020-01-01
          */
      this.contractExpectedEndDate = builder.contractExpectedEndDate;
         /**
          * 所属薪资组 ID
          * <p> 示例值：7164286667866966659
          */
      this.payGroupId = builder.payGroupId;
         /**
          * 所属外派薪资组 ID
          * <p> 示例值：7164286667866966659
          */
      this.assignmentPayGroupId = builder.assignmentPayGroupId;
         /**
          * 是否外派
          * <p> 示例值：true
          */
      this.internationalAssignment = builder.internationalAssignment;
         /**
          * 工作日历 ID
          * <p> 示例值：7164286667866966659
          */
      this.workCalendarId = builder.workCalendarId;
         /**
          * 部门基本信息
          * <p> 示例值：
          */
      this.department = builder.department;
         /**
          * 直接上级基本信息
          * <p> 示例值：
          */
      this.directManager = builder.directManager;
         /**
          * 虚线上级基本信息
          * <p> 示例值：
          */
      this.dottedLineManager = builder.dottedLineManager;
         /**
          * 时区
          * <p> 示例值：Asia/Shanghai
          */
      this.timeZone = builder.timeZone;
         /**
          * 当前生效的外派记录
          * <p> 示例值：
          */
      this.primaryInternationalAssignment = builder.primaryInternationalAssignment;
         /**
          * 任职公司
          * <p> 示例值：7174374910734141112
          */
      this.serviceCompany = builder.serviceCompany;
         /**
          * 薪资类型
          * <p> 示例值：
          */
      this.compensationType = builder.compensationType;
         /**
          * 排班类型
          * <p> 示例值：
          */
      this.workShift = builder.workShift;
         /**
          * 所属人才池
          * <p> 示例值：
          */
      this.talentPoolIdList = builder.talentPoolIdList;
         /**
          * 自定义组织
          * <p> 示例值：{"custom_org_02":[{"id":"1","rate":"99"}]}
          */
      this.customOrg = builder.customOrg;
         /**
          * 司龄调整信息
          * <p> 示例值：
          */
      this.seniorityAdjustInformationList = builder.seniorityAdjustInformationList;
         /**
          * 员工直属 BP 信息，当员工所在部门、属地无 BP 时，会上钻找到最近的 BP
          * <p> 示例值：
          */
      this.employmentDirectBps = builder.employmentDirectBps;
         /**
          * 员工全部 BP 信息
          * <p> 示例值：
          */
      this.employmentAllBps = builder.employmentAllBps;
         /**
          * 当前所属合同类型;- 可通过[获取字段详情](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)查询;  - object_api_name：contract;  - custom_api_name：contract_type
          * <p> 示例值：
          */
      this.contractType = builder.contractType;
         /**
          * 当前所属薪资方案 ID;- 可结合[批量查询薪资方案](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/plan/list)接口使用
          * <p> 示例值：123456789
          */
      this.archiveCpstPlanId = builder.archiveCpstPlanId;
         /**
          * 当前所在考勤组 ID;- 可通过[按 ID 查询考勤组](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/attendance-v1/group/get)获取详情
          * <p> 示例值：123456789
          */
      this.attendanceGroupId = builder.attendanceGroupId;
  }

    public static class Builder {
     /**
      * 雇佣 ID;- 类型与 user_id_type 一致;- 请使用 employment_id_v2
      * <p> 示例值：6893014062142064135
      */
        private String employmentId;
     /**
      * 雇佣 ID;- 类型与 user_id_type 一致，转换失败时返回空值
      * <p> 示例值：6893014062142064135
      */
        private String employmentIdV2;
     /**
      * 招聘投递 ID ，详细信息可以通过【获取投递信息】接口查询获得
      * <p> 示例值：6838119494196871234
      */
        private String atsApplicationId;
     /**
      * 待入职 ID
      * <p> 示例值：7023239238976141133
      */
        private String prehireId;
     /**
      * 工号
      * <p> 示例值：1000000
      */
        private String employeeNumber;
     /**
      * 人员类型 ID，详细信息可通过【查询单个人员类型】接口获得
      * <p> 示例值：6971090097697521314
      */
        private String employeeTypeId;
     /**
      * 人员子类型 ID
      * <p> 示例值：6971090097697521317
      */
        private String employeeSubtypeId;
     /**
      * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致;- 请使用 department_id_v2
      * <p> 示例值：6893014062142064135
      */
        private String departmentId;
     /**
      * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致，转换失败时返回空值
      * <p> 示例值：6893014062142064135
      */
        private String departmentIdV2;
     /**
      * 职级 ID，详细信息可通过【查询单个职务级别】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String jobLevelId;
     /**
      * 职级
      * <p> 示例值：
      */
        private EmployeeJobLevel jobLevel;
     /**
      * 通道 ID
      * <p> 示例值：6893014062142064135
      */
        private String pathwayId;
     /**
      * 通道
      * <p> 示例值：
      */
        private EmployeePathway pathway;
     /**
      * 职等 ID
      * <p> 示例值：6893014062142064135
      */
        private String jobGradeId;
     /**
      * 工作地点 ID，详细信息可通过【查询单个地点】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String workLocationId;
     /**
      * 序列 ID，详细信息可通过【查询单个职务序列】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String jobFamilyId;
     /**
      * 序列
      * <p> 示例值：
      */
        private EmployeeJobFamily jobFamily;
     /**
      * 岗位 ID，详细信息可通过【查询单个岗位】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String positionId;
     /**
      * 岗位
      * <p> 示例值：
      */
        private Position position;
     /**
      * 职务 ID，详细信息可通过【查询单个职务】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String jobId;
     /**
      * 职务
      * <p> 示例值：
      */
        private Job job;
     /**
      * 所属公司 ID，详细信息可通过【查询单个公司】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String companyId;
     /**
      * 工时制度 ID，详细信息可通过【查询单个工时制度】接口获得
      * <p> 示例值：6893014062142064135
      */
        private String workingHoursTypeId;
     /**
      * 司龄
      * <p> 示例值：0.01
      */
        private String tenure;
     /**
      * 资历起算日期
      * <p> 示例值：2021-03-16
      */
        private String seniorityDate;
     /**
      * 当前雇佣记录的入职日期
      * <p> 示例值：2021-03-16
      */
        private String effectiveDate;
     /**
      * 是否是主雇佣信息
      * <p> 示例值：true
      */
        private Boolean primaryEmployment;
     /**
      * 试用期时长（月）
      * <p> 示例值：16
      */
        private Integer probationPeriod;
     /**
      * 是否在试用期中
      * <p> 示例值：true
      */
        private Boolean onProbation;
     /**
      * 试用期结束日期（实际结束日期）
      * <p> 示例值：2022-08-01
      */
        private String probationEndDate;
     /**
      * 直接上级的雇佣 ID;- 类型与 user_id_type 一致;- 请使用 direct_manager_id_v2
      * <p> 示例值：7027024823985411287
      */
        private String directManagerId;
     /**
      * 虚线上级的雇佣 ID; - 类型与 user_id_type 一致; - 请使用 dotted_line_manager_id_v2
      * <p> 示例值：7027024823985411782
      */
        private String dottedLineManagerId;
     /**
      * 直接上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
      * <p> 示例值：7027024823985411287
      */
        private String directManagerIdV2;
     /**
      * 虚线上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
      * <p> 示例值：7027024823985411782
      */
        private String dottedLineManagerIdV2;
     /**
      * 雇佣类型，枚举值可通过文档【飞书人事枚举常量】雇佣类型（employment_type）枚举定义获得
      * <p> 示例值：
      */
        private Enum employmentType;
     /**
      * 雇佣状态，枚举值可通过文档【飞书人事枚举常量】雇员状态（employment_status）枚举定义获得
      * <p> 示例值：
      */
        private Enum employmentStatus;
     /**
      * 离职日期，即员工的最后一个工作日，最后一个工作日时员工的雇佣状态仍为“在职”，次日凌晨将更改为“离职”
      * <p> 示例值：2022-08-16
      */
        private String expirationDate;
     /**
      * 离职原因，枚举值可通过文档【飞书人事枚举常量】离职原因（reason_for_offboarding）枚举定义部分获得
      * <p> 示例值：
      */
        private Enum reasonForOffboarding;
     /**
      * 邮箱地址
      * <p> 示例值：test@163.com
      */
        private String emailAddress;
     /**
      * 对应老People user_name字段，仅支持字节租户
      * <p> 示例值：test
      */
        private String userName;
     /**
      * 工作邮箱列表，只有当邮箱满足下面所有条件时，才在个人信息页面可见
      * <p> 示例值：
      */
        private WorkEmail[] workEmailList;
     /**
      * 成本中心列表
      * <p> 示例值：
      */
        private JobDataCostCenter[] costCenterList;
     /**
      * 是否离职重聘
      * <p> 示例值：
      */
        private Enum rehire;
     /**
      * 历史雇佣信息 ID，可以通过【查询单个雇佣信息】查询详细信息
      * <p> 示例值：7164286667866966659
      */
        private String rehireEmploymentId;
     /**
      * 基本个人信息
      * <p> 示例值：
      */
        private PersonInfo personInfo;
     /**
      * 自定义字段
      * <p> 示例值：
      */
        private CustomFieldData[] customFields;
     /**
      * 竞业状态，枚举值包括:1.竞业中；2.未竞业
      * <p> 示例值：
      */
        private Enum noncompeteStatus;
     /**
      * 是否历史离职人员
      * <p> 示例值：true
      */
        private Boolean pastOffboarding;
     /**
      * 转正式日期
      * <p> 示例值：2020-01-01
      */
        private String regularEmployeeStartDate;
     /**
      * 外部系统 ID , 可存储租户系统中的员工 ID
      * <p> 示例值：10000000
      */
        private String externalId;
     /**
      * 入职次数
      * <p> 示例值：16
      */
        private Integer timesEmployed;
     /**
      * 招聘来源，枚举值 api_name 可通过【获取自定义字段详情】接口查询
      * <p> 示例值：
      */
        private Enum recruitmentType;
     /**
      * 员工头像
      * <p> 示例值：https://internal-api-lark-file.feishu-boe.cn/static-resource/v1/v2_a550d36b-28ef-48ad-9e50-58004beb386j~?image_size=noop&cut_type=&quality=&format=png&sticker_format=.webp
      */
        private String avatarUrl;
     /**
      * 主合同 ID
      * <p> 示例值：7164286667866966659
      */
        private String primaryContractId;
     /**
      * 主合同开始日期
      * <p> 示例值：2020-01-01
      */
        private String contractStartDate;
     /**
      * 主合同到期日期
      * <p> 示例值：2020-01-01
      */
        private String contractEndDate;
     /**
      * 主合同预计到期日期
      * <p> 示例值：2020-01-01
      */
        private String contractExpectedEndDate;
     /**
      * 所属薪资组 ID
      * <p> 示例值：7164286667866966659
      */
        private String payGroupId;
     /**
      * 所属外派薪资组 ID
      * <p> 示例值：7164286667866966659
      */
        private String assignmentPayGroupId;
     /**
      * 是否外派
      * <p> 示例值：true
      */
        private Boolean internationalAssignment;
     /**
      * 工作日历 ID
      * <p> 示例值：7164286667866966659
      */
        private String workCalendarId;
     /**
      * 部门基本信息
      * <p> 示例值：
      */
        private BasicDepartment department;
     /**
      * 直接上级基本信息
      * <p> 示例值：
      */
        private BasicEmployee directManager;
     /**
      * 虚线上级基本信息
      * <p> 示例值：
      */
        private BasicEmployee dottedLineManager;
     /**
      * 时区
      * <p> 示例值：Asia/Shanghai
      */
        private String timeZone;
     /**
      * 当前生效的外派记录
      * <p> 示例值：
      */
        private InternationalAssignment primaryInternationalAssignment;
     /**
      * 任职公司
      * <p> 示例值：7174374910734141112
      */
        private String serviceCompany;
     /**
      * 薪资类型
      * <p> 示例值：
      */
        private Enum compensationType;
     /**
      * 排班类型
      * <p> 示例值：
      */
        private Enum workShift;
     /**
      * 所属人才池
      * <p> 示例值：
      */
        private String[] talentPoolIdList;
     /**
      * 自定义组织
      * <p> 示例值：{"custom_org_02":[{"id":"1","rate":"99"}]}
      */
        private String customOrg;
     /**
      * 司龄调整信息
      * <p> 示例值：
      */
        private SeniorityAdjustInformation[] seniorityAdjustInformationList;
     /**
      * 员工直属 BP 信息，当员工所在部门、属地无 BP 时，会上钻找到最近的 BP
      * <p> 示例值：
      */
        private EmploymentBp employmentDirectBps;
     /**
      * 员工全部 BP 信息
      * <p> 示例值：
      */
        private EmploymentBp employmentAllBps;
     /**
      * 当前所属合同类型;- 可通过[获取字段详情](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)查询;  - object_api_name：contract;  - custom_api_name：contract_type
      * <p> 示例值：
      */
        private Enum contractType;
     /**
      * 当前所属薪资方案 ID;- 可结合[批量查询薪资方案](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/plan/list)接口使用
      * <p> 示例值：123456789
      */
        private String archiveCpstPlanId;
     /**
      * 当前所在考勤组 ID;- 可通过[按 ID 查询考勤组](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/attendance-v1/group/get)获取详情
      * <p> 示例值：123456789
      */
        private String attendanceGroupId;

        /**
         * 雇佣 ID;- 类型与 user_id_type 一致;- 请使用 employment_id_v2
         * <p> 示例值：6893014062142064135
         * @param employmentId
         * @return
         */
        public Builder employmentId(String employmentId) {
             this.employmentId = employmentId;
             return this;
        }

    

        /**
         * 雇佣 ID;- 类型与 user_id_type 一致，转换失败时返回空值
         * <p> 示例值：6893014062142064135
         * @param employmentIdV2
         * @return
         */
        public Builder employmentIdV2(String employmentIdV2) {
             this.employmentIdV2 = employmentIdV2;
             return this;
        }

    

        /**
         * 招聘投递 ID ，详细信息可以通过【获取投递信息】接口查询获得
         * <p> 示例值：6838119494196871234
         * @param atsApplicationId
         * @return
         */
        public Builder atsApplicationId(String atsApplicationId) {
             this.atsApplicationId = atsApplicationId;
             return this;
        }

    

        /**
         * 待入职 ID
         * <p> 示例值：7023239238976141133
         * @param prehireId
         * @return
         */
        public Builder prehireId(String prehireId) {
             this.prehireId = prehireId;
             return this;
        }

    

        /**
         * 工号
         * <p> 示例值：1000000
         * @param employeeNumber
         * @return
         */
        public Builder employeeNumber(String employeeNumber) {
             this.employeeNumber = employeeNumber;
             return this;
        }

    

        /**
         * 人员类型 ID，详细信息可通过【查询单个人员类型】接口获得
         * <p> 示例值：6971090097697521314
         * @param employeeTypeId
         * @return
         */
        public Builder employeeTypeId(String employeeTypeId) {
             this.employeeTypeId = employeeTypeId;
             return this;
        }

    

        /**
         * 人员子类型 ID
         * <p> 示例值：6971090097697521317
         * @param employeeSubtypeId
         * @return
         */
        public Builder employeeSubtypeId(String employeeSubtypeId) {
             this.employeeSubtypeId = employeeSubtypeId;
             return this;
        }

    

        /**
         * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致;- 请使用 department_id_v2
         * <p> 示例值：6893014062142064135
         * @param departmentId
         * @return
         */
        public Builder departmentId(String departmentId) {
             this.departmentId = departmentId;
             return this;
        }

    

        /**
         * 部门 ID;- 可通过 [【查询单个部门】](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/department/get)获取详细信息;- 类型与 department_id_type 一致，转换失败时返回空值
         * <p> 示例值：6893014062142064135
         * @param departmentIdV2
         * @return
         */
        public Builder departmentIdV2(String departmentIdV2) {
             this.departmentIdV2 = departmentIdV2;
             return this;
        }

    

        /**
         * 职级 ID，详细信息可通过【查询单个职务级别】接口获得
         * <p> 示例值：6893014062142064135
         * @param jobLevelId
         * @return
         */
        public Builder jobLevelId(String jobLevelId) {
             this.jobLevelId = jobLevelId;
             return this;
        }

    

        /**
         * 职级
         * <p> 示例值：
         * @param jobLevel
         * @return
         */
        public Builder jobLevel(EmployeeJobLevel jobLevel) {
             this.jobLevel = jobLevel;
             return this;
        }

    

        /**
         * 通道 ID
         * <p> 示例值：6893014062142064135
         * @param pathwayId
         * @return
         */
        public Builder pathwayId(String pathwayId) {
             this.pathwayId = pathwayId;
             return this;
        }

    

        /**
         * 通道
         * <p> 示例值：
         * @param pathway
         * @return
         */
        public Builder pathway(EmployeePathway pathway) {
             this.pathway = pathway;
             return this;
        }

    

        /**
         * 职等 ID
         * <p> 示例值：6893014062142064135
         * @param jobGradeId
         * @return
         */
        public Builder jobGradeId(String jobGradeId) {
             this.jobGradeId = jobGradeId;
             return this;
        }

    

        /**
         * 工作地点 ID，详细信息可通过【查询单个地点】接口获得
         * <p> 示例值：6893014062142064135
         * @param workLocationId
         * @return
         */
        public Builder workLocationId(String workLocationId) {
             this.workLocationId = workLocationId;
             return this;
        }

    

        /**
         * 序列 ID，详细信息可通过【查询单个职务序列】接口获得
         * <p> 示例值：6893014062142064135
         * @param jobFamilyId
         * @return
         */
        public Builder jobFamilyId(String jobFamilyId) {
             this.jobFamilyId = jobFamilyId;
             return this;
        }

    

        /**
         * 序列
         * <p> 示例值：
         * @param jobFamily
         * @return
         */
        public Builder jobFamily(EmployeeJobFamily jobFamily) {
             this.jobFamily = jobFamily;
             return this;
        }

    

        /**
         * 岗位 ID，详细信息可通过【查询单个岗位】接口获得
         * <p> 示例值：6893014062142064135
         * @param positionId
         * @return
         */
        public Builder positionId(String positionId) {
             this.positionId = positionId;
             return this;
        }

    

        /**
         * 岗位
         * <p> 示例值：
         * @param position
         * @return
         */
        public Builder position(Position position) {
             this.position = position;
             return this;
        }

    

        /**
         * 职务 ID，详细信息可通过【查询单个职务】接口获得
         * <p> 示例值：6893014062142064135
         * @param jobId
         * @return
         */
        public Builder jobId(String jobId) {
             this.jobId = jobId;
             return this;
        }

    

        /**
         * 职务
         * <p> 示例值：
         * @param job
         * @return
         */
        public Builder job(Job job) {
             this.job = job;
             return this;
        }

    

        /**
         * 所属公司 ID，详细信息可通过【查询单个公司】接口获得
         * <p> 示例值：6893014062142064135
         * @param companyId
         * @return
         */
        public Builder companyId(String companyId) {
             this.companyId = companyId;
             return this;
        }

    

        /**
         * 工时制度 ID，详细信息可通过【查询单个工时制度】接口获得
         * <p> 示例值：6893014062142064135
         * @param workingHoursTypeId
         * @return
         */
        public Builder workingHoursTypeId(String workingHoursTypeId) {
             this.workingHoursTypeId = workingHoursTypeId;
             return this;
        }

    

        /**
         * 司龄
         * <p> 示例值：0.01
         * @param tenure
         * @return
         */
        public Builder tenure(String tenure) {
             this.tenure = tenure;
             return this;
        }

    

        /**
         * 资历起算日期
         * <p> 示例值：2021-03-16
         * @param seniorityDate
         * @return
         */
        public Builder seniorityDate(String seniorityDate) {
             this.seniorityDate = seniorityDate;
             return this;
        }

    

        /**
         * 当前雇佣记录的入职日期
         * <p> 示例值：2021-03-16
         * @param effectiveDate
         * @return
         */
        public Builder effectiveDate(String effectiveDate) {
             this.effectiveDate = effectiveDate;
             return this;
        }

    

        /**
         * 是否是主雇佣信息
         * <p> 示例值：true
         * @param primaryEmployment
         * @return
         */
        public Builder primaryEmployment(Boolean primaryEmployment) {
             this.primaryEmployment = primaryEmployment;
             return this;
        }

    

        /**
         * 试用期时长（月）
         * <p> 示例值：16
         * @param probationPeriod
         * @return
         */
        public Builder probationPeriod(Integer probationPeriod) {
             this.probationPeriod = probationPeriod;
             return this;
        }

    

        /**
         * 是否在试用期中
         * <p> 示例值：true
         * @param onProbation
         * @return
         */
        public Builder onProbation(Boolean onProbation) {
             this.onProbation = onProbation;
             return this;
        }

    

        /**
         * 试用期结束日期（实际结束日期）
         * <p> 示例值：2022-08-01
         * @param probationEndDate
         * @return
         */
        public Builder probationEndDate(String probationEndDate) {
             this.probationEndDate = probationEndDate;
             return this;
        }

    

        /**
         * 直接上级的雇佣 ID;- 类型与 user_id_type 一致;- 请使用 direct_manager_id_v2
         * <p> 示例值：7027024823985411287
         * @param directManagerId
         * @return
         */
        public Builder directManagerId(String directManagerId) {
             this.directManagerId = directManagerId;
             return this;
        }

    

        /**
         * 虚线上级的雇佣 ID; - 类型与 user_id_type 一致; - 请使用 dotted_line_manager_id_v2
         * <p> 示例值：7027024823985411782
         * @param dottedLineManagerId
         * @return
         */
        public Builder dottedLineManagerId(String dottedLineManagerId) {
             this.dottedLineManagerId = dottedLineManagerId;
             return this;
        }

    

        /**
         * 直接上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
         * <p> 示例值：7027024823985411287
         * @param directManagerIdV2
         * @return
         */
        public Builder directManagerIdV2(String directManagerIdV2) {
             this.directManagerIdV2 = directManagerIdV2;
             return this;
        }

    

        /**
         * 虚线上级的雇佣 ID;- 类型与 user_id_type 一致，转换失败返回空值
         * <p> 示例值：7027024823985411782
         * @param dottedLineManagerIdV2
         * @return
         */
        public Builder dottedLineManagerIdV2(String dottedLineManagerIdV2) {
             this.dottedLineManagerIdV2 = dottedLineManagerIdV2;
             return this;
        }

    

        /**
         * 雇佣类型，枚举值可通过文档【飞书人事枚举常量】雇佣类型（employment_type）枚举定义获得
         * <p> 示例值：
         * @param employmentType
         * @return
         */
        public Builder employmentType(Enum employmentType) {
             this.employmentType = employmentType;
             return this;
        }

    

        /**
         * 雇佣状态，枚举值可通过文档【飞书人事枚举常量】雇员状态（employment_status）枚举定义获得
         * <p> 示例值：
         * @param employmentStatus
         * @return
         */
        public Builder employmentStatus(Enum employmentStatus) {
             this.employmentStatus = employmentStatus;
             return this;
        }

    

        /**
         * 离职日期，即员工的最后一个工作日，最后一个工作日时员工的雇佣状态仍为“在职”，次日凌晨将更改为“离职”
         * <p> 示例值：2022-08-16
         * @param expirationDate
         * @return
         */
        public Builder expirationDate(String expirationDate) {
             this.expirationDate = expirationDate;
             return this;
        }

    

        /**
         * 离职原因，枚举值可通过文档【飞书人事枚举常量】离职原因（reason_for_offboarding）枚举定义部分获得
         * <p> 示例值：
         * @param reasonForOffboarding
         * @return
         */
        public Builder reasonForOffboarding(Enum reasonForOffboarding) {
             this.reasonForOffboarding = reasonForOffboarding;
             return this;
        }

    

        /**
         * 邮箱地址
         * <p> 示例值：test@163.com
         * @param emailAddress
         * @return
         */
        public Builder emailAddress(String emailAddress) {
             this.emailAddress = emailAddress;
             return this;
        }

    

        /**
         * 对应老People user_name字段，仅支持字节租户
         * <p> 示例值：test
         * @param userName
         * @return
         */
        public Builder userName(String userName) {
             this.userName = userName;
             return this;
        }

    

        /**
         * 工作邮箱列表，只有当邮箱满足下面所有条件时，才在个人信息页面可见
         * <p> 示例值：
         * @param workEmailList
         * @return
         */
        public Builder workEmailList(WorkEmail[] workEmailList) {
             this.workEmailList = workEmailList;
             return this;
        }

    

        /**
         * 成本中心列表
         * <p> 示例值：
         * @param costCenterList
         * @return
         */
        public Builder costCenterList(JobDataCostCenter[] costCenterList) {
             this.costCenterList = costCenterList;
             return this;
        }

    

        /**
         * 是否离职重聘
         * <p> 示例值：
         * @param rehire
         * @return
         */
        public Builder rehire(Enum rehire) {
             this.rehire = rehire;
             return this;
        }

    

        /**
         * 历史雇佣信息 ID，可以通过【查询单个雇佣信息】查询详细信息
         * <p> 示例值：7164286667866966659
         * @param rehireEmploymentId
         * @return
         */
        public Builder rehireEmploymentId(String rehireEmploymentId) {
             this.rehireEmploymentId = rehireEmploymentId;
             return this;
        }

    

        /**
         * 基本个人信息
         * <p> 示例值：
         * @param personInfo
         * @return
         */
        public Builder personInfo(PersonInfo personInfo) {
             this.personInfo = personInfo;
             return this;
        }

    

        /**
         * 自定义字段
         * <p> 示例值：
         * @param customFields
         * @return
         */
        public Builder customFields(CustomFieldData[] customFields) {
             this.customFields = customFields;
             return this;
        }

    

        /**
         * 竞业状态，枚举值包括:1.竞业中；2.未竞业
         * <p> 示例值：
         * @param noncompeteStatus
         * @return
         */
        public Builder noncompeteStatus(Enum noncompeteStatus) {
             this.noncompeteStatus = noncompeteStatus;
             return this;
        }

    

        /**
         * 是否历史离职人员
         * <p> 示例值：true
         * @param pastOffboarding
         * @return
         */
        public Builder pastOffboarding(Boolean pastOffboarding) {
             this.pastOffboarding = pastOffboarding;
             return this;
        }

    

        /**
         * 转正式日期
         * <p> 示例值：2020-01-01
         * @param regularEmployeeStartDate
         * @return
         */
        public Builder regularEmployeeStartDate(String regularEmployeeStartDate) {
             this.regularEmployeeStartDate = regularEmployeeStartDate;
             return this;
        }

    

        /**
         * 外部系统 ID , 可存储租户系统中的员工 ID
         * <p> 示例值：10000000
         * @param externalId
         * @return
         */
        public Builder externalId(String externalId) {
             this.externalId = externalId;
             return this;
        }

    

        /**
         * 入职次数
         * <p> 示例值：16
         * @param timesEmployed
         * @return
         */
        public Builder timesEmployed(Integer timesEmployed) {
             this.timesEmployed = timesEmployed;
             return this;
        }

    

        /**
         * 招聘来源，枚举值 api_name 可通过【获取自定义字段详情】接口查询
         * <p> 示例值：
         * @param recruitmentType
         * @return
         */
        public Builder recruitmentType(Enum recruitmentType) {
             this.recruitmentType = recruitmentType;
             return this;
        }

    

        /**
         * 员工头像
         * <p> 示例值：https://internal-api-lark-file.feishu-boe.cn/static-resource/v1/v2_a550d36b-28ef-48ad-9e50-58004beb386j~?image_size=noop&cut_type=&quality=&format=png&sticker_format=.webp
         * @param avatarUrl
         * @return
         */
        public Builder avatarUrl(String avatarUrl) {
             this.avatarUrl = avatarUrl;
             return this;
        }

    

        /**
         * 主合同 ID
         * <p> 示例值：7164286667866966659
         * @param primaryContractId
         * @return
         */
        public Builder primaryContractId(String primaryContractId) {
             this.primaryContractId = primaryContractId;
             return this;
        }

    

        /**
         * 主合同开始日期
         * <p> 示例值：2020-01-01
         * @param contractStartDate
         * @return
         */
        public Builder contractStartDate(String contractStartDate) {
             this.contractStartDate = contractStartDate;
             return this;
        }

    

        /**
         * 主合同到期日期
         * <p> 示例值：2020-01-01
         * @param contractEndDate
         * @return
         */
        public Builder contractEndDate(String contractEndDate) {
             this.contractEndDate = contractEndDate;
             return this;
        }

    

        /**
         * 主合同预计到期日期
         * <p> 示例值：2020-01-01
         * @param contractExpectedEndDate
         * @return
         */
        public Builder contractExpectedEndDate(String contractExpectedEndDate) {
             this.contractExpectedEndDate = contractExpectedEndDate;
             return this;
        }

    

        /**
         * 所属薪资组 ID
         * <p> 示例值：7164286667866966659
         * @param payGroupId
         * @return
         */
        public Builder payGroupId(String payGroupId) {
             this.payGroupId = payGroupId;
             return this;
        }

    

        /**
         * 所属外派薪资组 ID
         * <p> 示例值：7164286667866966659
         * @param assignmentPayGroupId
         * @return
         */
        public Builder assignmentPayGroupId(String assignmentPayGroupId) {
             this.assignmentPayGroupId = assignmentPayGroupId;
             return this;
        }

    

        /**
         * 是否外派
         * <p> 示例值：true
         * @param internationalAssignment
         * @return
         */
        public Builder internationalAssignment(Boolean internationalAssignment) {
             this.internationalAssignment = internationalAssignment;
             return this;
        }

    

        /**
         * 工作日历 ID
         * <p> 示例值：7164286667866966659
         * @param workCalendarId
         * @return
         */
        public Builder workCalendarId(String workCalendarId) {
             this.workCalendarId = workCalendarId;
             return this;
        }

    

        /**
         * 部门基本信息
         * <p> 示例值：
         * @param department
         * @return
         */
        public Builder department(BasicDepartment department) {
             this.department = department;
             return this;
        }

    

        /**
         * 直接上级基本信息
         * <p> 示例值：
         * @param directManager
         * @return
         */
        public Builder directManager(BasicEmployee directManager) {
             this.directManager = directManager;
             return this;
        }

    

        /**
         * 虚线上级基本信息
         * <p> 示例值：
         * @param dottedLineManager
         * @return
         */
        public Builder dottedLineManager(BasicEmployee dottedLineManager) {
             this.dottedLineManager = dottedLineManager;
             return this;
        }

    

        /**
         * 时区
         * <p> 示例值：Asia/Shanghai
         * @param timeZone
         * @return
         */
        public Builder timeZone(String timeZone) {
             this.timeZone = timeZone;
             return this;
        }

    

        /**
         * 当前生效的外派记录
         * <p> 示例值：
         * @param primaryInternationalAssignment
         * @return
         */
        public Builder primaryInternationalAssignment(InternationalAssignment primaryInternationalAssignment) {
             this.primaryInternationalAssignment = primaryInternationalAssignment;
             return this;
        }

    

        /**
         * 任职公司
         * <p> 示例值：7174374910734141112
         * @param serviceCompany
         * @return
         */
        public Builder serviceCompany(String serviceCompany) {
             this.serviceCompany = serviceCompany;
             return this;
        }

    

        /**
         * 薪资类型
         * <p> 示例值：
         * @param compensationType
         * @return
         */
        public Builder compensationType(Enum compensationType) {
             this.compensationType = compensationType;
             return this;
        }

    

        /**
         * 排班类型
         * <p> 示例值：
         * @param workShift
         * @return
         */
        public Builder workShift(Enum workShift) {
             this.workShift = workShift;
             return this;
        }

    

        /**
         * 所属人才池
         * <p> 示例值：
         * @param talentPoolIdList
         * @return
         */
        public Builder talentPoolIdList(String[] talentPoolIdList) {
             this.talentPoolIdList = talentPoolIdList;
             return this;
        }

    

        /**
         * 自定义组织
         * <p> 示例值：{"custom_org_02":[{"id":"1","rate":"99"}]}
         * @param customOrg
         * @return
         */
        public Builder customOrg(String customOrg) {
             this.customOrg = customOrg;
             return this;
        }

    

        /**
         * 司龄调整信息
         * <p> 示例值：
         * @param seniorityAdjustInformationList
         * @return
         */
        public Builder seniorityAdjustInformationList(SeniorityAdjustInformation[] seniorityAdjustInformationList) {
             this.seniorityAdjustInformationList = seniorityAdjustInformationList;
             return this;
        }

    

        /**
         * 员工直属 BP 信息，当员工所在部门、属地无 BP 时，会上钻找到最近的 BP
         * <p> 示例值：
         * @param employmentDirectBps
         * @return
         */
        public Builder employmentDirectBps(EmploymentBp employmentDirectBps) {
             this.employmentDirectBps = employmentDirectBps;
             return this;
        }

    

        /**
         * 员工全部 BP 信息
         * <p> 示例值：
         * @param employmentAllBps
         * @return
         */
        public Builder employmentAllBps(EmploymentBp employmentAllBps) {
             this.employmentAllBps = employmentAllBps;
             return this;
        }

    

        /**
         * 当前所属合同类型;- 可通过[获取字段详情](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/corehr-v1/custom_field/get_by_param)查询;  - object_api_name：contract;  - custom_api_name：contract_type
         * <p> 示例值：
         * @param contractType
         * @return
         */
        public Builder contractType(Enum contractType) {
             this.contractType = contractType;
             return this;
        }

    

        /**
         * 当前所属薪资方案 ID;- 可结合[批量查询薪资方案](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/compensation-v1/plan/list)接口使用
         * <p> 示例值：123456789
         * @param archiveCpstPlanId
         * @return
         */
        public Builder archiveCpstPlanId(String archiveCpstPlanId) {
             this.archiveCpstPlanId = archiveCpstPlanId;
             return this;
        }

    

        /**
         * 当前所在考勤组 ID;- 可通过[按 ID 查询考勤组](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/attendance-v1/group/get)获取详情
         * <p> 示例值：123456789
         * @param attendanceGroupId
         * @return
         */
        public Builder attendanceGroupId(String attendanceGroupId) {
             this.attendanceGroupId = attendanceGroupId;
             return this;
        }

    
    
    public Employee build(){
        return new Employee(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
