// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class FormVariableValueInfo {
     /**
      * 文本变量对象
      * <p> 示例值：
      */
    @SerializedName("text_value")
    private FormFieldVariableStringValue textValue;
     /**
      * 数值变量对象（这里的value必须传入一个合法的数字，常见非法值："" 和 null）
      * <p> 示例值：
      */
    @SerializedName("number_value")
    private FormFieldVariableStringValue numberValue;
     /**
      * 日期变量对象（这里的value为从1970年1月1日（UTC/GMT的午夜）开始所经过的天数）
      * <p> 示例值：
      */
    @SerializedName("date_value")
    private FormFieldVariableNumberValue dateValue;
     /**
      * 员工变量对象（值传入employmentID）
      * <p> 示例值：
      */
    @SerializedName("employment_value")
    private FormFieldVariableStringValue employmentValue;
     /**
      * 日期时间变量对象（从1970年1月1日（UTC/GMT的午夜）开始所经过的毫秒数。）
      * <p> 示例值：
      */
    @SerializedName("date_time_value")
    private FormFieldVariableNumberValue dateTimeValue;
     /**
      * 枚举变量对象（客户需要传入 枚举的枚举项key作为enum_value.value的值）
      * <p> 示例值：
      */
    @SerializedName("enum_value")
    private FormFieldVariableStringValue enumValue;
     /**
      * 空变量对象
      * <p> 示例值：
      */
    @SerializedName("null_value")
    private FormFieldVariableNullValue nullValue;
     /**
      * 布尔变量对象
      * <p> 示例值：
      */
    @SerializedName("bool_value")
    private FormFieldVariableBoolValue boolValue;
     /**
      * 部门变量对象（值传入departmentID）
      * <p> 示例值：
      */
    @SerializedName("department_value")
    private FormFieldVariableStringValue departmentValue;
     /**
      * i18n变量对象（中英文为可选，但不能出现中英文均为空的数据。）
      * <p> 示例值：
      */
    @SerializedName("i18n_value")
    private FormFieldVariableI18nValue i18nValue;
     /**
      * 对象变量（对于所有引用wukong数据的Value，object_value.value中传入wukong中的wkID。）
      * <p> 示例值：
      */
    @SerializedName("object_value")
    private FormFieldVariableStringValue objectValue;
    public FormFieldVariableStringValue getTextValue() {
        return this.textValue;
    }

    public void setTextValue(FormFieldVariableStringValue textValue) {
        this.textValue = textValue;
    }

    public FormFieldVariableStringValue getNumberValue() {
        return this.numberValue;
    }

    public void setNumberValue(FormFieldVariableStringValue numberValue) {
        this.numberValue = numberValue;
    }

    public FormFieldVariableNumberValue getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(FormFieldVariableNumberValue dateValue) {
        this.dateValue = dateValue;
    }

    public FormFieldVariableStringValue getEmploymentValue() {
        return this.employmentValue;
    }

    public void setEmploymentValue(FormFieldVariableStringValue employmentValue) {
        this.employmentValue = employmentValue;
    }

    public FormFieldVariableNumberValue getDateTimeValue() {
        return this.dateTimeValue;
    }

    public void setDateTimeValue(FormFieldVariableNumberValue dateTimeValue) {
        this.dateTimeValue = dateTimeValue;
    }

    public FormFieldVariableStringValue getEnumValue() {
        return this.enumValue;
    }

    public void setEnumValue(FormFieldVariableStringValue enumValue) {
        this.enumValue = enumValue;
    }

    public FormFieldVariableNullValue getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(FormFieldVariableNullValue nullValue) {
        this.nullValue = nullValue;
    }

    public FormFieldVariableBoolValue getBoolValue() {
        return this.boolValue;
    }

    public void setBoolValue(FormFieldVariableBoolValue boolValue) {
        this.boolValue = boolValue;
    }

    public FormFieldVariableStringValue getDepartmentValue() {
        return this.departmentValue;
    }

    public void setDepartmentValue(FormFieldVariableStringValue departmentValue) {
        this.departmentValue = departmentValue;
    }

    public FormFieldVariableI18nValue getI18nValue() {
        return this.i18nValue;
    }

    public void setI18nValue(FormFieldVariableI18nValue i18nValue) {
        this.i18nValue = i18nValue;
    }

    public FormFieldVariableStringValue getObjectValue() {
        return this.objectValue;
    }

    public void setObjectValue(FormFieldVariableStringValue objectValue) {
        this.objectValue = objectValue;
    }


// builder 开始
  public FormVariableValueInfo(){}

  public FormVariableValueInfo(Builder builder){
         /**
          * 文本变量对象
          * <p> 示例值：
          */
      this.textValue = builder.textValue;
         /**
          * 数值变量对象（这里的value必须传入一个合法的数字，常见非法值："" 和 null）
          * <p> 示例值：
          */
      this.numberValue = builder.numberValue;
         /**
          * 日期变量对象（这里的value为从1970年1月1日（UTC/GMT的午夜）开始所经过的天数）
          * <p> 示例值：
          */
      this.dateValue = builder.dateValue;
         /**
          * 员工变量对象（值传入employmentID）
          * <p> 示例值：
          */
      this.employmentValue = builder.employmentValue;
         /**
          * 日期时间变量对象（从1970年1月1日（UTC/GMT的午夜）开始所经过的毫秒数。）
          * <p> 示例值：
          */
      this.dateTimeValue = builder.dateTimeValue;
         /**
          * 枚举变量对象（客户需要传入 枚举的枚举项key作为enum_value.value的值）
          * <p> 示例值：
          */
      this.enumValue = builder.enumValue;
         /**
          * 空变量对象
          * <p> 示例值：
          */
      this.nullValue = builder.nullValue;
         /**
          * 布尔变量对象
          * <p> 示例值：
          */
      this.boolValue = builder.boolValue;
         /**
          * 部门变量对象（值传入departmentID）
          * <p> 示例值：
          */
      this.departmentValue = builder.departmentValue;
         /**
          * i18n变量对象（中英文为可选，但不能出现中英文均为空的数据。）
          * <p> 示例值：
          */
      this.i18nValue = builder.i18nValue;
         /**
          * 对象变量（对于所有引用wukong数据的Value，object_value.value中传入wukong中的wkID。）
          * <p> 示例值：
          */
      this.objectValue = builder.objectValue;
  }

    public static class Builder {
     /**
      * 文本变量对象
      * <p> 示例值：
      */
        private FormFieldVariableStringValue textValue;
     /**
      * 数值变量对象（这里的value必须传入一个合法的数字，常见非法值："" 和 null）
      * <p> 示例值：
      */
        private FormFieldVariableStringValue numberValue;
     /**
      * 日期变量对象（这里的value为从1970年1月1日（UTC/GMT的午夜）开始所经过的天数）
      * <p> 示例值：
      */
        private FormFieldVariableNumberValue dateValue;
     /**
      * 员工变量对象（值传入employmentID）
      * <p> 示例值：
      */
        private FormFieldVariableStringValue employmentValue;
     /**
      * 日期时间变量对象（从1970年1月1日（UTC/GMT的午夜）开始所经过的毫秒数。）
      * <p> 示例值：
      */
        private FormFieldVariableNumberValue dateTimeValue;
     /**
      * 枚举变量对象（客户需要传入 枚举的枚举项key作为enum_value.value的值）
      * <p> 示例值：
      */
        private FormFieldVariableStringValue enumValue;
     /**
      * 空变量对象
      * <p> 示例值：
      */
        private FormFieldVariableNullValue nullValue;
     /**
      * 布尔变量对象
      * <p> 示例值：
      */
        private FormFieldVariableBoolValue boolValue;
     /**
      * 部门变量对象（值传入departmentID）
      * <p> 示例值：
      */
        private FormFieldVariableStringValue departmentValue;
     /**
      * i18n变量对象（中英文为可选，但不能出现中英文均为空的数据。）
      * <p> 示例值：
      */
        private FormFieldVariableI18nValue i18nValue;
     /**
      * 对象变量（对于所有引用wukong数据的Value，object_value.value中传入wukong中的wkID。）
      * <p> 示例值：
      */
        private FormFieldVariableStringValue objectValue;

        /**
         * 文本变量对象
         * <p> 示例值：
         * @param textValue
         * @return
         */
        public Builder textValue(FormFieldVariableStringValue textValue) {
             this.textValue = textValue;
             return this;
        }

    

        /**
         * 数值变量对象（这里的value必须传入一个合法的数字，常见非法值："" 和 null）
         * <p> 示例值：
         * @param numberValue
         * @return
         */
        public Builder numberValue(FormFieldVariableStringValue numberValue) {
             this.numberValue = numberValue;
             return this;
        }

    

        /**
         * 日期变量对象（这里的value为从1970年1月1日（UTC/GMT的午夜）开始所经过的天数）
         * <p> 示例值：
         * @param dateValue
         * @return
         */
        public Builder dateValue(FormFieldVariableNumberValue dateValue) {
             this.dateValue = dateValue;
             return this;
        }

    

        /**
         * 员工变量对象（值传入employmentID）
         * <p> 示例值：
         * @param employmentValue
         * @return
         */
        public Builder employmentValue(FormFieldVariableStringValue employmentValue) {
             this.employmentValue = employmentValue;
             return this;
        }

    

        /**
         * 日期时间变量对象（从1970年1月1日（UTC/GMT的午夜）开始所经过的毫秒数。）
         * <p> 示例值：
         * @param dateTimeValue
         * @return
         */
        public Builder dateTimeValue(FormFieldVariableNumberValue dateTimeValue) {
             this.dateTimeValue = dateTimeValue;
             return this;
        }

    

        /**
         * 枚举变量对象（客户需要传入 枚举的枚举项key作为enum_value.value的值）
         * <p> 示例值：
         * @param enumValue
         * @return
         */
        public Builder enumValue(FormFieldVariableStringValue enumValue) {
             this.enumValue = enumValue;
             return this;
        }

    

        /**
         * 空变量对象
         * <p> 示例值：
         * @param nullValue
         * @return
         */
        public Builder nullValue(FormFieldVariableNullValue nullValue) {
             this.nullValue = nullValue;
             return this;
        }

    

        /**
         * 布尔变量对象
         * <p> 示例值：
         * @param boolValue
         * @return
         */
        public Builder boolValue(FormFieldVariableBoolValue boolValue) {
             this.boolValue = boolValue;
             return this;
        }

    

        /**
         * 部门变量对象（值传入departmentID）
         * <p> 示例值：
         * @param departmentValue
         * @return
         */
        public Builder departmentValue(FormFieldVariableStringValue departmentValue) {
             this.departmentValue = departmentValue;
             return this;
        }

    

        /**
         * i18n变量对象（中英文为可选，但不能出现中英文均为空的数据。）
         * <p> 示例值：
         * @param i18nValue
         * @return
         */
        public Builder i18nValue(FormFieldVariableI18nValue i18nValue) {
             this.i18nValue = i18nValue;
             return this;
        }

    

        /**
         * 对象变量（对于所有引用wukong数据的Value，object_value.value中传入wukong中的wkID。）
         * <p> 示例值：
         * @param objectValue
         * @return
         */
        public Builder objectValue(FormFieldVariableStringValue objectValue) {
             this.objectValue = objectValue;
             return this;
        }

    
    
    public FormVariableValueInfo build(){
        return new FormVariableValueInfo(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
