// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class PatchCustomOrgReq {
     /**
      * 根据client_token是否一致来判断是否为同一请求
      * <p> 示例值：1245464678
      */
    @Query
    @SerializedName("client_token")
    private String clientToken;
     /**
      * 用户 ID 类型
      * <p> 示例值：people_corehr_id
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

     /**
      * 组织ID
      * <p> 示例值：6862995757234914824
      */
    @Path
    @SerializedName("org_id")
    private String orgId;
    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    @Body
    private CustomOrgUpdate body;

    public CustomOrgUpdate getCustomOrgUpdate() {
        return this.body;
    }

    public void setCustomOrgUpdate(CustomOrgUpdate body) {
        this.body = body;
    }

// builder 开始
  public PatchCustomOrgReq(){}

  public PatchCustomOrgReq(Builder builder){
         /**
          * 根据client_token是否一致来判断是否为同一请求
          * <p> 示例值：1245464678
          */
       this.clientToken = builder.clientToken;
         /**
          * 用户 ID 类型
          * <p> 示例值：people_corehr_id
          */
       this.userIdType = builder.userIdType;
     /**
      * 组织ID
      * <p> 示例值：6862995757234914824
      */
       this.orgId = builder.orgId;
        this.body = builder.body;
  }

    public static class Builder {
        private String clientToken; // 根据client_token是否一致来判断是否为同一请求
        private String userIdType; // 用户 ID 类型
    
        /**
         * 根据client_token是否一致来判断是否为同一请求
         * <p> 示例值：1245464678
         * @param clientToken
         * @return
         */
           public Builder clientToken(String clientToken) {
                this.clientToken = clientToken;
                return this;
           }

    
        /**
         * 用户 ID 类型
         * <p> 示例值：people_corehr_id
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 用户 ID 类型
         * <p> 示例值：people_corehr_id
         * @param userIdType {@link com.lark.oapi.service.corehr.v2.enums.PatchCustomOrgUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.corehr.v2.enums.PatchCustomOrgUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        private String orgId; // 组织ID
        /**
         * 组织ID
         * <p> 示例值：6862995757234914824
         * @param orgId
         * @return
         */
          public Builder orgId(String orgId) {
               this.orgId = orgId;
               return this;
          }

    
        private CustomOrgUpdate body;
    
        public CustomOrgUpdate getCustomOrgUpdate() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder customOrgUpdate(CustomOrgUpdate body) {
             this.body = body;
             return this;
        }
    public PatchCustomOrgReq build(){
        return new PatchCustomOrgReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
