// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.corehr.v2.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.corehr.v2.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class UpdateProcessApproverReq {
     /**
      * 用户 ID 类型
      * <p> 示例值：open_id
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 此次调用中使用的部门 ID 类型
      * <p> 示例值：open_department_id
      */
    @Query
    @SerializedName("department_id_type")
    private String departmentIdType;
    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getDepartmentIdType() {
        return this.departmentIdType;
    }

    public void setDepartmentIdType(String departmentIdType) {
        this.departmentIdType = departmentIdType;
    }

     /**
      * 流程实例id
      * <p> 示例值：7328345170959681068
      */
    @Path
    @SerializedName("process_id")
    private String processId;
     /**
      * 审批任务id
      * <p> 示例值：7328345235136726572
      */
    @Path
    @SerializedName("approver_id")
    private String approverId;
    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getApproverId() {
        return this.approverId;
    }

    public void setApproverId(String approverId) {
        this.approverId = approverId;
    }

    @Body
    private ProcessApprover body;

    public ProcessApprover getProcessApprover() {
        return this.body;
    }

    public void setProcessApprover(ProcessApprover body) {
        this.body = body;
    }

// builder 开始
  public UpdateProcessApproverReq(){}

  public UpdateProcessApproverReq(Builder builder){
         /**
          * 用户 ID 类型
          * <p> 示例值：open_id
          */
       this.userIdType = builder.userIdType;
         /**
          * 此次调用中使用的部门 ID 类型
          * <p> 示例值：open_department_id
          */
       this.departmentIdType = builder.departmentIdType;
     /**
      * 流程实例id
      * <p> 示例值：7328345170959681068
      */
       this.processId = builder.processId;
     /**
      * 审批任务id
      * <p> 示例值：7328345235136726572
      */
       this.approverId = builder.approverId;
        this.body = builder.body;
  }

    public static class Builder {
        private String userIdType; // 用户 ID 类型
        private String departmentIdType; // 此次调用中使用的部门 ID 类型
    
        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 用户 ID 类型
         * <p> 示例值：open_id
         * @param userIdType {@link com.lark.oapi.service.corehr.v2.enums.UpdateProcessApproverUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.corehr.v2.enums.UpdateProcessApproverUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        /**
         * 此次调用中使用的部门 ID 类型
         * <p> 示例值：open_department_id
         * @param departmentIdType
         * @return
         */
           public Builder departmentIdType(String departmentIdType) {
                this.departmentIdType = departmentIdType;
                return this;
           }

        /**
         * 此次调用中使用的部门 ID 类型
         * <p> 示例值：open_department_id
         * @param departmentIdType {@link com.lark.oapi.service.corehr.v2.enums.UpdateProcessApproverDepartmentIdTypeEnum}
         * @return
         */
          public Builder departmentIdType(com.lark.oapi.service.corehr.v2.enums.UpdateProcessApproverDepartmentIdTypeEnum departmentIdType) {
               this.departmentIdType = departmentIdType.getValue();
               return this;
          }

    
        private String processId; // 流程实例id
        private String approverId; // 审批任务id
        /**
         * 流程实例id
         * <p> 示例值：7328345170959681068
         * @param processId
         * @return
         */
          public Builder processId(String processId) {
               this.processId = processId;
               return this;
          }

    
        /**
         * 审批任务id
         * <p> 示例值：7328345235136726572
         * @param approverId
         * @return
         */
          public Builder approverId(String approverId) {
               this.approverId = approverId;
               return this;
          }

    
        private ProcessApprover body;
    
        public ProcessApprover getProcessApprover() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder processApprover(ProcessApprover body) {
             this.body = body;
             return this;
        }
    public UpdateProcessApproverReq build(){
        return new UpdateProcessApproverReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
