// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.lark.oapi.service.docx;

import com.lark.oapi.core.Config;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.docx.v1.V1;
import com.lark.oapi.service.docx.v1.model.*;
import com.lark.oapi.service.docx.v1.resource.ChatAnnouncement;
import com.lark.oapi.service.docx.v1.resource.ChatAnnouncementBlock;
import com.lark.oapi.service.docx.v1.resource.ChatAnnouncementBlockChildren;
import com.lark.oapi.service.docx.v1.resource.Document;
import com.lark.oapi.service.docx.v1.resource.DocumentBlock;
import com.lark.oapi.service.docx.v1.resource.DocumentBlockChildren;
import com.lark.oapi.service.docx.v1.resource.DocumentBlockDescendant;

public class DocxService {
    private final V1 v1;
    private final ChatAnnouncement chatAnnouncement; // chat.announcement
    private final ChatAnnouncementBlock chatAnnouncementBlock; // chat.announcement.block
    private final ChatAnnouncementBlockChildren chatAnnouncementBlockChildren; // chat.announcement.block.children
    private final Document document; // 文档
    private final DocumentBlock documentBlock; // 块
    private final DocumentBlockChildren documentBlockChildren; // document.block.children
    private final DocumentBlockDescendant documentBlockDescendant; // document.block.descendant

    public DocxService(Config config) {
    this.v1 = new V1(config);
    this.chatAnnouncement = new ChatAnnouncement(config);
    this.chatAnnouncementBlock = new ChatAnnouncementBlock(config);
    this.chatAnnouncementBlockChildren = new ChatAnnouncementBlockChildren(config);
    this.document = new Document(config);
    this.documentBlock = new DocumentBlock(config);
    this.documentBlockChildren = new DocumentBlockChildren(config);
    this.documentBlockDescendant = new DocumentBlockDescendant(config);
    }
    public V1 v1() {
        return v1;
    }
    public ChatAnnouncement chatAnnouncement() {
        return chatAnnouncement;
    }
    public ChatAnnouncementBlock chatAnnouncementBlock() {
        return chatAnnouncementBlock;
    }
    public ChatAnnouncementBlockChildren chatAnnouncementBlockChildren() {
        return chatAnnouncementBlockChildren;
    }
    public Document document() {
        return document;
    }
    public DocumentBlock documentBlock() {
        return documentBlock;
    }
    public DocumentBlockChildren documentBlockChildren() {
        return documentBlockChildren;
    }
    public DocumentBlockDescendant documentBlockDescendant() {
        return documentBlockDescendant;
    }
}