// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class CreateChatAnnouncementBlockChildrenReq {
     /**
      * 要操作的群公告版本。-1 表示群公告最新版本。群公告创建后，版本为 1。你需确保你已拥有群公告的编辑权限
      * <p> 示例值：-1
      */
    @Query
    @SerializedName("revision_id")
    private Integer revisionId;
     /**
      * 操作的唯一标识，与接口返回值的 client_token 相对应，用于幂等的进行更新操作。此值为空表示将发起一次新的请求，此值非空表示幂等的进行更新操作。
      * <p> 示例值：fe599b60-450f-46ff-b2ef-9f6675625b97
      */
    @Query
    @SerializedName("client_token")
    private String clientToken;
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    public Integer getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Integer revisionId) {
        this.revisionId = revisionId;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

     /**
      * 群公告对应的群 ID
      * <p> 示例值：oc_5ad11d72b830411d72b836c20
      */
    @Path
    @SerializedName("chat_id")
    private String chatId;
     /**
      * Block 的唯一标识
      * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZpFIth
      */
    @Path
    @SerializedName("block_id")
    private String blockId;
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    @Body
    private CreateChatAnnouncementBlockChildrenReqBody body;

    public CreateChatAnnouncementBlockChildrenReqBody getCreateChatAnnouncementBlockChildrenReqBody() {
        return this.body;
    }

    public void setCreateChatAnnouncementBlockChildrenReqBody(CreateChatAnnouncementBlockChildrenReqBody body) {
        this.body = body;
    }

// builder 开始
  public CreateChatAnnouncementBlockChildrenReq(){}

  public CreateChatAnnouncementBlockChildrenReq(Builder builder){
         /**
          * 要操作的群公告版本。-1 表示群公告最新版本。群公告创建后，版本为 1。你需确保你已拥有群公告的编辑权限
          * <p> 示例值：-1
          */
       this.revisionId = builder.revisionId;
         /**
          * 操作的唯一标识，与接口返回值的 client_token 相对应，用于幂等的进行更新操作。此值为空表示将发起一次新的请求，此值非空表示幂等的进行更新操作。
          * <p> 示例值：fe599b60-450f-46ff-b2ef-9f6675625b97
          */
       this.clientToken = builder.clientToken;
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
     /**
      * 群公告对应的群 ID
      * <p> 示例值：oc_5ad11d72b830411d72b836c20
      */
       this.chatId = builder.chatId;
     /**
      * Block 的唯一标识
      * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZpFIth
      */
       this.blockId = builder.blockId;
        this.body = builder.body;
  }

    public static class Builder {
        private Integer revisionId; // 要操作的群公告版本。-1 表示群公告最新版本。群公告创建后，版本为 1。你需确保你已拥有群公告的编辑权限
        private String clientToken; // 操作的唯一标识，与接口返回值的 client_token 相对应，用于幂等的进行更新操作。此值为空表示将发起一次新的请求，此值非空表示幂等的进行更新操作。
        private String userIdType; // 此次调用中使用的用户ID的类型
    
        /**
         * 要操作的群公告版本。-1 表示群公告最新版本。群公告创建后，版本为 1。你需确保你已拥有群公告的编辑权限
         * <p> 示例值：-1
         * @param revisionId
         * @return
         */
           public Builder revisionId(Integer revisionId) {
                this.revisionId = revisionId;
                return this;
           }

    
        /**
         * 操作的唯一标识，与接口返回值的 client_token 相对应，用于幂等的进行更新操作。此值为空表示将发起一次新的请求，此值非空表示幂等的进行更新操作。
         * <p> 示例值：fe599b60-450f-46ff-b2ef-9f6675625b97
         * @param clientToken
         * @return
         */
           public Builder clientToken(String clientToken) {
                this.clientToken = clientToken;
                return this;
           }

    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.docx.v1.enums.CreateChatAnnouncementBlockChildrenUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.docx.v1.enums.CreateChatAnnouncementBlockChildrenUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        private String chatId; // 群公告对应的群 ID
        private String blockId; // Block 的唯一标识
        /**
         * 群公告对应的群 ID
         * <p> 示例值：oc_5ad11d72b830411d72b836c20
         * @param chatId
         * @return
         */
          public Builder chatId(String chatId) {
               this.chatId = chatId;
               return this;
          }

    
        /**
         * Block 的唯一标识
         * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZpFIth
         * @param blockId
         * @return
         */
          public Builder blockId(String blockId) {
               this.blockId = blockId;
               return this;
          }

    
        private CreateChatAnnouncementBlockChildrenReqBody body;
    
        public CreateChatAnnouncementBlockChildrenReqBody getCreateChatAnnouncementBlockChildrenReqBody() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder createChatAnnouncementBlockChildrenReqBody(CreateChatAnnouncementBlockChildrenReqBody body) {
             this.body = body;
             return this;
        }
    public CreateChatAnnouncementBlockChildrenReq build(){
        return new CreateChatAnnouncementBlockChildrenReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
