// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class GetChatAnnouncementBlockReq {
     /**
      * 查询的群公告版本，-1 表示群公告最新版本。群公告创建后，版本为 1。若查询的版本为群公告最新版本，则需要持有群公告的阅读权限；若查询的版本为群公告的历史版本，则需要持有群公告的更新权限
      * <p> 示例值：-1
      */
    @Query
    @SerializedName("revision_id")
    private Integer revisionId;
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    public Integer getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Integer revisionId) {
        this.revisionId = revisionId;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

     /**
      * 群公告对应的群 ID
      * <p> 示例值：oc_5ad11d72b830411d72b836c20
      */
    @Path
    @SerializedName("chat_id")
    private String chatId;
     /**
      * Block 的唯一标识
      * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZabcef
      */
    @Path
    @SerializedName("block_id")
    private String blockId;
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public String getBlockId() {
        return this.blockId;
    }

    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }


// builder 开始
  public GetChatAnnouncementBlockReq(){}

  public GetChatAnnouncementBlockReq(Builder builder){
         /**
          * 查询的群公告版本，-1 表示群公告最新版本。群公告创建后，版本为 1。若查询的版本为群公告最新版本，则需要持有群公告的阅读权限；若查询的版本为群公告的历史版本，则需要持有群公告的更新权限
          * <p> 示例值：-1
          */
       this.revisionId = builder.revisionId;
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
     /**
      * 群公告对应的群 ID
      * <p> 示例值：oc_5ad11d72b830411d72b836c20
      */
       this.chatId = builder.chatId;
     /**
      * Block 的唯一标识
      * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZabcef
      */
       this.blockId = builder.blockId;
  }

    public static class Builder {
        private Integer revisionId; // 查询的群公告版本，-1 表示群公告最新版本。群公告创建后，版本为 1。若查询的版本为群公告最新版本，则需要持有群公告的阅读权限；若查询的版本为群公告的历史版本，则需要持有群公告的更新权限
        private String userIdType; // 此次调用中使用的用户ID的类型
    
        /**
         * 查询的群公告版本，-1 表示群公告最新版本。群公告创建后，版本为 1。若查询的版本为群公告最新版本，则需要持有群公告的阅读权限；若查询的版本为群公告的历史版本，则需要持有群公告的更新权限
         * <p> 示例值：-1
         * @param revisionId
         * @return
         */
           public Builder revisionId(Integer revisionId) {
                this.revisionId = revisionId;
                return this;
           }

    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.docx.v1.enums.GetChatAnnouncementBlockUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.docx.v1.enums.GetChatAnnouncementBlockUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        private String chatId; // 群公告对应的群 ID
        private String blockId; // Block 的唯一标识
        /**
         * 群公告对应的群 ID
         * <p> 示例值：oc_5ad11d72b830411d72b836c20
         * @param chatId
         * @return
         */
          public Builder chatId(String chatId) {
               this.chatId = chatId;
               return this;
          }

    
        /**
         * Block 的唯一标识
         * <p> 示例值：doxcnO6UW6wAw2qIcYf4hZabcef
         * @param blockId
         * @return
         */
          public Builder blockId(String blockId) {
               this.blockId = blockId;
               return this;
          }

    
    public GetChatAnnouncementBlockReq build(){
        return new GetChatAnnouncementBlockReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
