// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.docx.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.docx.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class UpdateTextRequest {
     /**
      * 更新的文本元素列表，单次更新中 reminder 上限 30 个，mention_doc 上限 50 个，mention_user 上限 100 个
      * <p> 示例值：
      */
    @SerializedName("elements")
    private TextElement[] elements;
     /**
      * 更新的文本样式
      * <p> 示例值：
      */
    @SerializedName("style")
    private TextStyle style;
     /**
      * 文本样式中应更新的字段，必须至少指定一个字段。例如，要调整 Block 对齐方式，请设置 fields 为 [1]。
      * <p> 示例值：[1]
      */
    @SerializedName("fields")
    private Integer[] fields;
    public TextElement[] getElements() {
        return this.elements;
    }

    public void setElements(TextElement[] elements) {
        this.elements = elements;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public void setStyle(TextStyle style) {
        this.style = style;
    }

    public Integer[] getFields() {
        return this.fields;
    }

    public void setFields(Integer[] fields) {
        this.fields = fields;
    }


// builder 开始
  public UpdateTextRequest(){}

  public UpdateTextRequest(Builder builder){
         /**
          * 更新的文本元素列表，单次更新中 reminder 上限 30 个，mention_doc 上限 50 个，mention_user 上限 100 个
          * <p> 示例值：
          */
      this.elements = builder.elements;
         /**
          * 更新的文本样式
          * <p> 示例值：
          */
      this.style = builder.style;
         /**
          * 文本样式中应更新的字段，必须至少指定一个字段。例如，要调整 Block 对齐方式，请设置 fields 为 [1]。
          * <p> 示例值：[1]
          */
      this.fields = builder.fields;
  }

    public static class Builder {
     /**
      * 更新的文本元素列表，单次更新中 reminder 上限 30 个，mention_doc 上限 50 个，mention_user 上限 100 个
      * <p> 示例值：
      */
        private TextElement[] elements;
     /**
      * 更新的文本样式
      * <p> 示例值：
      */
        private TextStyle style;
     /**
      * 文本样式中应更新的字段，必须至少指定一个字段。例如，要调整 Block 对齐方式，请设置 fields 为 [1]。
      * <p> 示例值：[1]
      */
        private Integer[] fields;

        /**
         * 更新的文本元素列表，单次更新中 reminder 上限 30 个，mention_doc 上限 50 个，mention_user 上限 100 个
         * <p> 示例值：
         * @param elements
         * @return
         */
        public Builder elements(TextElement[] elements) {
             this.elements = elements;
             return this;
        }

    

        /**
         * 更新的文本样式
         * <p> 示例值：
         * @param style
         * @return
         */
        public Builder style(TextStyle style) {
             this.style = style;
             return this;
        }

    

        /**
         * 文本样式中应更新的字段，必须至少指定一个字段。例如，要调整 Block 对齐方式，请设置 fields 为 [1]。
         * <p> 示例值：[1]
         * @param fields
         * @return
         */
        public Builder fields(Integer[] fields) {
             this.fields = fields;
             return this;
        }

    
    
    public UpdateTextRequest build(){
        return new UpdateTextRequest(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
