// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class JobDetailBasicInfo {
     /**
      * 职位 ID
      * <p> 示例值：6001
      */
    @SerializedName("id")
    private String id;
     /**
      * 职位名称
      * <p> 示例值：测试职位
      */
    @SerializedName("title")
    private String title;
     /**
      * 职位描述
      * <p> 示例值：职位描述文本
      */
    @SerializedName("description")
    private String description;
     /**
      * 职位编号
      * <p> 示例值：R18
      */
    @SerializedName("code")
    private String code;
     /**
      * 职位要求
      * <p> 示例值：职位要求文本
      */
    @SerializedName("requirement")
    private String requirement;
     /**
      * 雇佣类型
      * <p> 示例值：
      */
    @SerializedName("recruitment_type")
    private JobDetailRecruitmentType recruitmentType;
     /**
      * 部门
      * <p> 示例值：
      */
    @SerializedName("department")
    private JobDetailDepartment department;
     /**
      * 最低职级
      * <p> 示例值：
      */
    @SerializedName("min_job_level")
    private JobDetailLevel minJobLevel;
     /**
      * 最高职级
      * <p> 示例值：
      */
    @SerializedName("max_job_level")
    private JobDetailLevel maxJobLevel;
     /**
      * 职位亮点
      * <p> 示例值：
      */
    @SerializedName("highlight_list")
    private JobDetailHighlight[] highlightList;
     /**
      * 职位序列
      * <p> 示例值：
      */
    @SerializedName("job_category")
    private JobDetailCategory jobCategory;
     /**
      * 职位类别
      * <p> 示例值：
      */
    @SerializedName("job_type")
    private JobDetailType jobType;
     /**
      * 启用状态
      * <p> 示例值：1
      */
    @SerializedName("active_status")
    private Integer activeStatus;
     /**
      * 创建人ID，若为空则为系统或其他对接系统创建
      * <p> 示例值：ou-xxx
      */
    @SerializedName("creator_id")
    private String creatorId;
     /**
      * 创建时间, 毫秒级时间戳
      * <p> 示例值：1617170925462
      */
    @SerializedName("create_time")
    private String createTime;
     /**
      * 更新时间，毫秒级时间戳
      * <p> 示例值：1617170925462
      */
    @SerializedName("update_time")
    private String updateTime;
     /**
      * 职位流程类型
      * <p> 示例值：1
      */
    @SerializedName("process_type")
    private Integer processType;
     /**
      * 职位流程 ID
      * <p> 示例值：1
      */
    @SerializedName("process_id")
    private String processId;
     /**
      * 职位流程名称
      * <p> 示例值：
      */
    @SerializedName("process_name")
    private I18n processName;
     /**
      * 自定义字段列表
      * <p> 示例值：
      */
    @SerializedName("customized_data_list")
    private JobCustomizedData[] customizedDataList;
     /**
      * 职能分类
      * <p> 示例值：
      */
    @SerializedName("job_function")
    private IdNameObject jobFunction;
     /**
      * 职位项目
      * <p> 示例值：
      */
    @SerializedName("subject")
    private IdNameObject subject;
     /**
      * 招聘数量
      * <p> 示例值：100
      */
    @SerializedName("head_count")
    private Integer headCount;
     /**
      * 工作年限
      * <p> 示例值：1
      */
    @SerializedName("experience")
    private Integer experience;
     /**
      * 到期日期,毫秒级时间戳
      * <p> 示例值：1622484739955
      */
    @SerializedName("expiry_time")
    private String expiryTime;
     /**
      * 最低薪资，单位:k
      * <p> 示例值：10
      */
    @SerializedName("min_salary")
    private Integer minSalary;
     /**
      * 最高薪资，单位:k
      * <p> 示例值：20
      */
    @SerializedName("max_salary")
    private Integer maxSalary;
     /**
      * 学历要求
      * <p> 示例值：1
      */
    @SerializedName("required_degree")
    private Integer requiredDegree;
     /**
      * 工作地点列表
      * <p> 示例值：
      */
    @SerializedName("city_list")
    private CodeNameObject[] cityList;
     /**
      * 职位属性，1是实体职位，2是虚拟职位
      * <p> 示例值：1
      */
    @SerializedName("job_attribute")
    private Integer jobAttribute;
     /**
      * 目标专业
      * <p> 示例值：
      */
    @SerializedName("target_major_list")
    private JobDetailTargetMajorInfo[] targetMajorList;
     /**
      * 标志是否门店职位，1是普通职位，2是门店职位
      * <p> 示例值：1
      */
    @SerializedName("storefront_mode")
    private Integer storefrontMode;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRequirement() {
        return this.requirement;
    }

    public void setRequirement(String requirement) {
        this.requirement = requirement;
    }

    public JobDetailRecruitmentType getRecruitmentType() {
        return this.recruitmentType;
    }

    public void setRecruitmentType(JobDetailRecruitmentType recruitmentType) {
        this.recruitmentType = recruitmentType;
    }

    public JobDetailDepartment getDepartment() {
        return this.department;
    }

    public void setDepartment(JobDetailDepartment department) {
        this.department = department;
    }

    public JobDetailLevel getMinJobLevel() {
        return this.minJobLevel;
    }

    public void setMinJobLevel(JobDetailLevel minJobLevel) {
        this.minJobLevel = minJobLevel;
    }

    public JobDetailLevel getMaxJobLevel() {
        return this.maxJobLevel;
    }

    public void setMaxJobLevel(JobDetailLevel maxJobLevel) {
        this.maxJobLevel = maxJobLevel;
    }

    public JobDetailHighlight[] getHighlightList() {
        return this.highlightList;
    }

    public void setHighlightList(JobDetailHighlight[] highlightList) {
        this.highlightList = highlightList;
    }

    public JobDetailCategory getJobCategory() {
        return this.jobCategory;
    }

    public void setJobCategory(JobDetailCategory jobCategory) {
        this.jobCategory = jobCategory;
    }

    public JobDetailType getJobType() {
        return this.jobType;
    }

    public void setJobType(JobDetailType jobType) {
        this.jobType = jobType;
    }

    public Integer getActiveStatus() {
        return this.activeStatus;
    }

    public void setActiveStatus(Integer activeStatus) {
        this.activeStatus = activeStatus;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getProcessType() {
        return this.processType;
    }

    public void setProcessType(Integer processType) {
        this.processType = processType;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public I18n getProcessName() {
        return this.processName;
    }

    public void setProcessName(I18n processName) {
        this.processName = processName;
    }

    public JobCustomizedData[] getCustomizedDataList() {
        return this.customizedDataList;
    }

    public void setCustomizedDataList(JobCustomizedData[] customizedDataList) {
        this.customizedDataList = customizedDataList;
    }

    public IdNameObject getJobFunction() {
        return this.jobFunction;
    }

    public void setJobFunction(IdNameObject jobFunction) {
        this.jobFunction = jobFunction;
    }

    public IdNameObject getSubject() {
        return this.subject;
    }

    public void setSubject(IdNameObject subject) {
        this.subject = subject;
    }

    public Integer getHeadCount() {
        return this.headCount;
    }

    public void setHeadCount(Integer headCount) {
        this.headCount = headCount;
    }

    public Integer getExperience() {
        return this.experience;
    }

    public void setExperience(Integer experience) {
        this.experience = experience;
    }

    public String getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Integer getMinSalary() {
        return this.minSalary;
    }

    public void setMinSalary(Integer minSalary) {
        this.minSalary = minSalary;
    }

    public Integer getMaxSalary() {
        return this.maxSalary;
    }

    public void setMaxSalary(Integer maxSalary) {
        this.maxSalary = maxSalary;
    }

    public Integer getRequiredDegree() {
        return this.requiredDegree;
    }

    public void setRequiredDegree(Integer requiredDegree) {
        this.requiredDegree = requiredDegree;
    }

    public CodeNameObject[] getCityList() {
        return this.cityList;
    }

    public void setCityList(CodeNameObject[] cityList) {
        this.cityList = cityList;
    }

    public Integer getJobAttribute() {
        return this.jobAttribute;
    }

    public void setJobAttribute(Integer jobAttribute) {
        this.jobAttribute = jobAttribute;
    }

    public JobDetailTargetMajorInfo[] getTargetMajorList() {
        return this.targetMajorList;
    }

    public void setTargetMajorList(JobDetailTargetMajorInfo[] targetMajorList) {
        this.targetMajorList = targetMajorList;
    }

    public Integer getStorefrontMode() {
        return this.storefrontMode;
    }

    public void setStorefrontMode(Integer storefrontMode) {
        this.storefrontMode = storefrontMode;
    }


// builder 开始
  public JobDetailBasicInfo(){}

  public JobDetailBasicInfo(Builder builder){
         /**
          * 职位 ID
          * <p> 示例值：6001
          */
      this.id = builder.id;
         /**
          * 职位名称
          * <p> 示例值：测试职位
          */
      this.title = builder.title;
         /**
          * 职位描述
          * <p> 示例值：职位描述文本
          */
      this.description = builder.description;
         /**
          * 职位编号
          * <p> 示例值：R18
          */
      this.code = builder.code;
         /**
          * 职位要求
          * <p> 示例值：职位要求文本
          */
      this.requirement = builder.requirement;
         /**
          * 雇佣类型
          * <p> 示例值：
          */
      this.recruitmentType = builder.recruitmentType;
         /**
          * 部门
          * <p> 示例值：
          */
      this.department = builder.department;
         /**
          * 最低职级
          * <p> 示例值：
          */
      this.minJobLevel = builder.minJobLevel;
         /**
          * 最高职级
          * <p> 示例值：
          */
      this.maxJobLevel = builder.maxJobLevel;
         /**
          * 职位亮点
          * <p> 示例值：
          */
      this.highlightList = builder.highlightList;
         /**
          * 职位序列
          * <p> 示例值：
          */
      this.jobCategory = builder.jobCategory;
         /**
          * 职位类别
          * <p> 示例值：
          */
      this.jobType = builder.jobType;
         /**
          * 启用状态
          * <p> 示例值：1
          */
      this.activeStatus = builder.activeStatus;
         /**
          * 创建人ID，若为空则为系统或其他对接系统创建
          * <p> 示例值：ou-xxx
          */
      this.creatorId = builder.creatorId;
         /**
          * 创建时间, 毫秒级时间戳
          * <p> 示例值：1617170925462
          */
      this.createTime = builder.createTime;
         /**
          * 更新时间，毫秒级时间戳
          * <p> 示例值：1617170925462
          */
      this.updateTime = builder.updateTime;
         /**
          * 职位流程类型
          * <p> 示例值：1
          */
      this.processType = builder.processType;
         /**
          * 职位流程 ID
          * <p> 示例值：1
          */
      this.processId = builder.processId;
         /**
          * 职位流程名称
          * <p> 示例值：
          */
      this.processName = builder.processName;
         /**
          * 自定义字段列表
          * <p> 示例值：
          */
      this.customizedDataList = builder.customizedDataList;
         /**
          * 职能分类
          * <p> 示例值：
          */
      this.jobFunction = builder.jobFunction;
         /**
          * 职位项目
          * <p> 示例值：
          */
      this.subject = builder.subject;
         /**
          * 招聘数量
          * <p> 示例值：100
          */
      this.headCount = builder.headCount;
         /**
          * 工作年限
          * <p> 示例值：1
          */
      this.experience = builder.experience;
         /**
          * 到期日期,毫秒级时间戳
          * <p> 示例值：1622484739955
          */
      this.expiryTime = builder.expiryTime;
         /**
          * 最低薪资，单位:k
          * <p> 示例值：10
          */
      this.minSalary = builder.minSalary;
         /**
          * 最高薪资，单位:k
          * <p> 示例值：20
          */
      this.maxSalary = builder.maxSalary;
         /**
          * 学历要求
          * <p> 示例值：1
          */
      this.requiredDegree = builder.requiredDegree;
         /**
          * 工作地点列表
          * <p> 示例值：
          */
      this.cityList = builder.cityList;
         /**
          * 职位属性，1是实体职位，2是虚拟职位
          * <p> 示例值：1
          */
      this.jobAttribute = builder.jobAttribute;
         /**
          * 目标专业
          * <p> 示例值：
          */
      this.targetMajorList = builder.targetMajorList;
         /**
          * 标志是否门店职位，1是普通职位，2是门店职位
          * <p> 示例值：1
          */
      this.storefrontMode = builder.storefrontMode;
  }

    public static class Builder {
     /**
      * 职位 ID
      * <p> 示例值：6001
      */
        private String id;
     /**
      * 职位名称
      * <p> 示例值：测试职位
      */
        private String title;
     /**
      * 职位描述
      * <p> 示例值：职位描述文本
      */
        private String description;
     /**
      * 职位编号
      * <p> 示例值：R18
      */
        private String code;
     /**
      * 职位要求
      * <p> 示例值：职位要求文本
      */
        private String requirement;
     /**
      * 雇佣类型
      * <p> 示例值：
      */
        private JobDetailRecruitmentType recruitmentType;
     /**
      * 部门
      * <p> 示例值：
      */
        private JobDetailDepartment department;
     /**
      * 最低职级
      * <p> 示例值：
      */
        private JobDetailLevel minJobLevel;
     /**
      * 最高职级
      * <p> 示例值：
      */
        private JobDetailLevel maxJobLevel;
     /**
      * 职位亮点
      * <p> 示例值：
      */
        private JobDetailHighlight[] highlightList;
     /**
      * 职位序列
      * <p> 示例值：
      */
        private JobDetailCategory jobCategory;
     /**
      * 职位类别
      * <p> 示例值：
      */
        private JobDetailType jobType;
     /**
      * 启用状态
      * <p> 示例值：1
      */
        private Integer activeStatus;
     /**
      * 创建人ID，若为空则为系统或其他对接系统创建
      * <p> 示例值：ou-xxx
      */
        private String creatorId;
     /**
      * 创建时间, 毫秒级时间戳
      * <p> 示例值：1617170925462
      */
        private String createTime;
     /**
      * 更新时间，毫秒级时间戳
      * <p> 示例值：1617170925462
      */
        private String updateTime;
     /**
      * 职位流程类型
      * <p> 示例值：1
      */
        private Integer processType;
     /**
      * 职位流程 ID
      * <p> 示例值：1
      */
        private String processId;
     /**
      * 职位流程名称
      * <p> 示例值：
      */
        private I18n processName;
     /**
      * 自定义字段列表
      * <p> 示例值：
      */
        private JobCustomizedData[] customizedDataList;
     /**
      * 职能分类
      * <p> 示例值：
      */
        private IdNameObject jobFunction;
     /**
      * 职位项目
      * <p> 示例值：
      */
        private IdNameObject subject;
     /**
      * 招聘数量
      * <p> 示例值：100
      */
        private Integer headCount;
     /**
      * 工作年限
      * <p> 示例值：1
      */
        private Integer experience;
     /**
      * 到期日期,毫秒级时间戳
      * <p> 示例值：1622484739955
      */
        private String expiryTime;
     /**
      * 最低薪资，单位:k
      * <p> 示例值：10
      */
        private Integer minSalary;
     /**
      * 最高薪资，单位:k
      * <p> 示例值：20
      */
        private Integer maxSalary;
     /**
      * 学历要求
      * <p> 示例值：1
      */
        private Integer requiredDegree;
     /**
      * 工作地点列表
      * <p> 示例值：
      */
        private CodeNameObject[] cityList;
     /**
      * 职位属性，1是实体职位，2是虚拟职位
      * <p> 示例值：1
      */
        private Integer jobAttribute;
     /**
      * 目标专业
      * <p> 示例值：
      */
        private JobDetailTargetMajorInfo[] targetMajorList;
     /**
      * 标志是否门店职位，1是普通职位，2是门店职位
      * <p> 示例值：1
      */
        private Integer storefrontMode;

        /**
         * 职位 ID
         * <p> 示例值：6001
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 职位名称
         * <p> 示例值：测试职位
         * @param title
         * @return
         */
        public Builder title(String title) {
             this.title = title;
             return this;
        }

    

        /**
         * 职位描述
         * <p> 示例值：职位描述文本
         * @param description
         * @return
         */
        public Builder description(String description) {
             this.description = description;
             return this;
        }

    

        /**
         * 职位编号
         * <p> 示例值：R18
         * @param code
         * @return
         */
        public Builder code(String code) {
             this.code = code;
             return this;
        }

    

        /**
         * 职位要求
         * <p> 示例值：职位要求文本
         * @param requirement
         * @return
         */
        public Builder requirement(String requirement) {
             this.requirement = requirement;
             return this;
        }

    

        /**
         * 雇佣类型
         * <p> 示例值：
         * @param recruitmentType
         * @return
         */
        public Builder recruitmentType(JobDetailRecruitmentType recruitmentType) {
             this.recruitmentType = recruitmentType;
             return this;
        }

    

        /**
         * 部门
         * <p> 示例值：
         * @param department
         * @return
         */
        public Builder department(JobDetailDepartment department) {
             this.department = department;
             return this;
        }

    

        /**
         * 最低职级
         * <p> 示例值：
         * @param minJobLevel
         * @return
         */
        public Builder minJobLevel(JobDetailLevel minJobLevel) {
             this.minJobLevel = minJobLevel;
             return this;
        }

    

        /**
         * 最高职级
         * <p> 示例值：
         * @param maxJobLevel
         * @return
         */
        public Builder maxJobLevel(JobDetailLevel maxJobLevel) {
             this.maxJobLevel = maxJobLevel;
             return this;
        }

    

        /**
         * 职位亮点
         * <p> 示例值：
         * @param highlightList
         * @return
         */
        public Builder highlightList(JobDetailHighlight[] highlightList) {
             this.highlightList = highlightList;
             return this;
        }

    

        /**
         * 职位序列
         * <p> 示例值：
         * @param jobCategory
         * @return
         */
        public Builder jobCategory(JobDetailCategory jobCategory) {
             this.jobCategory = jobCategory;
             return this;
        }

    

        /**
         * 职位类别
         * <p> 示例值：
         * @param jobType
         * @return
         */
        public Builder jobType(JobDetailType jobType) {
             this.jobType = jobType;
             return this;
        }

    

        /**
         * 启用状态
         * <p> 示例值：1
         * @param activeStatus
         * @return
         */
        public Builder activeStatus(Integer activeStatus) {
             this.activeStatus = activeStatus;
             return this;
        }

    

        /**
         * 创建人ID，若为空则为系统或其他对接系统创建
         * <p> 示例值：ou-xxx
         * @param creatorId
         * @return
         */
        public Builder creatorId(String creatorId) {
             this.creatorId = creatorId;
             return this;
        }

    

        /**
         * 创建时间, 毫秒级时间戳
         * <p> 示例值：1617170925462
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
             this.createTime = createTime;
             return this;
        }

    

        /**
         * 更新时间，毫秒级时间戳
         * <p> 示例值：1617170925462
         * @param updateTime
         * @return
         */
        public Builder updateTime(String updateTime) {
             this.updateTime = updateTime;
             return this;
        }

    

        /**
         * 职位流程类型
         * <p> 示例值：1
         * @param processType
         * @return
         */
        public Builder processType(Integer processType) {
             this.processType = processType;
             return this;
        }

    

        /**
         * 职位流程 ID
         * <p> 示例值：1
         * @param processId
         * @return
         */
        public Builder processId(String processId) {
             this.processId = processId;
             return this;
        }

    

        /**
         * 职位流程名称
         * <p> 示例值：
         * @param processName
         * @return
         */
        public Builder processName(I18n processName) {
             this.processName = processName;
             return this;
        }

    

        /**
         * 自定义字段列表
         * <p> 示例值：
         * @param customizedDataList
         * @return
         */
        public Builder customizedDataList(JobCustomizedData[] customizedDataList) {
             this.customizedDataList = customizedDataList;
             return this;
        }

    

        /**
         * 职能分类
         * <p> 示例值：
         * @param jobFunction
         * @return
         */
        public Builder jobFunction(IdNameObject jobFunction) {
             this.jobFunction = jobFunction;
             return this;
        }

    

        /**
         * 职位项目
         * <p> 示例值：
         * @param subject
         * @return
         */
        public Builder subject(IdNameObject subject) {
             this.subject = subject;
             return this;
        }

    

        /**
         * 招聘数量
         * <p> 示例值：100
         * @param headCount
         * @return
         */
        public Builder headCount(Integer headCount) {
             this.headCount = headCount;
             return this;
        }

    

        /**
         * 工作年限
         * <p> 示例值：1
         * @param experience
         * @return
         */
        public Builder experience(Integer experience) {
             this.experience = experience;
             return this;
        }

    

        /**
         * 到期日期,毫秒级时间戳
         * <p> 示例值：1622484739955
         * @param expiryTime
         * @return
         */
        public Builder expiryTime(String expiryTime) {
             this.expiryTime = expiryTime;
             return this;
        }

    

        /**
         * 最低薪资，单位:k
         * <p> 示例值：10
         * @param minSalary
         * @return
         */
        public Builder minSalary(Integer minSalary) {
             this.minSalary = minSalary;
             return this;
        }

    

        /**
         * 最高薪资，单位:k
         * <p> 示例值：20
         * @param maxSalary
         * @return
         */
        public Builder maxSalary(Integer maxSalary) {
             this.maxSalary = maxSalary;
             return this;
        }

    

        /**
         * 学历要求
         * <p> 示例值：1
         * @param requiredDegree
         * @return
         */
        public Builder requiredDegree(Integer requiredDegree) {
             this.requiredDegree = requiredDegree;
             return this;
        }

    

        /**
         * 工作地点列表
         * <p> 示例值：
         * @param cityList
         * @return
         */
        public Builder cityList(CodeNameObject[] cityList) {
             this.cityList = cityList;
             return this;
        }

    

        /**
         * 职位属性，1是实体职位，2是虚拟职位
         * <p> 示例值：1
         * @param jobAttribute
         * @return
         */
        public Builder jobAttribute(Integer jobAttribute) {
             this.jobAttribute = jobAttribute;
             return this;
        }

    

        /**
         * 目标专业
         * <p> 示例值：
         * @param targetMajorList
         * @return
         */
        public Builder targetMajorList(JobDetailTargetMajorInfo[] targetMajorList) {
             this.targetMajorList = targetMajorList;
             return this;
        }

    

        /**
         * 标志是否门店职位，1是普通职位，2是门店职位
         * <p> 示例值：1
         * @param storefrontMode
         * @return
         */
        public Builder storefrontMode(Integer storefrontMode) {
             this.storefrontMode = storefrontMode;
             return this;
        }

    
    
    public JobDetailBasicInfo build(){
        return new JobDetailBasicInfo(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
