// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListApplicationInterviewReq {
     /**
      * 分页大小，不能超过 50
      * <p> 示例值：10
      */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
     /**
      * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
      * <p> 示例值：xx
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：open_id
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 此次调用中使用的「职级 ID」的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("job_level_id_type")
    private String jobLevelIdType;
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getJobLevelIdType() {
        return this.jobLevelIdType;
    }

    public void setJobLevelIdType(String jobLevelIdType) {
        this.jobLevelIdType = jobLevelIdType;
    }

     /**
      * 投递 ID
      * <p> 示例值：6960663240925956555
      */
    @Path
    @SerializedName("application_id")
    private String applicationId;
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }


// builder 开始
  public ListApplicationInterviewReq(){}

  public ListApplicationInterviewReq(Builder builder){
         /**
          * 分页大小，不能超过 50
          * <p> 示例值：10
          */
       this.pageSize = builder.pageSize;
         /**
          * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
          * <p> 示例值：xx
          */
       this.pageToken = builder.pageToken;
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：open_id
          */
       this.userIdType = builder.userIdType;
         /**
          * 此次调用中使用的「职级 ID」的类型
          * <p> 示例值：
          */
       this.jobLevelIdType = builder.jobLevelIdType;
     /**
      * 投递 ID
      * <p> 示例值：6960663240925956555
      */
       this.applicationId = builder.applicationId;
  }

    public static class Builder {
        private Integer pageSize; // 分页大小，不能超过 50
        private String pageToken; // 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String jobLevelIdType; // 此次调用中使用的「职级 ID」的类型
    
        /**
         * 分页大小，不能超过 50
         * <p> 示例值：10
         * @param pageSize
         * @return
         */
           public Builder pageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        /**
         * 分页标记，第一次请求不填，表示从头开始遍历；分页查询结果还有更多项时会同时返回新的 page_token，下次遍历可采用该 page_token 获取查询结果
         * <p> 示例值：xx
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：open_id
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

    
        /**
         * 此次调用中使用的「职级 ID」的类型
         * <p> 示例值：
         * @param jobLevelIdType
         * @return
         */
           public Builder jobLevelIdType(String jobLevelIdType) {
                this.jobLevelIdType = jobLevelIdType;
                return this;
           }

    
        private String applicationId; // 投递 ID
        /**
         * 投递 ID
         * <p> 示例值：6960663240925956555
         * @param applicationId
         * @return
         */
          public Builder applicationId(String applicationId) {
               this.applicationId = applicationId;
               return this;
          }

    
    public ListApplicationInterviewReq build(){
        return new ListApplicationInterviewReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
