// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListUserRoleReq {
     /**
      * 下一页页码
      * <p> 示例值：eyJvZmZzZXQiOjEwLCJ0aW1lc3RhbXAiOjE2Mjc1NTUyMjM2NzIsImlkIjpudWxsfQ==
      */
    @Query
    @SerializedName("page_token")
    private String pageToken;
     /**
      * 每页获取记录数量，最大10
      * <p> 示例值：10
      */
    @Query
    @SerializedName("page_size")
    private Integer pageSize;
     /**
      * 用户 ID
      * <p> 示例值：ou_xxxx
      */
    @Query
    @SerializedName("user_id")
    private String userId;
     /**
      * 角色 ID
      * <p> 示例值：101
      */
    @Query
    @SerializedName("role_id")
    private String roleId;
     /**
      * 最早更新时间，毫秒级时间戳
      * <p> 示例值：1618500278663
      */
    @Query
    @SerializedName("update_start_time")
    private String updateStartTime;
     /**
      * 最晚更新时间，毫秒级时间戳
      * <p> 示例值：1618500278663
      */
    @Query
    @SerializedName("update_end_time")
    private String updateEndTime;
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getUpdateStartTime() {
        return this.updateStartTime;
    }

    public void setUpdateStartTime(String updateStartTime) {
        this.updateStartTime = updateStartTime;
    }

    public String getUpdateEndTime() {
        return this.updateEndTime;
    }

    public void setUpdateEndTime(String updateEndTime) {
        this.updateEndTime = updateEndTime;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }


// builder 开始
  public ListUserRoleReq(){}

  public ListUserRoleReq(Builder builder){
         /**
          * 下一页页码
          * <p> 示例值：eyJvZmZzZXQiOjEwLCJ0aW1lc3RhbXAiOjE2Mjc1NTUyMjM2NzIsImlkIjpudWxsfQ==
          */
       this.pageToken = builder.pageToken;
         /**
          * 每页获取记录数量，最大10
          * <p> 示例值：10
          */
       this.pageSize = builder.pageSize;
         /**
          * 用户 ID
          * <p> 示例值：ou_xxxx
          */
       this.userId = builder.userId;
         /**
          * 角色 ID
          * <p> 示例值：101
          */
       this.roleId = builder.roleId;
         /**
          * 最早更新时间，毫秒级时间戳
          * <p> 示例值：1618500278663
          */
       this.updateStartTime = builder.updateStartTime;
         /**
          * 最晚更新时间，毫秒级时间戳
          * <p> 示例值：1618500278663
          */
       this.updateEndTime = builder.updateEndTime;
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
  }

    public static class Builder {
        private String pageToken; // 下一页页码
        private Integer pageSize; // 每页获取记录数量，最大10
        private String userId; // 用户 ID
        private String roleId; // 角色 ID
        private String updateStartTime; // 最早更新时间，毫秒级时间戳
        private String updateEndTime; // 最晚更新时间，毫秒级时间戳
        private String userIdType; // 此次调用中使用的用户ID的类型
    
        /**
         * 下一页页码
         * <p> 示例值：eyJvZmZzZXQiOjEwLCJ0aW1lc3RhbXAiOjE2Mjc1NTUyMjM2NzIsImlkIjpudWxsfQ==
         * @param pageToken
         * @return
         */
           public Builder pageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
           }

    
        /**
         * 每页获取记录数量，最大10
         * <p> 示例值：10
         * @param pageSize
         * @return
         */
           public Builder pageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
           }

    
        /**
         * 用户 ID
         * <p> 示例值：ou_xxxx
         * @param userId
         * @return
         */
           public Builder userId(String userId) {
                this.userId = userId;
                return this;
           }

    
        /**
         * 角色 ID
         * <p> 示例值：101
         * @param roleId
         * @return
         */
           public Builder roleId(String roleId) {
                this.roleId = roleId;
                return this;
           }

    
        /**
         * 最早更新时间，毫秒级时间戳
         * <p> 示例值：1618500278663
         * @param updateStartTime
         * @return
         */
           public Builder updateStartTime(String updateStartTime) {
                this.updateStartTime = updateStartTime;
                return this;
           }

    
        /**
         * 最晚更新时间，毫秒级时间戳
         * <p> 示例值：1618500278663
         * @param updateEndTime
         * @return
         */
           public Builder updateEndTime(String updateEndTime) {
                this.updateEndTime = updateEndTime;
                return this;
           }

    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

    
    public ListUserRoleReq build(){
        return new ListUserRoleReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
