// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.hire.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Sentence {
     /**
      * 速记句子文本
      * <p> 示例值：你好，可以做一下自我介绍么？
      */
    @SerializedName("content")
    private String content;
     /**
      * 句子开始讲话时的毫秒级时间戳
      * <p> 示例值：1720967514994
      */
    @SerializedName("speak_time")
    private String speakTime;
     /**
      * 该句子的说话人用户类型
      * <p> 示例值：1
      */
    @SerializedName("user_type")
    private Integer userType;
     /**
      * 该句子的说话人名称
      * <p> 示例值：
      */
    @SerializedName("speaker_name")
    private I18n speakerName;
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSpeakTime() {
        return this.speakTime;
    }

    public void setSpeakTime(String speakTime) {
        this.speakTime = speakTime;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public I18n getSpeakerName() {
        return this.speakerName;
    }

    public void setSpeakerName(I18n speakerName) {
        this.speakerName = speakerName;
    }


// builder 开始
  public Sentence(){}

  public Sentence(Builder builder){
         /**
          * 速记句子文本
          * <p> 示例值：你好，可以做一下自我介绍么？
          */
      this.content = builder.content;
         /**
          * 句子开始讲话时的毫秒级时间戳
          * <p> 示例值：1720967514994
          */
      this.speakTime = builder.speakTime;
         /**
          * 该句子的说话人用户类型
          * <p> 示例值：1
          */
      this.userType = builder.userType;
         /**
          * 该句子的说话人名称
          * <p> 示例值：
          */
      this.speakerName = builder.speakerName;
  }

    public static class Builder {
     /**
      * 速记句子文本
      * <p> 示例值：你好，可以做一下自我介绍么？
      */
        private String content;
     /**
      * 句子开始讲话时的毫秒级时间戳
      * <p> 示例值：1720967514994
      */
        private String speakTime;
     /**
      * 该句子的说话人用户类型
      * <p> 示例值：1
      */
        private Integer userType;
     /**
      * 该句子的说话人名称
      * <p> 示例值：
      */
        private I18n speakerName;

        /**
         * 速记句子文本
         * <p> 示例值：你好，可以做一下自我介绍么？
         * @param content
         * @return
         */
        public Builder content(String content) {
             this.content = content;
             return this;
        }

    

        /**
         * 句子开始讲话时的毫秒级时间戳
         * <p> 示例值：1720967514994
         * @param speakTime
         * @return
         */
        public Builder speakTime(String speakTime) {
             this.speakTime = speakTime;
             return this;
        }

    

        /**
         * 该句子的说话人用户类型
         * <p> 示例值：1
         * @param userType
         * @return
         */
        public Builder userType(Integer userType) {
             this.userType = userType;
             return this;
        }

    

        /**
         * 该句子的说话人名称
         * <p> 示例值：
         * @param speakerName
         * @return
         */
        public Builder speakerName(I18n speakerName) {
             this.speakerName = speakerName;
             return this;
        }

    
    
    public Sentence build(){
        return new Sentence(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
