// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.im.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.im.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class UpdateChatReq {
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

     /**
      * 群 ID，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description);;**注意**：仅支持群模式为`group`的群组ID
      * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
      */
    @Path
    @SerializedName("chat_id")
    private String chatId;
    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @Body
    private UpdateChatReqBody body;

    public UpdateChatReqBody getUpdateChatReqBody() {
        return this.body;
    }

    public void setUpdateChatReqBody(UpdateChatReqBody body) {
        this.body = body;
    }

// builder 开始
  public UpdateChatReq(){}

  public UpdateChatReq(Builder builder){
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
     /**
      * 群 ID，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description);;**注意**：仅支持群模式为`group`的群组ID
      * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
      */
       this.chatId = builder.chatId;
        this.body = builder.body;
  }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.im.v1.enums.UpdateChatUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.im.v1.enums.UpdateChatUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        private String chatId; // 群 ID，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description);;**注意**：仅支持群模式为`group`的群组ID
        /**
         * 群 ID，详情参见[群ID 说明](https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description);;**注意**：仅支持群模式为`group`的群组ID
         * <p> 示例值：oc_a0553eda9014c201e6969b478895c230
         * @param chatId
         * @return
         */
          public Builder chatId(String chatId) {
               this.chatId = chatId;
               return this;
          }

    
        private UpdateChatReqBody body;
    
        public UpdateChatReqBody getUpdateChatReqBody() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder updateChatReqBody(UpdateChatReqBody body) {
             this.body = body;
             return this;
        }
    public UpdateChatReq build(){
        return new UpdateChatReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
