// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Folder {
     /**
      * folder id
      * <p> 示例值：12314123123123123
      */
    @SerializedName("id")
    private String id;
     /**
      * 文件夹名称
      * <p> 示例值：newsletter 相关
      */
    @SerializedName("name")
    private String name;
     /**
      * 父文件夹 id，该值为 0 表示根文件夹
      * <p> 示例值：725627422334644
      */
    @SerializedName("parent_folder_id")
    private String parentFolderId;
     /**
      * 文件夹类型
      * <p> 示例值：1
      */
    @SerializedName("folder_type")
    private Integer folderType;
     /**
      * 未读邮件数量
      * <p> 示例值：3
      */
    @SerializedName("unread_message_count")
    private Integer unreadMessageCount;
     /**
      * 未读会话数量
      * <p> 示例值：4
      */
    @SerializedName("unread_thread_count")
    private Integer unreadThreadCount;
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(String parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    public Integer getFolderType() {
        return this.folderType;
    }

    public void setFolderType(Integer folderType) {
        this.folderType = folderType;
    }

    public Integer getUnreadMessageCount() {
        return this.unreadMessageCount;
    }

    public void setUnreadMessageCount(Integer unreadMessageCount) {
        this.unreadMessageCount = unreadMessageCount;
    }

    public Integer getUnreadThreadCount() {
        return this.unreadThreadCount;
    }

    public void setUnreadThreadCount(Integer unreadThreadCount) {
        this.unreadThreadCount = unreadThreadCount;
    }


// builder 开始
  public Folder(){}

  public Folder(Builder builder){
         /**
          * folder id
          * <p> 示例值：12314123123123123
          */
      this.id = builder.id;
         /**
          * 文件夹名称
          * <p> 示例值：newsletter 相关
          */
      this.name = builder.name;
         /**
          * 父文件夹 id，该值为 0 表示根文件夹
          * <p> 示例值：725627422334644
          */
      this.parentFolderId = builder.parentFolderId;
         /**
          * 文件夹类型
          * <p> 示例值：1
          */
      this.folderType = builder.folderType;
         /**
          * 未读邮件数量
          * <p> 示例值：3
          */
      this.unreadMessageCount = builder.unreadMessageCount;
         /**
          * 未读会话数量
          * <p> 示例值：4
          */
      this.unreadThreadCount = builder.unreadThreadCount;
  }

    public static class Builder {
     /**
      * folder id
      * <p> 示例值：12314123123123123
      */
        private String id;
     /**
      * 文件夹名称
      * <p> 示例值：newsletter 相关
      */
        private String name;
     /**
      * 父文件夹 id，该值为 0 表示根文件夹
      * <p> 示例值：725627422334644
      */
        private String parentFolderId;
     /**
      * 文件夹类型
      * <p> 示例值：1
      */
        private Integer folderType;
     /**
      * 未读邮件数量
      * <p> 示例值：3
      */
        private Integer unreadMessageCount;
     /**
      * 未读会话数量
      * <p> 示例值：4
      */
        private Integer unreadThreadCount;

        /**
         * folder id
         * <p> 示例值：12314123123123123
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 文件夹名称
         * <p> 示例值：newsletter 相关
         * @param name
         * @return
         */
        public Builder name(String name) {
             this.name = name;
             return this;
        }

    

        /**
         * 父文件夹 id，该值为 0 表示根文件夹
         * <p> 示例值：725627422334644
         * @param parentFolderId
         * @return
         */
        public Builder parentFolderId(String parentFolderId) {
             this.parentFolderId = parentFolderId;
             return this;
        }

    

        /**
         * 文件夹类型
         * <p> 示例值：1
         * @param folderType
         * @return
         */
        public Builder folderType(Integer folderType) {
             this.folderType = folderType;
             return this;
        }
        /**
         * 文件夹类型
         * <p> 示例值：1
         * @param folderType {@link com.lark.oapi.service.mail.v1.enums.FolderFolderTypeEnum}
         * @return
         */
        public Builder folderType(com.lark.oapi.service.mail.v1.enums.FolderFolderTypeEnum folderType) {
             this.folderType = folderType.getValue();
             return this;
        }

    

        /**
         * 未读邮件数量
         * <p> 示例值：3
         * @param unreadMessageCount
         * @return
         */
        public Builder unreadMessageCount(Integer unreadMessageCount) {
             this.unreadMessageCount = unreadMessageCount;
             return this;
        }

    

        /**
         * 未读会话数量
         * <p> 示例值：4
         * @param unreadThreadCount
         * @return
         */
        public Builder unreadThreadCount(Integer unreadThreadCount) {
             this.unreadThreadCount = unreadThreadCount;
             return this;
        }

    
    
    public Folder build(){
        return new Folder(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
