// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.mail.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.mail.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class PatchUserMailboxMailContactReq {
     /**
      * 用户邮箱地址 或 输入me代表当前调用接口用户
      * <p> 示例值：user@xxx.xx 或 me
      */
    @Path
    @SerializedName("user_mailbox_id")
    private String userMailboxId;
     /**
      * 邮箱联系人 id
      * <p> 示例值：123
      */
    @Path
    @SerializedName("mail_contact_id")
    private String mailContactId;
    public String getUserMailboxId() {
        return this.userMailboxId;
    }

    public void setUserMailboxId(String userMailboxId) {
        this.userMailboxId = userMailboxId;
    }

    public String getMailContactId() {
        return this.mailContactId;
    }

    public void setMailContactId(String mailContactId) {
        this.mailContactId = mailContactId;
    }

    @Body
    private MailContact body;

    public MailContact getMailContact() {
        return this.body;
    }

    public void setMailContact(MailContact body) {
        this.body = body;
    }

// builder 开始
  public PatchUserMailboxMailContactReq(){}

  public PatchUserMailboxMailContactReq(Builder builder){
     /**
      * 用户邮箱地址 或 输入me代表当前调用接口用户
      * <p> 示例值：user@xxx.xx 或 me
      */
       this.userMailboxId = builder.userMailboxId;
     /**
      * 邮箱联系人 id
      * <p> 示例值：123
      */
       this.mailContactId = builder.mailContactId;
        this.body = builder.body;
  }

    public static class Builder {
    
        private String userMailboxId; // 用户邮箱地址 或 输入me代表当前调用接口用户
        private String mailContactId; // 邮箱联系人 id
        /**
         * 用户邮箱地址 或 输入me代表当前调用接口用户
         * <p> 示例值：user@xxx.xx 或 me
         * @param userMailboxId
         * @return
         */
          public Builder userMailboxId(String userMailboxId) {
               this.userMailboxId = userMailboxId;
               return this;
          }

    
        /**
         * 邮箱联系人 id
         * <p> 示例值：123
         * @param mailContactId
         * @return
         */
          public Builder mailContactId(String mailContactId) {
               this.mailContactId = mailContactId;
               return this;
          }

    
        private MailContact body;
    
        public MailContact getMailContact() {
            return this.body;
        }

        /**
         * body
         * @param body
         * @return
         */
        public Builder mailContact(MailContact body) {
             this.body = body;
             return this;
        }
    public PatchUserMailboxMailContactReq build(){
        return new PatchUserMailboxMailContactReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
