// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.minutes.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.minutes.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class GetMinuteTranscriptReq {
     /**
      * 是否包含说话人
      * <p> 示例值：true
      */
    @Query
    @SerializedName("need_speaker")
    private Boolean needSpeaker;
     /**
      * 是否包含时间戳
      * <p> 示例值：true
      */
    @Query
    @SerializedName("need_timestamp")
    private Boolean needTimestamp;
     /**
      * 导出文件格式
      * <p> 示例值：txt；srt
      */
    @Query
    @SerializedName("file_format")
    private String fileFormat;
    public Boolean getNeedSpeaker() {
        return this.needSpeaker;
    }

    public void setNeedSpeaker(Boolean needSpeaker) {
        this.needSpeaker = needSpeaker;
    }

    public Boolean getNeedTimestamp() {
        return this.needTimestamp;
    }

    public void setNeedTimestamp(Boolean needTimestamp) {
        this.needTimestamp = needTimestamp;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

     /**
      * 妙记唯一标识
      * <p> 示例值：obcnq3b9jl72l83w4f149w9c
      */
    @Path
    @SerializedName("minute_token")
    private String minuteToken;
    public String getMinuteToken() {
        return this.minuteToken;
    }

    public void setMinuteToken(String minuteToken) {
        this.minuteToken = minuteToken;
    }


// builder 开始
  public GetMinuteTranscriptReq(){}

  public GetMinuteTranscriptReq(Builder builder){
         /**
          * 是否包含说话人
          * <p> 示例值：true
          */
       this.needSpeaker = builder.needSpeaker;
         /**
          * 是否包含时间戳
          * <p> 示例值：true
          */
       this.needTimestamp = builder.needTimestamp;
         /**
          * 导出文件格式
          * <p> 示例值：txt；srt
          */
       this.fileFormat = builder.fileFormat;
     /**
      * 妙记唯一标识
      * <p> 示例值：obcnq3b9jl72l83w4f149w9c
      */
       this.minuteToken = builder.minuteToken;
  }

    public static class Builder {
        private Boolean needSpeaker; // 是否包含说话人
        private Boolean needTimestamp; // 是否包含时间戳
        private String fileFormat; // 导出文件格式
    
        /**
         * 是否包含说话人
         * <p> 示例值：true
         * @param needSpeaker
         * @return
         */
           public Builder needSpeaker(Boolean needSpeaker) {
                this.needSpeaker = needSpeaker;
                return this;
           }

    
        /**
         * 是否包含时间戳
         * <p> 示例值：true
         * @param needTimestamp
         * @return
         */
           public Builder needTimestamp(Boolean needTimestamp) {
                this.needTimestamp = needTimestamp;
                return this;
           }

    
        /**
         * 导出文件格式
         * <p> 示例值：txt；srt
         * @param fileFormat
         * @return
         */
           public Builder fileFormat(String fileFormat) {
                this.fileFormat = fileFormat;
                return this;
           }

    
        private String minuteToken; // 妙记唯一标识
        /**
         * 妙记唯一标识
         * <p> 示例值：obcnq3b9jl72l83w4f149w9c
         * @param minuteToken
         * @return
         */
          public Builder minuteToken(String minuteToken) {
               this.minuteToken = minuteToken;
               return this;
          }

    
    public GetMinuteTranscriptReq build(){
        return new GetMinuteTranscriptReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
