// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.moments.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.moments.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class Comment {
     /**
      * 评论所属用户ID
      * <p> 示例值："ou_xxxxx"
      */
    @SerializedName("user_id")
    private String userId;
     /**
      * 评论内容
      * <p> 示例值："[[{\"tag\":\"text\",\"text\":\"豪华中型车…………\"},{\"tag\":\"a\",\"text\":\"查看原文\",\"href\":\"https://www.autohome.com.cn/advice/202204/1244455.html\"}]]"
      */
    @SerializedName("content")
    private String content;
     /**
      * 评论图片的key
      * <p> 示例值："img_v2_xxxxxx"
      */
    @SerializedName("image_key")
    private String imageKey;
     /**
      * 是否热评
      * <p> 示例值：false
      */
    @SerializedName("is_hot")
    private Boolean isHot;
     /**
      * 评论 reactions
      * <p> 示例值：
      */
    @SerializedName("reaction_set")
    private ReactionSet reactionSet;
     /**
      * 评论 ID
      * <p> 示例值："248381240"
      */
    @SerializedName("id")
    private String id;
     /**
      * 评论创建时间
      * <p> 示例值："2022-05-23T00:00:00+08:00"
      */
    @SerializedName("create_time")
    private String createTime;
     /**
      * 评论所属实体的ID
      * <p> 示例值："248381241"
      */
    @SerializedName("post_id")
    private String postId;
     /**
      * 回复的评论ID
      * <p> 示例值：""
      */
    @SerializedName("reply_comment_id")
    private String replyCommentId;
     /**
      * 根评论ID
      * <p> 示例值：""
      */
    @SerializedName("root_comment_id")
    private String rootCommentId;
     /**
      * 创建评论时去重
      * <p> 示例值："generate-a-uuid-here"
      */
    @SerializedName("cid")
    private String cid;
     /**
      * 表情回复人类型
      * <p> 示例值：1
      */
    @SerializedName("user_type")
    private Integer userType;
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        this.imageKey = imageKey;
    }

    public Boolean getIsHot() {
        return this.isHot;
    }

    public void setIsHot(Boolean isHot) {
        this.isHot = isHot;
    }

    public ReactionSet getReactionSet() {
        return this.reactionSet;
    }

    public void setReactionSet(ReactionSet reactionSet) {
        this.reactionSet = reactionSet;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getPostId() {
        return this.postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getReplyCommentId() {
        return this.replyCommentId;
    }

    public void setReplyCommentId(String replyCommentId) {
        this.replyCommentId = replyCommentId;
    }

    public String getRootCommentId() {
        return this.rootCommentId;
    }

    public void setRootCommentId(String rootCommentId) {
        this.rootCommentId = rootCommentId;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public Integer getUserType() {
        return this.userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }


// builder 开始
  public Comment(){}

  public Comment(Builder builder){
         /**
          * 评论所属用户ID
          * <p> 示例值："ou_xxxxx"
          */
      this.userId = builder.userId;
         /**
          * 评论内容
          * <p> 示例值："[[{\"tag\":\"text\",\"text\":\"豪华中型车…………\"},{\"tag\":\"a\",\"text\":\"查看原文\",\"href\":\"https://www.autohome.com.cn/advice/202204/1244455.html\"}]]"
          */
      this.content = builder.content;
         /**
          * 评论图片的key
          * <p> 示例值："img_v2_xxxxxx"
          */
      this.imageKey = builder.imageKey;
         /**
          * 是否热评
          * <p> 示例值：false
          */
      this.isHot = builder.isHot;
         /**
          * 评论 reactions
          * <p> 示例值：
          */
      this.reactionSet = builder.reactionSet;
         /**
          * 评论 ID
          * <p> 示例值："248381240"
          */
      this.id = builder.id;
         /**
          * 评论创建时间
          * <p> 示例值："2022-05-23T00:00:00+08:00"
          */
      this.createTime = builder.createTime;
         /**
          * 评论所属实体的ID
          * <p> 示例值："248381241"
          */
      this.postId = builder.postId;
         /**
          * 回复的评论ID
          * <p> 示例值：""
          */
      this.replyCommentId = builder.replyCommentId;
         /**
          * 根评论ID
          * <p> 示例值：""
          */
      this.rootCommentId = builder.rootCommentId;
         /**
          * 创建评论时去重
          * <p> 示例值："generate-a-uuid-here"
          */
      this.cid = builder.cid;
         /**
          * 表情回复人类型
          * <p> 示例值：1
          */
      this.userType = builder.userType;
  }

    public static class Builder {
     /**
      * 评论所属用户ID
      * <p> 示例值："ou_xxxxx"
      */
        private String userId;
     /**
      * 评论内容
      * <p> 示例值："[[{\"tag\":\"text\",\"text\":\"豪华中型车…………\"},{\"tag\":\"a\",\"text\":\"查看原文\",\"href\":\"https://www.autohome.com.cn/advice/202204/1244455.html\"}]]"
      */
        private String content;
     /**
      * 评论图片的key
      * <p> 示例值："img_v2_xxxxxx"
      */
        private String imageKey;
     /**
      * 是否热评
      * <p> 示例值：false
      */
        private Boolean isHot;
     /**
      * 评论 reactions
      * <p> 示例值：
      */
        private ReactionSet reactionSet;
     /**
      * 评论 ID
      * <p> 示例值："248381240"
      */
        private String id;
     /**
      * 评论创建时间
      * <p> 示例值："2022-05-23T00:00:00+08:00"
      */
        private String createTime;
     /**
      * 评论所属实体的ID
      * <p> 示例值："248381241"
      */
        private String postId;
     /**
      * 回复的评论ID
      * <p> 示例值：""
      */
        private String replyCommentId;
     /**
      * 根评论ID
      * <p> 示例值：""
      */
        private String rootCommentId;
     /**
      * 创建评论时去重
      * <p> 示例值："generate-a-uuid-here"
      */
        private String cid;
     /**
      * 表情回复人类型
      * <p> 示例值：1
      */
        private Integer userType;

        /**
         * 评论所属用户ID
         * <p> 示例值："ou_xxxxx"
         * @param userId
         * @return
         */
        public Builder userId(String userId) {
             this.userId = userId;
             return this;
        }

    

        /**
         * 评论内容
         * <p> 示例值："[[{\"tag\":\"text\",\"text\":\"豪华中型车…………\"},{\"tag\":\"a\",\"text\":\"查看原文\",\"href\":\"https://www.autohome.com.cn/advice/202204/1244455.html\"}]]"
         * @param content
         * @return
         */
        public Builder content(String content) {
             this.content = content;
             return this;
        }

    

        /**
         * 评论图片的key
         * <p> 示例值："img_v2_xxxxxx"
         * @param imageKey
         * @return
         */
        public Builder imageKey(String imageKey) {
             this.imageKey = imageKey;
             return this;
        }

    

        /**
         * 是否热评
         * <p> 示例值：false
         * @param isHot
         * @return
         */
        public Builder isHot(Boolean isHot) {
             this.isHot = isHot;
             return this;
        }

    

        /**
         * 评论 reactions
         * <p> 示例值：
         * @param reactionSet
         * @return
         */
        public Builder reactionSet(ReactionSet reactionSet) {
             this.reactionSet = reactionSet;
             return this;
        }

    

        /**
         * 评论 ID
         * <p> 示例值："248381240"
         * @param id
         * @return
         */
        public Builder id(String id) {
             this.id = id;
             return this;
        }

    

        /**
         * 评论创建时间
         * <p> 示例值："2022-05-23T00:00:00+08:00"
         * @param createTime
         * @return
         */
        public Builder createTime(String createTime) {
             this.createTime = createTime;
             return this;
        }

    

        /**
         * 评论所属实体的ID
         * <p> 示例值："248381241"
         * @param postId
         * @return
         */
        public Builder postId(String postId) {
             this.postId = postId;
             return this;
        }

    

        /**
         * 回复的评论ID
         * <p> 示例值：""
         * @param replyCommentId
         * @return
         */
        public Builder replyCommentId(String replyCommentId) {
             this.replyCommentId = replyCommentId;
             return this;
        }

    

        /**
         * 根评论ID
         * <p> 示例值：""
         * @param rootCommentId
         * @return
         */
        public Builder rootCommentId(String rootCommentId) {
             this.rootCommentId = rootCommentId;
             return this;
        }

    

        /**
         * 创建评论时去重
         * <p> 示例值："generate-a-uuid-here"
         * @param cid
         * @return
         */
        public Builder cid(String cid) {
             this.cid = cid;
             return this;
        }

    

        /**
         * 表情回复人类型
         * <p> 示例值：1
         * @param userType
         * @return
         */
        public Builder userType(Integer userType) {
             this.userType = userType;
             return this;
        }
        /**
         * 表情回复人类型
         * <p> 示例值：1
         * @param userType {@link com.lark.oapi.service.moments.v1.enums.CommentUserTypeEnum}
         * @return
         */
        public Builder userType(com.lark.oapi.service.moments.v1.enums.CommentUserTypeEnum userType) {
             this.userType = userType.getValue();
             return this;
        }

    
    
    public Comment build(){
        return new Comment(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
