// Code generated by lark suite oapi sdk gen
/*
 * MIT License
 *
 * Copyright (c) 2022 Lark Technologies Pte. Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice, shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package com.lark.oapi.service.okr.v1.model;
import com.lark.oapi.core.response.EmptyData;
import com.lark.oapi.service.okr.v1.enums.*;
import com.google.gson.annotations.SerializedName;
import com.lark.oapi.core.annotation.Body;
import com.lark.oapi.core.annotation.Path;
import com.lark.oapi.core.annotation.Query;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import com.lark.oapi.core.utils.Strings;
import com.lark.oapi.core.response.BaseResponse;
public class ListUserOkrReq {
     /**
      * 此次调用中使用的用户ID的类型
      * <p> 示例值：
      */
    @Query
    @SerializedName("user_id_type")
    private String userIdType;
     /**
      * 请求列表的偏移，offset>=0
      * <p> 示例值：0
      */
    @Query
    @SerializedName("offset")
    private String offset;
     /**
      * 列表长度，0-10
      * <p> 示例值：5
      */
    @Query
    @SerializedName("limit")
    private String limit;
     /**
      * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn
      * <p> 示例值：zh_cn
      */
    @Query
    @SerializedName("lang")
    private String lang;
     /**
      * period_id列表，最多10个
      * <p> 示例值：["6951461264858777132"]
      */
    @Query
    @SerializedName("period_ids")
    private String[] periodIds;
    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    public String getLimit() {
        return this.limit;
    }

    public void setLimit(String limit) {
        this.limit = limit;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String[] getPeriodIds() {
        return this.periodIds;
    }

    public void setPeriodIds(String[] periodIds) {
        this.periodIds = periodIds;
    }

     /**
      * 目标用户id
      * <p> 示例值：ou-asdasdasdasdasd
      */
    @Path
    @SerializedName("user_id")
    private String userId;
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }


// builder 开始
  public ListUserOkrReq(){}

  public ListUserOkrReq(Builder builder){
         /**
          * 此次调用中使用的用户ID的类型
          * <p> 示例值：
          */
       this.userIdType = builder.userIdType;
         /**
          * 请求列表的偏移，offset>=0
          * <p> 示例值：0
          */
       this.offset = builder.offset;
         /**
          * 列表长度，0-10
          * <p> 示例值：5
          */
       this.limit = builder.limit;
         /**
          * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn
          * <p> 示例值：zh_cn
          */
       this.lang = builder.lang;
         /**
          * period_id列表，最多10个
          * <p> 示例值：["6951461264858777132"]
          */
       this.periodIds = builder.periodIds;
     /**
      * 目标用户id
      * <p> 示例值：ou-asdasdasdasdasd
      */
       this.userId = builder.userId;
  }

    public static class Builder {
        private String userIdType; // 此次调用中使用的用户ID的类型
        private String offset; // 请求列表的偏移，offset>=0
        private String limit; // 列表长度，0-10
        private String lang; // 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn
        private String[] periodIds; // period_id列表，最多10个
    
        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType
         * @return
         */
           public Builder userIdType(String userIdType) {
                this.userIdType = userIdType;
                return this;
           }

        /**
         * 此次调用中使用的用户ID的类型
         * <p> 示例值：
         * @param userIdType {@link com.lark.oapi.service.okr.v1.enums.ListUserOkrUserIdTypeEnum}
         * @return
         */
          public Builder userIdType(com.lark.oapi.service.okr.v1.enums.ListUserOkrUserIdTypeEnum userIdType) {
               this.userIdType = userIdType.getValue();
               return this;
          }

    
        /**
         * 请求列表的偏移，offset>=0
         * <p> 示例值：0
         * @param offset
         * @return
         */
           public Builder offset(String offset) {
                this.offset = offset;
                return this;
           }

    
        /**
         * 列表长度，0-10
         * <p> 示例值：5
         * @param limit
         * @return
         */
           public Builder limit(String limit) {
                this.limit = limit;
                return this;
           }

    
        /**
         * 请求OKR的语言版本（比如@的人名），lang=en_us/zh_cn
         * <p> 示例值：zh_cn
         * @param lang
         * @return
         */
           public Builder lang(String lang) {
                this.lang = lang;
                return this;
           }

    
        /**
         * period_id列表，最多10个
         * <p> 示例值：["6951461264858777132"]
         * @param periodIds
         * @return
         */
           public Builder periodIds(String[] periodIds) {
                this.periodIds = periodIds;
                return this;
           }

    
        private String userId; // 目标用户id
        /**
         * 目标用户id
         * <p> 示例值：ou-asdasdasdasdasd
         * @param userId
         * @return
         */
          public Builder userId(String userId) {
               this.userId = userId;
               return this;
          }

    
    public ListUserOkrReq build(){
        return new ListUserOkrReq(this);
      }
    }

    public static Builder newBuilder() {
        return new Builder();
    }
}
